/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.EmployeeInterfacePermBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.customer.gtiit.osf.util.DateUtils;
import com.kingdee.shr.integration.oa.util.IntegrateOAUtil;
import com.kingdee.shr.integration.oa.util.MappingFieldInfo;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtiitOAGetAdminOrgDataService
implements IHRMsfService {
    private static final Logger logger = LoggerFactory.getLogger(GtiitOAGetAdminOrgDataService.class);

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        logger.error("GtiitOAGetAdminOrgDataService enter ");
        new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startDate = (String)param.get("startDate");
        String endDate = (String)param.get("endDate");
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            startDate = DateUtils.formatDate(startDate, true);
            endDate = DateUtils.formatDate(endDate, false);
        }
        String adminPermItem = "fffffff0-ffff-efff-e22e-0000000dfa21PERMITEM";
        PermItemInfo permItem = PermItemFactory.getLocalInstance((Context)ctx).getPermItemInfo((IObjectPK)new ObjectUuidPK(adminPermItem));
        try {
            SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)permItem);
        }
        catch (Exception var9) {
            logger.error(var9.getMessage(), (Throwable)var9);
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(userId));
            throw new EmployeeInterfacePermBizException(EmployeeInterfacePermBizException.NO_FUNCTION_PERMISSION, new Object[]{userInfo.getName(), permItem.getAlias()});
        }
        List<MappingFieldInfo> fieldList = this.initMappingField();
        StringBuffer sql = IntegrateOAUtil.getSelectFieldSql(fieldList);
        sql.append(" from t_org_admin org left join t_org_admin parent on parent.fid=org.FParentID  left join T_ORG_POSITION position on org.fid=position.FAdminOrgUnitID  left join T_HR_EmpOrgRelation he on he.fAdminOrgId=org.fid ");
        sql.append(" where org.FIsStartSHR=1");
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            sql.append(" and (org.flastupdatetime >= '" + startDate + "' and org.flastupdatetime<='" + endDate + "') ");
            sql.append(" or (position.flastupdatetime >= '" + startDate + "' and position.flastupdatetime<='" + endDate + "') ");
            sql.append(" or (he.flastupdatetime >= '" + startDate + "' and he.flastupdatetime<='" + endDate + "') ");
        }
        sql.append(" group by org.fid,org.fname_l2,org.fname_l1,org.FParentID,parent.fname_l2,org.fSortCode,org.FIsLeaf,org.FIsSealUp ,org.FNumber ,org.fcreateTime ,org.FLastUpdateTime ,parent.FNumber ,org.FEffectDate ,org.FsimpleName ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        logger.info("GtiitOAGetAdminOrgDataService....sql: " + sql.toString());
        List dataList = IntegrateOAUtil.getRsListData(fieldList, (IRowSet)rs);
        try {
            if (dataList != null && dataList.size() > 0) {
                this.processHead(ctx, dataList, startDate, endDate);
            }
        }
        catch (SQLException e) {
            logger.info("processHead...." + e);
        }
        return dataList;
    }

    private List<MappingFieldInfo> initMappingField() {
        ArrayList<MappingFieldInfo> list = new ArrayList<MappingFieldInfo>();
        MappingFieldInfo fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("easdept_id");
        fieldInfo.setShrField("org.fid");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("name");
        fieldInfo.setShrField("org.fname_l2");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("name_L1");
        fieldInfo.setShrField("org.fname_l1");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("superior");
        fieldInfo.setShrField("org.FParentID");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("supname");
        fieldInfo.setShrField("parent.fname_l2");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("sortCode");
        fieldInfo.setShrField("org.fSortCode");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("endflag");
        fieldInfo.setShrField("org.FIsLeaf");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("status");
        fieldInfo.setShrField("org.FIsSealUp");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("fnumber");
        fieldInfo.setShrField("org.FNumber");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("fcreateTime");
        fieldInfo.setShrField("org.fcreateTime");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("flastUpdateTime");
        fieldInfo.setShrField("org.FLastUpdateTime");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("supFnumber");
        fieldInfo.setShrField("parent.FNumber");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("fEffectDate");
        fieldInfo.setShrField("org.FEffectDate");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("simpleName");
        fieldInfo.setShrField("org.FsimpleName");
        list.add(fieldInfo);
        fieldInfo = new MappingFieldInfo();
        fieldInfo.setOaField("isSealUp");
        fieldInfo.setShrField("org.fissealup");
        list.add(fieldInfo);
        return list;
    }

    private void processHead(Context ctx, List<HashMap<String, String>> dataList, String startDate, String endDate) throws BOSException, SQLException {
        ArrayList<String> ids = new ArrayList<String>();
        int i = 0;
        while (i < dataList.size()) {
            ids.add(dataList.get(i).get("easdept_id"));
            ++i;
        }
        String processStr = this.processStr(ids);
        Map<String, String> heads = this.getHead(ctx, processStr, startDate, endDate);
        Map<String, String> pvcs = this.getPvc(ctx, processStr);
        if (heads.size() > 0) {
            logger.info("heads....count{}  ", (Object)heads.size());
        }
        int i2 = 0;
        while (i2 < dataList.size()) {
            HashMap<String, String> data;
            data.put("pnumber", heads.get((data = dataList.get(i2)).get("fnumber")) == null ? "" : heads.get(data.get("fnumber")));
            data.put("pvc_number", pvcs.get(data.get("fnumber")) == null ? "" : pvcs.get(data.get("fnumber")));
            ++i2;
        }
    }

    private Map<String, String> getPvc(Context ctx, String processStr) throws BOSException, SQLException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "SELECT\r\n\torg.fnumber orgNumber,\r\n\torg.Fname_l1 orgName,\r\n\tbp.fnumber pNumber,\r\n\tbp.Fname_l1 pName\r\nFROM\r\n\tT_WFR_WFROLE wf\r\n\tLEFT JOIN T_WFR_PERSONROLE wp ON wp.froleid= wf.fid\r\n\tLEFT JOIN T_BD_Person bp ON bp.fid= wp.fpsersonid\r\n\tLEFT JOIN T_ORG_Admin org ON org.fid= wp.forgid \r\nWHERE\r\n\twf.fnumber= '02' and org.fid in(" + processStr + ")";
        logger.info("GtiitOAGetAdminOrgDataService->getPvc->sql{} ", (Object)sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String orgNumber = rs.getString("orgNumber");
            if (StringUtils.isBlank((CharSequence)orgNumber)) continue;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)resultMap.get(orgNumber)))) {
                resultMap.put(orgNumber, String.valueOf((String)resultMap.get(orgNumber)) + "," + rs.getString("pNumber"));
                continue;
            }
            resultMap.put(orgNumber, rs.getString("pNumber"));
        }
        return resultMap;
    }

    private Map<String, String> getHead(Context ctx, String processStr, String startDate, String endDate) throws BOSException, SQLException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = "SELECT\r\n\ta.fid AS oId,\r\n\ta.fnumber AS oNumber,\r\n\td.fnumber AS pNumber,\r\n\td.fname_L1 AS pNameL1,\r\n\td.fname_L2 AS pNameL2 \r\nFROM\r\n\tT_ORG_Admin a\r\n\tLEFT JOIN T_ORG_POSITION b ON a.FResponPositionID= b.fid\r\n\tLEFT JOIN (\r\n\tSELECT\r\n\t\tca.fpositionid,\r\n\t\tca.fpersonid, \r\n\t\tca.fislatestinaday, \r\n\t\tca.fadminorgid, \r\n\t\tca.flastupdatetime \r\n\tFROM\r\n\t\tT_HR_EmpOrgRelation ca\r\n\t\tINNER JOIN ( SELECT fpositionid, MAX ( fleffdt ) maxDate FROM T_HR_EmpOrgRelation GROUP BY fpositionid ) cb ON ca.fpositionid= cb.fpositionid \r\n\t\tAND ca.fleffdt= cb.maxDate \r\n\t) c ON c.fpositionid= b.fid\r\n\tLEFT JOIN T_BD_Person d ON d.fid= c.fpersonid\r\n\tLEFT JOIN T_HR_BDEmployeeType e ON e.fid= d.femployeetypeid \r\nWHERE\r\n\ta.fid IN (" + processStr + ") \r\n" + "\tAND b.FIsRespPosition= 1 \r\n" + "\tAND e.finservice= 1 \r\n" + "\tAND b.fdeletedstatus= 1 \r\n" + "\tAND c.fislatestinaday=1  \r\n";
        if (StringUtils.isNotBlank((CharSequence)startDate) && StringUtils.isNotBlank((CharSequence)endDate)) {
            sql = String.valueOf(sql) + "\tAND (b.flastupdatetime>= '" + startDate + "' \r\n" + "\tAND b.flastupdatetime<= '" + endDate + "') ";
            sql = String.valueOf(sql) + " or(c.flastupdatetime<= '" + endDate + "' and c.fadminorgid IN (" + processStr + ") \r\n" + "\tAND c.fislatestinaday=1 and e.finservice=1) ";
        }
        sql = String.valueOf(sql) + " group by a.fid,a.fnumber,d.fnumber,d.fname_L1,d.fname_L2  order by a.fnumber";
        logger.info("getHead.....sql{} ", (Object)sql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            String oNumber = rs.getString("oNumber");
            if (StringUtils.isBlank((CharSequence)oNumber)) continue;
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)resultMap.get(oNumber)))) {
                resultMap.put(oNumber, String.valueOf((String)resultMap.get(oNumber)) + "," + rs.getString("pNumber"));
                continue;
            }
            resultMap.put(oNumber, rs.getString("pNumber"));
        }
        return resultMap;
    }

    private String processStr(List<String> numbers) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        for (String s : numbers) {
            sb.append("'").append(s).append("'").append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.lastIndexOf(","));
            result = sb.toString();
        }
        return result;
    }
}

