/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.rpt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.customer.gtiit.util.DateTimeUtils;
import com.kingdee.shr.customer.gtiit.util.ExportUtils;
import com.kingdee.shr.customer.gtiit.util.RptUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.ui.ModelMap;

public class FacultyAbsenceReportListHandler
extends ListHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.customer.gtiit.rpt.FacultyAbsenceReportListHandler");
    Context ctx = SHRContext.getInstance().getContext();
    private int totalCount;

    public String getGridColModelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, SQLException {
        ArrayList<String> colNames = this.getcolNamesAction();
        List<Map<String, Object>> colModel = this.getcolModelAction();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        map.put("colNames", colNames);
        map.put("colModel", colModel);
        JSONUtils.writeJson((HttpServletResponse)response, map);
        return null;
    }

    public void getGridDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException, ParseException {
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        ArrayList maplist = new ArrayList();
        int num = 0;
        ArrayList<String> qfNames = new ArrayList<String>();
        qfNames.add("queryTime");
        String parameter = request.getParameter("fastFilterItems");
        JSONObject paramJson = JSON.parseObject((String)parameter);
        Map<String, Object> rptSQLFilterate = RptUtils.getRptSQLFilterate(paramJson, qfNames);
        Map contractDateMap = (Map)rptSQLFilterate.get("queryTime");
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        if (ObjectUtils.isNotEmpty(contractDateMap.get("startDate")) && ObjectUtils.isNotEmpty(contractDateMap.get("endDate"))) {
            startDate = DateTimeUtils.parseDate(String.valueOf((String)contractDateMap.get("startDate")) + " 08:30", "yyyy-MM-dd HH:mm");
            endDate = DateTimeUtils.parseDate(String.valueOf((String)contractDateMap.get("endDate")) + " 17:30", "yyyy-MM-dd HH:mm");
        }
        String sql = this.getSql(rptSQLFilterate);
        String searchFilterItems = request.getParameter("searchFilterItems");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchFilterItems})) {
            String filterItmes = this.getSearchFilterItems(searchFilterItems);
            sql = String.valueOf(sql) + " and " + filterItmes;
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        while (rs.next()) {
            if (++num < rows * (page - 1) + 1 || num > rows * page) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("StaffID", rs.getString("StaffID"));
            map.put("Name", rs.getString("Name"));
            map.put("PhysicsProgram", rs.getString("PhysicsProgram"));
            map.put("Title", rs.getString("Title"));
            map.put("Document No.", rs.getString("Document No."));
            map.put("Type", rs.getString("Type"));
            map.put("Purpose", rs.getString("Purpose"));
            map.put("Location", rs.getString("Location"));
            map.put("Course", rs.getString("Course"));
            map.put("ReplacerNameForCourse", rs.getString("ReplacerNameForCourse"));
            map.put("Status", rs.getString("Status"));
            java.util.Date leaveStartDate = rs.getDate("BusinessTripStartDate");
            java.util.Date leaveEndDate = rs.getDate("BusinessTripEndDate");
            if (startDate != null && endDate != null) {
                if (startDate.compareTo(leaveStartDate) > 0) {
                    leaveStartDate = startDate;
                }
                if (endDate.compareTo(leaveEndDate) < 0) {
                    leaveEndDate = endDate;
                }
            }
            map.put("BusinessTripStartDate", leaveStartDate);
            map.put("BusinessTripEndDate", leaveEndDate);
            maplist.add(map);
        }
        this.totalCount = num;
        LinkedHashMap<String, Serializable> gridDataMap = new LinkedHashMap<String, Serializable>();
        if (this.totalCount % rows == 0) {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows));
        } else {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows + 1));
        }
        gridDataMap.put("page", Integer.valueOf(page));
        gridDataMap.put("records", Integer.valueOf(this.totalCount));
        gridDataMap.put("rows", maplist);
        JSONUtils.writeJson((HttpServletResponse)response, gridDataMap);
    }

    public ArrayList<String> getcolNamesAction() throws SHRWebException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("StaffID");
        list.add("Name");
        list.add("PhysicsProgram");
        list.add("Title");
        list.add("Document No.");
        list.add("Type");
        list.add("BusinessTripStartDate");
        list.add("BusinessTripEndDate");
        list.add("Purpose");
        list.add("Location");
        list.add("Course");
        list.add("ReplacerNameForCourse");
        list.add("Status");
        return list;
    }

    public List<Map<String, Object>> getcolModelAction() {
        ArrayList<Map<String, Object>> modelColList = new ArrayList<Map<String, Object>>();
        modelColList.add(this.buildColModelMap("StaffID", "\u5de5\u53f7", 70));
        modelColList.add(this.buildColModelMap("Name", "\u59d3", 120));
        modelColList.add(this.buildColModelMap("PhysicsProgram", "\u90e8\u95e8", 170));
        modelColList.add(this.buildColModelMap("Title", "\u5c97\u4f4d", 160));
        modelColList.add(this.buildColModelMap("Document No.", "\u8bf7\u5047\u5355\u53f7", 120));
        modelColList.add(this.buildColModelMap("Type", "\u5047\u52e4\u7c7b\u578b", 130));
        modelColList.add(this.buildColModelMap("BusinessTripStartDate", "\u5f00\u59cb\u65f6\u95f4", 160));
        modelColList.add(this.buildColModelMap("BusinessTripEndDate", "\u7ed3\u675f\u65f6\u95f4", 160));
        modelColList.add(this.buildColModelMap("Purpose", "\u76ee\u7684", 120));
        modelColList.add(this.buildColModelMap("Location", "\u4f4d\u7f6e", 120));
        modelColList.add(this.buildColModelMap("Course", "\u8bfe\u7a0b", 160));
        modelColList.add(this.buildColModelMap("ReplacerNameForCourse", "\u8bfe\u7a0b\u7684\u66ff\u4ee3\u8005\u540d\u79f0", 120));
        modelColList.add(this.buildColModelMap("Status", "\u5355\u636e\u72b6\u6001", 90));
        return modelColList;
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width) {
        return this.buildColModelMap(index, label, width, false, false, false);
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width, boolean rowspan, boolean isKey, boolean isHedden) {
        LinkedHashMap<String, Object> gridIdMap = new LinkedHashMap<String, Object>();
        gridIdMap.put("index", index);
        gridIdMap.put("name", index);
        gridIdMap.put("label", label);
        gridIdMap.put("width", width);
        if (rowspan) {
            gridIdMap.put("rowspan", rowspan);
        }
        if (isKey) {
            gridIdMap.put("key", isKey);
        }
        if (isHedden) {
            gridIdMap.put("hidden", isHedden);
        }
        return gridIdMap;
    }

    public String toExcelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException {
        ArrayList<String> qfNames = new ArrayList<String>();
        qfNames.add("queryTime");
        String parameter = request.getParameter("fastFilterItems");
        JSONObject paramJson = JSON.parseObject((String)parameter);
        Map<String, Object> rptSQLFilterate = RptUtils.getRptSQLFilterate(paramJson, qfNames);
        String sql = this.getSql(rptSQLFilterate);
        String searchFilterItems = request.getParameter("searchFilterItems");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchFilterItems})) {
            String filterItmes = this.getSearchFilterItems(searchFilterItems);
            sql = String.valueOf(sql) + " and " + filterItmes;
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        LinkedHashMap<String, String> selectFieldsTypeMap = new LinkedHashMap<String, String>();
        String stringType = "String_@";
        String dateType = "Date_yyyy/MM/dd HH:mm";
        selectFieldsTypeMap.put("StaffID", "Number_0_%s");
        selectFieldsTypeMap.put("Name", stringType);
        selectFieldsTypeMap.put("PhysicsProgram", stringType);
        selectFieldsTypeMap.put("Title", stringType);
        selectFieldsTypeMap.put("Document No.", stringType);
        selectFieldsTypeMap.put("Type", stringType);
        selectFieldsTypeMap.put("BusinessTripStartDate", dateType);
        selectFieldsTypeMap.put("BusinessTripEndDate", dateType);
        selectFieldsTypeMap.put("Purpose", stringType);
        selectFieldsTypeMap.put("Location", stringType);
        selectFieldsTypeMap.put("Course", stringType);
        selectFieldsTypeMap.put("ReplacerNameForCourse", stringType);
        selectFieldsTypeMap.put("Status", stringType);
        FacultyAbsenceReportListHandler.exportData(response, rs, "FacultyAbsenceReport.xlsx", selectFieldsTypeMap, rptSQLFilterate);
        return null;
    }

    public static void exportData(HttpServletResponse response, Object resource, String fileName, LinkedHashMap<String, String> selectFieldsTypeMap, Map<String, Object> rptSQLFilterate) throws SQLException {
        Map contractDateMap = (Map)rptSQLFilterate.get("queryTime");
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        if (ObjectUtils.isNotEmpty(contractDateMap.get("startDate")) && ObjectUtils.isNotEmpty(contractDateMap.get("endDate"))) {
            startDate = DateTimeUtils.parseDate(String.valueOf((String)contractDateMap.get("startDate")) + " 08:30", "yyyy-MM-dd HH:mm");
            endDate = DateTimeUtils.parseDate(String.valueOf((String)contractDateMap.get("endDate")) + " 17:30", "yyyy-MM-dd HH:mm");
        }
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet("Sheet1");
        XSSFDataFormat format = workBook.createDataFormat();
        if (resource != null && resource instanceof IRowSet) {
            IRowSet rs = (IRowSet)resource;
            int numColumns = selectFieldsTypeMap.entrySet().size();
            int i = 0;
            XSSFRow titleRow = sheet.createRow(i);
            List keyList = selectFieldsTypeMap.keySet().stream().collect(Collectors.toList());
            if (i == 0) {
                int j = 0;
                while (j < numColumns) {
                    XSSFCell cell = titleRow.createCell(j);
                    cell.setCellValue((String)keyList.get(j));
                    ++j;
                }
            }
            ++i;
            while (rs.next()) {
                try {
                    XSSFRow dateRow = sheet.createRow(i);
                    int j = 0;
                    while (j < numColumns) {
                        String value;
                        XSSFCellStyle style = workBook.createCellStyle();
                        XSSFCell cell = dateRow.createCell(j);
                        String column = (String)keyList.get(j);
                        String fieldTypeAndcellStyleType = selectFieldsTypeMap.get(column);
                        int indexOf = fieldTypeAndcellStyleType.indexOf("_");
                        String fieldType = fieldTypeAndcellStyleType.substring(0, indexOf);
                        String cellStyleType = fieldTypeAndcellStyleType.substring(indexOf + 1, fieldTypeAndcellStyleType.length());
                        if ("Date".equals(fieldType)) {
                            Date date = rs.getDate(column);
                            if (startDate != null && endDate != null) {
                                date = column.equals("BusinessTripStartDate") && startDate.compareTo(date) > 0 ? startDate : date;
                                date = column.equals("BusinessTripEndDate") && endDate.compareTo(date) < 0 ? endDate : date;
                            }
                            style.setDataFormat(format.getFormat(cellStyleType));
                            cell.setCellStyle((CellStyle)style);
                            cell.setCellValue((java.util.Date)date);
                        } else if ("Number".equals(fieldType)) {
                            style.setDataFormat(format.getFormat(String.format(cellStyleType, " ")));
                            value = rs.getString(column);
                            cell.setCellStyle((CellStyle)style);
                            if (cellStyleType.contains(".")) {
                                cell.setCellValue(Double.parseDouble(value));
                            } else {
                                cell.setCellValue((double)Integer.parseInt(value));
                            }
                        } else if ("String".equals(fieldType)) {
                            value = rs.getString(column);
                            cell.setCellValue(value);
                        }
                        ++j;
                    }
                    ++i;
                }
                catch (Exception e) {
                    System.out.println();
                    logger.info((Object)("Excel file was created Error!" + e.getMessage()));
                }
            }
            try {
                ExportUtils.setResponseHeader(response, fileName);
                ServletOutputStream os = response.getOutputStream();
                workBook.write((OutputStream)os);
                workBook.close();
                os.flush();
                os.close();
                logger.info((Object)"Excel file was created successfully!");
            }
            catch (IOException e) {
                logger.info((Object)("Error while writing to file " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    private String getSql(Map<String, Object> params) {
        Map contractDateMap = (Map)params.get("queryTime");
        Object startDate = contractDateMap.get("startDate");
        Object endDate = contractDateMap.get("endDate");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT a.FNUMBER \"Document No.\",d.fnumber StaffID,d.fname_l1 Name,f.fname_l1 PhysicsProgram,g.fname_l1 Title,c.fname_l1 Type,");
        sql.append("b.FREALBEGINTIME BusinessTripStartDate,b.FREALENDTIME BusinessTripEndDate,b.CFPURPOSE Purpose,b.CFCITY Location,");
        sql.append("b.CFAlternativeTeacher as ReplacerNameforCourse,b.CFTeachingTask as Course,case when a.FBILLSTATE = 3 then 'Approved' else 'Pending Approval' end Status ");
        sql.append(" FROM T_HR_ATS_LeaveBill a ");
        sql.append("left join T_HR_ATS_LeaveBillEntry b on a.fid = b.fbillid ");
        sql.append("left join  T_HR_ATS_HolidayPolicy c on c.fid=b.fpolicyid ");
        sql.append("left join t_bd_person d on d.fid = b.FPERSONID ");
        sql.append("left join (SELECT emh.fpersonid,emh.fadminorgid,emh.fpositionid,emh.CFWorkercategoryID FROM ");
        sql.append("  (select fpersonid,max(fleffdt) maxdate from T_HR_EmpOrgRelation ");
        sql.append("  where fassigntype = 1 and fislatestinaday = 1 group by fpersonid) emp ");
        sql.append("  left join T_HR_EmpOrgRelation emh on emp.fpersonid = emh.fpersonid and emp.maxdate = emh.fleffdt ");
        sql.append("  where emh.fassigntype = 1 and emh.fislatestinaday = 1) e on e.fpersonid = b.FPERSONID ");
        sql.append("left join T_ORG_BaseUnit f on f.fid = e.FAdminOrgID ");
        sql.append("left join T_ORG_Position g on g.fid = e.fpositionid ");
        sql.append("left join CT_MP_WorkerCategory h on h.fid = e.CFWorkercategoryID ");
        sql.append("where a.FBILLSTATE in ('1','2','3') and h.fnumber = 'GTIIT_FACULTY' ");
        if (ObjectUtils.isNotEmpty(startDate) && ObjectUtils.isNotEmpty(endDate)) {
            startDate = String.valueOf(startDate) + " 08:30";
            endDate = String.valueOf(endDate) + " 17:30";
            sql.append(" and b.FREALBEGINTIME <= '" + endDate + "' and b.FREALENDTIME >= '" + startDate + "' ");
        }
        logger.error((Object)("\u6559\u5e08\u7f3a\u52e4\u62a5\u544aSQL\uff1a" + sql.toString()));
        return sql.toString();
    }

    public String getSearchFilterItems(String searchFilterItems) {
        String filter = null;
        if (StringUtils.isNotBlank((CharSequence)searchFilterItems)) {
            if (searchFilterItems.indexOf("name") != -1) {
                filter = searchFilterItems.replaceAll("name", "d.fname_l1");
            }
            if (searchFilterItems.indexOf("number") != -1) {
                filter = searchFilterItems.replaceAll("number", "d.fnumber");
            }
        }
        if (filter != null) {
            return filter.replace("(", "").replace(")", "");
        }
        return filter;
    }
}

