/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.handler;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.message.common.KDMemAttachment;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.metas.MailApproveAgentFactory;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.mobile.framework.IAttachmentBrige;
import org.apache.log4j.Logger;

public class EmailApproveAttachmentBrige
implements IAttachmentBrige {
    protected static final Logger logger = Logger.getLogger(EmailApproveAttachmentBrige.class);

    @Override
    public KDMessageAttachment[] KDMessageAttachments(Context ctx, String boId) {
        if (boId == null || boId.length() == 0) {
            return null;
        }
        try {
            if (!MailApproveAgentFactory.getLocalInstance((Context)ctx).exists(" where assignid = '" + boId + "'")) {
                return null;
            }
            WfUtil wfutil = new WfUtil(ctx);
            String mode = wfutil.getApproveActPermissionMode(boId);
            if (mode.equals("10")) {
                return null;
            }
            String billId = WfEngine.getEngine(ctx).getAssignment(boId).getMeta().getBizObjectIds();
            IBoAttchAsso iBoAttchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            String[] attchIDs = iBoAttchAsso.getAttchIDsByBoID(billId);
            return this.download(ctx, attchIDs);
        }
        catch (Throwable e) {
            logger.error((Object)"", e);
            return null;
        }
    }

    private KDMessageAttachment[] download(Context ctx, String[] attachmentIDs) {
        KDMessageAttachment[] attachments = null;
        if (attachmentIDs != null) {
            int numOfAttach = attachmentIDs.length;
            attachments = new KDMessageAttachment[numOfAttach];
            if (numOfAttach > 0) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("file"));
                sic.add(new SelectorItemInfo("type"));
                sic.add(new SelectorItemInfo("simpleName"));
                for (int i = 0; i < numOfAttach; ++i) {
                    try {
                        KDMemAttachment att = new KDMemAttachment();
                        IAttachment ia = AttachmentFactory.getLocalInstance((Context)ctx);
                        AttachmentInfo ai = (AttachmentInfo)ia.getValue((IObjectPK)new ObjectUuidPK(attachmentIDs[i]), sic);
                        String name = ai.getName();
                        String type = ai.getSimpleName();
                        StringBuffer filename = new StringBuffer();
                        filename.append(name);
                        filename.append(".");
                        filename.append(type);
                        String fname = filename.toString();
                        AttachmentServerManager asm = AttachmentManagerFactory.getServerManager((Context)ctx);
                        byte[] bytes = asm.download(attachmentIDs[i]);
                        att.setData(bytes);
                        att.setName(fname);
                        attachments[i] = att;
                        continue;
                    }
                    catch (Throwable e) {
                        logger.error((Object)"", e);
                    }
                }
            }
        }
        return attachments;
    }
}

