/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.s;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.script.core.NativeFunction;

public class QueryList
implements NativeFunction {
    private static volatile int MAX_SIZE;

    static {
        QueryList.initResultSetMaxSize();
    }

    @Override
    public String name() {
        return "query_list";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Connection cn = (Connection)args[0];
        if (cn == null) {
            throw new IllegalArgumentException(ResManager.loadKDString("\u7b2c\u4e00\u4e2a\u53c2\u6570\u6570\u636e\u5e93\u8fde\u63a5\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u6267\u884cSQL\u67e5\u8be2!", "QueryList_0", "isc-iscb-util", new Object[0]));
        }
        String sql = D.s(args[1]);
        List values = args.length == 2 ? Collections.emptyList() : (List)args[2];
        List types = args.length == 2 ? Collections.emptyList() : (List)args[3];
        ObjectReader<DataRow> reader = DbUtil.executeQuery(cn, sql, values, types);
        try {
            ArrayList<DataRow> list = new ArrayList<DataRow>();
            int totalBytes = 0;
            DataRow item = reader.read();
            while (item != null) {
                totalBytes = QueryList.checkTotalBytes(totalBytes, item);
                list.add(item);
                item = reader.read();
            }
            ArrayList<DataRow> arrayList = list;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    static int checkTotalBytes(int totalBytes, DataRow item) {
        QueryList.checkTotalBytes(totalBytes += DbUtil.calcBytes(item));
        return totalBytes;
    }

    public static void checkTotalBytes(Object result) {
        long totalBytes = DbUtil.getObjectSize(result);
        QueryList.checkTotalBytes(totalBytes);
    }

    public static void checkTotalBytes(long totalBytes) {
        int max_size = MAX_SIZE;
        if (totalBytes > (long)max_size) {
            throw new RuntimeException(String.format(ResManager.loadKDString("\u67e5\u8be2\u7ed3\u679c\u8d85\u8fc7\u4e86\u201c%s\u201d\u5b57\u8282\uff0c\u6b64\u63aa\u65bd\u662f\u4e3a\u4e86\u9650\u5236\u67e5\u8be2\u7ed3\u679c\u96c6\u7684\u5927\u5c0f\u4ee5\u964d\u4f4e\u7cfb\u7edfOOM\u7684\u98ce\u9669\u3002\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u8c03\u6574\u4e1a\u52a1\u5b9e\u73b0\u4e3a\u5206\u6279\u5904\u7406\u907f\u514d\u4e00\u6b21\u67e5\u8be2\u592a\u591a\u6570\u636e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574JVM\u7cfb\u7edf\u53c2\u6570 ISC_QUERY_MAX_SIZE \u63d0\u9ad8\u4e0a\u9650\u3002", "QueryList_4", "isc-iscb-util", new Object[0]), max_size));
        }
    }

    public static int getResultSetMaxSize() {
        return MAX_SIZE;
    }

    public static void initResultSetMaxSize() {
        int defaultMaxSize = 20000000;
        try {
            int max_size;
            String s = System.getProperty("ISC_QUERY_MAX_SIZE");
            if (s == null) {
                s = System.getenv("ISC_QUERY_MAX_SIZE");
            }
            MAX_SIZE = (max_size = D.i((Object)s)) <= 0 ? 19999999 : Math.max(10000, max_size);
        }
        catch (Throwable e) {
            MAX_SIZE = 20000001;
        }
    }
}

