/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.network;

import java.net.InetAddress;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.network.CheckBean;
import kd.isc.iscb.util.network.CheckNetWorkUtil;
import kd.isc.iscb.util.network.CheckNetwork;
import kd.isc.iscb.util.network.CheckResult;

public class SimplePing
implements CheckNetwork {
    protected static final SimplePing INSTANCE = new SimplePing();
    private static final int MAX_NUM = 5;

    private SimplePing() {
    }

    @Override
    public CheckResult check(CheckBean checkBean) {
        if (StringUtil.isEmpty(checkBean.getIpOrHostName())) {
            throw new IscBizException(ResManager.loadKDString("ip\u6216\u57df\u540d\u4e3a\u7a7a", "SimplePing_0", "isc-iscb-util", new Object[0]));
        }
        long start = System.currentTimeMillis();
        return this.executeSimple(checkBean, start);
    }

    private CheckResult executeSimple(CheckBean checkBean, long start) {
        try {
            InetAddress inetAddress = InetAddress.getByName(checkBean.getIpOrHostName());
            StringBuilder sb = new StringBuilder();
            sb.append(inetAddress.getHostAddress()).append(ResManager.loadKDString(" \u7684 Ping \u7edf\u8ba1\u4fe1\u606f:", "SimplePing_7", "isc-iscb-util", new Object[0])).append("\r\n");
            int i = 1;
            while (i <= 5) {
                long eachStart = System.currentTimeMillis();
                boolean reachable = inetAddress.isReachable(checkBean.getTimeout());
                long span = System.currentTimeMillis() - eachStart;
                if (reachable) {
                    sb.append(String.format(ResManager.loadKDString("\u7b2c %1$s \u6b21 PING %2$s \u6210\u529f\uff0c\u8017\u65f6\uff1a%3$sms", "SimplePing_4", "isc-iscb-util", new Object[0]), i, inetAddress.getHostAddress(), span));
                } else {
                    sb.append(String.format(ResManager.loadKDString("\u7b2c %1$s \u6b21 PING %2$s \u5931\u8d25\uff0c\u8017\u65f6\uff1a%3$sms", "SimplePing_5", "isc-iscb-util", new Object[0]), i, inetAddress.getHostAddress(), span));
                }
                sb.append("\r\n");
                ++i;
            }
            return new CheckResult(true, sb.toString(), start);
        }
        catch (Exception e) {
            return new CheckResult(false, CheckNetWorkUtil.toString(e), start);
        }
    }
}

