/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.erp.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.eas.custom.erp.util.HttpsReqUtil;
import com.kingdee.eas.custom.erp.util.SynPublicUtils;
import com.kingdee.eas.custom.erp.util.SynSalaryFromErpUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynPositionToErpUtils {
    private static Logger log = LoggerFactory.getLogger(SynPositionToErpUtils.class);
    private static String ierp = "https://sites.gtiit.edu.cn/kderpdev/ierp";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getGt15BosPositionAddUrl() {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/kapi/v2/gt15/base/bos_position/gt15_bos_position_add").toString();
    }

    public static String getBosPositionDisableUrl() {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/kapi/v2/gt15/base/bos_position/gt15_bos_position_disable").toString();
    }

    public static void synPostionToErp(Context ctx, String startDate, String endDate) throws Exception {
        String appToken = SynSalaryFromErpUtils.getAppToken(ctx);
        log.info("synPostionToErp.appToken\uff1a" + appToken);
        String accessToken = SynSalaryFromErpUtils.getAccessToken(appToken);
        log.info("synPostionToErp.accessToken\u72b6\u6001\u4e3a\uff1a" + accessToken);
        SynPositionToErpUtils.gt15_bos_position_add(ctx, accessToken, startDate, endDate);
    }

    public static String synPositionDisableToErp(Context ctx, String startDate, String endDate) throws Exception {
        String appToken = SynSalaryFromErpUtils.getAppToken(ctx);
        log.info("SynPositionToErpUtils.appToken\uff1a" + appToken);
        String accessToken = SynSalaryFromErpUtils.getAccessToken(appToken);
        log.info("SynPositionToErpUtils.accessToken\u4e3a\uff1a" + accessToken);
        SynPositionToErpUtils.bosPositionDisable(ctx, accessToken, startDate, endDate);
        log.info("SynPositionToErpUtils.responseMsg\uff1a" + accessToken);
        return "";
    }

    public static String gt15_bos_position_add(Context ctx, String accessToken, String startDate, String endDate) throws Exception {
        String gt15BosPositionAddUrl = SynPositionToErpUtils.getGt15BosPositionAddUrl();
        log.info("SynPositionToErpUtils.gt15_bos_position_add.gt15BosPositionAddUrl:" + gt15BosPositionAddUrl);
        String paramJOStr = SynPositionToErpUtils.getBosPositionDetailEntry(ctx, startDate, endDate);
        log.info("SynPositionToErpUtils.gt15_adminorg_add.paramJOStr:" + paramJOStr);
        if (StringUtils.isEmpty((CharSequence)paramJOStr)) {
            return "";
        }
        String responseMsg = HttpsReqUtil.postByHttps(gt15BosPositionAddUrl, paramJOStr, accessToken);
        return responseMsg;
    }

    public static void bosPositionDisable(Context ctx, String accessToken, String startDate, String endDate) throws Exception {
        String gtBosPositionDisableUrl = SynPositionToErpUtils.getBosPositionDisableUrl();
        log.info("SynPositionToErpUtils.bosPositionDisable.gtBosPositionDisableUrl:" + gtBosPositionDisableUrl);
        List<String> numbers = SynPositionToErpUtils.getBosPositionDisableDetailEntry(ctx, startDate, endDate);
        log.info("SynPositionToErpUtils.bosPositionDisable.numbers:" + numbers.size());
        for (String number : numbers) {
            String paramJOStr = SynPositionToErpUtils.getParamJOStrByNumber(number);
            String string = HttpsReqUtil.postByHttps(gtBosPositionDisableUrl, paramJOStr, accessToken);
        }
    }

    public static String getParamJOStrByNumber(String number) {
        JSONObject data = new JSONObject();
        data.put("number", (Object)number);
        JSONObject paramJO = new JSONObject();
        paramJO.put("data", (Object)data);
        String paramJOStr = paramJO.toString();
        return paramJOStr;
    }

    public static List<String> getBosPositionDisableDetailEntry(Context ctx, String startDateStr, String endDateStr) throws BOSException, SQLException {
        String lastDateZeroTimeStr = "";
        String noeTimeStr = "";
        if (StringUtils.isEmpty((CharSequence)startDateStr) || StringUtils.isEmpty((CharSequence)endDateStr)) {
            lastDateZeroTimeStr = SynPublicUtils.getLastUpdateSynTableTimeStrByEvenName(ctx, "synPositionDisable");
            if (StringUtils.isEmpty((CharSequence)lastDateZeroTimeStr)) {
                lastDateZeroTimeStr = SynPublicUtils.getLastDateZeroTime();
            }
            SynPublicUtils.updateSynTimeTable(ctx, "synPositionDisable");
            noeTimeStr = SynPublicUtils.getNowTimeStr();
        } else {
            lastDateZeroTimeStr = startDateStr;
            noeTimeStr = endDateStr;
        }
        String sql = " select fnumber as number from T_ORG_Position where fdeletedstatus = 2  and  (flastupdatetime> {ts '" + lastDateZeroTimeStr + "'} and  flastupdatetime <=  {ts '" + noeTimeStr + "'})";
        log.info("getBosPositionDisableDetailEntry.sql" + sql);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> numbers = new ArrayList<String>();
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                String number = executeQuery.getString("number");
                numbers.add(number);
            }
        }
        return numbers;
    }

    private static String getLastUpdateSynTableTimeStrByEvenName(Context ctx, String evenName) throws BOSException, SQLException {
        String sql = "select event_timestamp as evenTimeStamp from T_HR_SynTimeTable where event_name = '" + evenName + "'";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        Date evenTimeStamp = null;
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                evenTimeStamp = executeQuery.getDate("evenTimeStamp");
            }
        }
        String lastUpdateTimeStr = "";
        if (evenTimeStamp != null) {
            lastUpdateTimeStr = dateFormat.format(evenTimeStamp);
        }
        return lastUpdateTimeStr;
    }

    private static String getNowTimeStr() {
        java.util.Date now = new java.util.Date();
        String formattedDateTime = dateFormat.format(now);
        return formattedDateTime;
    }

    private static String getBosPositionDetailEntry(Context ctx, String startDateStr, String endDateStr) throws BOSException, SQLException {
        String lastDateZeroTimeStr = "";
        String noeTimeStr = "";
        if (StringUtils.isEmpty((CharSequence)startDateStr) || StringUtils.isEmpty((CharSequence)endDateStr)) {
            lastDateZeroTimeStr = SynPublicUtils.getLastUpdateSynTableTimeStrByEvenName(ctx, "SynPosition");
            if (StringUtils.isEmpty((CharSequence)lastDateZeroTimeStr)) {
                lastDateZeroTimeStr = SynPublicUtils.getLastDateZeroTime();
            }
            SynPublicUtils.updateSynTimeTable(ctx, "SynPosition");
            noeTimeStr = SynPublicUtils.getNowTimeStr();
        } else {
            lastDateZeroTimeStr = startDateStr;
            noeTimeStr = endDateStr;
        }
        String sql = "/*dialect*/select position.fnumber as  number ,position.fname_l1, position.fname_l2,position.fname_l3,admin.fnumber as dpt_number,position2.fnumber as superiorposition_number,position.fdescription_l1 as description_l1,position.fdescription_l2 as description_l2,position.fdescription_l3 as description_l3,position.fisRespPosition isRespPosition from T_ORG_Position position  left join T_org_admin admin on admin.fid = position.fadminorgunitid left join T_ORG_Position position2 on position2.fid = position.fparentid  where (  (position.flastupdatetime >  {ts '" + lastDateZeroTimeStr + "'} and  position.flastupdatetime <=  {ts '" + noeTimeStr + "'} )" + " or   (admin.flastupdatetime >  {ts '" + lastDateZeroTimeStr + "'} and  admin.flastupdatetime <=  {ts '" + noeTimeStr + "'} )" + " or (position2.flastupdatetime >  {ts '" + lastDateZeroTimeStr + "'} and  position2.flastupdatetime <=  {ts '" + noeTimeStr + "'} )) ";
        log.info("getBosPositionDetailEntry.sql:" + sql);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        JSONArray datas = new JSONArray();
        String paramJOStr = "";
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                String number = executeQuery.getString("number");
                String name_l1 = executeQuery.getString("fname_l1");
                String name_l2 = executeQuery.getString("fname_l2");
                String name_l3 = executeQuery.getString("fname_l3");
                String dpt_number = executeQuery.getString("dpt_number");
                String superiorposition_number = executeQuery.getString("superiorposition_number");
                String description_l1 = executeQuery.getString("description_l1");
                String description_l2 = executeQuery.getString("description_l2");
                String description_l3 = executeQuery.getString("description_l3");
                boolean isRespPosition = executeQuery.getBoolean("isRespPosition");
                log.info("getBosPositionDetailEntry.isRespPosition:" + isRespPosition);
                JSONObject data = new JSONObject();
                data.put("number", (Object)number);
                JSONObject name = new JSONObject();
                name.put("en_US", (Object)name_l1);
                name.put("zh_CN", (Object)name_l2);
                name.put("zh_TW", (Object)name_l3);
                data.put("name", (Object)name);
                data.put("dpt_number", (Object)dpt_number);
                data.put("superiorposition_number", (Object)superiorposition_number);
                data.put("ismainposition", (Object)isRespPosition);
                datas.add((Object)data);
            }
            JSONObject paramJO = new JSONObject();
            paramJO.put("data", (Object)datas);
            paramJOStr = paramJO.toString();
        }
        return paramJOStr;
    }
}

