/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.rpc.ObjectFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.Util;
import kd.isc.connector.eas.e.GetTableInfo;
import kd.isc.iscb.util.connector.Response;
import kd.isc.iscb.util.connector.SaveDataType;
import kd.isc.iscb.util.connector.TableAction;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;

public class DoDataAction
extends AbstractCommandExecutor {
    protected Object exec(ConnectorContext ctx, Map<String, Object> params) {
        try {
            Context bos_context = Util.generateBosCtx(ctx, null);
            String mainTable = D.s((Object)params.get("mainTable"));
            Map entryTables = (Map)params.get("entryTables");
            Map data = (Map)params.get("data");
            Map judgeFields = (Map)params.get("judgeFields");
            List actions = (List)params.get("actions");
            Method m = DoDataAction.class.getMethod("doAction", Context.class, Map.class, String.class, Map.class, Map.class, List.class);
            Response res = (Response)ObjectFactory.invokeRequired((Object)((Object)this), (Method)m, (Object[])new Object[]{bos_context, data, mainTable, entryTables, judgeFields, actions});
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("id", res.getId());
            result.put("type", res.getType().name());
            result.put("$entry_mapping", res.getEntryMappings());
            return result;
        }
        catch (Exception e) {
            throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
        }
    }

    public Response doAction(Context ctx, Map<String, Object> data, String mainTableName, Map<String, Map<String, String>> entryTableNames, Map<String, List<String>> judgeFields, List<String> actions) {
        Connection cn = null;
        try {
            cn = DbConnector.getConnection((Context)ctx);
            Table mainTable = GetTableInfo.getTable(cn, mainTableName);
            String first = actions.get(0);
            if (first.endsWith(".delete")) {
                Response response = this.executeDeleteOperation(ctx, data, cn, mainTable, first, judgeFields);
                return response;
            }
            Response res = this.executeTableAction(cn, data, mainTable, entryTableNames, judgeFields, actions);
            if (res.getType() == SaveDataType.DELETE || res.getType() == SaveDataType.NOP) {
                Response response = res;
                return response;
            }
            this.executeBizOperation(ctx, res, actions);
            Response response = res;
            return response;
        }
        catch (Exception e) {
            throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }

    private void executeBizOperation(Context ctx, Response res, List<String> actions) throws BOSException, EASBizException {
        String id = res.getId();
        CoreBaseInfo info = null;
        ICoreBase finder = null;
        for (String action : actions) {
            int i = action.indexOf(46);
            if (i <= 0) continue;
            String bostype = action.substring(0, i);
            if (info == null || !info.getBOSType().toString().equals(bostype)) {
                finder = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bostype));
                info = finder.getValue("where id ='" + id + "'");
            }
            String operation = action.substring(i + 1);
            this.invokeOperation(res, info, finder, action, operation);
        }
    }

    private void invokeOperation(Response res, CoreBaseInfo info, ICoreBase finder, String action, String operation) throws BOSException, EASBizException {
        if ("submit".equals(operation)) {
            finder.submit(info);
        } else if ("update".equals(operation)) {
            finder.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
        } else if ("cancel".equals(operation)) {
            finder.cancel((IObjectPK)new ObjectUuidPK(info.getId()), info);
        } else if ("uncancel".equals(operation)) {
            finder.cancelCancel((IObjectPK)new ObjectUuidPK(info.getId()), info);
        } else if ("revise".equals(operation)) {
            finder.revise((IObjectPK)new ObjectUuidPK(info.getId()), info);
        } else {
            if ("addnew".equals(operation)) {
                throw new IscBizException(res.getType() + "\u64cd\u4f5c\u540e\u9762\u4e0d\u5e94\u8be5\u518d\u64cd\u4f5caddnew\uff0c\u8bf7\u8c03\u6574\u65b9\u6848");
            }
            if ("save".equals(operation)) {
                throw new IscBizException(res.getType() + "\u64cd\u4f5c\u540e\u9762\u4e0d\u5e94\u8be5\u518d\u64cd\u4f5csave\uff0c\u8bf7\u8c03\u6574\u65b9\u6848");
            }
            if ("delete".equals(operation)) {
                throw new IscBizException(res.getType() + "\u64cd\u4f5c\u540e\u9762\u4e0d\u5e94\u8be5\u518d\u64cd\u4f5cdelete\uff0c\u8bf7\u8c03\u6574\u65b9\u6848");
            }
            throw new UnsupportedOperationException(action);
        }
    }

    private Response executeTableAction(Connection cn, Map<String, Object> data, Table mainTable, Map<String, Map<String, String>> entryTableNames, Map<String, List<String>> judgeFields, List<String> actions) {
        Map<String, Pair<Table, String>> entryTables = this.getEntryTables(entryTableNames, cn);
        Response res = TableUtil.doAction((Connection)cn, data, (Table)mainTable, entryTables, judgeFields, (TableAction)TableAction.valueOf((String)this.getTableAction(actions)));
        return res;
    }

    private Response executeDeleteOperation(Context ctx, Map<String, Object> data, Connection cn, Table mainTable, String firstAction, Map<String, List<String>> judgeFields) throws BOSException, EASBizException {
        Object id = TableUtil.queryPrimaryKey(data, (Table)mainTable, null, judgeFields.get("$"), (Connection)cn);
        if (id == null) {
            return new Response(null, SaveDataType.NOP, null);
        }
        int i = firstAction.indexOf(46);
        String bostype = firstAction.substring(0, i);
        ICoreBase finder = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bostype));
        IObjectPK[] list = finder.delete("where id ='" + id + "'");
        if (list == null || list.length == 0) {
            return new Response(null, SaveDataType.NOP, null);
        }
        return new Response(D.s((Object)list[0]), SaveDataType.DELETE, null);
    }

    private String getTableAction(List<String> actions) {
        String first = actions.get(0);
        if (first.indexOf(46) >= 0) {
            return TableAction._SAVE.name();
        }
        return first;
    }

    private Map<String, Pair<Table, String>> getEntryTables(Map<String, Map<String, String>> entryTableNames, Connection cn) {
        HashMap<String, Pair<Table, String>> entryTables = new HashMap<String, Pair<Table, String>>();
        for (Map.Entry<String, Map<String, String>> e : entryTableNames.entrySet()) {
            Map<String, String> item = e.getValue();
            Table table = GetTableInfo.getTable(cn, item.get("table"));
            String masterField = item.get("master");
            entryTables.put(e.getKey(), (Pair<Table, String>)new Pair((Object)table, (Object)masterField));
        }
        return entryTables;
    }

    public String getCommand() {
        return "do_data_action";
    }
}

