/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.trace;

import java.util.ArrayList;
import java.util.List;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.i.c.Command;
import kd.isc.iscb.util.flow.core.i.c.composite.CallSubFlow;
import kd.isc.iscb.util.flow.core.i.model.NodeImpl;
import kd.isc.iscb.util.flow.trace.Line;

public class CommandLineCollector {
    public static List<Line> collectLines(Flow flow) {
        ArrayList<Line> lines = new ArrayList<Line>();
        CommandLineCollector.collectLines(flow, 0, lines);
        return lines;
    }

    private static void collectLines(Flow flow, int tab, List<Line> lines) {
        lines.add(new Line(String.valueOf(flow.getTitle()) + " {", tab));
        CommandLineCollector.collectLines((NodeImpl)flow.getRoot(), tab + 1, lines);
        lines.add(new Line("}", tab));
    }

    private static void collectLines(NodeImpl node, int tab, List<Line> lines) {
        lines.add(new Line(node + "::" + node.getId() + " {", tab));
        CommandLineCollector.collectCommandLines(node, tab + 2, lines);
        CommandLineCollector.collectSubFlowLines(node, tab + 1, lines);
        CommandLineCollector.collectChildrenLines(node, tab + 1, lines);
        lines.add(new Line("}", tab));
    }

    private static void collectCommandLines(NodeImpl node, int tab, List<Line> lines) {
        int i = 0;
        int j = node.getCommandCount();
        while (i < j) {
            Command cmd = node.getCommand(i);
            lines.add(new Line(cmd + ";", node, i, tab));
            ++i;
        }
    }

    private static void collectChildrenLines(NodeImpl node, int tab, List<Line> lines) {
        for (String id : node.getGraph().wfsVisit()) {
            NodeImpl child = node.getFlow().getNode(id);
            CommandLineCollector.collectLines(child, tab, lines);
        }
    }

    private static void collectSubFlowLines(NodeImpl node, int tab, List<Line> lines) {
        int i = 0;
        int j = node.getCommandCount();
        while (i < j) {
            Command cmd = node.getCommand(i);
            if (cmd instanceof CallSubFlow) {
                try {
                    Flow flow = ((CallSubFlow)cmd).getLoader().getFlow(null);
                    CommandLineCollector.collectLines(flow, tab, lines);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++i;
        }
    }
}

