/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.encoding;

import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.encoding.Hash;
import kd.isc.iscb.util.script.encoding.MurmurHash;

public class Murmur
extends Hash {
    @Override
    public byte[] hash(byte[] message) {
        long h = Murmur.calc(message);
        return this.toBytes(h);
    }

    public byte[] toBytes(long h) {
        byte[] bytes = new byte[8];
        int i = 7;
        while (i >= 0) {
            bytes[i] = (byte)(0xFFL & h);
            h >>>= 8;
            --i;
        }
        return bytes;
    }

    public static String calc16(Object ... values) {
        String s = Murmur.toString(values);
        int h = MurmurHash.hash(s.getBytes(D.UTF_8), 1937006962);
        return Integer.toHexString(h & 0xFFFF).toLowerCase();
    }

    public static String calc24(Object ... values) {
        String s = Murmur.toString(values);
        int h = MurmurHash.hash(s.getBytes(D.UTF_8), 1937006962);
        return Integer.toHexString(h & 0xFFFFFF).toLowerCase();
    }

    public static String calc32(Object ... values) {
        String s = Murmur.toString(values);
        int h = MurmurHash.hash(s.getBytes(D.UTF_8), 1937006962);
        return Integer.toHexString(h).toLowerCase();
    }

    public static long calc(byte[] bytes) {
        return MurmurHash.hash64A(bytes, 1937006962);
    }

    public static int calc32(byte[] bytes) {
        return MurmurHash.hash(bytes, 1937006962);
    }

    private static String toString(Object ... values) {
        if (values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            Object v = values[0];
            return v == null ? "" : v.toString();
        }
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            sb.append(v).append('\n');
            ++n2;
        }
        return sb.toString();
    }
}

