/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.string;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.misc.Xml;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class XmlObject
implements Context,
NativeFunction {
    private static final String CHILDREN_PREFIX = "#children:";
    private static final String TEXT_CONTENT = "#text";
    private Element el;

    XmlObject(Element el) {
        this.el = el;
    }

    private List<XmlObject> getChildren() {
        NodeList nodes = this.el.getChildNodes();
        ArrayList<XmlObject> list = new ArrayList<XmlObject>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                list.add(new XmlObject((Element)node));
            }
            ++i;
        }
        return list;
    }

    @Override
    public boolean set(String property, Object value) {
        if (value == null) {
            value = "";
        }
        if (value instanceof Map) {
            this.addElement(property, (Map)value);
        } else if (value instanceof Collection) {
            this.appendElements(property, (Collection)value);
        } else if (TEXT_CONTENT.equals(property)) {
            this.el.setTextContent(value.toString());
        } else {
            XmlObject.setAttribute(this.el, property, value.toString());
        }
        return true;
    }

    private void appendElements(String property, Collection<?> c) {
        for (Object o : c) {
            if (o instanceof Map) {
                this.addElement(property, (Map)o);
                continue;
            }
            throw new IllegalArgumentException("The elements of collection must be Maps!");
        }
    }

    @Override
    public String name() {
        return "appendChild";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Map attrs;
        String name = args[0].toString();
        Map map = attrs = args.length == 1 ? null : (Map)args[1];
        if (attrs == null) {
            attrs = Collections.EMPTY_MAP;
        }
        Element c = this.addElement(name, attrs);
        return new XmlObject(c);
    }

    private Element addElement(String property, Map<?, ?> map) {
        Element c = this.el.getOwnerDocument().createElement(property);
        for (Map.Entry<?, ?> e : map.entrySet()) {
            Object value = e.getValue();
            if (value == null) continue;
            String a = e.getKey().toString();
            String text = e.getValue().toString();
            XmlObject.setAttribute(c, a, text);
        }
        this.el.appendChild(c);
        return c;
    }

    private static void setAttribute(Element c, String a, String text) {
        c.setAttribute(a, text);
    }

    @Override
    public Object get(String property) {
        if (property.charAt(0) == '#') {
            if (TEXT_CONTENT.equals(property)) {
                return this.el.getTextContent();
            }
            if ("#children".equals(property)) {
                return this.getChildren();
            }
            if (property.startsWith(CHILDREN_PREFIX)) {
                String name = property.substring(CHILDREN_PREFIX.length());
                return this.getChildren(name);
            }
            if ("#name".equals(property)) {
                return this.el.getNodeName();
            }
            if ("#document".equals(property)) {
                return this.getDocumentElement();
            }
            throw new IllegalArgumentException(String.format(ResManager.loadKDString("\u975e\u6cd5\u5c5e\u6027\uff1a%s", "XmlObject_1", "isc-iscb-util", new Object[0]), property));
        }
        if (property.equals("to_text")) {
            return this.toString();
        }
        return this.el.getAttribute(property);
    }

    private Object getChildren(String name) {
        NodeList nodes = this.el.getChildNodes();
        ArrayList<XmlObject> list = new ArrayList<XmlObject>(nodes.getLength());
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element && node.getNodeName().equals(name)) {
                list.add(new XmlObject((Element)node));
            }
            ++i;
        }
        return list;
    }

    private Object getDocumentElement() {
        Element doc = this.el.getOwnerDocument().getDocumentElement();
        return new XmlObject(doc);
    }

    Element getElement() {
        return this.el;
    }

    @Override
    public boolean contains(String property) {
        if (property.charAt(0) == '#') {
            if (property.equals(TEXT_CONTENT)) {
                return this.isNotEmpty(this.el.getTextContent());
            }
            if (property.equals("#children")) {
                return true;
            }
            if (property.startsWith(CHILDREN_PREFIX)) {
                return true;
            }
            if (property.equals("#name")) {
                return true;
            }
            return property.equals("#document");
        }
        if (property.equals("to_text")) {
            return true;
        }
        return this.isNotEmpty(this.el.getAttribute(property));
    }

    private boolean isNotEmpty(String text) {
        if (text == null) {
            return false;
        }
        return text.length() > 0;
    }

    public String toString() {
        return Xml.toString(this.el.getOwnerDocument());
    }

    public String pretty() {
        return Xml.toString(this.el.getOwnerDocument(), true);
    }
}

