/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.define.ActivityDef;
import com.kingdee.bos.workflow.define.ExtendedAttributeDef;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.pa.MessageModelEnum;
import com.kingdee.lightapp.pa.MessageTypeEnum;
import com.kingdee.lightapp.pa.api.IMessageAdapter;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.LocaleUtils;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class WFMessageAdapter
implements IMessageAdapter {
    private static Logger logger = Logger.getLogger(WFMessageAdapter.class);
    private Message message = null;
    private Context ctx = null;
    private MessageModelEnum MESSAGEMODEL = null;
    private Map<String, Map<String, Object>> eidContentMap = null;

    public WFMessageAdapter(Message message) {
        logger.debug((Object)"WFMessageAdapter init");
        this.message = message;
        this.ctx = WFMessageAdapter.createContext(message.getStringHeader("solution"), message.getStringHeader("databaseCenter"));
        this.initMessageModel();
    }

    public boolean isNeedSendXT() {
        return true;
    }

    public MessageTypeEnum getType() {
        return MessageTypeEnum.LINK;
    }

    public MessageModelEnum getModel() {
        return this.MESSAGEMODEL;
    }

    public Map<String, Object> getContent() {
        this.eidContentMap = this.eidContentMap == null ? new HashMap() : this.eidContentMap;
        String dbCode = this.ctx.getAIS();
        XTServiceConfig instance = XTServiceConfig.getInstance();
        String eid = instance.getEidByDbCode(dbCode);
        if (this.eidContentMap.get(eid) != null) {
            return this.eidContentMap.get(eid);
        }
        HashMap<String, Object> contents = new HashMap<String, Object>();
        this.eidContentMap.put(eid, contents);
        String content = this.parseContent();
        try {
            contents.put("text", content);
            Locale locale = this.getConfigLocale(eid);
            String title = this.message.getLocaleStringHeader("predetails", locale);
            String assignId = this.message.getStringHeader("assignid");
            String host = instance.getPubAcctProperty(eid, "WFMessage", "host", "");
            String appId = instance.getPubAcctProperty(eid, "WFMessage", "appId", "");
            String url = this.getUrl(assignId, eid, host, appId);
            String itemtitle = title;
            String msgShow = instance.getPubAcctProperty(eid, "WFMessage", "MsgShow", "");
            if ("1".equals(msgShow)) {
                itemtitle = StringUtils.isEmpty((CharSequence)title) ? "\u6d41\u7a0b\u52a9\u624b" : title.substring(title.lastIndexOf("\u7684") + 1, title.length());
                itemtitle = "l1".equalsIgnoreCase(locale.getDisplayName()) && "\u6d41\u7a0b\u52a9\u624b".equals(itemtitle) ? "Process Assistant" : itemtitle;
            }
            contents.put("itemtitle", itemtitle);
            contents.put("title", this.message.getStringHeader("sendNamel1"));
            contents.put("sendId", this.message.getStringHeader("sendId"));
            contents.put("receiver", this.message.getStringHeader("receiver"));
            contents.put("url", url);
            String bizfunction = this.message.getStringHeader("bizfunction");
            String passUrl = this.getPassUrl(assignId, eid, bizfunction);
            if (passUrl != null) {
                contents.put("passUrl", passUrl);
            }
            contents.put("assignId", assignId);
            contents.put("appid", appId);
            contents.put("todoPriStatus", "undo");
            contents.put("billID", this.message.getStringHeader("billID"));
            logger.info((Object)("XT Message URL: " + url));
            String WXMsgType = instance.getPubAcctProperty(eid, "WFMessage", "WXMsgType", "");
            if (!StringUtils.isEmpty((CharSequence)WXMsgType) && "MultiApproveUIFunction".equalsIgnoreCase(bizfunction)) {
                contents.put("WXMsgType", WXMsgType);
            }
            if (!StringUtils.isEmpty((CharSequence)title)) {
                String sendName = title.substring(0, title.lastIndexOf("\u7684")).replace("\u63d0\u4ea4", "");
                contents.put("sendName", sendName);
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getContent() error!", (Throwable)e);
        }
        return contents;
    }

    private String getPassUrl(String assignId, String eid, String bizfunction) {
        String passUrl = null;
        String signKey = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "signKey", "");
        try {
            if (!StringUtils.isEmpty((CharSequence)signKey) && "MultiApproveUIFunction".equalsIgnoreCase(bizfunction)) {
                String host = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "host", "");
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)this.ctx);
                Map actmap = service.getActivityDefAndActivityInstInfo(assignId);
                ActivityDef def = (ActivityDef)actmap.get("ACTIVITYDEF");
                ExtendedAttributeDef ed = def.getActivityHeader().getExtendedAttributes().get("customUIStatus");
                if (ed == null || StringUtils.isEmpty((CharSequence)ed.getValue()) || "view".equalsIgnoreCase(ed.getValue())) {
                    passUrl = host.indexOf("?") > -1 ? String.valueOf(host.substring(0, host.lastIndexOf("/page"))) + "/auth/batchDealTodo?eid=" + eid : String.valueOf(host) + "/batchDealTodo.action";
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"getPassUrl for yunzhijia failed", (Throwable)e);
        }
        return passUrl;
    }

    private String getUrl(String assignid, String eid, String host, String appId) throws Exception {
        String newEid = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "eid", "");
        logger.info((Object)("XT Message newEidnewEid=" + newEid));
        String url = host;
        IEnactmentService svc = EnactmentServiceFactory.createEnactService((Context)this.ctx);
        AssignmentInfo info = svc.getAssignmentById(assignid);
        String billID = this.message.getStringHeader("billID");
        if (host.indexOf("?") > -1) {
            String actdef = info.getActDefId();
            String procdef = info.getProcDefId();
            String mbosUrl = this.getMbosUrl(procdef, actdef, eid);
            if (!StringUtils.isEmpty((CharSequence)mbosUrl)) {
                host.substring(host.indexOf("&"), host.length());
                mbosUrl = mbosUrl.replace("page/loadPage", "mbosw/getWorkflowUrl");
                url = String.valueOf(mbosUrl) + "&eid=" + newEid + "&assignId=" + assignid + "&appid=" + appId + "&billID=" + URLEncoder.encode(billID, "utf-8");
                url = String.valueOf(url) + (host.contains("&") ? host.substring(host.indexOf("&"), host.length()) : "");
                return url;
            }
        }
        url = host.indexOf("?") > -1 ? String.valueOf(url) + "&storeEid=21231&name=approveui.navui&eid=" + newEid + "&assignId=" + assignid + "&appid=" + appId : String.valueOf(url) + "/dealWithNotice.html?eid=" + newEid + "&assignId=" + assignid + "&appid=" + appId;
        return url;
    }

    private String getMbosUrl(String procid, String actDefId, String eid) {
        String url = "";
        try {
            IRowSet rowSet;
            StringBuffer sql = new StringBuffer("SELECT url FROM T_WFR_MBOS_WORKFLOW WHERE url like '%eid=" + eid + "%'");
            if (!StringUtils.isEmpty((CharSequence)actDefId)) {
                sql.append(" and actDefId in ('" + actDefId + "')");
            }
            if (!StringUtils.isEmpty((CharSequence)procid)) {
                sql.append(" and procdefid in ('" + procid + "')");
            }
            if ((rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString())).next()) {
                url = rowSet.getString("url");
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return url;
    }

    private String parseContent() {
        String msgContent = null;
        String eid = XTServiceConfig.getInstance().getEidByDbCode(this.ctx.getAIS());
        Locale locale = this.getConfigLocale(eid);
        try {
            msgContent = this.message.getLocaleStringHeader("body", locale);
            if (MessageModelEnum.FLOWCENTERTODO == this.MESSAGEMODEL || msgContent == null || msgContent.equals("")) {
                msgContent = this.message.getLocaleStringHeader("title", locale);
            }
            logger.debug((Object)("body=" + this.message.getLocaleStringHeader("body", locale) + ",title=" + this.message.getLocaleStringHeader("title", locale)));
        }
        catch (Exception e) {
            logger.error((Object)"XT Message parseContent() error!", (Throwable)e);
        }
        String result = "";
        result = msgContent;
        return result;
    }

    public List<String> getUsers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            IUser user = UserFactory.getLocalInstance((Context)this.ctx);
            String msgReceiver = this.message.getStringHeader("receiver");
            logger.info((Object)("XT Message getUsers() msgReceiver: " + msgReceiver));
            if (msgReceiver != null) {
                list.add(msgReceiver);
                logger.info((Object)("XT Message getUsers() userID:" + msgReceiver));
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message getUsers() error!", (Throwable)e);
        }
        return list;
    }

    public Date getUpdateTime() {
        return new Date();
    }

    public void clearTemporary() {
    }

    private Locale getConfigLocale(String eid) {
        String localeStr = XTServiceConfig.getInstance().getLocale(eid);
        localeStr = StringUtils.isEmpty((CharSequence)localeStr) ? "L2" : localeStr;
        return LocaleUtils.getLocale((String)localeStr);
    }

    private static Context createContext(String solution, String ais) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), solution, ais, new Locale("l2"));
        return context;
    }

    private void initMessageModel() {
        boolean ifInit = false;
        String apiVersion = (String)XTServiceConfig.getInstance().getXTInfoProperties().get("apiVersion");
        try {
            if ("flowcenter".equalsIgnoreCase(apiVersion)) {
                String sendId = this.message.getStringHeader("sendId");
                String quarySql = "SELECT 1 FROM T_PM_EASXTUSERMAP WHERE FUSERID = ? OR FPERSONID = ? ";
                IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)quarySql, (Object[])new Object[]{sendId, sendId});
                if (rowSet.next()) {
                    ifInit = true;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"XT Message ifInitFlowCenterMoudle error!", (Throwable)e);
        }
        if (ifInit) {
            this.MESSAGEMODEL = MessageModelEnum.FLOWCENTERTODO;
        }
    }
}

