/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.lightapp.message.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.jms.TextMessage;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.message.AssignmentCreationEvent;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.lightapp.message.WFMessageHandler;
import com.kingdee.lightapp.xt.XTServiceConfig;
import com.kingdee.util.StringUtils;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LightAppProcessAssistHandler {
    private static final Logger logger = Logger.getLogger(LightAppProcessAssistHandler.class);

    public static void processAssistHandle(AssignmentCreationEvent ed) {
        block12: {
            if (ed != null && !StringUtils.isEmpty((String)ed.assignmentId) && ed.isSendCommon) {
                try {
                    Context ctx = LightAppProcessAssistHandler.getContext(ed.solution, ed.databaseCenter);
                    String dbCode = ctx.getAIS();
                    String eid = XTServiceConfig.getInstance().getEidByDbCode(dbCode);
                    if (ed == null || StringUtils.isEmpty((String)ed.assignmentId) || !ed.isSendCommon || !LightAppProcessAssistHandler.checkIsSupportProcessAssist(ed)) break block12;
                    TextMessage message = new TextMessage();
                    message.setStringHeader("databaseCenter", ed.databaseCenter);
                    message.setStringHeader("solution", ed.solution);
                    message.setStringHeader("receiver", ed.receiver);
                    message.setStringHeader("assignid", ed.assignmentId);
                    message.setStringHeader("sendId", ed.initiatorId);
                    message.setStringHeader("bizfunction", ed.functionName);
                    Map name = ed.initiatorName;
                    String billID = ed.bizObjId;
                    BOSObjectType bostype = null;
                    EntityObjectInfo entityinfo = null;
                    String pk = "";
                    boolean sendMessage = true;
                    if (billID != null) {
                        bostype = BOSUuid.getBOSObjectType((String)billID, (boolean)true);
                        entityinfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bostype);
                        pk = entityinfo.getFullName();
                    }
                    message.setStringHeader("billID", billID);
                    String checkSend = XTServiceConfig.getInstance().getPubAcctProperty(eid, "WFMessage", "checkSend", "");
                    if ("true".equals(checkSend) && !StringUtils.isEmpty((String)pk)) {
                        try {
                            String sql = "SELECT FISSHOWINMOBILE FROM T_BILL_ASSIGN WHERE FISSHOWINMOBILE =0 AND FMETADATAPK = ?";
                            IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk});
                            if (countRowSet.size() > 0) {
                                sendMessage = false;
                            }
                        }
                        catch (Exception sql) {
                            // empty catch block
                        }
                    }
                    if (sendMessage) {
                        int i = 1;
                        while (i < 4) {
                            Locale locale = new Locale("L" + i);
                            String initiatorName = (String)name.get(locale);
                            String billAlias = "";
                            if (entityinfo != null) {
                                billAlias = entityinfo.getAlias(locale);
                                billAlias = i == 1 && StringUtils.isEmpty((String)billAlias) ? entityinfo.getBaseEntity().getName() : billAlias;
                                billAlias = i == 3 && StringUtils.isEmpty((String)billAlias) ? entityinfo.getAlias(new Locale("L2")) : billAlias;
                            }
                            String pre = new StringBuilder(initiatorName == null ? "" : new StringBuilder(initiatorName).append("\u7684")).append(billAlias).toString();
                            message.setLocaleStringHeader("predetails", pre, locale);
                            message.setLocaleStringHeader("title", (String)ed.titles.get(locale), locale);
                            message.setLocaleStringHeader("body", (String)ed.bodies.get(locale), locale);
                            ++i;
                        }
                        if (bostype == null || bostype != null && !"F4C22AF9".equals(bostype.toString())) {
                            WFMessageHandler.sendMessageToXT((Message)message, ctx);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Send XT WorkFlow_Message Error:: ", (Throwable)e);
                }
            }
        }
    }

    private static Context getContext(String currentSolutionName, String currentDatabaseCenter) {
        Context context = new Context((IObjectPK)new ObjectUuidPK(), currentSolutionName, currentDatabaseCenter, new Locale("l2"));
        return context;
    }

    private static boolean checkIsSupportProcessAssist(AssignmentCreationEvent ed) {
        boolean flag = true;
        try {
            flag = ed.isSupportProcessAssist;
        }
        catch (Throwable e) {
            logger.error((Object)"LightAppProcessAssistHandler no field isSupportProcessAssist !");
        }
        return flag;
    }

    public void execute(AssignmentCreationEvent ed) {
        LightAppProcessAssistHandler.processAssistHandle(ed);
    }
}

