/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.mailApprove;

import com.google.common.collect.Lists;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailApproveHtmlDTO;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailDigestField;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class MailDigestArea {
    private static Logger logger = Logger.getLogger(MailDigestArea.class);
    private static final String digestHtml = "<div id=\"{{billDigestArea}}\" class=\"subArea\" style=\"display: flex ;flex-wrap: wrap\">\n    <div id = \"{{digestTitle}}\"  class=\"c_titleDiv\" style=\"flex-basis: 100%\">\n        <span style=\"color: #5582F3;\">|</span>\n        <span id = \"{{digestTitleContent}}\" style=\"margin-bottom:0;\">{{billDigestTitle}}</span>\n    </div>\n</div>";
    private static final String digestFiledHtml = "<div id = \"{{digestField}}\" class=\"c_fieldDiv\"><span style = \"flex-basis: 85px;text-align: right\">{{digestFieldName}}</span><span style = \"flex-basis: 20px;text-align: center\">:</span><span style = \"flex-basis: 85%;\">{{digestFieldValue}}</span></div>";
    private static final String digestTableHtml = "   <tr id=\"{{billDigestArea}}\">\n    <td colspan=\"{{td_col_count_}}\">\n     <span style=\"color: #5582F3;font-weight: 800;font-family: MicrosoftYaHeiSemibold;font-size: 14px;\">|</span>\n     <span id = \"{{digestTitleContent}}\" style=\"{{digest_titleContentStyle_}}\">{{billDigestTitle}}</span>\n    </td>\n   </tr>\n {{tdHtml}}";
    private static final String digestTableFieldHtml = "<td id = \"{{digestField}}\" colspan=\"1\"><span style=\"{{digestFieldStyle_}}\">{{digestFieldName}} : {{digestFieldValue}}</span></td>\n";
    private String divId;
    private String title;
    private String titleStyle;
    private String titleContentStyle;
    private Integer colCount;
    List<MailDigestField> billDigestFields;

    public String getTitle() {
        return this.title;
    }

    public MailDigestArea setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getTitleStyle() {
        return this.titleStyle;
    }

    public MailDigestArea setTitleStyle(String titleStyle) {
        this.titleStyle = titleStyle;
        return this;
    }

    public List<MailDigestField> getBillDigestFields() {
        return this.billDigestFields;
    }

    public MailDigestArea setBillDigestFields(List<MailDigestField> billDigestFields) {
        this.billDigestFields = billDigestFields;
        return this;
    }

    public String getDivId() {
        return this.divId;
    }

    public MailDigestArea setDivId(String divId) {
        this.divId = divId;
        return this;
    }

    public String getTitleContentStyle() {
        return this.titleContentStyle;
    }

    public MailDigestArea setTitleContentStyle(String titleContentStyle) {
        this.titleContentStyle = titleContentStyle;
        return this;
    }

    public Integer getColCount() {
        return this.colCount;
    }

    public MailDigestArea setColCount(Integer colCount) {
        this.colCount = colCount;
        return this;
    }

    public static Map<String, String> buildDigestArea(MailApproveHtmlDTO mailApproveHtmlDTO) {
        if ("DIV".equals(mailApproveHtmlDTO.getModelStyle())) {
            return MailDigestArea.buildDigestAreaWithDiv(mailApproveHtmlDTO);
        }
        return MailDigestArea.buildDigestAreaWithTable(mailApproveHtmlDTO);
    }

    public static Map<String, String> buildDigestAreaWithTable(MailApproveHtmlDTO mailApproveHtmlDTO) {
        MailDigestArea digestArea = mailApproveHtmlDTO.getMailDigestArea();
        HashMap<String, String> idHtmlMap = new HashMap<String, String>();
        String html = digestTableHtml;
        if (StringUtils.isBlank((CharSequence)digestArea.getTitle())) {
            html = "{{tdHtml}}";
        }
        html = html.replace("{{billDigestTitle}}", MailApproveHtmlDTO.replaceNullStr(digestArea.getTitle()));
        html = digestArea.getTitleContentStyle() != null && !"".equals(digestArea.getTitleContentStyle()) ? html.replace("{{digest_titleContentStyle_}}", digestArea.getTitleContentStyle().replace("\"", "'")) : html.replace("{{digest_titleContentStyle_}}", "font-weight: 800;font-family: MicrosoftYaHeiSemibold;font-size: 14px;");
        List<MailDigestField> digestFields = digestArea.getBillDigestFields();
        StringBuilder digestTdStr = new StringBuilder("");
        if (!digestFields.isEmpty()) {
            Integer colCount = digestArea.getColCount();
            if (colCount == null || colCount == 0) {
                MailDigestField field = digestArea.getBillDigestFields().get(0);
                String fieldStyle = field.getFieldStyle();
                String[] split = fieldStyle.split(";");
                try {
                    String[] stringArray = split;
                    int n = split.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String singleStyle = stringArray[n2];
                        String[] singleStyleArr = singleStyle.split(":");
                        if (singleStyleArr.length >= 2 && "flex-basis".equals(singleStyleArr[0]) && !"%".equals(singleStyleArr[1])) {
                            String percent = singleStyleArr[1].substring(0, singleStyleArr[1].length() - 1);
                            colCount = 100 / Integer.parseInt(percent.trim());
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception e) {
                    logger.error((Object)("err , \u90ae\u4ef6\u5ba1\u6279\u89e3\u6790\u5386\u53f2\u6570\u636e\u7684\u5217\u6570\u51fa\u73b0\u5f02\u5e38 , procDefId = " + mailApproveHtmlDTO.getProcDefId()), (Throwable)e);
                }
                if (colCount == null || colCount == 0) {
                    colCount = 2;
                }
                digestArea.setColCount(colCount);
            }
            ArrayList<MailDigestField> displayFields = new ArrayList<MailDigestField>();
            for (MailDigestField digestField : digestFields) {
                if (digestField.getOutDisplayValue() != null && !digestField.getOutDisplayValue().booleanValue()) continue;
                displayFields.add(digestField);
            }
            List partition = Lists.partition(displayFields, (int)colCount);
            int cnt = 0;
            for (List mailDigestFields : partition) {
                digestTdStr.append("<tr>");
                for (MailDigestField digestField : mailDigestFields) {
                    String tempFielHtml = digestTableFieldHtml;
                    tempFielHtml = tempFielHtml.replace("{{digestFieldName}}", MailApproveHtmlDTO.replaceNullStr(digestField.getDigestFieldName()));
                    tempFielHtml = tempFielHtml.replace("{{digestFieldValue}}", MailApproveHtmlDTO.replaceNullStr(digestField.getDigestFieldValue()));
                    String fieldStyle = digestField.getFieldStyle();
                    tempFielHtml = StringUtils.isNotBlank((CharSequence)fieldStyle) ? tempFielHtml.replace("{{digestFieldStyle_}}", fieldStyle.replace("\"", "'").replace("padding:10px", "padding-left:10px")) : tempFielHtml.replace("{{digestFieldStyle_}}", "color: #666666;font-size: 12px;font-family:'Microsoft YaHei';padding-left:10px;");
                    tempFielHtml = tempFielHtml.replace("{{digestField}}", "digestField_" + ++cnt);
                    digestTdStr.append(tempFielHtml);
                }
                digestTdStr.append("</tr>\n");
            }
        }
        html = html.replace("{{td_col_count_}}", MailApproveHtmlDTO.calColCount(mailApproveHtmlDTO).toString());
        html = html.replace("{{tdHtml}}", digestTdStr.toString());
        html = html.replace("{{digestTitle}}", "digestTitle");
        html = html.replace("{{digestTitleContent}}", "digestTitleContent");
        if (digestArea.getDivId() != null && !"".equals(digestArea.getDivId())) {
            html = html.replace("{{billDigestArea}}", digestArea.getDivId());
            idHtmlMap.put(digestArea.getDivId(), html);
        } else {
            html = html.replace("{{billDigestArea}}", "billDigestArea");
            idHtmlMap.put("billDigestArea", html);
        }
        return idHtmlMap;
    }

    public static Map<String, String> buildDigestAreaWithDiv(MailApproveHtmlDTO mailApproveHtmlDTO) {
        MailDigestArea digestArea = mailApproveHtmlDTO.getMailDigestArea();
        HashMap<String, String> idHtmlMap = new HashMap<String, String>();
        String html = digestHtml;
        Document digestDoc = Jsoup.parse((String)(html = html.replace("{{billDigestTitle}}", MailApproveHtmlDTO.replaceNullStr(digestArea.getTitle()))));
        Element digestTitle = digestDoc.getElementById("{{digestTitle}}");
        if (digestTitle != null) {
            List<MailDigestField> digestFields;
            Element titleContentEle;
            if (digestArea.getTitleStyle() != null && !"".equals(digestArea.getTitleStyle())) {
                digestTitle.removeAttr("style");
                digestTitle.attr("style", digestArea.getTitleStyle());
            }
            if (digestArea.getTitleContentStyle() != null && !"".equals(digestArea.getTitleContentStyle()) && (titleContentEle = digestDoc.getElementById("{{digestTitleContent}}")) != null) {
                titleContentEle.removeAttr("style");
                titleContentEle.attr("style", digestArea.getTitleContentStyle());
            }
            if (!(digestFields = digestArea.getBillDigestFields()).isEmpty()) {
                int i = digestFields.size() - 1;
                while (i >= 0) {
                    MailDigestField digestField = digestFields.get(i);
                    if (digestField.getOutDisplayValue() == null || digestField.getOutDisplayValue().booleanValue()) {
                        String tempFielHtml = digestFiledHtml;
                        tempFielHtml = tempFielHtml.replace("{{digestFieldName}}", MailApproveHtmlDTO.replaceNullStr(digestField.getDigestFieldName()));
                        tempFielHtml = tempFielHtml.replace("{{digestFieldValue}}", MailApproveHtmlDTO.replaceNullStr(digestField.getDigestFieldValue()));
                        String fieldStyle = digestField.getFieldStyle();
                        Document fieldDoc = Jsoup.parse((String)tempFielHtml);
                        Element fieldEle = fieldDoc.getElementById("{{digestField}}");
                        if (fieldEle != null && fieldStyle != null && !"".equals(fieldStyle)) {
                            fieldEle.removeAttr("style");
                            fieldEle.attr("style", fieldStyle);
                            tempFielHtml = fieldDoc.html();
                        }
                        tempFielHtml = tempFielHtml.replace("{{digestField}}", "digestField_" + i);
                        digestTitle.after(tempFielHtml);
                    }
                    --i;
                }
            }
            html = digestDoc.html();
            html = html.replace("{{digestTitle}}", "digestTitle");
            html = html.replace("{{digestTitleContent}}", "digestTitleContent");
        }
        if (digestArea.getDivId() != null && !"".equals(digestArea.getDivId())) {
            html = html.replace("{{billDigestArea}}", digestArea.getDivId());
            idHtmlMap.put(digestArea.getDivId(), html);
        } else {
            html = html.replace("{{billDigestArea}}", "billDigestArea");
            idHtmlMap.put("billDigestArea", html);
        }
        return idHtmlMap;
    }
}

