/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ltpa;

import com.kingdee.eas.cp.eip.sso.ltpa.ConfigurationError;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaToken;
import com.kingdee.eas.cp.eip.sso.ltpa.util.LtpaTool;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.cp.eip.sso.util.LMBCSUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;

public class LtpaTokenManager {
    public static final String COOKIE_DOMAIN = "cookie.domain";
    public static final String COOKIE_NAME = "LtpaToken";
    public static final String DOMINO_SECRET = "domino.secret";
    public static final String CHECK_DEFAULT = "domino.secret.defalut.check";
    public static final String TOKEN_EXPIRATION = "token.expiration";
    public static final String ISLMBCSENCODE = "isLMBCSEncode";
    public static final String Algorithm = "algorithm";
    private static Properties properties = null;
    private static File propertiesFile = null;
    private static boolean isConfigLoaded = false;
    private static long lastLoadedTime = 0L;

    public static void loadConfig(String configFile) {
        if (!LtpaTokenManager.isConfigLoaded()) {
            propertiesFile = new File(configFile);
            properties = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(propertiesFile);
                properties.load(is);
                lastLoadedTime = System.currentTimeMillis();
                isConfigLoaded = true;
            }
            catch (IOException ioe) {
                throw new ConfigurationError("LtpaToken.properties not found. file = " + configFile);
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null == properties.getProperty(DOMINO_SECRET) || null == properties.getProperty(COOKIE_DOMAIN) || null == properties.getProperty(TOKEN_EXPIRATION)) {
                throw new ConfigurationError("LtpaToken.properties not configured properly. file = " + configFile);
            }
        }
    }

    private static Properties getProperties() {
        if (!LtpaTokenManager.isConfigLoaded()) {
            LtpaTokenManager.loadDefaultConfig();
        }
        return properties;
    }

    public static LtpaToken generate(String canonicalUser) {
        String configFile = LtpaTokenManager.getDefaultConfigFile();
        return LtpaTokenManager.generate(canonicalUser, configFile);
    }

    public static LtpaToken generate(String canonicalUser, String configFile) {
        LtpaTokenManager.initConfig(configFile);
        Date creationDate = new Date();
        Date expirationDate = new Date();
        int interval = Integer.parseInt(LtpaTokenManager.getProperties().getProperty(TOKEN_EXPIRATION));
        expirationDate.setTime(creationDate.getTime() + (long)(60000 * interval));
        return LtpaTokenManager.generate(canonicalUser, creationDate, expirationDate, configFile);
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires) {
        String configFile = LtpaTokenManager.getDefaultConfigFile();
        return LtpaTokenManager.generate(canonicalUser, tokenCreation, tokenExpires, configFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDefaultConfigFile() {
        Properties prop = new Properties();
        String configFile = "";
        String defaultConfigFileName = "config.properties";
        InputStream is = LtpaTokenManager.class.getResourceAsStream(defaultConfigFileName);
        try {
            prop.load(is);
            configFile = prop.getProperty("config.path");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return configFile;
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires, String configFile) {
        String isLMBC;
        boolean isLMBCSEncode = false;
        if (LtpaTokenManager.getProperties() != null && (isLMBC = LtpaTokenManager.getProperties().getProperty(ISLMBCSENCODE)) != null && "true".equals(isLMBC)) {
            isLMBCSEncode = true;
        }
        return LtpaTokenManager.generate(canonicalUser, tokenCreation, tokenExpires, configFile, isLMBCSEncode);
    }

    public static LtpaToken generate(String canonicalUser, Date tokenCreation, Date tokenExpires, String configFile, boolean isLMBCSEncode) {
        LtpaTokenManager.initConfig(configFile);
        LtpaToken ltpa = new LtpaToken();
        Calendar calendar = Calendar.getInstance();
        MessageDigest md = ltpa.getMessageDigest();
        ltpa.setHeader(new byte[]{0, 1, 2, 3});
        if (isLMBCSEncode) {
            ltpa.setUser(LMBCSUtil.getLMBCSLocalGroupBytes((String)canonicalUser));
        } else {
            try {
                ltpa.setUser(canonicalUser.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                ltpa.setUser(canonicalUser.getBytes());
            }
        }
        byte[] token = null;
        calendar.setTime(tokenCreation);
        ltpa.setCreation(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        calendar.setTime(tokenExpires);
        ltpa.setExpires(Long.toHexString(calendar.getTime().getTime() / 1000L).toUpperCase().getBytes());
        token = LMBCSUtil.concatenate(token, (byte[])ltpa.getHeader());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getCreation());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getExpires());
        token = LMBCSUtil.concatenate((byte[])token, (byte[])ltpa.getUser());
        md.update(token);
        byte[] digest = md.digest(BASE64Util.decodeAsBytes((String)LtpaTokenManager.getProperties().getProperty(DOMINO_SECRET)));
        ltpa.setDigest(digest);
        token = LMBCSUtil.concatenate((byte[])token, (byte[])digest);
        String tokenStr = BASE64Util.encode((byte[])token);
        String result = "";
        StringTokenizer st = new StringTokenizer(tokenStr);
        while (st.hasMoreTokens()) {
            result = result + st.nextToken();
        }
        return new LtpaToken(result);
    }

    private static void initConfig(String configFile) {
        LtpaTokenManager.loadConfig(configFile);
    }

    public static boolean isValid(String ltpaToken) {
        LtpaTokenManager.checkConfig();
        LtpaToken ltpa = new LtpaToken(LtpaToken.decodeToken((String)ltpaToken));
        boolean result = ltpa.isValid(LtpaTokenManager.getProperties().getProperty(DOMINO_SECRET));
        System.out.println("LTPA token isValid result:" + result);
        if (!result) {
            System.out.println("LTPA token compare false, token:" + ltpaToken);
        }
        return result;
    }

    public static Cookie toCookie(String ltpaToken) {
        LtpaTokenManager.checkConfig();
        Cookie cookie = new Cookie(COOKIE_NAME, ltpaToken);
        String domain = LtpaTokenManager.getProperties().getProperty(COOKIE_DOMAIN);
        if (domain != null && !"".equals(domain)) {
            cookie.setDomain(domain);
        }
        cookie.setPath("/");
        cookie.setSecure(false);
        cookie.setMaxAge(-1);
        return cookie;
    }

    private static void checkConfig() {
        if (!LtpaTokenManager.isConfigLoaded()) {
            throw new ConfigurationError("LtpaToken properties is unloaded properly. ");
        }
    }

    private static boolean isConfigLoaded() {
        if (isConfigLoaded && propertiesFile.lastModified() > lastLoadedTime) {
            isConfigLoaded = false;
        }
        return isConfigLoaded;
    }

    public static String getDefaultLtpaConfig() {
        String portalConfig = System.getProperty("portal.config");
        if (portalConfig == null || "".equals(portalConfig)) {
            System.err.println("[Eas Portal] please set system property [portal.config].");
        }
        File portalConfigFile = new File(portalConfig);
        String configPath = portalConfigFile.getParentFile().getAbsolutePath() + File.separator + "LtpaToken.properties";
        return configPath;
    }

    public static String getMarkLtapToken() {
        String SECRET = (String)LtpaTokenManager.getProperties().get(DOMINO_SECRET);
        SECRET = SECRET.length() > 20 ? LtpaTool.mask(SECRET, 3, SECRET.length() - 4, '*') : LtpaTool.mask(SECRET, 0, SECRET.length() - 1, '*');
        return SECRET;
    }

    public static String getLtapToken() {
        String SECRET = (String)LtpaTokenManager.getProperties().get(DOMINO_SECRET);
        return SECRET;
    }

    public static String saveLtpaSecret(String secret) throws IOException {
        LtpaTokenManager.getProperties().setProperty(DOMINO_SECRET, secret);
        LtpaTool.saveLtpaAllProfilesConfig(properties, "config" + File.separator + "portalConfig" + File.separator + "LtpaToken.properties");
        LtpaTokenManager.loadDefaultConfig();
        return LtpaTokenManager.getMarkLtapToken();
    }

    public static String resetDefalutLtpaSecret() throws IOException {
        String randomNonce = LtpaTool.getRandomNonce(64);
        LtpaTokenManager.saveLtpaSecret(randomNonce);
        return LtpaTokenManager.getLtapToken();
    }

    public static boolean isDefalutSecret() {
        HashSet<String> stringHashSet = new HashSet<String>();
        stringHashSet.add("BnTfa8F+FHwNejYEGtuZSwqJTWOZL/t8=");
        stringHashSet.add("BTfa8F+HwiNejeYEWGtuZSJTyWOZ/qt8=");
        stringHashSet.add("BTfa8F+HwNej6YEuGutyuZSJTFWOZ/t8=");
        stringHashSet.add("BTefa38F+HwNejYEnGtquZSJTWOZ/wt8=");
        stringHashSet.add("BTf1ma8F+HwNejYEGtuXZSJT3WOZW/t8=");
        String SECRET = LtpaTokenManager.getProperties().getProperty(DOMINO_SECRET);
        return stringHashSet.contains(SECRET);
    }

    public static boolean checkDefault() {
        String check = LtpaTokenManager.getProperties().getProperty(CHECK_DEFAULT);
        return !"0".equals(check) && !"false".equals(check);
    }

    public static void cancelCheckDefault(String check) {
        if ("0".equals(check)) {
            LtpaTokenManager.getProperties().put(CHECK_DEFAULT, "0");
        } else {
            LtpaTokenManager.getProperties().put(CHECK_DEFAULT, "1");
        }
        LtpaTool.saveLtpaAllProfilesConfig(properties, "config" + File.separator + "portalConfig" + File.separator + "LtpaToken.properties");
    }

    public static synchronized void loadDefaultConfig() {
        LtpaTokenManager.loadConfig(LtpaTokenManager.getDefaultLtpaConfig());
    }

    public static boolean compare(String token, String userNumber) {
        boolean result = false;
        LtpaToken lt = new LtpaToken(LtpaToken.decodeToken((String)token));
        String username = lt.getUsername();
        result = username == null ? false : username.equals(userNumber);
        System.out.println("LTPA token compare result:" + result);
        if (!result) {
            System.out.println("LTPA token compare false, token:" + token);
        }
        return result;
    }

    public static boolean verifyToken(String path, String token, String userNumber) {
        boolean result = false;
        if (path == null || path.trim().length() == 0) {
            LtpaTokenManager.loadDefaultConfig();
        } else {
            LtpaTokenManager.loadConfig(path);
        }
        boolean isValid = LtpaTokenManager.isValid(LtpaToken.decodeToken((String)token));
        if (isValid) {
            result = LtpaTokenManager.compare(LtpaToken.decodeToken((String)token), userNumber);
            if (!result) {
                System.out.println("LTPA token compare false, token:" + token);
            }
        } else {
            System.out.println("LTPA token isValid false, token:" + token);
        }
        return result;
    }

    protected static String getAlgorithm() {
        if (!isConfigLoaded) {
            LtpaTokenManager.loadDefaultConfig();
        }
        if (LtpaTokenManager.getProperties() != null) {
            return LtpaTokenManager.getProperties().getProperty(Algorithm);
        }
        return null;
    }
}

