/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.eip.sso.ltpa.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class LtpaTool {
    private static Logger logger = Logger.getLogger(LtpaTool.class);

    public static void saveLtpaAllProfilesConfig(Properties prop, String path) {
        List<File> folders = LtpaTool.getServerList();
        for (int i = 0; i < folders.size(); ++i) {
            String filePath = folders.get(i).getAbsolutePath();
            filePath = filePath.endsWith("//") || filePath.endsWith(File.separator) ? filePath + path : filePath + File.separator + path;
            LtpaTool.saveProperties(filePath, prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveProperties(String filePath, Object prop) {
        FileOutputStream fos = null;
        try {
            boolean isChange;
            File file = new File(filePath);
            fos = new FileOutputStream(file);
            if (prop instanceof Properties) {
                Properties properties = (Properties)prop;
                properties.store(fos, "");
            }
            if ((isChange = file.setLastModified(System.currentTimeMillis())) && logger.isDebugEnabled()) {
                logger.debug((Object)"change fileTime success");
            }
            fos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static List<File> getServerList() {
        String serverPath = LtpaTool.getProfilesPath();
        File[] fileDirs = new File(serverPath).listFiles();
        ArrayList<File> retrunFolders = new ArrayList<File>();
        for (File f : fileDirs) {
            if (!f.isDirectory() || f.listFiles().length == 0) continue;
            retrunFolders.add(f);
        }
        return retrunFolders;
    }

    public static String getProfilesPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(LtpaTool.getServerPath()).append(File.separator).append("profiles");
        return sb.toString();
    }

    public static String getServerPath() {
        StringBuilder sb = new StringBuilder();
        sb.append(LtpaTool.getEASHomePath()).append(File.separator).append("server");
        return sb.toString();
    }

    public static String getEASHomePath() {
        return System.getProperty("EAS_HOME");
    }

    public static String getRandomNonce(int number) {
        StringBuilder uid = new StringBuilder();
        SecureRandom rd = new SecureRandom();
        block5: for (int i = 0; i < number; ++i) {
            int type = rd.nextInt(3);
            switch (type) {
                case 0: {
                    uid.append(rd.nextInt(10));
                    continue block5;
                }
                case 1: {
                    uid.append((char)(rd.nextInt(25) + 65));
                    continue block5;
                }
                case 2: {
                    uid.append((char)(rd.nextInt(25) + 97));
                    continue block5;
                }
            }
        }
        return uid.toString();
    }

    public static String mask(String str, int start, int end, char maskChar) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] chars = str.toCharArray();
        for (int i = start; i < end && i < chars.length; ++i) {
            chars[i] = maskChar;
        }
        return new String(chars);
    }
}

