/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.string;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.core.Repository;

public class ToString
implements NativeFunction {
    private static final String TO_STRING = "toString";

    @Override
    public String name() {
        return TO_STRING;
    }

    @Override
    public final Object call(ScriptContext ctx, Object[] args) {
        if (args.length == 1) {
            Object v = args[0];
            return ToString.toString(v);
        }
        throw new IllegalArgumentException("args.length is " + args.length);
    }

    public static String toString(Object v) {
        Object title;
        Map m;
        if (v == null) {
            return "";
        }
        if (v instanceof CharSequence) {
            return v.toString();
        }
        if (v instanceof Context) {
            Object text = ((Context)v).get("to_text");
            if (text != null) {
                return text.toString();
            }
            return v.toString();
        }
        if (v instanceof Repository) {
            Object text = ((Repository)v).getProperty("to_text");
            return text == null ? v.toString() : text.toString();
        }
        if (v instanceof Object[]) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            Object[] objectArray = (Object[])v;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                i = ToString.append(sb, i, o);
                ++n2;
            }
            return sb.toString();
        }
        if (v instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (Object o : (Collection)v) {
                i = ToString.append(sb, i, o);
            }
            return sb.toString();
        }
        if (v instanceof Timestamp) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return sdf.format(v);
        }
        if (v instanceof Map && ((m = (Map)v).containsKey("_type") || m.containsKey("value") || m.containsKey("entity")) && (title = m.get("title")) != null) {
            return ToString.toString(title);
        }
        return v.toString();
    }

    private static int append(StringBuilder sb, int i, Object o) {
        if (i > 0) {
            sb.append(", ");
        } else {
            ++i;
        }
        sb.append(ToString.toString(o));
        return i;
    }
}

