/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.format;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.isc.iscb.util.format.Expr;
import kd.isc.iscb.util.format.Format;
import kd.isc.iscb.util.format.Snippet;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.LifeScriptContext;

class ForEach
implements Snippet {
    private Expr expr;
    private Pair<String, String> rename;
    private Format content;
    private String s;

    ForEach(String s, Map<String, Object> ctx) throws ScriptException {
        int j = this.parseVarName(s, ctx);
        this.parseContent(s, j, ctx);
        this.s = s;
    }

    private void parseContent(String content, int j, Map<String, Object> ctx) throws ScriptException {
        while (Json.isSpace(content.charAt(j))) {
            ++j;
        }
        this.content = Format.parse(content.substring(j), ctx);
    }

    private int parseVarName(String content, Map<String, Object> ctx) throws ScriptException {
        String rename;
        int i = 0;
        while (Json.isSpace(content.charAt(i))) {
            ++i;
        }
        int j = i + 1;
        while (!Json.isSpace(content.charAt(j))) {
            ++j;
        }
        String s = content.substring(i, j);
        if ((i = s.indexOf("->")) > 0) {
            this.expr = new Expr(s.substring(0, i), ctx);
            rename = s.substring(i + "->".length());
        } else {
            this.expr = new Expr(s, ctx);
            rename = s;
        }
        if (rename.indexOf(44) > 0) {
            String[] tmp = rename.split(",", 2);
            this.rename = new Pair<String, String>(tmp[0], tmp[1]);
        } else {
            this.rename = new Pair<Object, String>(null, rename);
        }
        return j;
    }

    @Override
    public Object getFrom(ScriptContext ctx) {
        Object value = this.expr.getFrom(ctx);
        if (value == null) {
            return "";
        }
        List<Object> list = this.translate(ctx, value);
        return this.concatList(list);
    }

    private String concatList(List<Object> list) {
        StringBuilder s = new StringBuilder();
        for (Object o : list) {
            s.append(o);
        }
        return s.toString();
    }

    private List<Object> translate(ScriptContext ctx, Object value) {
        List<Object> list = value instanceof Object[] ? this.translateOnObjectArray(ctx, value) : (value instanceof Collection ? this.translateOnCollection(ctx, value) : (value.getClass().isArray() ? this.translateOnPrimitiveArray(ctx, value) : (value instanceof Map ? this.translateOnMap(ctx, value) : this.translateOnSingleValue(ctx, value))));
        return list;
    }

    private List<Object> translateOnSingleValue(ScriptContext ctx, Object value) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        this.translateOnElement(ctx, list, 1, value);
        return list;
    }

    private List<Object> translateOnObjectArray(ScriptContext ctx, Object value) {
        Object[] array = (Object[])value;
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            this.translateOnElement(ctx, list, array.length, v);
            ++n2;
        }
        return list;
    }

    private List<Object> translateOnCollection(ScriptContext ctx, Object value) {
        Collection collection = (Collection)value;
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        for (Object v : collection) {
            this.translateOnElement(ctx, list, collection.size(), v);
        }
        return list;
    }

    private List<Object> translateOnPrimitiveArray(ScriptContext ctx, Object value) {
        ArrayList<Object> list = new ArrayList<Object>(Array.getLength(value));
        int count = Array.getLength(value);
        int i = 0;
        while (i < count) {
            Object v = Array.get(value, i);
            this.translateOnElement(ctx, list, count, v);
            ++i;
        }
        return list;
    }

    private List<Object> translateOnMap(ScriptContext ctx, Object value) {
        Map map = (Map)value;
        int count = map.size();
        ArrayList<Object> list = new ArrayList<Object>(count);
        for (Map.Entry entry : map.entrySet()) {
            this.translateOnElement(ctx, list, count, entry);
        }
        return list;
    }

    private void translateOnElement(ScriptContext ctx, List<Object> list, int count, Map.Entry<?, ?> entry) {
        int index = list.size() + 1;
        InnerContext ctx0 = new InnerContext(this.rename, index, count, new Pair<Object, Object>(entry.getKey(), entry.getValue()), ctx);
        list.add(this.content.translateValue(ctx0));
    }

    private void translateOnElement(ScriptContext ctx, List<Object> list, int count, Object v) {
        int index = list.size() + 1;
        InnerContext ctx0 = new InnerContext(this.rename, index, count, new Pair<Object, Object>(null, v), ctx);
        list.add(this.content.translateValue(ctx0));
    }

    public String toString() {
        return "#{for-each:" + this.s + "}";
    }

    private static class InnerContext
    extends LifeScriptContext {
        private Pair<String, String> var;
        private Pair<Object, Object> value;
        private int index;
        private int count;
        private ScriptContext inner;

        InnerContext(Pair<String, String> var, int index, int count, Pair<Object, Object> value, ScriptContext inner) {
            this.var = var;
            this.index = index;
            this.value = value;
            this.inner = inner;
            this.count = count;
        }

        @Override
        public Object getAttribute(String property) {
            if (property.equals(this.var.getB())) {
                return this.value.getB();
            }
            if ("index".equals(property)) {
                return this.index;
            }
            if ("size".equals(property)) {
                return this.count;
            }
            if (property.equals(this.var.getA())) {
                return this.value.getA();
            }
            return this.inner.getAttribute(property);
        }

        @Override
        public Object getAttribute(String property, int scope) {
            return this.getAttribute(property);
        }

        @Override
        public void setAttribute(String property, Object value, int scope) {
            this.inner.setAttribute(property, value, scope);
        }
    }
}

