/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.g;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.isc.iscb.util.g.Edge;
import kd.isc.iscb.util.g.Vertex;

public class Graph<V> {
    private Vertex<V> first;
    private Map<String, Vertex<V>> nodes = new LinkedHashMap<String, Vertex<V>>();
    private Map<String, Edge<V>> edges = new LinkedHashMap<String, Edge<V>>();
    private Set<Vertex<V>> starts = new LinkedHashSet<Vertex<V>>();
    private Set<Vertex<V>> ends = new LinkedHashSet<Vertex<V>>();

    public boolean appendVertex(String name, V value) {
        if (this.nodes.containsKey(name)) {
            return false;
        }
        Vertex<V> v = new Vertex<V>(this.nodes.size() + 1, name, value);
        this.nodes.put(name, v);
        this.starts.add(v);
        this.ends.add(v);
        if (this.first == null) {
            this.first = v;
        }
        return true;
    }

    public Vertex<V> getFirst() {
        return this.first;
    }

    public boolean append(String from, String to) {
        return this.appendEdge(from, to, null);
    }

    public boolean appendEdge(String from, String to, Object value) {
        String key = this.getEdgeKey(from, to);
        if (this.edges.containsKey(key)) {
            return false;
        }
        Vertex<V> vf = this.nodes.get(from);
        Vertex<V> vt = this.nodes.get(to);
        Edge<V> e = new Edge<V>(vf, vt, value);
        this.edges.put(key, e);
        this.starts.remove(vt);
        this.ends.remove(vf);
        return true;
    }

    private String getEdgeKey(String from, String to) {
        return String.valueOf(from) + " -> " + to;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public Set<V> getNodes() {
        HashSet<V> list = new HashSet<V>(this.nodes.size());
        for (Vertex<V> v : this.nodes.values()) {
            list.add(v.value());
        }
        return list;
    }

    public boolean contains(String name) {
        return this.nodes.containsKey(name);
    }

    public boolean contains(String from, String to) {
        String key = this.getEdgeKey(from, to);
        return this.edges.containsKey(key);
    }

    public List<V> topSort() {
        this.reset();
        ArrayList<V> list = new ArrayList<V>(this.nodes.size());
        LinkedList<Vertex<V>> queue = this.prepareForTopSort();
        while (!queue.isEmpty()) {
            Vertex<V> v = queue.removeFirst();
            if (v.isVisited() || !this.isPriorVisited(v)) continue;
            this.addNext(queue, v);
            v.setVisited(true);
            list.add(v.value());
        }
        return list;
    }

    protected LinkedList<Vertex<V>> prepareForTopSort() {
        LinkedList<Vertex<V>> queue = new LinkedList<Vertex<V>>();
        queue.addAll(this.starts);
        return queue;
    }

    private boolean isPriorVisited(Vertex<V> v) {
        for (Edge<V> e : v.inComing()) {
            if (e.isVisited()) continue;
            return false;
        }
        return true;
    }

    protected void addNext(LinkedList<Vertex<V>> queue, Vertex<V> v) {
        for (Edge<V> e : v.outGoing()) {
            e.setVisited(true);
            Vertex<V> next = e.getTo();
            if (next.isVisited()) continue;
            queue.addLast(next);
        }
    }

    private void reset() {
        for (Edge<V> edge : this.edges.values()) {
            edge.setVisited(false);
        }
        for (Vertex vertex : this.nodes.values()) {
            vertex.setVisited(false);
        }
    }

    public Map<String, Vertex<V>> getNodes2() {
        return Collections.unmodifiableMap(this.nodes);
    }

    public Map<String, Edge<V>> getEdges() {
        return Collections.unmodifiableMap(this.edges);
    }

    public Set<Vertex<V>> getEnds() {
        return Collections.unmodifiableSet(this.ends);
    }

    public Set<Vertex<V>> getStarts() {
        return Collections.unmodifiableSet(this.starts);
    }
}

