/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.advanced;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.script.LifeScriptContext;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.parser.Program;

public class Eval
implements Constructor {
    @Override
    public String name() {
        return "eval";
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        final Object script = pos.getOperand(statement, 0);
        final LifeScriptEngine engine = statement.getEngine();
        final Map<String, Object> context = statement.getContext();
        return new Evaluator(){

            public String toString() {
                return "eval(" + script + ")";
            }

            @Override
            public Object eval(ScriptContext ctx) {
                Object o = Util.eval(ctx, script);
                if (o instanceof Evaluator) {
                    return ((Evaluator)o).eval(ctx);
                }
                if (o == null) {
                    return null;
                }
                CompiledScript compiled = this.compile(engine, context, o.toString());
                LifeScriptContext newCtx = new LifeScriptContext(ctx.getBindings(0));
                return this.evalScript(compiled, newCtx);
            }

            private Object evalScript(CompiledScript compiled, LifeScriptContext newCtx) {
                try {
                    return compiled.eval(newCtx);
                }
                catch (ScriptException e) {
                    throw CommonError.SCRIPT_RUNTIME_ERROR.wrap(e);
                }
            }

            private CompiledScript compile(LifeScriptEngine engine2, Map<String, Object> context2, String s) {
                try {
                    HashMap<String, Object> dupContext = new HashMap<String, Object>(context2.size());
                    dupContext.putAll(context2);
                    StringReader script2 = new StringReader(s);
                    Program compiled = engine2.compile(script2, dupContext);
                    return compiled;
                }
                catch (ScriptException e) {
                    throw CommonError.SCRIPT_GRAMMAR_ERROR.create(e, e.getMessage(), s);
                }
            }
        };
    }
}

