/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app.io.fileImport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ICommonBOSType;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.app.filter.StructureConfigConvertHelper;
import com.kingdee.eas.hr.emp.PersonCredentialsTypeInfo;
import com.kingdee.shr.base.syssetting.BaseItemCustomInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseColumnInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseRowInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ImportEntityInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ImportException;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ValueCovertUtils;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.web.dynamic.model.DynamicModelInfo;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnCollection;
import com.kingdee.shr.baseconfig.StructureConfigFilterColumnInfo;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.shrimport.SHRImportTypeEnum;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.lang.reflect.Constructor;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicModelHelper {
    private Context ctx = null;
    private String scheme = null;
    private SHRImportTypeEnum importTypeEnum = null;
    private static Logger logger = Logger.getLogger(DynamicModelHelper.class);
    private Map<String, String> importPropNameAndEntityPropMap = null;
    private Map<String, ImportEntityInfo> entityInfoMap = null;
    private Map<String, ICoreBase> entityICoreBase = null;
    private String mainEntityFullName = null;
    private String mainEntityShortName = null;
    private boolean multiImport;
    private BaseRowInfo currentRow = null;
    private String currentBillid = null;

    public DynamicModelHelper(String scheme, Context ctx, Map<String, BaseColumnInfo> columnMap, SHRImportTypeEnum importType) throws BOSException, EASBizException {
        this.ctx = ctx;
        this.scheme = scheme;
        this.importPropNameAndEntityPropMap = new HashMap<String, String>();
        this.importTypeEnum = importType;
        StructureConfigInfo main = StructureConfigConvertHelper.getMain((Context)this.ctx, (String)this.scheme);
        if (main == null) {
            throw new ImportException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"unable_get_primary_entity", (Context)this.ctx));
        }
        this.mainEntityFullName = main.getEntityName();
        this.entityInfoMap = new HashMap<String, ImportEntityInfo>();
        Iterator<Map.Entry<String, BaseColumnInfo>> iter = columnMap.entrySet().iterator();
        this.multiImport = true;
        BaseColumnInfo columnInfo2 = null;
        ArrayList<BaseColumnInfo> temp = new ArrayList<BaseColumnInfo>();
        while (iter.hasNext()) {
            columnInfo2 = iter.next().getValue();
            if (this.handleColumnInfo(columnInfo2)) continue;
            temp.add(columnInfo2);
        }
        for (BaseColumnInfo columnInfo2 : temp) {
            this.handleColumnInfo(columnInfo2);
        }
    }

    private boolean handleColumnInfo(BaseColumnInfo columnInfo) throws EASBizException, BOSException {
        return this.handleColumnInfo(columnInfo, true);
    }

    public void setCurrentBillid(String billId) {
        this.currentBillid = billId;
    }

    private boolean handleColumnInfo(BaseColumnInfo columnInfo, boolean convertColumn) throws EASBizException, BOSException {
        String shortName = this.getEntityShortNameByPropName(columnInfo.getPropName());
        ImportEntityInfo importEntityInfo = this.entityInfoMap.get(shortName);
        if (importEntityInfo == null) {
            if (convertColumn) {
                columnInfo = this.convertColumnInfo(columnInfo);
                return this.handleColumnInfo(columnInfo, false);
            }
            importEntityInfo = this.getImportEntityInfo(columnInfo.getPropName());
            if (importEntityInfo == null) {
                return false;
            }
            this.entityInfoMap.put(shortName, importEntityInfo);
            if (importEntityInfo.getEntityFullName().equals(this.mainEntityFullName)) {
                this.mainEntityShortName = shortName;
                importEntityInfo.setMainEntity(true);
            }
            if (this.multiImport && !importEntityInfo.isMainEntity() && !importEntityInfo.isMultiRow()) {
                this.multiImport = false;
            }
        }
        importEntityInfo.addImportColumn(columnInfo);
        return true;
    }

    private BaseColumnInfo convertColumnInfo(BaseColumnInfo columnInfo) throws BOSException {
        QueryConfigFieldInfo fieldInfo;
        String propName = columnInfo.getPropName();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("debugxg1" + propName));
        }
        if ((fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)this.ctx, (String)this.scheme, (String)propName)) == null) {
            return columnInfo;
        }
        StructureConfigInfo configInfo = fieldInfo.getFactField().getStructureConfig();
        if (!configInfo.isBaseData()) {
            return columnInfo;
        }
        StructureConfigInfo parentConfigInfo = configInfo.getParent();
        if (parentConfigInfo.isBaseData()) {
            return columnInfo;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("debugxg2" + propName));
        }
        configInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)configInfo.getId().toString(), (String)this.scheme);
        String tempRelationName = this.getRelationName(configInfo);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("debugxg3" + parentConfigInfo.getId() + "|" + parentConfigInfo.getName()));
        }
        String parentShortName = parentConfigInfo.getClientNumber().toUpperCase();
        BaseColumnInfo tempColumnInfo = new BaseColumnInfo(String.valueOf(parentShortName) + "." + tempRelationName, columnInfo.getName(), columnInfo.isNecessary(), 0, null);
        tempColumnInfo.setColumnIndex(columnInfo.getColumnIndex());
        return tempColumnInfo;
    }

    private String getEntityShortNameByPropName(String propName) {
        String[] strs = propName.split("\\.");
        return strs.length > 0 ? strs[0].toUpperCase() : propName.toUpperCase();
    }

    private ImportEntityInfo getImportEntityInfo(String propName) throws BOSException, EASBizException {
        String tempRelationName;
        QueryConfigFieldInfo fieldInfo = StructureConfigConvertHelper.getQueryFieldByKey((Context)this.ctx, (String)this.scheme, (String)propName);
        StructureConfigInfo configInfo = null;
        if (fieldInfo == null) {
            String[] split = propName.split("\\.");
            tempRelationName = "";
            if (split.length > 0) {
                tempRelationName = split[0];
            }
            if ((configInfo = StructureConfigConvertHelper.getStructureConfigByNumber((Context)this.ctx, (String)tempRelationName, (String)this.scheme)) == null) {
                return null;
            }
        }
        ImportEntityInfo entityInfo = new ImportEntityInfo();
        if (configInfo == null) {
            configInfo = fieldInfo.getFactField().getStructureConfig();
            configInfo = StructureConfigConvertHelper.getStructureConfigByID((Context)this.ctx, (String)configInfo.getId().toString(), (String)configInfo.getScheme().getNumber());
        }
        entityInfo.setEntityAliasName(configInfo.getAlias());
        entityInfo.setConfigInfo(configInfo);
        entityInfo.setEntityFullName(configInfo.getEntityName());
        entityInfo.setMultiRow(configInfo.isMultiRow());
        if (configInfo.isMultiRow() && configInfo.isSupportSingleView()) {
            entityInfo.setSingleShowCondition(configInfo.getSingleCondition());
        }
        entityInfo.setSingleFields(configInfo.getSingleFields());
        if (configInfo.getParent() != null) {
            tempRelationName = this.getRelationName(configInfo);
            entityInfo.setRelationName(tempRelationName);
        }
        return entityInfo;
    }

    private String getRelationName(StructureConfigInfo configInfo) {
        String tempRelationName = null;
        StructureConfigFilterColumnCollection filterColumnList = configInfo.getFilterColumn();
        int i = 0;
        int size = filterColumnList.size();
        while (i < size) {
            StructureConfigFilterColumnInfo filterColumn = filterColumnList.get(i);
            if (filterColumn.getParentColumn() != null && "id".equalsIgnoreCase(filterColumn.getClientColumn())) {
                tempRelationName = filterColumn.getParentColumn();
                break;
            }
            if (filterColumn.getParentColumn() != null && "id".equalsIgnoreCase(filterColumn.getParentColumn())) {
                tempRelationName = filterColumn.getClientColumn();
                break;
            }
            if (filterColumn.getParentColumn() != null && "person".equalsIgnoreCase(filterColumn.getParentColumn()) && "person".equalsIgnoreCase(filterColumn.getClientColumn())) {
                return filterColumn.getParentColumn();
            }
            ++i;
        }
        return tempRelationName;
    }

    public void setRow(BaseRowInfo row) {
        this.currentRow = row;
    }

    public ICoreBase getEntityInterface(String entityName) {
        ICoreBase coreBase;
        if (this.entityICoreBase == null) {
            this.entityICoreBase = new HashMap<String, ICoreBase>();
        }
        if ((coreBase = this.entityICoreBase.get(entityName)) == null) {
            MetaDataPK entityPK = MetaDataPK.create((String)entityName);
            try {
                coreBase = (ICoreBase)BOSObjectFactory.createCommonBOSObject((Context)this.ctx, (IMetaDataPK)entityPK);
                this.entityICoreBase.put(entityName, coreBase);
            }
            catch (BOSException var5) {
                throw new ImportException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"get_api_instance_error", (Context)this.ctx), (Throwable)var5);
            }
        }
        return coreBase;
    }

    public DynamicModelInfo convertRowToDynamicModel(BaseRowInfo row) throws ImportException {
        this.currentRow = row;
        return this.convertRowToDynamicModel();
    }

    public DynamicModelInfo convertRowToDynamicModel() {
        if (this.currentRow == null) {
            throw new ImportException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"row_data_isempty", (Context)this.ctx));
        }
        ImportEntityInfo mainEntityInfo = this.entityInfoMap.get(this.mainEntityShortName);
        CoreBaseInfo mainCoreBaseInfo = this.loadMainEntityInfo(mainEntityInfo);
        if (mainCoreBaseInfo == null) {
            throw new ImportException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"entity_not_found", (Context)this.ctx));
        }
        this.currentBillid = mainCoreBaseInfo.getId().toString();
        DynamicModelInfo dyModelInfo = new DynamicModelInfo();
        HashMap<String, CoreBaseInfo> valueMap = new HashMap<String, CoreBaseInfo>();
        HashMap<String, Boolean> hasData = new HashMap<String, Boolean>();
        valueMap.put(mainEntityInfo.getEntityFullName(), mainCoreBaseInfo);
        hasData.put(mainEntityInfo.getEntityFullName(), true);
        dyModelInfo.setValueMap(valueMap);
        Iterator<Map.Entry<String, ImportEntityInfo>> iter = this.entityInfoMap.entrySet().iterator();
        ImportEntityInfo entityInfo = null;
        while (iter.hasNext()) {
            entityInfo = iter.next().getValue();
            if (valueMap.containsKey(entityInfo.getEntityFullName())) continue;
            CoreBaseInfo baseInfo = this.loadEntityInfo(entityInfo);
            if (baseInfo instanceof PersonCredentialsTypeInfo && this.importTypeEnum.getValue() == 10) {
                baseInfo = null;
            }
            if (baseInfo == null) {
                SelectorItemCollection coll = this.getLoadSelectorColl(entityInfo.getImportColumn());
                if (coll.size() != 0) continue;
                hasData.put(entityInfo.getEntityFullName(), false);
                continue;
            }
            valueMap.put(entityInfo.getEntityFullName(), baseInfo);
            hasData.put(entityInfo.getEntityFullName(), true);
        }
        this.verifyOrCreateBlankBaseInfo(dyModelInfo, hasData);
        this.assignInfoSaveValue(dyModelInfo, hasData);
        this.currentBillid = null;
        return dyModelInfo;
    }

    private void verifyOrCreateBlankBaseInfo(DynamicModelInfo dyModelInfo, HashMap<String, Boolean> hasData) {
        HashMap valueMap = dyModelInfo.getValueMap();
        StringBuffer errorMsg = new StringBuffer();
        Iterator<Map.Entry<String, ImportEntityInfo>> iter = this.entityInfoMap.entrySet().iterator();
        ImportEntityInfo entityInfo = null;
        IObjectValue baseInfo = null;
        String tempEntityFullName = null;
        while (true) {
            String emsg;
            if (!iter.hasNext()) {
                emsg = errorMsg.toString();
                if (!StringUtils.isEmpty((String)emsg)) {
                    throw new ImportException(emsg);
                }
                return;
            }
            entityInfo = iter.next().getValue();
            if (entityInfo.isMainEntity() || hasData.get(tempEntityFullName = entityInfo.getEntityFullName()) != null && !hasData.get(tempEntityFullName).booleanValue()) continue;
            baseInfo = (IObjectValue)valueMap.get(tempEntityFullName);
            switch (this.importTypeEnum.getValue()) {
                case 10: {
                    if (baseInfo == null) {
                        baseInfo = this.createInfo(tempEntityFullName);
                        valueMap.put(tempEntityFullName, baseInfo);
                        break;
                    }
                    if (baseInfo instanceof PersonCredentialsTypeInfo) break;
                    emsg = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"add_fails_already_exist", (Context)this.ctx), entityInfo.getEntityAliasName());
                    errorMsg.append(emsg);
                    break;
                }
                case 20: {
                    if (baseInfo == null) {
                        emsg = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"cover_fails_not_load", (Context)this.ctx), entityInfo.getEntityAliasName());
                        errorMsg.append(emsg);
                        break;
                    }
                    CoreBaseInfo coreBaseInfo = this.createInfo(tempEntityFullName);
                    coreBaseInfo.setId(((CoreBaseInfo)baseInfo).getId());
                    valueMap.put(tempEntityFullName, coreBaseInfo);
                    break;
                }
                case 30: {
                    if (baseInfo != null) break;
                    emsg = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"update_fails_not_load", (Context)this.ctx), entityInfo.getEntityAliasName());
                    errorMsg.append(emsg);
                    break;
                }
                case 40: {
                    if (baseInfo != null) break;
                    baseInfo = this.createInfo(tempEntityFullName);
                    valueMap.put(tempEntityFullName, baseInfo);
                }
            }
        }
    }

    private void assignInfoSaveValue(DynamicModelInfo dyModelInfo, HashMap<String, Boolean> hasData) {
        boolean hasUpdate;
        HashMap tempObjMap = dyModelInfo.getValueMap();
        LinkedHashMap<String, IObjectValue> saveModelMap = new LinkedHashMap<String, IObjectValue>();
        Iterator<Map.Entry<String, ImportEntityInfo>> iter = this.entityInfoMap.entrySet().iterator();
        ImportEntityInfo entityInfo = null;
        IObjectValue coreBase = null;
        BaseColumnInfo tempColumnInfo = null;
        Object tempValue = null;
        boolean bl = hasUpdate = this.importTypeEnum.getValue() == 40 || this.importTypeEnum.getValue() == 30;
        while (true) {
            IObjectValue mainValue;
            if (!iter.hasNext()) {
                if (tempObjMap.containsKey(this.mainEntityFullName)) {
                    saveModelMap.put(this.mainEntityFullName, (IObjectValue)tempObjMap.get(this.mainEntityFullName));
                    tempObjMap.remove(this.mainEntityFullName);
                }
                saveModelMap.putAll(tempObjMap);
                dyModelInfo.setSaveModelMap(saveModelMap);
                return;
            }
            entityInfo = iter.next().getValue();
            Boolean has = hasData.get(entityInfo.getEntityFullName());
            if (has != null && !has.booleanValue()) continue;
            coreBase = (IObjectValue)tempObjMap.get(entityInfo.getEntityFullName());
            boolean tempBoolean = hasUpdate && coreBase.get(coreBase.getPKField()) != null;
            List columnInfoList = entityInfo.getImportColumn();
            boolean isPersonEntity = this.isPersonEntity(entityInfo.getEntityFullName());
            int i = 0;
            int size = columnInfoList.size();
            while (i < size) {
                block9: {
                    String valString;
                    block10: {
                        tempColumnInfo = (BaseColumnInfo)columnInfoList.get(i);
                        if (isPersonEntity && ("person.name".equals(tempColumnInfo.getPropName()) || "person.number".equals(tempColumnInfo.getPropName()))) break block9;
                        if (!tempBoolean) break block10;
                        valString = this.currentRow.getValueOfStringByIndex(tempColumnInfo.getColumnIndex());
                        if (StringUtils.isEmpty((String)valString)) break block9;
                        if (ValueCovertUtils.UPDATE_BLANK_FLAG.equals(valString)) {
                            tempValue = null;
                        }
                    }
                    tempValue = this.currentRow.getValueOfObjectByIndex(tempColumnInfo.getColumnIndex());
                    valString = this.getEntityPropName(tempColumnInfo.getPropName());
                    coreBase.put(valString, tempValue);
                    if (1 == tempColumnInfo.getDataType()) {
                        coreBase.put(String.valueOf(valString) + "_" + LocaleUtils.locale_l1.getDisplayName(), tempValue);
                        coreBase.put(String.valueOf(valString) + "_" + LocaleUtils.locale_l2.getDisplayName(), tempValue);
                        coreBase.put(String.valueOf(valString) + "_" + LocaleUtils.locale_l3.getDisplayName(), tempValue);
                    }
                }
                ++i;
            }
            String tempRelate = entityInfo.getRelationName();
            if (StringUtils.isEmpty((String)tempRelate) || (mainValue = (IObjectValue)tempObjMap.get(this.mainEntityFullName)) == null) continue;
            coreBase.put(tempRelate, (Object)mainValue);
        }
    }

    private CoreBaseInfo loadEntityInfo(ImportEntityInfo entityInfo) {
        int size;
        CoreBaseCollection coreBaseColl;
        block9: {
            FilterInfo filter = null;
            SelectorItemCollection coll = this.getLoadSelectorColl(entityInfo.getImportColumn());
            if (coll.size() == 0) {
                return null;
            }
            List keyColumn = entityInfo.getKeyColumn();
            if (keyColumn != null && keyColumn.size() > 0) {
                filter = new FilterInfo();
                this.getLoadFilterInfo(filter, keyColumn);
            }
            if (!StringUtils.isEmpty((String)entityInfo.getRelationName())) {
                if (filter == null) {
                    filter = new FilterInfo();
                }
                filter.getFilterItems().add(new FilterItemInfo(entityInfo.getRelationName(), (Object)this.currentBillid));
            }
            if (filter == null) {
                return null;
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            try {
                ICoreBase iCoreBase = this.getEntityInterface(entityInfo.getEntityFullName());
                coreBaseColl = iCoreBase.getCollection(view);
                size = coreBaseColl.size();
                if (size != 0) break block9;
                return null;
            }
            catch (BOSException var9) {
                throw new ImportException(MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"load_existing_entity_fails", (Context)this.ctx), entityInfo.entityAliasName), (Throwable)var9);
            }
        }
        if (size == 1) {
            return coreBaseColl.get(0);
        }
        throw new ImportException(MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"load_entity_fails_mult", (Context)this.ctx), entityInfo.entityAliasName));
    }

    private CoreBaseInfo loadMainEntityInfo(ImportEntityInfo entityInfo) {
        if (!StringUtils.isEmpty((String)this.currentBillid)) {
            try {
                ICoreBase iCoreBase = this.getEntityInterface(entityInfo.getEntityFullName());
                CoreBaseInfo coreBase = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(this.currentBillid));
                return coreBase;
            }
            catch (EASBizException var13) {
                throw new ImportException(var13.getMessage(), (Throwable)var13);
            }
            catch (BOSException var14) {
                throw new ImportException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"load_existing_entity_error", (Context)this.ctx), (Throwable)var14);
            }
        }
        FilterInfo filter = null;
        if (this.isPersonEntity(entityInfo.getEntityFullName())) {
            filter = new FilterInfo();
            String number = this.currentRow.getValueOfString("person.number");
            String name = this.currentRow.getValueOfString("person.name");
            if (!StringUtils.isEmpty((String)name)) {
                filter.getFilterItems().add(new FilterItemInfo(this.getEntityPropName("person.name"), (Object)name));
            }
            if (!StringUtils.isEmpty((String)number)) {
                filter.getFilterItems().add(new FilterItemInfo(this.getEntityPropName("person.number"), (Object)number));
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(filter);
            try {
                ICoreBase iCoreBase = this.getEntityInterface(entityInfo.getEntityFullName());
                CoreBaseCollection coreBaseColl = iCoreBase.getCollection(view);
                int size = coreBaseColl.size();
                if (size == 0) {
                    throw new ImportException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"unable_load_entity", (Context)this.ctx, (Object[])new Object[]{entityInfo.getEntityAliasName()}));
                }
                if (size == 1) {
                    return coreBaseColl.get(0);
                }
                CoreBaseInfo base = null;
                int count = 0;
                int i = 0;
                while (i < size) {
                    CoreBaseInfo baseInfo = coreBaseColl.get(i);
                    if ((StringUtils.isEmpty((String)name) || name.equals(baseInfo.getString("name"))) && (StringUtils.isEmpty((String)number) || number.equals(baseInfo.getString("number")))) {
                        base = baseInfo;
                        ++count;
                    }
                    ++i;
                }
                if (count == 1) {
                    return base;
                }
                throw new ImportException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"load_mult_entity", (Context)this.ctx, (Object[])new Object[]{entityInfo.getEntityAliasName()}));
            }
            catch (BOSException var15) {
                throw new ImportException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"load_existing_entity_fails", (Context)this.ctx, (Object[])new Object[]{entityInfo.getEntityAliasName()}), (Throwable)var15);
            }
        }
        return this.loadEntityInfo(entityInfo);
    }

    private boolean isPersonEntity(String entityFullName) {
        return "com.kingdee.eas.basedata.person.app.Person".equals(entityFullName);
    }

    private FilterInfo getLoadFilterInfo(FilterInfo filter, List<BaseColumnInfo> keyColumn) {
        BaseColumnInfo columnInfo = null;
        int i = 0;
        int size = keyColumn.size();
        while (i < size) {
            columnInfo = keyColumn.get(i);
            String key = columnInfo.getPropName();
            String entityPropName = this.getEntityPropName(key);
            Object value = this.currentRow.getValueOfObjectByIndex(columnInfo.getColumnIndex());
            if (value instanceof String) {
                filter.getFilterItems().add(new FilterItemInfo(entityPropName, value));
            } else if (value instanceof Timestamp) {
                filter.getFilterItems().add(new FilterItemInfo(entityPropName, value));
            } else if (value instanceof Date) {
                filter.getFilterItems().add(new FilterItemInfo(entityPropName, value));
            } else if (value instanceof Enum) {
                StringEnum en;
                if (value instanceof StringEnum) {
                    en = (StringEnum)value;
                    filter.getFilterItems().add(new FilterItemInfo(entityPropName, (Object)en.getValue()));
                } else if (value instanceof IntEnum) {
                    en = (IntEnum)value;
                    filter.getFilterItems().add(new FilterItemInfo(entityPropName, (Object)en.getValue()));
                }
            } else if (value instanceof CoreBaseInfo) {
                CoreBaseInfo coreBaseInfo = (CoreBaseInfo)value;
                filter.getFilterItems().add(new FilterItemInfo(entityPropName, (Object)coreBaseInfo.getId()));
            } else {
                filter.getFilterItems().add(new FilterItemInfo(entityPropName, value));
            }
            ++i;
        }
        return filter;
    }

    private SelectorItemCollection getLoadSelectorColl(List<BaseColumnInfo> columnList) {
        BaseColumnInfo columnInfo = null;
        SelectorItemCollection coll = new SelectorItemCollection();
        int i = 0;
        int size = columnList.size();
        while (i < size) {
            columnInfo = columnList.get(i);
            String key = columnInfo.getPropName();
            String entityPropName = this.getEntityPropName(key);
            String value = this.currentRow.getValueOfStringByIndex(columnInfo.getColumnIndex());
            if (!StringUtils.isEmpty((String)value)) {
                coll.add(new SelectorItemInfo(entityPropName));
            }
            ++i;
        }
        return coll;
    }

    private String getEntityPropName(String importPropName) {
        String entityPropName = this.importPropNameAndEntityPropMap.get(importPropName);
        if (entityPropName == null) {
            String[] strs = importPropName.split("\\.");
            if (strs.length > 1) {
                entityPropName = strs[1];
            }
            this.importPropNameAndEntityPropMap.put(importPropName, entityPropName);
        }
        return entityPropName;
    }

    private CoreBaseInfo createInfo(String entityFullName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)this.ctx);
        MetaDataPK metaDataPK = MetaDataPK.create((String)entityFullName);
        EntityObjectInfo eoInfo = loader.getEntity((IMetaDataPK)metaDataPK);
        String valueClassName = eoInfo.getObjectValueClass();
        CoreBaseInfo info = null;
        try {
            Class<?> c = Class.forName(valueClassName);
            Constructor<?> cst = c.getConstructor(new Class[0]);
            info = (CoreBaseInfo)cst.newInstance(new Object[0]);
            if (info instanceof DataBaseCustomInfo) {
                ((DataBaseCustomInfo)info).setBOSType(eoInfo.getType());
            } else if (info instanceof BaseItemCustomInfo) {
                ((BaseItemCustomInfo)info).setBOSType(eoInfo.getType());
            } else if (info instanceof CoreBillBaseCustomInfo) {
                ((CoreBillBaseCustomInfo)info).setBOSType(eoInfo.getType());
            } else if (eoInfo.isDynamic() && info instanceof ICommonBOSType) {
                ICommonBOSType commonObject = (ICommonBOSType)info;
                commonObject.setBOSType(eoInfo.getType());
                commonObject.setPK((IMetaDataPK)metaDataPK);
            }
            return info;
        }
        catch (Exception var10) {
            ImportException importException = new ImportException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"creat_object_fails", (Context)this.ctx), (Throwable)var10);
            throw importException;
        }
    }
}

