/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.notify;

import com.kingdee.bos.service.job.core.Configuration;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobManager;
import com.kingdee.cbos.process.vm.utils.group.Message;
import com.kingdee.cbos.process.vm.utils.group.MessageQueue;
import com.kingdee.cbos.process.vm.utils.group.MessageServer;
import com.kingdee.cbos.process.vm.utils.group.MessageService;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.notify.AsyncJob;
import kd.isc.connector.eas.notify.CommandSet;
import kd.isc.connector.eas.notify.MessageCommandThread;
import kd.isc.connector.eas.notify.cmd.IscClearCache;
import kd.isc.connector.eas.notify.cmd.NotifyLoadJob;
import kd.isc.connector.eas.notify.cmd.NotifyPushDataJob;
import kd.isc.connector.eas.notify.cmd.UndeployClearCache;

public class NotifyUtil {
    public static final String NOTIFY_LOAD_JOB = "NOTIFY_LOAD_JOB";
    public static final String NOTIFY_PUSH_DATA_JOB = "NOTIFY_PUSH_DATA_JOB";
    public static final String ISC_CLEAR_CACHE = "ISC_CLEAR_CACHE";
    public static final String UNDEPLOY_CLEAR_CACHE = "UNDEPLOY_CLEAR_CACHE";
    private static final ThreadPoolExecutor pool = new ThreadPoolExecutor(10, 10, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(512));

    static {
        try {
            MessageServer.init();
            if (!Configuration.isEnable()) {
                MessageQueue.SENDER.set((Object)new MsgQue());
                MessageQueue.RECEIVER.set((Object)new MsgQue());
            }
            MessageServer.register((String)NOTIFY_LOAD_JOB, (MessageService)new NotifyLoadJob());
            MessageServer.register((String)NOTIFY_PUSH_DATA_JOB, (MessageService)new NotifyPushDataJob());
            MessageServer.register((String)ISC_CLEAR_CACHE, (MessageService)new IscClearCache());
            MessageServer.register((String)UNDEPLOY_CLEAR_CACHE, (MessageService)new UndeployClearCache());
            new Thread(new MessageCommandThread()).start();
        }
        catch (Throwable e) {
            EasContext.getErrLogger().warn((Object)"\u521d\u59cb\u5316message\u670d\u52a1\u5f02\u5e38\uff1a", e);
        }
    }

    public static void executeJobByThreadPool(Job job) {
        pool.execute(new AsyncJob(job));
    }

    public static void submitJob(Job job) {
        if (Configuration.isEnable()) {
            JobManager.instance().add(job);
        } else if (job.isPersistent()) {
            JobManager.instance().add(job);
            NotifyUtil.sendMsg(job.getContext().getAIS(), NOTIFY_LOAD_JOB);
        } else {
            pool.execute(new AsyncJob(job));
        }
    }

    public static void sendMsg(String dataCenter, String cmd) {
        CommandSet.INSTANCE.putCommand(dataCenter, cmd);
    }

    private static class MsgQue
    implements MessageQueue {
        private MsgQue() {
        }

        public void enqueue(final Message message) {
            pool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        message.handle();
                    }
                    catch (Exception e) {
                        EasContext.getErrLogger().warn((Object)("\u6d88\u606f\u5904\u7406\u5f02\u5e38\uff1a" + message), (Throwable)e);
                    }
                }
            });
        }
    }
}

