/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.analyzer.expr;

import java.util.Map;
import javax.script.ScriptException;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.analyzer.ConstructorAnalyzer;
import kd.isc.iscb.util.script.analyzer.expr.DualInvoker;
import kd.isc.iscb.util.script.analyzer.expr.Util;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Operator;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.statement.Invocation;

public class DualOperator {
    public static int process(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int minPriority, Statement smt) throws ScriptException {
        int line = smt.line();
        return DualOperator.process(engine, context, elements, len, minPriority, line);
    }

    public static int process(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int minPriority, int line) throws ScriptException {
        if (len < 3) {
            return len;
        }
        int newLen;
        while ((newLen = DualOperator.processOnePass(engine, context, elements, len, minPriority, line)) != len && newLen >= 3) {
            len = newLen;
        }
        return newLen;
    }

    private static int processOnePass(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int minPriority, int line) throws ScriptException {
        Object e;
        int index = DualOperator.findMaxProrityPosition(elements, len, minPriority);
        if (index < 0) {
            return len;
        }
        Object prior = Util.getPriorElement(elements, index - 1);
        Object next = Util.getNextElement(elements, index + 1, len);
        Util.checkOperand(prior);
        Util.checkOperand(next);
        Object op = elements[index];
        if (op instanceof Constructor) {
            Invocation s = new Invocation(engine, context, new Object[]{op, prior, next}, line);
            e = ConstructorAnalyzer.INS.analyze(s);
        } else {
            e = new DualInvoker(op, prior, next, line);
        }
        elements[index - 1] = e;
        len -= 2;
        while (index < len) {
            elements[index] = elements[index + 2];
            ++index;
        }
        return len;
    }

    private static int findMaxProrityPosition(Object[] elements, int len, int minPriority) throws ScriptException {
        int max = Integer.MAX_VALUE;
        int pos = -1;
        int i = 0;
        while (i < len) {
            Object el = elements[i];
            if (el instanceof Operator) {
                Operator op = (Operator)el;
                if ((op.type() & 4) == 0) {
                    throw new IscBizException("'" + op.name() + "' is not an infix operator.");
                }
                int priority = op.priority();
                if (priority < max) {
                    max = priority;
                    pos = i;
                } else if (priority == max && op.type() == 12) {
                    pos = i;
                }
            }
            ++i;
        }
        return max > minPriority ? -1 : pos;
    }
}

