/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.analyzer.expr;

import java.util.Map;
import javax.script.ScriptException;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.analyzer.ConstructorAnalyzer;
import kd.isc.iscb.util.script.analyzer.expr.Util;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Operator;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.statement.Invocation;

public class MonoOperator {
    public static int process(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, Statement smt) throws ScriptException {
        int line = smt.line();
        return MonoOperator.process(engine, context, elements, len, line);
    }

    public static int process(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int line) throws ScriptException {
        len = MonoOperator.processSuffixMonoOperator(engine, context, elements, len, line);
        len = MonoOperator.processPrefixMonoOperator(engine, context, elements, len, line);
        return len;
    }

    private static int processPrefixMonoOperator(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int line) throws ScriptException {
        if (len < 2) {
            return len;
        }
        int p = len - 1;
        int i = len - 2;
        while (i >= 0) {
            Object current = elements[i];
            if (current instanceof Operator) {
                Operator op = (Operator)current;
                if (Util.isPrefixMonoOperator(op, elements, i - 1)) {
                    Object next = Util.getNextElement(elements, p, len);
                    if (op instanceof Constructor) {
                        elements[p] = ConstructorAnalyzer.INS.analyze(new Invocation(engine, context, new Object[]{op, next}, line));
                    } else {
                        Util.checkOperand(next);
                        elements[p] = new Invocation(engine, context, new Object[]{op, next}, line);
                    }
                } else {
                    elements[--p] = current;
                }
            } else {
                elements[--p] = current;
            }
            --i;
        }
        if (p > 0) {
            len -= p;
            i = 0;
            while (i < len) {
                elements[i] = elements[i + p];
                ++i;
            }
        }
        return len;
    }

    private static int processSuffixMonoOperator(LifeScriptEngine engine, Map<String, Object> context, Object[] elements, int len, int line) throws ScriptException {
        if (len < 2) {
            return len;
        }
        int p = 0;
        int i = 1;
        while (i < len) {
            Object current = elements[i];
            if (current instanceof Operator) {
                Operator op = (Operator)current;
                if (Util.isSuffixMonoOperator(op, elements, p)) {
                    Object prior = Util.getPriorElement(elements, p);
                    Util.checkOperand(prior);
                    elements[p] = op instanceof Constructor ? ConstructorAnalyzer.INS.analyze(new Invocation(engine, context, new Object[]{prior, op}, line)) : new Invocation(engine, context, new Object[]{op, prior}, line);
                } else {
                    elements[++p] = current;
                }
            } else {
                elements[++p] = current;
            }
            ++i;
        }
        return p + 1;
    }
}

