/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.op.store;

import java.math.BigDecimal;
import java.sql.Time;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import kd.isc.iscb.util.io.ObjectWriter;
import kd.isc.iscb.util.misc.mem.MemoryUtil;
import kd.isc.iscb.util.misc.mem.RuntimeContext;
import kd.isc.iscb.util.script.context.Context;
import kd.isc.iscb.util.script.core.Repository;
import kd.isc.iscb.util.script.data.Tuple;
import kd.isc.iscb.util.script.feature.op.store.Calc;
import kd.isc.iscb.util.script.feature.op.store.CalcAndStoreBase;
import kd.isc.iscb.util.script.feature.tool.date.DateAdd;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;
import kd.isc.iscb.util.script.feature.tool.string.ToString;

public final class AddBy
extends CalcAndStoreBase {
    @Override
    public String name() {
        return "+=";
    }

    @Override
    protected Calc getCalculater() {
        return new Calc(){

            @Override
            protected Object calc(int a, int b) {
                return a + b;
            }

            @Override
            protected Object calc(long a, long b) {
                return a + b;
            }

            @Override
            protected Object calc(double a, double b) {
                return a + b;
            }

            @Override
            protected Object calc(BigDecimal a, BigDecimal b) {
                return a.add(b);
            }

            @Override
            protected Object calc(Object a, Object b, ScriptContext ctx) {
                if (a == null) {
                    return b;
                }
                if (a instanceof Collection) {
                    Collection c = (Collection)a;
                    a = c.add(b);
                    MemoryUtil.checkCollectionMemorySize(c, (RuntimeContext)((Object)ctx));
                } else if (a instanceof Repository) {
                    a = ((Repository)a).append(b);
                } else if (a instanceof StringBuilder) {
                    ((StringBuilder)a).append(ToString.toString(b));
                } else if (a instanceof String) {
                    StringBuilder s = new StringBuilder((String)a);
                    a = s.append(ToString.toString(b));
                } else if (a instanceof Map) {
                    this.addToMap((Map)a, b);
                } else if (a instanceof Context) {
                    this.addToContext((Context)a, b);
                } else if (a instanceof ObjectWriter) {
                    ((ObjectWriter)a).write(b);
                } else if (a instanceof Date) {
                    a = this.addToDate(a, b);
                } else {
                    throw new UnsupportedOperationException(a.getClass().getName());
                }
                return a;
            }

            private Object addToDate(Object a, Object b) {
                if (b instanceof TimeSpan) {
                    a = DateAdd.calc((Date)a, (TimeSpan)b);
                } else if (b instanceof Time) {
                    a = DateAdd.calc((Date)a, (Time)b);
                } else if (b instanceof Long) {
                    a = DateAdd.calc((Date)a, (Long)b);
                } else if (b != null) {
                    throw new UnsupportedOperationException(String.valueOf(a.getClass().getName()) + " +=" + b.getClass().getName());
                }
                return a;
            }

            private void addToContext(Context ctx, Object b) {
                if (b instanceof Map) {
                    for (Map.Entry e : ((Map)b).entrySet()) {
                        Object key = e.getKey();
                        if (key == null) continue;
                        ctx.set(key.toString(), e.getValue());
                    }
                } else {
                    String message = String.valueOf(ctx.getClass().getName()) + " += " + (b == null ? null : b.getClass().getName());
                    throw new UnsupportedOperationException(message);
                }
            }

            private void addToMap(Map map, Object b) {
                if (b == null) {
                    return;
                }
                if (b instanceof Map.Entry) {
                    Map.Entry e = (Map.Entry)b;
                    map.put(e.getKey(), e.getValue());
                } else if (b instanceof Tuple) {
                    Tuple t = (Tuple)b;
                    map.put(t.get(0), t.get(1));
                } else if (b instanceof List) {
                    List list = (List)b;
                    int i = 0;
                    int len = list.size();
                    while (i < len) {
                        Object key = list.get(i);
                        Object value = list.get(i + 1);
                        map.put(key, value);
                        i += 2;
                    }
                } else if (b instanceof Map) {
                    map.putAll((Map)b);
                } else {
                    throw new UnsupportedOperationException(b.getClass().getName());
                }
            }
        };
    }
}

