/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.mailApprove;

import com.kingdee.bos.workflow.extscheme.mailApprove.MailApproveHtmlDTO;
import com.kingdee.bos.workflow.extscheme.mailApprove.MailEntriesField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class MailEntriesArea {
    private String divId;
    private String entriesTitle;
    private String titleStyle;
    private String titleContentStyle;
    private String tableDivStyle;
    private String tableStyle;
    private List<MailEntriesField> entriesFieldList;
    private String thStyle;
    private List<Object[]> dataList;
    private String tbodyStyle;
    private String displayType;
    public static final String DISPLAY_TABLE = "1";
    public static final String DISPLAY_BLOCK = "2";
    private static final String entriesAreaHtml = "<div id=\"{{billEntriesArea}}\" class=\"subArea\" style=\"display: flex ;flex-wrap: wrap\">\n    <div class=\"c_titleDiv\" style=\"flex-basis: 100%\">\n        <span style=\"color: #5582F3;\">|</span>\n        <span id=\"{{billEntriesTitleContent}}\" style=\"margin-bottom:0;\">{{entriesTitle}}</span>\n    </div>\n    <div id = \"{{billEntriesArea_tb_div}}\" style=\"flex-basis: 100%;overflow-x:auto\">\n        <table id = \"{{billEntriesArea_tb}}\" border=\"1\" cellspacing=\"0\" style=\"white-space: nowrap;\">\n            <thead>\n            <tr id = \"{{billEntriesArea_tr}}\">\n            </tr>\n            </thead>\n            <tbody id = \"{{billEntriesArea_tbb}}\">\n            </tbody>\n        </table>\n    </div>\n</div>";
    private static final String entriesBlockHtml = "<div id=\"{{billEntriesArea}}\" class=\"subArea\" style=\"display: flex ;flex-wrap: wrap\">\n    <div class=\"c_titleDiv\" style=\"flex-basis: 100%\">\n        <span style=\"color: #5582F3;\">|</span>\n        <span id=\"{{billEntriesTitleContent}}\" style=\"margin-bottom:0;\">{{entriesTitle}}</span>\n    </div>\n    <div id = \"{{billEntriesArea_tb_div}}\" style=\"flex-basis: 100%;overflow-x:auto\">\n    </div></div>";
    private static final String entriesAreaBlockTableHtml = "   <tr id=\"{{billEntriesArea}}\">\n    <td colspan=\"{{td_col_count_}}\">\n     <span style=\"color: #5582F3;font-weight: 800;font-family: MicrosoftYaHeiSemibold;font-size: 14px;\">|</span>\n     <span id=\"{{billEntriesTitleContent}}\" style=\"{{entries_titleContentStyle_}}\">{{entriesTitle}}</span>\n    </td>\n   </tr>\n\n       {{billEntriesArea_tr_th_td}} ";
    private static final String entriesAreaTableHtml = "   <tr id=\"{{billEntriesArea}}\">\n    <td>\n     <span style=\"color: #5582F3;font-weight: 800;font-family: MicrosoftYaHeiSemibold;font-size: 14px;\">|</span>\n     <span id=\"{{billEntriesTitleContent}}\" style=\"{{entries_titleContentStyle_}}\">{{entriesTitle}}</span>\n    </td>\n   </tr>\n\n   <tr>\n    <td colspan=\"{{td_col_count_}}\">\n     <table border=\"1px;\" cellspacing=\"0\" align=\"left\" style=\"border: 1px solid #d9d9d9;font-size: 11px;font-weight: normal;\" cellpadding=\"3\">\n      <thead>\n      <tr id = \"{{billEntriesArea_tr}}\" bgcolor=\"#F2F2F2\" style=\"border: 1px solid #d9d9d9;font-weight: 300;\" align=\"center\">\n      {{billEntriesArea_tr_th}}      </tr>\n      </thead>\n      <tbody id = \"{{billEntriesArea_tbb}}\">\n       {{billEntriesArea_tr_th_td}}       </tbody>\n     </table>\n\n    </td>\n   </tr>\n";
    private static final String entriesAreaTableHtmlWithNoTitle = "   <tr id=\"{{billEntriesArea}}\">\n    <td colspan=\"{{td_col_count_}}\">\n     <table border=\"1px;\" cellspacing=\"0\" align=\"left\" style=\"border: 1px solid #d9d9d9;font-size: 11px;line-height: 30px;font-weight: normal;white-space: nowrap;\" cellpadding=\"10\">\n      <thead>\n      <tr id = \"{{billEntriesArea_tr}}\" bgcolor=\"#F2F2F2\" style=\"border: 1px solid #d9d9d9;font-weight: 300;white-space: nowrap;\" align=\"center\">\n      {{billEntriesArea_tr_th}}      </tr>\n      </thead>\n      <tbody id = \"{{billEntriesArea_tbb}}\">\n       {{billEntriesArea_tr_th_td}}       </tbody>\n     </table>\n\n    </td>\n   </tr>\n";

    public static String buildEntriesAreaWithDiv(MailEntriesArea entriesArea) {
        Element entriesTitleContentEle;
        Element entriesAreaEle;
        Element entriestableDivEle;
        String html = DISPLAY_BLOCK.equals(entriesArea.getDisplayType()) ? entriesBlockHtml : entriesAreaHtml;
        html = html.replace("{{entriesTitle}}", entriesArea.getEntriesTitle() == null ? "" : MailApproveHtmlDTO.replaceNullStr(entriesArea.getEntriesTitle()));
        Document entriesAreaDoc = Jsoup.parse((String)html);
        if (entriesArea.getTableDivStyle() != null && !"".equals(entriesArea.getTableDivStyle()) && (entriestableDivEle = entriesAreaDoc.getElementById("{{billEntriesArea_tb_div}}")) != null) {
            entriestableDivEle.removeAttr("style");
            String tableDivStyle = entriesArea.getTableDivStyle();
            if (!tableDivStyle.contains("overflow-x")) {
                tableDivStyle = "overflow-x:auto;" + tableDivStyle;
            }
            entriestableDivEle.attr("style", tableDivStyle);
        }
        if ((entriesAreaEle = entriesAreaDoc.getElementById("{{billEntriesArea}}")) != null) {
            entriesAreaEle.removeAttr("style");
            entriesAreaEle.attr("style", entriesArea.getTitleStyle());
        }
        if ((entriesTitleContentEle = entriesAreaDoc.getElementById("{{billEntriesTitleContent}}")) != null) {
            entriesTitleContentEle.removeAttr("style");
            entriesTitleContentEle.attr("style", entriesArea.getTitleContentStyle());
        }
        if (DISPLAY_BLOCK.equals(entriesArea.getDisplayType())) {
            Element entriestableDivEle2;
            String blockEntries = MailEntriesArea.buildBlockEntries(entriesArea);
            if (!"".equals(blockEntries) && (entriestableDivEle2 = entriesAreaDoc.getElementById("{{billEntriesArea_tb_div}}")) != null) {
                entriestableDivEle2.append(blockEntries);
            }
        } else {
            List<MailEntriesField> entriesFieldList;
            Element entriestableEle;
            if (entriesArea.getTableStyle() != null && !"".equals(entriesArea.getTableStyle()) && (entriestableEle = entriesAreaDoc.getElementById("{{billEntriesArea_tb}}")) != null) {
                entriestableEle.removeAttr("style");
                entriestableEle.attr("style", entriesArea.getTableStyle());
            }
            if ((entriesFieldList = entriesArea.getEntriesFieldList()) != null && !entriesFieldList.isEmpty()) {
                Element thElement;
                StringBuilder allThHtml = new StringBuilder("");
                for (MailEntriesField mailEntriesField : entriesFieldList) {
                    if (mailEntriesField.getOutDisplayValue() != null && !mailEntriesField.getOutDisplayValue().booleanValue()) continue;
                    String thHtml = "<th>{{thName}}</th>";
                    thHtml = thHtml.replace("{{thName}}", MailApproveHtmlDTO.replaceNullStr(mailEntriesField.getThName()));
                    allThHtml.append(thHtml);
                }
                if (allThHtml.length() > 0 && (thElement = entriesAreaDoc.getElementById("{{billEntriesArea_tr}}")) != null) {
                    thElement.append(allThHtml.toString());
                    if (entriesArea.getThStyle() != null && !"".equals(entriesArea.getThStyle())) {
                        thElement.attr("style", entriesArea.getThStyle());
                    }
                }
                if (entriesArea.getDataList() != null && !entriesArea.getDataList().isEmpty()) {
                    Element tbbElement;
                    StringBuilder allTbbHtml = new StringBuilder("");
                    for (Object[] trData : entriesArea.getDataList()) {
                        allTbbHtml.append("<tr>");
                        int i = 0;
                        while (i < trData.length) {
                            if (entriesFieldList.get(i).getOutDisplayValue() == null || entriesFieldList.get(i).getOutDisplayValue().booleanValue()) {
                                Object obj = trData[i];
                                String tdHtml = " <td style='padding: 5px;'>{{tdValue}}</td>";
                                tdHtml = tdHtml.replace("{{tdValue}}", obj == null ? "" : obj.toString());
                                allTbbHtml.append(tdHtml);
                            }
                            ++i;
                        }
                        allTbbHtml.append("</tr>");
                    }
                    if (allTbbHtml.length() > 0 && (tbbElement = entriesAreaDoc.getElementById("{{billEntriesArea_tbb}}")) != null) {
                        tbbElement.append(allTbbHtml.toString());
                        if (entriesArea.getTbodyStyle() != null && !"".equals(entriesArea.getTbodyStyle())) {
                            tbbElement.attr("style", entriesArea.getTbodyStyle());
                        }
                    }
                }
            }
        }
        return entriesAreaDoc.html();
    }

    private static String buildBlockEntries(MailEntriesArea entriesArea) {
        StringBuilder blockHtml = new StringBuilder();
        if (entriesArea.getDataList() != null && !entriesArea.getDataList().isEmpty()) {
            List<MailEntriesField> entriesFieldList = entriesArea.getEntriesFieldList();
            int k = 0;
            while (k < entriesArea.getDataList().size()) {
                Object[] trData = entriesArea.getDataList().get(k);
                StringBuilder innerBlock = new StringBuilder();
                if (k == 0) {
                    innerBlock.append(" <div class=\"table_line\" style=\"border-bottom: 1px solid #E6E8EE;border-top: 1px solid #E6E8EE\">\n <table border=\"0\" cellspacing=\"0\">\n");
                } else {
                    innerBlock.append(" <div class=\"table_line\" style=\"border-bottom: 1px solid #E6E8EE\">\n <table border=\"0\" cellspacing=\"0\">\n");
                }
                int i = 0;
                while (i < trData.length) {
                    if (entriesFieldList.get(i).getOutDisplayValue() == null || entriesFieldList.get(i).getOutDisplayValue().booleanValue()) {
                        Object obj = trData[i];
                        String tdHtml = "<tr><td style=\"text-align: left;height: 15px;line-height: 16px;border: none;color:#666666\">{{fieldName}} : {{fieldValue}}</td></tr>";
                        tdHtml = tdHtml.replace("{{fieldName}}", entriesFieldList.get(i).getThName() == null ? "" : MailApproveHtmlDTO.replaceNullStr(entriesFieldList.get(i).getThName()));
                        tdHtml = tdHtml.replace("{{fieldValue}}", obj == null ? "" : obj.toString());
                        innerBlock.append(tdHtml);
                    }
                    ++i;
                }
                innerBlock.append(" </table>\n </div>");
                blockHtml.append((CharSequence)innerBlock);
                ++k;
            }
        }
        return blockHtml.toString();
    }

    private static String buildBlockTableEntries(MailEntriesArea entriesArea, MailApproveHtmlDTO approveHtmlDTO) {
        StringBuilder blockTbHtml = new StringBuilder();
        if (entriesArea.getDataList() != null && !entriesArea.getDataList().isEmpty()) {
            List<MailEntriesField> entriesFieldList = entriesArea.getEntriesFieldList();
            int k = 0;
            while (k < entriesArea.getDataList().size()) {
                Object[] trData = entriesArea.getDataList().get(k);
                StringBuilder innerBlock = new StringBuilder();
                int sortNum = 0;
                int i = 0;
                while (i < trData.length) {
                    if (entriesFieldList.get(i).getOutDisplayValue() == null || entriesFieldList.get(i).getOutDisplayValue().booleanValue()) {
                        Object obj = trData[i];
                        String tdHtml = "<tr><td style=\"font-size: 12px;font-family:'Microsoft YaHei';text-align: left;height: 15px;line-height: 16px;border: none;color:#666666\" colspan=\"{{td_col_count_}}\">{{fieldName}} : {{fieldValue}}</td></tr>";
                        if (++sortNum == 1) {
                            tdHtml = "<tr><td style=\"font-size: 12px;font-family:'Microsoft YaHei';text-align: left;height: 15px;line-height: 16px;border-top: 1px solid #E6E8EE;color:#666666\" colspan=\"{{td_col_count_}}\">{{fieldName}} : {{fieldValue}}</td></tr>";
                        } else if (k == entriesArea.getDataList().size() - 1 && i == trData.length - 1) {
                            tdHtml = "<tr><td style=\"font-size: 12px;font-family:'Microsoft YaHei';text-align: left;height: 15px;line-height: 16px;border-bottom: 1px solid #E6E8EE;color:#666666\" colspan=\"{{td_col_count_}}\">{{fieldName}} : {{fieldValue}}</td></tr>";
                        }
                        tdHtml = tdHtml.replace("{{fieldName}}", entriesFieldList.get(i).getThName() == null ? "" : MailApproveHtmlDTO.replaceNullStr(entriesFieldList.get(i).getThName()));
                        tdHtml = tdHtml.replace("{{fieldValue}}", obj == null ? "" : obj.toString());
                        tdHtml = tdHtml.replace("{{td_col_count_}}", MailApproveHtmlDTO.calColCount(approveHtmlDTO).toString());
                        innerBlock.append(tdHtml);
                    }
                    ++i;
                }
                blockTbHtml.append((CharSequence)innerBlock);
                ++k;
            }
        }
        return blockTbHtml.toString();
    }

    public static Map<String, String> buildEntriesArea(MailApproveHtmlDTO mailApproveHtmlDTO) {
        List<MailEntriesArea> entriesAreas = mailApproveHtmlDTO.getMailEntriesAreas();
        HashMap<String, String> idHtmlMap = new HashMap<String, String>();
        int i = 0;
        while (i < entriesAreas.size()) {
            MailEntriesArea entriesArea = entriesAreas.get(i);
            if (entriesArea.getEntriesFieldList() != null && !entriesArea.getEntriesFieldList().isEmpty()) {
                String singleHtml = "";
                singleHtml = "DIV".equals(mailApproveHtmlDTO.getModelStyle()) ? MailEntriesArea.buildEntriesAreaWithDiv(entriesArea) : MailEntriesArea.buildEntriesAreaWithTable(entriesArea, mailApproveHtmlDTO);
                String extName = "";
                if (i > 0) {
                    extName = "_" + i;
                }
                String divId = "billEntriesArea" + extName;
                if (entriesArea.getDivId() != null && !"".equals(entriesArea.getDivId())) {
                    divId = entriesArea.getDivId();
                }
                singleHtml = singleHtml.replace("{{billEntriesArea}}", divId);
                singleHtml = singleHtml.replace("{{billEntriesTitleContent}}", "billEntriesTitleContent" + extName);
                singleHtml = singleHtml.replace("{{billEntriesArea_tr}}", "billEntriesArea_tr" + extName);
                singleHtml = singleHtml.replace("{{billEntriesArea_tb}}", "billEntriesArea_tb" + extName);
                singleHtml = singleHtml.replace("{{billEntriesArea_tb_div}}", "billEntriesArea_tb_div" + extName);
                singleHtml = singleHtml.replace("{{billEntriesArea_tbb}}", "billEntriesArea_tbb" + extName);
                idHtmlMap.put(divId, singleHtml);
            }
            ++i;
        }
        return idHtmlMap;
    }

    public static String buildEntriesAreaWithTable(MailEntriesArea entriesArea, MailApproveHtmlDTO approveHtmlDTO) {
        String html = DISPLAY_BLOCK.equals(entriesArea.getDisplayType()) ? (StringUtils.isBlank((CharSequence)entriesArea.getEntriesTitle()) ? "{{billEntriesArea_tr_th_td}}" : entriesAreaBlockTableHtml) : (StringUtils.isBlank((CharSequence)entriesArea.getEntriesTitle()) ? entriesAreaTableHtmlWithNoTitle : entriesAreaTableHtml);
        html = html.replace("{{td_col_count_}}", MailApproveHtmlDTO.calColCount(approveHtmlDTO).toString());
        html = html.replace("{{entriesTitle}}", entriesArea.getEntriesTitle() == null ? "" : MailApproveHtmlDTO.replaceNullStr(entriesArea.getEntriesTitle()));
        html = entriesArea.getTitleContentStyle() != null && !"".equals(entriesArea.getTitleContentStyle()) ? html.replace("{{entries_titleContentStyle_}}", entriesArea.getTitleContentStyle().replace("\"", "'")) : html.replace("{{entries_titleContentStyle_}}", "font-weight: 800;font-family: MicrosoftYaHeiSemibold;font-size: 14px;");
        List<MailEntriesField> entriesFieldList = entriesArea.getEntriesFieldList();
        if (DISPLAY_BLOCK.equals(entriesArea.getDisplayType())) {
            String tdHtml = MailEntriesArea.buildBlockTableEntries(entriesArea, approveHtmlDTO);
            html = html.replace("{{billEntriesArea_tr_th_td}}", tdHtml);
        } else if (entriesFieldList != null && !entriesFieldList.isEmpty()) {
            StringBuilder allThHtml = new StringBuilder("");
            for (MailEntriesField mailEntriesField : entriesFieldList) {
                if (mailEntriesField.getOutDisplayValue() != null && !mailEntriesField.getOutDisplayValue().booleanValue()) continue;
                String thHtml = "<th style=\"border: 1px solid #d9d9d9;font-weight:normal;\">{{thName}}</th>\n";
                thHtml = thHtml.replace("{{thName}}", MailApproveHtmlDTO.replaceNullStr(mailEntriesField.getThName()));
                allThHtml.append(thHtml);
            }
            if (allThHtml.length() > 0) {
                html = html.replace("{{billEntriesArea_tr_th}}", allThHtml);
            }
            if (entriesArea.getDataList() != null && !entriesArea.getDataList().isEmpty()) {
                StringBuilder allTbbHtml = new StringBuilder("");
                for (Object[] trData : entriesArea.getDataList()) {
                    allTbbHtml.append("<tr style=\"border: 1px solid #d9d9d9;\" align=\"center\">");
                    int i = 0;
                    while (i < trData.length) {
                        if (entriesFieldList.get(i).getOutDisplayValue() == null || entriesFieldList.get(i).getOutDisplayValue().booleanValue()) {
                            Object obj = trData[i];
                            String tdHtml = "<td style=\"border: 1px solid #d9d9d9;color:#666666;\" valign=\"middle\">{{tdValue}}</td>\n";
                            tdHtml = tdHtml.replace("{{tdValue}}", obj == null ? "" : obj.toString());
                            allTbbHtml.append(tdHtml);
                        }
                        ++i;
                    }
                    allTbbHtml.append("</tr>");
                }
                if (allTbbHtml.length() > 0) {
                    html = html.replace("{{billEntriesArea_tr_th_td}}", allTbbHtml);
                }
            }
        }
        return html;
    }

    public String getEntriesTitle() {
        return this.entriesTitle;
    }

    public MailEntriesArea setEntriesTitle(String entriesTitle) {
        this.entriesTitle = entriesTitle;
        return this;
    }

    public String getTitleStyle() {
        return this.titleStyle;
    }

    public MailEntriesArea setTitleStyle(String titleStyle) {
        this.titleStyle = titleStyle;
        return this;
    }

    public String getTableDivStyle() {
        return this.tableDivStyle;
    }

    public MailEntriesArea setTableDivStyle(String tableDivStyle) {
        this.tableDivStyle = tableDivStyle;
        return this;
    }

    public String getTableStyle() {
        return this.tableStyle;
    }

    public MailEntriesArea setTableStyle(String tableStyle) {
        this.tableStyle = tableStyle;
        return this;
    }

    public List<MailEntriesField> getEntriesFieldList() {
        return this.entriesFieldList;
    }

    public MailEntriesArea setEntriesFieldList(List<MailEntriesField> entriesFieldList) {
        this.entriesFieldList = entriesFieldList;
        return this;
    }

    public String getThStyle() {
        return this.thStyle;
    }

    public MailEntriesArea setThStyle(String thStyle) {
        this.thStyle = thStyle;
        return this;
    }

    public String getDivId() {
        return this.divId;
    }

    public MailEntriesArea setDivId(String divId) {
        this.divId = divId;
        return this;
    }

    public List<Object[]> getDataList() {
        return this.dataList;
    }

    public MailEntriesArea setDataList(List<Object[]> dataList) {
        this.dataList = dataList;
        return this;
    }

    public String getTbodyStyle() {
        return this.tbodyStyle;
    }

    public MailEntriesArea setTbodyStyle(String tbodyStyle) {
        this.tbodyStyle = tbodyStyle;
        return this;
    }

    public String getTitleContentStyle() {
        return this.titleContentStyle;
    }

    public MailEntriesArea setTitleContentStyle(String titleContentStyle) {
        this.titleContentStyle = titleContentStyle;
        return this;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public MailEntriesArea setDisplayType(String displayType) {
        this.displayType = displayType;
        return this;
    }
}

