/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.web.handler.integrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.sensitive.ShrSensitiveServiceUtil;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.exception.CmpBasicException;
import com.kingdee.shr.compensation.util.BaseUtils;
import com.kingdee.shr.compensation.util.report.CmpReportHelper;
import com.kingdee.shr.compensation.util.report.CommonSQLUtil;
import com.kingdee.shr.compensation.util.report.DataCacheManager;
import com.kingdee.shr.compensation.util.report.FileConventHelper;
import com.kingdee.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionMode;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.ui.ModelMap;

public class FileExportHelper {
    private static Logger logger = Logger.getLogger(FileExportHelper.class);
    private static final int MAX_COLUMN_COUNT = 200;

    public String assembleExportDataSql(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String sql = session.getAttribute("exportDataSql").toString();
        return sql;
    }

    public String[] assembleQueryMode(HttpServletRequest request) throws SHRWebException {
        HttpSession session = request.getSession();
        List colModel = (List)session.getAttribute("colModel");
        return this.doAssembleQueryMode(request, colModel);
    }

    public String[] doAssembleQueryMode(HttpServletRequest request, List<Map<String, Object>> colModel) throws SHRWebException {
        String[] queryMode = new String[colModel.size()];
        Map<String, Object> col = null;
        long startTime = System.currentTimeMillis();
        Object[] numberTypeItemPrefxArr = CmpReportHelper.getNumberTypeItemFieldSnArray((HttpServletRequest)request);
        Map numberTypeCmpItemMap = DataCacheManager.getNumberTypeCmpItemMapInSession((HttpServletRequest)request);
        int i = 0;
        int size = colModel.size();
        while (i < size) {
            String type;
            col = colModel.get(i);
            String index = col.get("index").toString();
            boolean hidden = false;
            if (col.get("hidden") != null) {
                hidden = Boolean.valueOf(col.get("hidden").toString());
            }
            String label = col.get("label") == null ? col.get("name").toString() : col.get("label").toString();
            StringBuffer buffer = new StringBuffer();
            buffer.append(index).append(",").append(hidden).append(",").append(label);
            String name = col.get("name").toString();
            boolean numItem = CmpReportHelper.isNumberTypeSN((Object[])numberTypeItemPrefxArr, (String)name);
            buffer.append(",").append(numItem);
            if (numItem) {
                type = name.toUpperCase(Locale.ENGLISH);
                type = type.contains(".") ? type.substring(type.indexOf(".") + 1) : type;
                int precision = Integer.valueOf(numberTypeCmpItemMap.get(type).toString());
                buffer.append(",").append(precision);
            } else {
                buffer.append(",").append(0);
            }
            String string = type = col.containsKey("type") ? col.get("type").toString() : "String";
            if (!("IntEnum".equalsIgnoreCase(type) || "StringEnum".equalsIgnoreCase(type) || "Enum".equalsIgnoreCase(type))) {
                buffer.append(",").append(false);
            } else {
                buffer.append(",").append(true);
            }
            queryMode[i] = buffer.toString();
            ++i;
        }
        long endTime = System.currentTimeMillis();
        logger.info((Object)("assembleQueryMode cost time : " + (endTime - startTime)));
        logger.info((Object)("export total count  " + queryMode.length));
        return queryMode;
    }

    public void checkMaxExportColumnCount(String[] queryMode) throws SHRWebException {
        if (queryMode.length > 200) {
            throw new ShrWebBizException((Throwable)new CmpBasicException(CmpBasicException.EXPORTFAIL, new Object[]{200}));
        }
    }

    public String exportToExcel(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String sql = this.assembleExportDataSql(request);
        IRowSet rowSet = CommonSQLUtil.executeQuery((String)sql);
        String[] queryMode = this.assembleQueryMode(request);
        List<Map<String, Object>> datas = this.transferRowSetToList(rowSet, queryMode);
        return this.doExportToExcel(request, response, datas, queryMode);
    }

    public String exportToExcel(HttpServletRequest request, HttpServletResponse response, String sql, String[] queryMode) throws SHRWebException {
        IRowSet rowSet = CommonSQLUtil.executeQuery((String)sql);
        List<Map<String, Object>> datas = this.transferRowSetToList(rowSet, queryMode);
        return this.doExportToExcel(request, response, datas, queryMode);
    }

    public String exportToPDF(HttpServletRequest request, HttpServletResponse response, String sql, String[] queryMode) throws SHRWebException, EASBizException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        String psw = request.getParameter("psw");
        boolean isPswNeeded = ShrSensitiveServiceUtil.isExportInProtected((Context)ctx, (HttpServletRequest)request);
        if (isPswNeeded && StringUtils.isEmpty((String)psw)) {
            throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"exportPrivteProtected", (Context)ctx));
        }
        IRowSet rowSet = CommonSQLUtil.executeQuery((String)sql);
        List<Map<String, Object>> datas = this.transferRowSetToList(rowSet, queryMode);
        return this.doExportToPDF(request, response, datas, queryMode);
    }

    public String exportToPDF(HttpServletRequest request, HttpServletResponse response, List<Map<String, Object>> datas, String[] queryMode) throws SHRWebException, EASBizException, BOSException {
        Context ctx = SHRContext.getInstance().getContext();
        String psw = request.getParameter("psw");
        boolean isPswNeeded = ShrSensitiveServiceUtil.isExportInProtected((Context)ctx, (HttpServletRequest)request);
        if (isPswNeeded && StringUtils.isEmpty((String)psw)) {
            throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"exportPrivteProtected", (Context)ctx));
        }
        return this.doExportToPDF(request, response, datas, queryMode);
    }

    protected String doExportToPDF(HttpServletRequest request, HttpServletResponse response, List<Map<String, Object>> datas, String[] queryMode) throws ShrWebBizException {
        ServletOutputStream os = null;
        BufferedInputStream in = null;
        FileOutputStream outputStream = null;
        try {
            int length;
            long stime = System.currentTimeMillis();
            String title = this.assembleExprotTitile(request);
            String datetime = this.assembleExportDateTimeStr();
            String sheetTitle = String.valueOf(title) + "_" + datetime;
            SXSSFWorkbook wb = this.generateWorkBookData(datas, queryMode, sheetTitle, true);
            String dfileName = this.assembleExportFileName(request, sheetTitle);
            outputStream = FileConventHelper.getExcelFileOutputStream((String)dfileName);
            wb.write((OutputStream)outputStream);
            String pdfFileName = FileConventHelper.convertExcelToPdf((HttpServletRequest)request, (String)dfileName);
            os = response.getOutputStream();
            response.reset();
            response.setHeader("Content-Disposition", "attachment; filename=" + pdfFileName);
            response.setContentType("application/pdf");
            in = new BufferedInputStream(FileConventHelper.getPdfFileInputStream((String)dfileName));
            byte[] data = new byte[1024];
            while ((length = in.read(data)) != -1) {
                os.write(data, 0, length);
            }
            long etime = System.currentTimeMillis();
            logger.info((Object)(" do execute export pdf cost time: " + (etime - stime)));
        }
        catch (Exception var23) {
            try {
                throw new ShrWebBizException(var23.getMessage());
            }
            catch (Throwable throwable) {
                BaseUtils.closeResource((Closeable[])new Closeable[]{outputStream, os, in});
                throw throwable;
            }
        }
        BaseUtils.closeResource((Closeable[])new Closeable[]{outputStream, os, in});
        return null;
    }

    protected String assembleExprotTitile(HttpServletRequest request) {
        String title = request.getParameter("title");
        if (StringUtils.isEmpty((String)title)) {
            title = (String)request.getAttribute("title");
        }
        return title;
    }

    protected String doExportToExcel(HttpServletRequest request, HttpServletResponse response, List<Map<String, Object>> datas, String[] queryMode) throws SHRWebException {
        boolean isPswNeeded;
        Context ctx = SHRContext.getInstance().getContext();
        String psw = request.getParameter("psw");
        try {
            isPswNeeded = ShrSensitiveServiceUtil.isExportInProtected((Context)ctx, (HttpServletRequest)request);
        }
        catch (EASBizException var377) {
            throw new ShrWebBizException(var377.getMessage(), (Throwable)var377);
        }
        catch (BOSException var378) {
            throw new SHRWebException(var378.getMessage(), (Throwable)var378);
        }
        if (isPswNeeded && StringUtils.isEmpty((String)psw)) {
            throw new ShrWebBizException(SHRWebResource.getString((String)"com.kingdee.shr.base.syssetting.SHRSyssettingResource", (String)"exportPrivteProtected", (Context)ctx));
        }
        long stime = System.currentTimeMillis();
        response.reset();
        response.setHeader("Content-disposition", "attachment; filename=" + this.getExportFileName(request));
        response.setContentType("application/msexcel");
        String sheetTitle = this.getSheetTitle(request);
        if (StringUtils.isEmpty((String)psw)) {
            try {
                Throwable var12 = null;
                try (SXSSFWorkbook wb = this.generateWorkBookData(datas, queryMode, sheetTitle, false);){
                    try {
                        Throwable var14 = null;
                        try (ServletOutputStream responseOutputStream = response.getOutputStream();){
                            try {
                                wb.write((OutputStream)responseOutputStream);
                                long etime = System.currentTimeMillis();
                                logger.info((Object)("do execute export cost time: " + (etime - stime)));
                                Object info = null;
                            }
                            catch (Throwable var375) {
                                var14 = var375;
                                throw var375;
                            }
                        }
                    }
                    catch (Throwable var380) {
                        var12 = var380;
                        throw var380;
                    }
                }
                return null;
            }
            catch (IOException | SQLException var382) {
                throw new SHRWebException(var382.getMessage(), (Throwable)var382);
            }
        }
        try {
            Throwable var12 = null;
            try (SXSSFWorkbook wb = this.generateWorkBookData(datas, queryMode, sheetTitle, false);){
                try {
                    Throwable var14 = null;
                    try (ServletOutputStream responseOutputStream = response.getOutputStream();){
                        try {
                            Throwable var16 = null;
                            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                                try {
                                    wb.write((OutputStream)baos);
                                    EncryptionInfo info = new EncryptionInfo(EncryptionMode.agile);
                                    Encryptor encryptor = info.getEncryptor();
                                    encryptor.confirmPassword(psw);
                                    Throwable var20 = null;
                                    try (ByteArrayInputStream workbookInput = new ByteArrayInputStream(baos.toByteArray());){
                                        try {
                                            Throwable var22 = null;
                                            try (OPCPackage opc = OPCPackage.open((InputStream)workbookInput);){
                                                try {
                                                    Throwable var24 = null;
                                                    try (POIFSFileSystem fs = new POIFSFileSystem();){
                                                        try {
                                                            Throwable var26 = null;
                                                            try (OutputStream encOs = encryptor.getDataStream(fs);){
                                                                try {
                                                                    opc.save(encOs);
                                                                }
                                                                catch (Throwable var376) {
                                                                    var26 = var376;
                                                                    throw var376;
                                                                }
                                                            }
                                                            fs.writeFilesystem((OutputStream)responseOutputStream);
                                                        }
                                                        catch (Throwable var384) {
                                                            var24 = var384;
                                                            throw var384;
                                                        }
                                                    }
                                                }
                                                catch (Throwable var386) {
                                                    var22 = var386;
                                                    throw var386;
                                                }
                                            }
                                        }
                                        catch (Throwable var388) {
                                            var20 = var388;
                                            throw var388;
                                        }
                                    }
                                }
                                catch (Throwable var390) {
                                    var16 = var390;
                                    throw var390;
                                }
                            }
                        }
                        catch (Throwable var392) {
                            var14 = var392;
                            throw var392;
                        }
                    }
                }
                catch (Throwable var394) {
                    var12 = var394;
                    throw var394;
                }
            }
        }
        catch (Exception var396) {
            throw new ShrWebBizException(var396.getMessage(), (Throwable)var396);
        }
        long etime = System.currentTimeMillis();
        logger.info((Object)(" do execute export cost time: " + (etime - stime)));
        return null;
    }

    protected String getSheetTitle(HttpServletRequest request) {
        String title = this.assembleExprotTitile(request);
        String datetime = this.assembleExportDateTimeStr();
        return String.valueOf(title) + "_" + datetime;
    }

    protected String getExportFileName(HttpServletRequest request) throws SHRWebException {
        String sheetTitle = this.getSheetTitle(request);
        try {
            return this.assembleExportFileName(request, sheetTitle);
        }
        catch (UnsupportedEncodingException var4) {
            throw new SHRWebException(var4.getMessage(), (Throwable)var4);
        }
    }

    public List<Map<String, Object>> transferRowSetToList(IRowSet rowSet, String[] queryMode) throws SHRWebException {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        if (rowSet != null && rowSet.size() >= 1 && queryMode != null && queryMode.length >= 1) {
            try {
                while (rowSet.next()) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    int i = 0;
                    while (i < queryMode.length) {
                        String[] column = queryMode[i].split(",");
                        if (StringUtils.isEmpty((String)column[1]) || !Boolean.valueOf(column[1]).booleanValue()) {
                            dataMap.put(column[0], rowSet.getObject(column[0]));
                        }
                        ++i;
                    }
                    datas.add(dataMap);
                }
                return datas;
            }
            catch (SQLException var7) {
                throw new SHRWebException(var7.getMessage(), (Throwable)var7);
            }
        }
        return datas;
    }

    protected SXSSFWorkbook generateWorkBookData(List<Map<String, Object>> datas, String[] queryMode, String sheetTitle, Boolean isPdf) throws SHRWebException, SQLException, IOException {
        if (datas == null) {
            datas = new ArrayList<Map<String, Object>>();
        }
        SXSSFWorkbook wb = new SXSSFWorkbook();
        CellStyle headCellStyle = wb.createCellStyle();
        Font fontStyle = wb.createFont();
        fontStyle.setFontName("Arial");
        fontStyle.setFontHeightInPoints((short)10);
        headCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headCellStyle.setBorderTop(BorderStyle.THIN);
        headCellStyle.setBorderLeft(BorderStyle.THIN);
        headCellStyle.setBorderBottom(BorderStyle.THIN);
        headCellStyle.setBorderRight(BorderStyle.THIN);
        headCellStyle.setFont(fontStyle);
        Row row = null;
        Cell cell = null;
        CellStyle cellStyleString = wb.createCellStyle();
        cellStyleString.setFont(fontStyle);
        SXSSFSheet sheet = wb.createSheet(sheetTitle);
        int hCol = 0;
        row = sheet.createRow(0);
        HashSet<String> dotNumSet = new HashSet<String>();
        int i = 0;
        while (i < queryMode.length) {
            String[] column = queryMode[i].split(",");
            boolean isHidden = Boolean.valueOf(column[1]);
            if (!isHidden) {
                cell = row.createCell(hCol);
                cell.setCellValue(column[2]);
                cell.setCellStyle(headCellStyle);
                ++hCol;
            }
            dotNumSet.add(column[4]);
            ++i;
        }
        Map<String, CellStyle> cellStyleMap = this.getCellStyleByDotNumber(dotNumSet, wb, fontStyle);
        int rowIndex = 0;
        HashMap<String, Object> sumDataMap = new HashMap<String, Object>();
        int rowSetSize = datas.size();
        BaseUtils utils = new BaseUtils();
        HashMap<String, String> enumSourceMap = new HashMap<String, String>();
        DataFormat format = wb.createDataFormat();
        for (Map<String, Object> data : datas) {
            row = sheet.createRow(rowIndex + 1);
            int colIndex = 0;
            int i2 = 0;
            while (i2 < queryMode.length) {
                String[] column = queryMode[i2].split(",");
                boolean isHidden = Boolean.valueOf(column[1]);
                if (!isHidden) {
                    String value;
                    String colOne = column[0];
                    Object valueObj = data.get(colOne);
                    if (!Boolean.valueOf(column[5]).booleanValue()) {
                        value = this.processCellValue(valueObj, column[3], column[4]);
                    } else if (enumSourceMap.containsKey(colOne)) {
                        String enumSource = (String)enumSourceMap.get(colOne);
                        Object obj = utils.getStructColumnsPupolateValueByType("002", colOne, valueObj, enumSource);
                        value = obj == null ? null : obj.toString();
                    } else {
                        Map structColumnsPupolateValue = utils.getStructColumnsPupolateValue("002", colOne, valueObj);
                        enumSourceMap.put(colOne, ((Map)structColumnsPupolateValue.get(colOne)).get("type").toString());
                        value = ((Map)structColumnsPupolateValue.get(colOne)).get("value") == null ? null : ((Map)structColumnsPupolateValue.get(colOne)).get("value").toString();
                    }
                    if (("startTime".equals(colOne) || "endTime".equals(colOne) || "restStartTime".equals(colOne) || "restEndTime".equals(colOne)) && valueObj instanceof Timestamp) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm");
                        SimpleDateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        try {
                            value = dateFormat.format(timeFormat.parse(valueObj.toString()));
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                    }
                    boolean isNumType = Boolean.valueOf(column[3]);
                    cell = row.createCell(colIndex);
                    String string = colOne = colOne.contains(".") ? colOne.substring(colOne.indexOf(".") + 1) : colOne;
                    if (!(colOne.toUpperCase(Locale.ENGLISH).startsWith("S") && isNumType || colOne.equalsIgnoreCase("personCounts"))) {
                        if (StringUtils.isEmpty((String)value)) {
                            cell.setCellType(CellType.BLANK);
                        } else {
                            cell.setCellValue(value);
                            cell.setCellStyle(cellStyleString);
                        }
                        cellStyleString.setDataFormat(format.getFormat("@"));
                    } else {
                        CellStyle cellStyleNumber = cellStyleMap.get(column[4]);
                        cell.setCellStyle(cellStyleNumber);
                        if (value != null && !isPdf.booleanValue()) {
                            cell.setCellValue(Double.valueOf(value).doubleValue());
                        } else {
                            cell.setCellValue(value);
                        }
                        if (sumDataMap.get(colOne) == null) {
                            sumDataMap.put(colOne, value);
                        } else {
                            BigDecimal tmpV;
                            Object tmp = sumDataMap.get(colOne);
                            BigDecimal bigDecimal = tmpV = tmp == null ? BigDecimal.ZERO : new BigDecimal(tmp.toString());
                            if (!StringUtils.isEmpty((String)value)) {
                                sumDataMap.put(colOne, tmpV.add(new BigDecimal(value)));
                            }
                        }
                    }
                    ++colIndex;
                }
                ++i2;
            }
            if (++rowIndex % 100 != 0) continue;
            sheet.flushRows();
        }
        return wb;
    }

    protected void addSumRowData(SXSSFWorkbook wb, Sheet sheet, int rowIndex, String[] queryMode, Map<String, Object> sumDataMap, int rowSetSize, Map<String, CellStyle> cellStyleMap, Boolean isPdf) {
        if (rowSetSize == rowIndex) {
            Font fontStyle = wb.createFont();
            fontStyle.setFontName("Arial");
            fontStyle.setFontHeightInPoints((short)10);
            CellStyle cellStyleNumber = wb.createCellStyle();
            CellStyle cellStyleString = wb.createCellStyle();
            cellStyleString.setFont(fontStyle);
            String getSum = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CalPersonResource", (String)"sumAll", (Locale)SHRContext.getInstance().getContext().getLocale());
            int FIRSTCOLINDEX = 0;
            Row row = sheet.createRow(rowIndex + 1);
            int colIndex = 0;
            int i = 0;
            while (i < queryMode.length) {
                String[] column = queryMode[i].split(",");
                boolean isHidden = Boolean.valueOf(column[1]);
                if (!isHidden) {
                    String colOne = column[0];
                    boolean isNumType = Boolean.valueOf(column[3]);
                    Cell cell = row.createCell(colIndex);
                    colOne = colOne.contains(".") ? colOne.substring(colOne.indexOf(".") + 1) : colOne;
                    String value = this.processCellValue(sumDataMap.get(colOne), column[3], column[4]);
                    if (FIRSTCOLINDEX == colIndex) {
                        value = getSum;
                    }
                    if (!(colOne.toUpperCase(Locale.ENGLISH).startsWith("S") && isNumType || colOne.equalsIgnoreCase("personCounts"))) {
                        cell.setCellValue(value);
                        cell.setCellStyle(cellStyleString);
                    } else {
                        cellStyleNumber = cellStyleMap.get(column[4]);
                        if (value != null && !isPdf.booleanValue()) {
                            cell.setCellValue(Double.valueOf(value).doubleValue());
                        } else {
                            cell.setCellValue(value);
                        }
                        cell.setCellStyle(cellStyleNumber);
                    }
                    ++colIndex;
                }
                ++i;
            }
        }
    }

    protected String assembleExportFileName(HttpServletRequest request, String sheetTitle) throws UnsupportedEncodingException {
        String dfileName = "";
        dfileName = String.valueOf(WebUtil.convertFileNameForDownload((HttpServletRequest)request, (String)sheetTitle)) + ".xlsx";
        return dfileName;
    }

    protected String assembleExportDateTimeStr() {
        Date currdate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(currdate);
        String datetime = String.valueOf(c.get(1)) + (c.get(2) + 1) + c.get(5);
        return datetime;
    }

    protected String processCellValue(Object value, Object fieldType, Object precision) {
        boolean isNumType = Boolean.valueOf(fieldType.toString());
        if (isNumType) {
            if (value == null) {
                return (String)value;
            }
            int pre = Integer.parseInt(precision.toString());
            return value == null ? null : FunctionTools.getRound((int)pre, (double)new BigDecimal(value == null ? "0" : value.toString()).doubleValue());
        }
        if (value instanceof Timestamp) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return dateFormat.format(dateFormat.parse(value.toString()));
            }
            catch (ParseException var7) {
                var7.printStackTrace();
            }
        }
        return value == null ? null : value.toString();
    }

    protected Map<String, CellStyle> getCellStyleByDotNumber(Set<String> dotNumSet, SXSSFWorkbook wb, Font fontStyle) {
        HashMap<String, CellStyle> map = new HashMap<String, CellStyle>();
        DataFormat format = wb.createDataFormat();
        Iterator<String> var6 = dotNumSet.iterator();
        while (var6.hasNext()) {
            String value = var6.next();
            CellStyle cellStyleNumber = wb.createCellStyle();
            cellStyleNumber.setFont(fontStyle);
            boolean flag = org.apache.commons.lang3.StringUtils.isNumeric((CharSequence)value);
            if (!flag) continue;
            int num = Integer.valueOf(value);
            if (num == 0) {
                cellStyleNumber.setDataFormat(format.getFormat("###0"));
            } else {
                StringBuilder builder = new StringBuilder("###0.");
                int i = 0;
                while (i < num) {
                    builder.append("0");
                    ++i;
                }
                cellStyleNumber.setDataFormat(format.getFormat(builder.toString()));
            }
            map.put(value, cellStyleNumber);
        }
        return map;
    }

    public String exportToExcel(HttpServletRequest request, HttpServletResponse response, List<Map<String, Object>> datas, String[] queryMode) throws SHRWebException {
        return this.doExportToExcel(request, response, datas, queryMode);
    }
}

