/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.integrate.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.utils.DateTimeUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.entity.Pair;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.DateTypeEnum;
import com.kingdee.shr.compensation.exception.SubmitBillVerifyException;
import com.kingdee.shr.compensation.integrate.verify.ISubmitBillVerifyInterface;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryHelper;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.LocaleUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractSubmitBillVerify
implements ISubmitBillVerifyInterface {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.integrate.verify.AbstractSubmitBillVerify");

    public void verify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException, EASBizException {
        this.beforeVerify(ctx, model, otherParams);
        this.runVerify(ctx, model, otherParams);
        this.afterVerify(ctx, model, otherParams);
    }

    protected void beforeVerify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException, EASBizException {
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        this.verifyBillState(ctx, (CoreBaseInfo)info);
    }

    protected void verifyBillState(Context ctx, CoreBaseInfo model) throws EASBizException, BOSException {
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        BatchSubmitShemeBillCollection colsInDB = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillCollection("select billState where id = '" + info.getId().toString() + "'");
        if (colsInDB.isEmpty()) {
            return;
        }
        HRBillStateEnum billState = colsInDB.get(0).getBillState();
        if (HRBillStateEnum.SAVED != billState && HRBillStateEnum.SUBMITED != billState) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION4);
        }
    }

    protected void runVerify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException, EASBizException {
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        this.verifyRemovedCmpFile(ctx, info);
        this.verifyCmpEmpRe(ctx, info);
        this.verifySubmitPeriod(ctx, info);
    }

    protected void verifyRemovedCmpFile(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        String billEntryTable = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameBySubmitSchemeId((Context)ctx, (String)info.getSubmitScheme().getId().toString());
        String sqlTemplate = "SELECT entry.fpersonId, person.FName_%s personName, person.FNumber personNum FROM %s entry LEFT JOIN T_BD_PERSON person ON entry.FPersonId = person.Fid WHERE NOT EXISTS(SELECT 1 FROM T_HR_SCmpEmpORelation empOrel WHERE entry.FCmpEmpORelationID = empOrel.FID) AND entry.fbillId = '%s'";
        HashSet<String> nameAndNumSet = new HashSet<String>();
        String personHint = SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.CommonResource", (String)"label195", (Locale)ctx.getLocale());
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)String.format(sqlTemplate, LocaleUtils.getShortCode((Locale)ctx.getLocale()), billEntryTable, info.getId().toString()));
            while (rs.next()) {
                nameAndNumSet.add(MessageFormat.format(personHint, rs.getString("personName"), rs.getString("personNum")));
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        if (!nameAndNumSet.isEmpty()) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION1, nameAndNumSet.toArray());
        }
    }

    protected void afterVerify(Context ctx, CoreBaseInfo model, Map<String, Object> otherParams) throws BOSException {
    }

    protected void verifyCmpEmpRe(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        Map<String, Pair<java.util.Date, java.util.Date>> empCmpRelationsFromDb = this.getEmpCmpRelationsFromDb(ctx, info);
        if (empCmpRelationsFromDb.isEmpty()) {
            return;
        }
        HashSet<String> errorPersons = new HashSet<String>();
        DateTypeEnum effectDateDisplay = null;
        CalSubmitSchemeCollection submitScheme = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeCollection("where id = '" + info.getSubmitScheme().getId().toString() + "'");
        if (submitScheme != null && submitScheme.size() > 0) {
            effectDateDisplay = submitScheme.get(0).getEffectDateDisplay();
        }
        BatchSubmitShemeBillEntryCollection coll = info.getEntry();
        int adjustMonth = 0;
        HashSet<String> personSet = new HashSet<String>();
        int dataSource = info.getDatasource().getValue();
        if (dataSource == 2) {
            HashSet<String> personIdSet = new HashSet<String>();
            int i = 0;
            while (i < coll.size()) {
                BatchSubmitShemeBillEntryInfo entryInfo = coll.get(i);
                String personId = entryInfo.getPerson().getId().toString();
                personIdSet.add(personId);
                ++i;
            }
            logger.error((Object)("\u4eba\u5458ID\u96c6\u5408\uff1a" + personIdSet));
            StringBuffer personIds = new StringBuffer();
            for (String id : personIdSet) {
                personIds.append("'" + id + "',");
            }
            String sql = "select top 1 * from T_HR_SHRRsvItem0 where fnumber = '1005' and FState = '1'";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    adjustMonth = rs.getInt("FName_l2");
                }
                if (personIds.length() > 0) {
                    personIds.deleteCharAt(personIds.length() - 1);
                    String nowDate = DateTimeUtils.dateFormat(new java.util.Date(), "yyyy-MM-dd");
                    String personSql = "SELECT DISTINCT a.fpersonid,a.fpositionid FROM T_HR_EmpOrgRelation a left join T_HR_EmpLaborRelationHis b on a.FPERSONID=b.fpersonid left join T_HR_BDEmployeeType c on c.fid=b.flaborrelationstateid where c.finservice not in ('2','3') and a.feffdt <= '" + nowDate + "' " + "and a.fleffdt >= '" + nowDate + "' and a.fislatestinaday = '1' " + "and b.fstartdatetime <= '" + nowDate + "' and b.fenddatetime >= '" + nowDate + "' " + "and a.fpersonid in (" + personIds + ")";
                    logger.error((Object)("\u67e5\u8be2\u5728\u804c\u4eba\u5458SQL\uff1a" + personSql));
                    IRowSet personRow = DbUtil.executeQuery((Context)ctx, (String)personSql);
                    while (personRow.next()) {
                        personSet.add(String.valueOf(personRow.getString("fpersonid")) + "_" + personRow.getString("fpositionid"));
                    }
                    logger.error((Object)("\u5458\u5de5+\u90e8\u95e8ID\u96c6\u5408" + personSet));
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (coll != null && coll.size() > 0) {
            int i = 0;
            while (i < coll.size()) {
                Pair<java.util.Date, java.util.Date> pair;
                BatchSubmitShemeBillEntryInfo entryInfo = coll.get(i);
                String employeeTypeId = entryInfo.getCmpEmpORelation().getId().toString();
                java.util.Date entryDate = entryInfo.getEffectDate();
                String personId = entryInfo.getPerson().getId().toString();
                String positionId = entryInfo.getPosition().getId().toString();
                if (!personSet.contains(String.valueOf(personId) + "_" + positionId)) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(entryDate);
                    calendar.add(2, adjustMonth);
                    entryDate = calendar.getTime();
                }
                if ((pair = empCmpRelationsFromDb.get(String.valueOf(personId) + "_" + positionId + "_" + employeeTypeId)) != null) {
                    java.util.Date effectDate = (java.util.Date)pair.getFirst();
                    java.util.Date leffectDate = (java.util.Date)pair.getSecond();
                    String personName = this.getPersonNameIfVerified(entryInfo);
                    if (effectDateDisplay == DateTypeEnum.yyyyMM) {
                        if (CmpDateUtil.compareMonth((java.util.Date)entryDate, (java.util.Date)effectDate) < 0 || CmpDateUtil.compareMonth((java.util.Date)entryDate, (java.util.Date)leffectDate) > 0) {
                            errorPersons.add(personName);
                        }
                    } else if (entryDate.compareTo(effectDate) < 0 || entryDate.compareTo(leffectDate) > 0) {
                        errorPersons.add(personName);
                    }
                }
                ++i;
            }
        }
        int maxSize = 30;
        int size = 1;
        StringBuilder errorMessage = new StringBuilder();
        for (String errorPersonName : errorPersons) {
            if (maxSize <= size) break;
            errorMessage.append(errorPersonName).append("\u3001");
            ++size;
        }
        if (errorMessage.length() > 0) {
            String message = errorMessage.substring(0, errorMessage.length() - 1);
            if (size == maxSize) {
                message = String.valueOf(message) + "...";
            }
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION5, new Object[]{message});
        }
    }

    protected String getPersonNameIfVerified(BatchSubmitShemeBillEntryInfo entryInfo) throws EASBizException {
        String personName = entryInfo.getPerson().getName();
        if (StringUtils.isEmpty((CharSequence)personName)) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.PERSON_PERM_ERROR);
        }
        return personName;
    }

    protected Map<String, Pair<java.util.Date, java.util.Date>> getEmpCmpRelationsFromDb(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        BatchSubmitShemeBillEntryCollection coll = info.getEntry();
        HashSet<String> personIds = new HashSet<String>();
        boolean personIsNull = false;
        int i = 0;
        while (i < coll.size()) {
            if (coll.get(i).getPerson() == null || coll.get(i).getPerson().getId() == null) {
                personIsNull = true;
            } else {
                personIds.add(coll.get(i).getPerson().getId().toString());
            }
            ++i;
        }
        if (personIsNull) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION8);
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String personInSql = cmpInSql.createInSqlBaseOnFId(ctx, personIds);
        String hrOrgUnitId = info.getHrOrgUnit().getId().toString();
        String adminOrgId = info.getAdminOrg().getId().toString();
        String longNumber = this.getLongNumber(ctx, adminOrgId);
        StringBuilder filter = new StringBuilder();
        String sql = "select p.Fid personId, p.FNumber, ce.FEffectDate, ce.FLeffectDate, pt.Fid positionId,ce.Fid employeeTypeId  FROM T_HR_SCmpEmpORelation AS ce  INNER JOIN T_HR_SPersonCmp AS pc ON ce.FPersonCmpID = pc.FID  INNER JOIN T_HR_EmpOrgRelation AS er ON ce.FEmpOrgRelationID = er.FID  INNER JOIN T_BD_Person AS p ON ce.FPersonID = p.FID  INNER JOIN T_ORG_HRO AS h ON pc.FHrOrgUnitID = h.FID  LEFT OUTER JOIN T_ORG_Admin AS ad ON er.FAdminOrgID = ad.FID  LEFT OUTER JOIN T_ORG_Position AS pt ON er.FPositionID = pt.FID LEFT OUTER JOIN T_HR_EmpLaborRelationHis AS re ON er.FlaborRelationID =re.FHistoryRelateID and er.FEndDateTime >=re.FStartDateTime and er.FEndDateTime <=re.FEndDateTime LEFT OUTER JOIN T_HR_BDEmployeeType AS et ON re.FLaborRelationStateID =et.FID ";
        filter.append(sql);
        filter.append(" where h.FID = '").append(hrOrgUnitId).append("'");
        filter.append(" and ((ad.flongNumber LIKE '").append(longNumber).append("%' and ce.fuseDefault=1) or ce.fuseDefault=0)");
        filter.append(" and p.FID in").append(personInSql);
        HashMap<String, Pair<java.util.Date, java.util.Date>> dbMap = new HashMap<String, Pair<java.util.Date, java.util.Date>>();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)filter.toString());
            while (rs.next()) {
                Pair pair = new Pair();
                Date effectDate = rs.getDate("FEffectDate");
                Date leffectDate = rs.getDate("FLeffectDate");
                pair.setFirst((Object)effectDate);
                pair.setSecond((Object)leffectDate);
                String personIdDB = rs.getString("personId");
                String positionIdDB = rs.getString("positionId");
                String employeeTypeId = rs.getString("employeeTypeId");
                dbMap.put(String.valueOf(personIdDB) + "_" + positionIdDB + "_" + employeeTypeId, (Pair<java.util.Date, java.util.Date>)pair);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        cmpInSql.release(ctx);
        return dbMap;
    }

    protected String getLongNumber(Context ctx, String id) throws BOSException {
        String sql = "select FLongNumber from T_ORG_Admin where fid = '" + id + "'";
        String longNumber = "";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                longNumber = rs.getString("FLongNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return longNumber;
    }

    protected void checkBillNumber(Context ctx, BatchSubmitShemeBillInfo info) throws BOSException, EASBizException {
        String number = info.getNumber();
        boolean flag = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).exists("where number = '" + number + "' and id <> '" + info.getId().toString() + "'");
        if (flag) {
            throw new SubmitBillVerifyException(SubmitBillVerifyException.EXCEPTION6, new Object[]{number});
        }
    }

    protected void verifySubmitPeriod(Context ctx, BatchSubmitShemeBillInfo info) throws EASBizException, BOSException {
    }

    protected String getMultiLan(Context ctx, String label) {
        return SHRServerResource.getString((String)"com.kingdee.shr.compensation.resource.SubmitShemeBillResource", (String)label, (Locale)ctx.getLocale());
    }
}

