/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.trace;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.isc.iscb.util.debugger.DebuggableResource;
import kd.isc.iscb.util.flow.core.Execution;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.FlowRuntime;
import kd.isc.iscb.util.flow.core.ProcessElement;
import kd.isc.iscb.util.flow.core.i.model.AbstractExecutable;
import kd.isc.iscb.util.flow.trace.Line;
import kd.isc.iscb.util.flow.trace.LineCollector;

public class FlowDebuggerResource
implements DebuggableResource {
    private Flow flow;
    private LineCollector collector;
    private String uuid = UUID.randomUUID().toString();
    private List<Line> lines;
    private Map<AbstractExecutable, Map<Integer, Integer>> breakpoints;

    public FlowDebuggerResource(Flow flow, LineCollector collector) {
        this.flow = flow;
        this.collector = collector;
    }

    @Override
    public String getResourceId() {
        return this.flow.getId();
    }

    @Override
    public void attachBreakpoints(Collection<Integer> lines) {
        for (int line : lines) {
            this.attachBreakpoint(line);
        }
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public String getLine(int line) {
        List<Line> lines = this.getLines();
        Line e = lines.get(line - 1);
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < e.getTab()) {
            s.append("  ");
            ++i;
        }
        s.append(e.getText());
        return s.toString();
    }

    private List<Line> getLines() {
        List<Line> lines = this.lines;
        if (lines == null) {
            lines = this.lines = this.collector.collectLines(this.flow);
        }
        return lines;
    }

    @Override
    public int getLineCount() {
        List<Line> lines = this.getLines();
        return lines.size();
    }

    @Override
    public Set<Integer> collectBreakpoints() {
        if (this.breakpoints == null) {
            return Collections.emptySet();
        }
        HashSet<Integer> breakpoints = new HashSet<Integer>();
        for (Map<Integer, Integer> s : this.breakpoints.values()) {
            breakpoints.addAll(s.values());
        }
        return breakpoints;
    }

    @Override
    public boolean attachBreakpoint(int line) {
        Map<Integer, Integer> s;
        List<Line> lines = this.getLines();
        Line c = lines.get(line - 1);
        AbstractExecutable e = c.getExecutable();
        if (e == null) {
            return false;
        }
        Map<AbstractExecutable, Map<Integer, Integer>> breakpoints = this.breakpoints;
        if (breakpoints == null) {
            breakpoints = this.breakpoints = new HashMap<AbstractExecutable, Map<Integer, Integer>>();
        }
        if ((s = breakpoints.get(e)) == null) {
            s = new HashMap<Integer, Integer>();
            breakpoints.put(e, s);
        }
        s.put(c.getIp(), line);
        return true;
    }

    @Override
    public void detachBreakpoint(int line) {
        Map<AbstractExecutable, Map<Integer, Integer>> breakpoints = this.breakpoints;
        if (breakpoints == null) {
            return;
        }
        List<Line> lines = this.getLines();
        Line c = lines.get(line - 1);
        Map<Integer, Integer> s = breakpoints.get(c.getExecutable());
        if (s != null) {
            s.remove(c.getIp());
        }
    }

    public boolean hasBreakpoint(Execution e) {
        Map<AbstractExecutable, Map<Integer, Integer>> breakpoints = this.breakpoints;
        if (breakpoints == null) {
            return false;
        }
        Map<Integer, Integer> s = breakpoints.get(e.getDefine());
        if (s == null) {
            return false;
        }
        return s.containsKey(e.getIp());
    }

    public int getLine(Execution e) {
        Map<Integer, Integer> lines = this.breakpoints.get(e.getDefine());
        if (lines == null) {
            return 0;
        }
        Integer line = lines.get(e.getIp());
        return line == null ? 0 : line;
    }

    public void attachBreakpoint(FlowRuntime runtime) {
        List<Line> lines = this.getLines();
        if (runtime.isSuspended()) {
            int i = 1;
            int j = lines.size();
            while (i <= j) {
                this.attachBreakpoint(i);
                ++i;
            }
        } else {
            ProcessElement x = runtime.getNext().getDefine();
            int index = 0;
            for (Line line : lines) {
                ++index;
                if (line.getExecutable() == x) break;
            }
            this.attachBreakpoint(index);
        }
    }
}

