/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.misc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.script.ScriptContext;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.HttpConnectionDecorator;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.misc.CookieUtil;
import kd.isc.iscb.util.script.misc.HttpHeaderUtil;
import kd.isc.iscb.util.script.misc.HttpUtil;

public class HttpUploadFile
implements NativeFunction {
    protected static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    protected static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    protected static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    protected static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object object;
        String url = D.s(args[0]);
        List data = (List)args[1];
        String charset = args[2] == null ? Charset.defaultCharset().name() : (String)args[2];
        Map<String, Object> cookies = CookieUtil.copyCookies(args, 3);
        Map<String, Object> headers = HttpHeaderUtil.copyHeaders(args, 4);
        String boundary = this.createBoundary();
        HttpConnectionDecorator decorator = new HttpConnectionDecorator(cookies, headers);
        InputStream in = null;
        try {
            in = NetUtil.httpAccess(url, "POST", this.buildBody(data, boundary, charset), "multipart/form-data;boundary=" + boundary, decorator, NetUtil.TIMEOUT);
            InputStreamReader reader = new InputStreamReader(in, HttpUploadFile.parseCharset(decorator.getHeader(), charset));
            String result = NetUtil.readText(reader);
            object = HttpUtil.compositeReturns(decorator.getResponseCode(), cookies, headers, result);
        }
        catch (IOException e) {
            try {
                throw new IscBizException(e);
            }
            catch (Throwable throwable) {
                DbUtil.close(in);
                throw throwable;
            }
        }
        DbUtil.close(in);
        return object;
    }

    public String createBoundary() {
        String uuid = UUID.randomUUID().toString();
        return "----WebKitFormBoundary" + uuid;
    }

    private byte[] buildBody(List<Map<String, Object>> data, String boundary, String charset) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            baos.write(STREAM_TERMINATOR);
            baos.write(boundary.getBytes(charset));
            for (Map<String, Object> fileMap : data) {
                String header;
                baos.write(FIELD_SEPARATOR);
                if (fileMap.containsKey("filename")) {
                    header = "Content-Disposition: form-data; name=\"" + fileMap.get("name") + "\";" + " filename=\"" + fileMap.get("filename") + "\"\r\n" + "Content-Type: application/octet-stream";
                    baos.write(header.getBytes(charset));
                    baos.write(HEADER_SEPARATOR);
                    baos.write(this.getBytes(fileMap));
                } else {
                    header = "Content-Disposition: form-data; name=\"" + fileMap.get("name") + "\"";
                    baos.write(header.getBytes(charset));
                    baos.write(HEADER_SEPARATOR);
                    String s = this.castToString(fileMap.get("data"));
                    baos.write(s.getBytes(charset));
                }
                baos.write(BOUNDARY_PREFIX);
                baos.write(boundary.getBytes(charset));
            }
            baos.write(STREAM_TERMINATOR);
            baos.write(FIELD_SEPARATOR);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            baos.close();
        }
    }

    private String castToString(Object o) {
        String s;
        if (o instanceof CharSequence) {
            s = o.toString();
        } else if (o == null) {
            s = "";
        } else {
            throw new IscBizException(String.format(ResManager.loadKDString("\u4e0d\u652f\u6301\u4f20\u9001\u7684\u6570\u636e\u7c7b\u578b%1$s,\u6570\u636e\u4e3a%2$s", "HttpUploadFile_3", "isc-iscb-util", new Object[0]), o.getClass().getName(), o));
        }
        return s;
    }

    private byte[] getBytes(Map<String, Object> fileMap) {
        Object obj = fileMap.get("data");
        if (obj == null) {
            return new byte[0];
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new IscBizException(String.format(ResManager.loadKDString("\u6587\u4ef6\u5185\u5bb9\u4e0d\u5408\u6cd5\uff0c\u8bf7\u4f20\u5165byte\u6570\u7ec4\uff0c\u5f53\u524d\u7c7b\u578b\u4e3a\uff1a%s", "HttpUploadFile_4", "isc-iscb-util", new Object[0]), obj.getClass()));
    }

    private static String parseCharset(Map<String, Object> headers, String defaultCharset) {
        String contentType;
        if (headers.get("Content-Type") != null && (contentType = (String)((List)headers.get("Content-Type")).get(0)) != null) {
            int pos = contentType.indexOf("charset=");
            int of = 8;
            if (pos < 0) {
                pos = contentType.indexOf("charset =");
                of = 9;
            }
            if (pos < 0) {
                return defaultCharset;
            }
            int split = contentType.indexOf(59, pos);
            if (split > -1) {
                return contentType.substring(pos + of, split).trim();
            }
            return contentType.substring(pos + of).trim();
        }
        return defaultCharset;
    }

    @Override
    public String name() {
        return "HttpUploadFile";
    }
}

