/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.bos.workflow.util.DataTypeUtil;
import com.kingdee.bos.workflow.util.TypeUtil;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.Util;
import kd.isc.connector.eas.e.GetEnumInfo;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;

public class GetEntityInfo
extends AbstractCommandExecutor {
    private static final String DELETE = "delete";
    private static final String SUBMIT = "submit";
    private static final String INSERT = "insert";
    private static final String SAVE = "save";
    private static final String UPDATE = "update";
    private static final String COM_KINGDEE_BOS_DAO_I_OBJECT_PK = "com.kingdee.bos.dao.IObjectPK";
    private static final String INTEGER = "integer";
    private static final String STRING = "string";
    private static final String ENTITY = "ENTITY";
    private static final String $FILE_LIST_FULL = "$FILE_LIST";
    private static final String $FILE_LIST = "$file_list";
    private static final String VIRTUALFILE = "VIRTUALFILE";
    private static final String ENUM = "ENUM";
    private static final String ENTRIES = "ENTRIES";
    private static final String INDEX = "index";
    private static final String IS_NULLABLE = "is_nullable";
    private static final String IS_PRIMARY_KEY = "is_primary_key";
    private static final String DATA_SCHEMA = "data_schema";
    private static final String DATA_TYPE = "data_type";
    private static final String LABEL = "label";
    private static final String PROPERTIES = "properties";
    private static final String TABLE_NAME = "table_name";
    private static final String ACTIONS2 = "actions";
    private static final String EVENTS2 = "events";
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String FULL_NAME = "full_name";
    private static final String NAME = "name";
    private static final Collator STRING_COMPARATOR = Collator.getInstance(Locale.CHINA);

    public String getCommand() {
        return "get_entity_info";
    }

    protected List<Map<String, Object>> exec(ConnectorContext ctx, Map<String, Object> params) {
        String dataCenter = ((EasContext)ctx).getDataCenter();
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)Ctx.newShadowContext((String)dataCenter));
        HashSet<String> entitySet = new HashSet<String>();
        return this.getEntityInfo(loader, D.s((Object)params.get(NAME)), entitySet);
    }

    private List<Map<String, Object>> getEntityInfo(IMetaDataLoader loader, String fullName, Set<String> entitySet) {
        EntityObjectInfo en = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)fullName));
        if (en == null || en.getType() == null) {
            throw new IscBizException("\u627e\u4e0d\u5230EAS\u5b9e\u4f53:" + fullName);
        }
        LinkedHashMap<String, Object> meta = new LinkedHashMap<String, Object>();
        meta.put(FULL_NAME, en.getFullName());
        meta.put(NAME, en.getType());
        meta.put(TYPE, ENTITY);
        meta.put(TITLE, Util.getTitle(en));
        MethodCollection methods = en.getAllMethodsRuntime();
        List<Map<String, Object>> events = GetEntityInfo.innerGetEvents(methods);
        meta.put(EVENTS2, events);
        List<Map<String, Object>> actions = GetEntityInfo.getActions(en);
        meta.put(ACTIONS2, actions);
        HashSet<String> ignoreSet = new HashSet<String>();
        this.appendActions(methods, actions, ignoreSet);
        meta.put(TABLE_NAME, en.getTable().getName());
        List<Map<String, Object>> propertiesMap = GetEntityInfo.getProperties(en);
        this.appendVirtualAttachField(propertiesMap);
        meta.put(PROPERTIES, propertiesMap);
        entitySet.add(fullName);
        List<Map<String, Object>> re = this.getRelatedMetas(loader, propertiesMap, entitySet);
        re.add(meta);
        return re;
    }

    public void appendVirtualAttachField(List<Map<String, Object>> propertiesMap) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put(NAME, $FILE_LIST);
        item.put(LABEL, "\u865a\u62df\u9644\u4ef6\u5206\u5f55");
        item.put(DATA_TYPE, ENTRIES);
        item.put(DATA_SCHEMA, $FILE_LIST_FULL);
        item.put(IS_PRIMARY_KEY, false);
        item.put(IS_NULLABLE, true);
        item.put(INDEX, propertiesMap.size() + 1);
        propertiesMap.add(item);
    }

    private Map<String, Object> newVirtualAttachEntry() {
        LinkedHashMap<String, Object> virtualAttachEntry = new LinkedHashMap<String, Object>();
        virtualAttachEntry.put(FULL_NAME, $FILE_LIST_FULL);
        virtualAttachEntry.put(NAME, $FILE_LIST_FULL);
        virtualAttachEntry.put(TYPE, ENTITY);
        virtualAttachEntry.put(TITLE, "\u865a\u62df\u9644\u4ef6\u5206\u5f55");
        ArrayList<Map<String, Object>> props = new ArrayList<Map<String, Object>>(5);
        this.addProperty(props, 1, "attachId", "\u9644\u4ef6id", STRING);
        this.addProperty(props, 2, TYPE, "\u9644\u4ef6\u7c7b\u578b", STRING);
        this.addProperty(props, 3, "bytes", "\u9644\u4ef6\u5b57\u8282\u6570", INTEGER);
        this.addProperty(props, 4, "desc", "\u9644\u4ef6\u5907\u6ce8", STRING);
        this.addProperty(props, 5, NAME, "\u9644\u4ef6\u540d\u79f0", STRING);
        virtualAttachEntry.put(PROPERTIES, props);
        return virtualAttachEntry;
    }

    private void addProperty(List<Map<String, Object>> props, int index, String name, String label, String datatype) {
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put(INDEX, index);
        item.put(NAME, name);
        item.put(LABEL, label);
        item.put(DATA_TYPE, datatype);
        item.put(DATA_SCHEMA, null);
        item.put(IS_PRIMARY_KEY, false);
        item.put(IS_NULLABLE, true);
        props.add(item);
    }

    private List<Map<String, Object>> getRelatedMetas(IMetaDataLoader loader, List<Map<String, Object>> propertiesMap, Set<String> entitySet) {
        ArrayList<Map<String, Object>> re = new ArrayList<Map<String, Object>>();
        if (!entitySet.contains(VIRTUALFILE)) {
            re.add(this.newVirtualAttachEntry());
            entitySet.add(VIRTUALFILE);
        }
        for (Map<String, Object> proInfo : propertiesMap) {
            if (proInfo.get(FULL_NAME) == null || entitySet.contains(D.s((Object)proInfo.get(FULL_NAME)))) continue;
            Object name = proInfo.get(DATA_TYPE);
            if (ENTRIES.equals(name)) {
                re.addAll(this.getEntityInfo(loader, D.s((Object)proInfo.get(FULL_NAME)), entitySet));
                continue;
            }
            if (!ENUM.equals(name)) continue;
            re.add(GetEnumInfo.getEnumInfo(loader, D.s((Object)proInfo.get(FULL_NAME))));
        }
        return re;
    }

    private void appendActions(MethodCollection methods, List<Map<String, Object>> actions, Set<String> ignoreSet) {
        for (Map<String, Object> action : actions) {
            ignoreSet.add(D.s((Object)action.get(NAME)));
        }
        int i = 0;
        while (i < methods.size()) {
            MethodInfo methodInfo = methods.get(i);
            if (!ignoreSet.contains(methodInfo.getName()) && !GetEntityInfo.isReadOnly(methodInfo.getName())) {
                this.appendAction(actions, ignoreSet, methodInfo);
            }
            ++i;
        }
    }

    private void appendAction(List<Map<String, Object>> actions, Set<String> ignoreSet, MethodInfo methodInfo) {
        ParameterCollection parameters = methodInfo.getParameters();
        if (parameters.size() == 1) {
            this.appendActionWithOneParam(actions, ignoreSet, methodInfo, parameters);
        } else if (parameters.size() == 2) {
            this.appendActionWithTwoParams(actions, ignoreSet, methodInfo, parameters);
        }
    }

    private void appendActionWithTwoParams(List<Map<String, Object>> actions, Set<String> ignoreSet, MethodInfo methodInfo, ParameterCollection parameters) {
        ParameterInfo param0 = parameters.get(0);
        ParameterInfo param1 = parameters.get(1);
        if (this.isIObjectPk(param0) && this.isCoreBaseInfo(param1)) {
            this.addAction(actions, methodInfo, ignoreSet);
        }
    }

    private void appendActionWithOneParam(List<Map<String, Object>> actions, Set<String> ignoreSet, MethodInfo methodInfo, ParameterCollection parameters) {
        ParameterInfo param = parameters.get(0);
        if (this.isIObjectPk(param) || this.isCoreBaseInfo(param) || this.isIObjectPkArr(param)) {
            this.addAction(actions, methodInfo, ignoreSet);
        }
    }

    private boolean isIObjectPkArr(ParameterInfo param) {
        TypeReference arrayElementType = param.getParameterType().getArrayElementType();
        return arrayElementType != null ? COM_KINGDEE_BOS_DAO_I_OBJECT_PK.equals(arrayElementType.getBaseType()) : false;
    }

    private boolean isIObjectPk(ParameterInfo param) {
        return COM_KINGDEE_BOS_DAO_I_OBJECT_PK.equals(param.getParameterType().getBaseType());
    }

    private boolean isCoreBaseInfo(ParameterInfo param) {
        String baseType = param.getParameterType().getBaseType();
        return "com.kingdee.eas.framework.CoreBillBaseInfo".equals(baseType) || "com.kingdee.bos.dao.IObjectValue".equals(baseType);
    }

    private void addAction(List<Map<String, Object>> actions, MethodInfo methodInfo, Set<String> ignoreSet) {
        LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
        item.put(INDEX, actions.size() + 1);
        item.put(NAME, methodInfo.getName());
        item.put(TYPE, UPDATE);
        item.put(LABEL, methodInfo.getAlias());
        actions.add(item);
        ignoreSet.add(methodInfo.getName());
    }

    static List<Map<String, Object>> getActions(EntityObjectInfo en) {
        int index = 0;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
        item.put(INDEX, ++index);
        item.put(NAME, SAVE);
        item.put(TYPE, SAVE);
        item.put(LABEL, "\u4fdd\u5b58");
        list.add(item);
        item = new LinkedHashMap();
        item.put(INDEX, ++index);
        item.put(NAME, "addnew");
        item.put(TYPE, INSERT);
        item.put(LABEL, "\u65b0\u589e");
        list.add(item);
        item = new LinkedHashMap();
        item.put(INDEX, ++index);
        item.put(NAME, SUBMIT);
        item.put(TYPE, UPDATE);
        item.put(LABEL, "\u63d0\u4ea4");
        list.add(item);
        item = new LinkedHashMap();
        item.put(INDEX, ++index);
        item.put(NAME, UPDATE);
        item.put(TYPE, UPDATE);
        item.put(LABEL, "\u4fee\u6539");
        list.add(item);
        item = new LinkedHashMap();
        item.put(INDEX, ++index);
        item.put(NAME, "cancel");
        item.put(TYPE, UPDATE);
        item.put(LABEL, "\u64a4\u9500");
        list.add(item);
        item = new LinkedHashMap();
        item.put(INDEX, ++index);
        item.put(NAME, "uncancel");
        item.put(TYPE, UPDATE);
        item.put(LABEL, "\u53cd\u64a4\u9500");
        list.add(item);
        item = new LinkedHashMap();
        item.put(INDEX, ++index);
        item.put(NAME, "revise");
        item.put(TYPE, UPDATE);
        item.put(LABEL, "\u4fee\u8ba2");
        list.add(item);
        item = new LinkedHashMap();
        item.put(INDEX, ++index);
        item.put(NAME, DELETE);
        item.put(TYPE, DELETE);
        item.put(LABEL, "\u5220\u9664");
        list.add(item);
        return list;
    }

    static List<Map<String, Object>> getEvents(EntityObjectInfo en) {
        MethodCollection methods = en.getAllMethodsRuntime();
        return GetEntityInfo.innerGetEvents(methods);
    }

    private static List<Map<String, Object>> innerGetEvents(MethodCollection methods) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < methods.size()) {
            MethodInfo methodInfo = methods.get(i);
            String name = methodInfo.getName();
            String alias = methodInfo.getAlias();
            if (!map.containsKey(name)) {
                map.put(name, alias);
            }
            ++i;
        }
        int index = 0;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map.Entry e : map.entrySet()) {
            String name = (String)e.getKey();
            String label = (String)e.getValue();
            if (GetEntityInfo.isReadOnly(name) || label == null) continue;
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put(INDEX, ++index);
            item.put(NAME, name);
            item.put(LABEL, label);
            list.add(item);
        }
        return list;
    }

    private static boolean isReadOnly(String name) {
        if (name.startsWith("get") || name.startsWith("exists")) {
            return true;
        }
        if (name.startsWith("set") || name.startsWith("find")) {
            return true;
        }
        if (name.startsWith("is") || name.startsWith("not")) {
            return true;
        }
        if (name.startsWith("have") || name.startsWith("has")) {
            return true;
        }
        if (name.equals("deleteBatchData") || name.equals("updateBatchData") || name.equals("saveBatchData")) {
            return false;
        }
        return name.contains("Batch");
    }

    private static List<Map<String, Object>> getProperties(EntityObjectInfo en) {
        PropertyCollection properties = en.getInheritedNoDuplicatedProperties();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(properties.size());
        int i = 0;
        while (i < properties.size()) {
            PropertyInfo propertyInfo = properties.get(i);
            LinkedHashMap<String, Object> item = new LinkedHashMap<String, Object>();
            item.put(NAME, propertyInfo.getName());
            item.put(LABEL, Util.getLabel(propertyInfo));
            Map<String, Object> d = GetEntityInfo.getDataType(propertyInfo, en);
            item.put(DATA_TYPE, d.get(NAME));
            item.put(DATA_SCHEMA, d.get(DATA_SCHEMA));
            item.put(IS_PRIMARY_KEY, propertyInfo.getName().equals("id"));
            if (d.get(FULL_NAME) != null) {
                item.put(FULL_NAME, d.get(FULL_NAME));
            }
            if (propertyInfo.getMappingField() == null) {
                item.put(IS_NULLABLE, true);
            } else {
                item.put(IS_NULLABLE, propertyInfo.getMappingField().isNullable());
            }
            list.add(item);
            ++i;
        }
        GetEntityInfo.sortProperties(list);
        int index = 0;
        for (Map map : list) {
            map.put(INDEX, ++index);
        }
        return list;
    }

    private static void sortProperties(List<Map<String, Object>> list) {
        Collections.sort(list, (Comparator)new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> a, Map<String, Object> b) {
                String ta = (String)a.get(GetEntityInfo.LABEL);
                String tb = (String)b.get(GetEntityInfo.LABEL);
                return STRING_COMPARATOR.compare(ta, tb);
            }
        });
    }

    public static Map<String, Object> getDataType(PropertyInfo p, EntityObjectInfo me) {
        LinkedHashMap<String, Object> data_type = new LinkedHashMap<String, Object>();
        if (p instanceof LinkPropertyInfo) {
            GetEntityInfo.setLinkType(p, me, data_type);
        } else if (p instanceof OwnPropertyInfo) {
            GetEntityInfo.setSimpleType(p, data_type);
        }
        return data_type;
    }

    private static void setLinkType(PropertyInfo p, EntityObjectInfo me, Map<String, Object> data_type) {
        RelationshipInfo rs = ((LinkPropertyInfo)p).getRelationship();
        CardinalityType type = rs.getSupplierCardinality();
        EntityObjectInfo supplierObject = rs.getSupplierObject();
        if (type == CardinalityType.ONE || type == CardinalityType.ZERO_TO_ONE) {
            GetEntityInfo.setRefType(data_type, supplierObject);
        } else {
            GetEntityInfo.setEntityType(me, data_type, rs, supplierObject);
        }
    }

    private static void setEntityType(EntityObjectInfo me, Map<String, Object> data_type, RelationshipInfo rs, EntityObjectInfo supplierObject) {
        if (supplierObject != null) {
            if (me.getFullName().equals(supplierObject.getFullName())) {
                GetEntityInfo.setMasterRefType(data_type, rs);
            } else {
                GetEntityInfo.setEntryType(data_type, supplierObject);
            }
        }
    }

    private static void setEntryType(Map<String, Object> data_type, EntityObjectInfo supplierObject) {
        data_type.put(NAME, ENTRIES);
        data_type.put(TITLE, "\u5355\u636e\u5206\u5f55");
        data_type.put(DATA_SCHEMA, supplierObject.getType());
        data_type.put(FULL_NAME, supplierObject.getFullName());
    }

    private static void setMasterRefType(Map<String, Object> data_type, RelationshipInfo rs) {
        EntityObjectInfo clientObject = rs.getClientObject();
        data_type.put(DATA_SCHEMA, clientObject.getType());
        data_type.put(NAME, "REF");
        data_type.put("is_master", true);
    }

    private static void setSimpleType(PropertyInfo p, Map<String, Object> data_type) {
        if (((OwnPropertyInfo)p).isMultilingual()) {
            data_type.put(NAME, "ml_string");
        } else {
            GetEntityInfo.convertDataType(p, data_type);
        }
    }

    private static void setRefType(Map<String, Object> data_type, EntityObjectInfo supplierObject) {
        data_type.put(NAME, "REF");
        if (supplierObject != null) {
            data_type.put(DATA_SCHEMA, supplierObject.getType());
        }
    }

    private static void convertDataType(PropertyInfo p, Map<String, Object> data_type) {
        DataType t = ((OwnPropertyInfo)p).getDataType();
        if (DataType.DECIMAL.equals((Object)t)) {
            data_type.put(NAME, t.toString());
            data_type.put(TITLE, t.toString());
        } else if (DataType.LONG.equals((Object)t)) {
            data_type.put(NAME, "long");
            data_type.put(TITLE, "long");
        } else if (DataType.DATE.equals((Object)t)) {
            data_type.put(NAME, "date");
            data_type.put(TITLE, "date");
        } else if (DataType.TIME.equals((Object)t)) {
            data_type.put(NAME, "time");
            data_type.put(TITLE, "time");
        } else {
            com.kingdee.bos.workflow.define.DataType dt = TypeUtil.convertMDataTypeToDataType((DataType)t);
            String name = dt.toString().toLowerCase();
            if (name.equals("enum")) {
                data_type.put(NAME, ENUM);
                BizEnumInfo enumType = ((OwnPropertyInfo)p).getEnumType();
                if (enumType != null) {
                    data_type.put(DATA_SCHEMA, Hash.mur32((Object[])new Object[]{enumType.getFullName()}));
                    data_type.put(FULL_NAME, enumType.getFullName());
                } else {
                    data_type.put(DATA_SCHEMA, Hash.mur32((Object[])new Object[]{((OwnPropertyInfo)p).getMetaDataRef()}));
                    data_type.put(FULL_NAME, ((OwnPropertyInfo)p).getMetaDataRef());
                }
            } else {
                data_type.put(NAME, name);
                data_type.put(TITLE, DataTypeUtil.getName((com.kingdee.bos.workflow.define.DataType)dt));
            }
        }
    }
}

