/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectCollection;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.util.backport.Collections;
import java.sql.Connection;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.Util;
import kd.isc.connector.eas.e.GetEntityInfo;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.e.DbInfo;
import kd.isc.iscb.util.connector.server.e.GetTable;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;

public class GetTableInfo
extends AbstractCommandExecutor {
    private static final String FIELD_LABEL = "label";
    private static final Collator STRING_COMPARATOR = Collator.getInstance(Locale.CHINA);
    private static final Map<String, Map<String, String[]>> table_mapping = Collections.synchronizedMap(new HashMap());

    public String getCommand() {
        return "get_table_info";
    }

    protected Map<String, Object> exec(ConnectorContext ctx, Map<String, Object> params) {
        Connection cn = ctx.getConnection();
        try {
            String table_name = D.s((Object)params.get("name"));
            HashMap<String, Object> meta = new HashMap<String, Object>();
            meta.put("full_name", table_name);
            meta.put("name", table_name);
            meta.put("type", "TABLE");
            meta.put("table_name", table_name);
            List<EntityObjectInfo> entities = GetTableInfo.getRelatedEntities((EasContext)ctx, table_name);
            meta.put("title", GetTableInfo.generateTableLabel(table_name, entities));
            Table table = GetTableInfo.getTable(cn, table_name);
            Map<String, String> fieldsMapping = GetTableInfo.createColumnMapping(entities);
            meta.put("properties", GetTableInfo.getProperties(table, fieldsMapping));
            meta.put("events", Collections.emptyList());
            meta.put("actions", this.getActions(entities));
            HashMap<String, Object> hashMap = meta;
            return hashMap;
        }
        finally {
            ctx.dispose(cn);
        }
    }

    private Object getActions(List<EntityObjectInfo> entities) {
        LinkedHashMap<String, Map<String, Object>> actions = new LinkedHashMap<String, Map<String, Object>>();
        for (EntityObjectInfo e : entities) {
            for (Map<String, Object> item : GetEntityInfo.getActions(e)) {
                String name = e.getType() + "." + item.get("name");
                item.put("name", name);
                String label = Util.getTitle(e) + "." + item.get(FIELD_LABEL);
                item.put(FIELD_LABEL, label);
                actions.put(name, item);
            }
        }
        return actions.values();
    }

    private Object getEvents(List<EntityObjectInfo> entities) {
        LinkedHashMap<String, Map<String, Object>> events = new LinkedHashMap<String, Map<String, Object>>();
        for (EntityObjectInfo e : entities) {
            for (Map<String, Object> item : GetEntityInfo.getEvents(e)) {
                String name = e.getType() + "." + item.get("name");
                item.put("name", name);
                events.put(name, item);
            }
        }
        return events.values();
    }

    public static Table getTable(Connection cn, String table_name) {
        DbInfo db = new DbInfo(cn);
        List fields = GetTable.getFields((DbInfo)db, (String)table_name);
        List pks = GetTable.getPrimaryKeys((DbInfo)db, (String)table_name);
        if (pks.size() == 0) {
            GetTableInfo.setDefaultPrimaryKey(fields, pks);
        }
        Table table = new Table(table_name, '\"', fields, pks);
        return table;
    }

    private static void setDefaultPrimaryKey(List<Map<String, Object>> fields, List<String> pks) {
        for (Map<String, Object> field : fields) {
            if (!"fid".equalsIgnoreCase(D.s((Object)field.get("COLUMN_NAME")))) continue;
            pks.add("fid");
            break;
        }
    }

    private static Object getProperties(Table table, Map<?, ?> fieldsMapping) {
        ArrayList<Map<String, Object>> properties = new ArrayList<Map<String, Object>>();
        int i = 0;
        while (i < table.getFieldCount()) {
            Column c = table.getField(i);
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("name", c.getName());
            Object label = fieldsMapping.get(c.getName());
            if (label == null) {
                label = c.getRealName();
            }
            item.put(FIELD_LABEL, label);
            item.put("data_type", c.getDataType().toString());
            item.put("is_primary_key", c.isPrimaryKey());
            item.put("is_nullable", c.isNullable());
            properties.add(item);
            ++i;
        }
        GetTableInfo.sortProperties(properties);
        return properties;
    }

    private static String generateTableLabel(String table_name, List<EntityObjectInfo> entities) {
        StringBuilder label = new StringBuilder();
        for (EntityObjectInfo e : entities) {
            if (label.length() > 0) {
                label.append('\uff0c');
            }
            label.append(Util.getTitle(e));
        }
        if (label.length() == 0) {
            return table_name;
        }
        return String.valueOf(label.toString()) + " - \u6570\u636e\u8868";
    }

    private static void sortProperties(List<Map<String, Object>> list) {
        Collections.sort(list, (Comparator)new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> a, Map<String, Object> b) {
                String ta = (String)a.get("name");
                String tb = (String)b.get("name");
                return STRING_COMPARATOR.compare(ta, tb);
            }
        });
    }

    public static List<EntityObjectInfo> getRelatedEntities(EasContext ctx, String table_name) {
        String dataCenter = ctx.getDataCenter();
        String[] entities = GetTableInfo.findEntityName(table_name, dataCenter);
        if (entities == null) {
            return Collections.emptyList();
        }
        ArrayList<EntityObjectInfo> list = new ArrayList<EntityObjectInfo>();
        String[] stringArray = entities;
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity_name = stringArray[n2];
            EntityObjectInfo en = GetTableInfo.getEntity(dataCenter, entity_name);
            list.add(en);
            ++n2;
        }
        return list;
    }

    private static EntityObjectInfo getEntity(String dataCenter, String entity_name) {
        Context ctx = Ctx.newShadowContext((String)dataCenter);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo en = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)entity_name));
        return en;
    }

    public static Map<String, String> createColumnMapping(List<EntityObjectInfo> entitites) {
        HashMap<String, String> column_mapping = new HashMap<String, String>();
        for (EntityObjectInfo e : entitites) {
            GetTableInfo.createColumnMapping(column_mapping, e);
        }
        return column_mapping;
    }

    private static void createColumnMapping(Map<String, String> column_mapping, EntityObjectInfo en) {
        PropertyCollection properties = en.getInheritedNoDuplicatedProperties();
        int i = 0;
        while (i < properties.size()) {
            PropertyInfo p = properties.get(i);
            ColumnInfo c = p.getMappingField();
            if (c != null) {
                String label = Util.getLabel(p);
                String key = c.getRealName().toLowerCase();
                GetTableInfo.addLabel(column_mapping, label, key);
                if (p instanceof OwnPropertyInfo && ((OwnPropertyInfo)p).isMultilingual()) {
                    GetTableInfo.addLabel(column_mapping, String.valueOf(label) + "(\u7e41\u4f53)", String.valueOf(key) + "_l3");
                    GetTableInfo.addLabel(column_mapping, String.valueOf(label) + "(\u7b80\u4f53)", String.valueOf(key) + "_l2");
                    GetTableInfo.addLabel(column_mapping, String.valueOf(label) + "(\u82f1\u6587)", String.valueOf(key) + "_l1");
                }
            }
            ++i;
        }
    }

    private static void addLabel(Map<String, String> column_mapping, String label, String key) {
        String tmp = column_mapping.get(key);
        if (tmp == null) {
            column_mapping.put(key, label);
        } else {
            column_mapping.put(key, String.valueOf(tmp) + "\uff0c" + label);
        }
    }

    private static String[] findEntityName(String table_name, String dataCenter) {
        Map<String, String[]> mapping = table_mapping.get(dataCenter);
        if (mapping == null) {
            mapping = GetTableInfo.load(dataCenter);
        }
        return mapping.get(table_name.toUpperCase());
    }

    private static Map<String, String[]> load(String dataCenter) {
        Context ctx = Ctx.newShadowContext((String)dataCenter);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectCollection c = loader.getEntityCollection();
        HashMap<String, String[]> mapping = new HashMap<String, String[]>();
        int i = 0;
        while (i < c.size()) {
            String table_name;
            EntityObjectInfo en = c.get(i);
            if (!en.isAbstract() && en.getTable() != null && (table_name = en.getTable().getName()) != null) {
                GetTableInfo.addTable(mapping, table_name, en);
            }
            ++i;
        }
        table_mapping.put(dataCenter, mapping);
        return mapping;
    }

    private static void addTable(Map<String, String[]> mapping, String table_name, EntityObjectInfo entity) {
        String key = table_name.toUpperCase();
        String[] entities = mapping.get(key);
        if (entities == null) {
            entities = new String[]{entity.getRealFullName()};
        } else {
            String[] tmp = new String[entities.length + 1];
            System.arraycopy(entities, 0, tmp, 0, entities.length);
            tmp[entities.length] = entity.getRealFullName();
            entities = tmp;
        }
        mapping.put(key, entities);
    }
}

