/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.service.AbstractServiceAdapter;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.bireport.bimanager.util.UUID;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.LogUtil;
import kd.isc.connector.eas.e.PushDataJobHandler;
import kd.isc.connector.eas.e.RetrieveData;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.server.CommandDispatcher;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class IscBizListener
extends AbstractServiceAdapter {
    String id = "IscBizListener-" + Hash.mur16((Object[])new Object[]{UUID.randomUUID()});
    private static final Map<IMetaDataPK, String> methods = new ReadLockFreeMap();
    private static final Map<BOSObjectType, String> entities = new ReadLockFreeMap();

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public String getName() {
        return this.id;
    }

    public void execute(IServiceContext serviceContext) throws BOSException {
        if (serviceContext.getOperationParameters().length <= 1) {
            return;
        }
        Object id = serviceContext.getOperationParameters()[1];
        if (id == null || id instanceof MetaDataPK) {
            return;
        }
        IMetaDataPK operationPK = serviceContext.getOperationPK();
        if (operationPK == null) {
            return;
        }
        BOSObjectType metaType = serviceContext.getMetaType();
        if (!metaType.equals((Object)MetaDataTypeList.ENTITY) && !metaType.equals((Object)MetaDataTypeList.FACADE)) {
            LogUtil.debugLog("id:" + id + "\uff0c\u4e0d\u662f\u5b9e\u4f53\u6216facade\uff0c\u4e0d\u9700\u8981\u5173\u6ce8");
            return;
        }
        String entity = this.getEntity(serviceContext);
        if (entity == null || entity.length() == 0) {
            LogUtil.debugLog("id:" + id + "\uff0cbotype:" + serviceContext.getBoType() + ",\u5b9e\u4f53\u540d\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u5173\u6ce8");
            return;
        }
        String event = this.getEvent(serviceContext, operationPK);
        if (this.isValid(serviceContext, id, operationPK, entity, event)) {
            Context ctx = serviceContext.getContext();
            BOSObjectType boType = serviceContext.getBoType();
            this.invokeTrigger(id, entity, event, ctx, boType);
        }
    }

    private boolean isValid(IServiceContext serviceContext, Object id, IMetaDataPK operationPK, String entity, String event) {
        if (event == null || event.length() == 0) {
            LogUtil.debugLog("id:" + id + ",\u5b9e\u4f53[" + entity + "]\u6ca1\u6709\u627e\u5230\u5bf9\u5e94[" + operationPK + "]\u7684\u65b9\u6cd5\u4fe1\u606f\uff0c\u4e0d\u9700\u8981\u5173\u6ce8");
            return false;
        }
        if (this.isDeleteEvent(event)) {
            if (serviceContext.getExecutionMode() != 0) {
                LogUtil.debugLog("\u5b9e\u4f53[" + entity + "],\u5220\u9664\u4e8b\u4ef6[" + event + "]\u5fc5\u987b\u5728\u8c03\u7528\u524d\u62e6\u622a\uff0c\u975e\u8c03\u7528\u524d\uff0c\u4e0d\u9700\u8981\u5173\u6ce8");
                return false;
            }
        } else if (serviceContext.getExecutionMode() != 1) {
            LogUtil.debugLog("\u5b9e\u4f53[" + entity + "],\u5176\u4ed6\u4e8b\u4ef6[" + event + "]\u5fc5\u987b\u5728\u8c03\u7528\u540e\u62e6\u622a\uff0c\u975e\u8c03\u7528\u540e\uff0c\u4e0d\u9700\u8981\u5173\u6ce8");
            return false;
        }
        return true;
    }

    private boolean isDeleteEvent(String event) {
        return "delete".equals(event) || "batchDelete".equals(event) || "batchRemove".equals(event) || "remove".equals(event) || "deleteBatchData".equals(event) || "deleteVoucherCollection".equals(event);
    }

    public void invokeTrigger(Object id, String entity, String event, Context ctx, BOSObjectType boType) {
        String dataCenter = ctx.getAIS();
        List triggers = EventBindingCache.find((String)dataCenter, (String)entity, (String)event);
        if (triggers == null || triggers.size() == 0) {
            LogUtil.debugLog("entity:" + entity + ",\u6ca1\u6709\u7ed1\u5b9a\u4e8b\u4ef6[" + event + "],\u5ffd\u7565");
            return;
        }
        if (CommandDispatcher.isRunning()) {
            LogUtil.debugLog("entity:" + entity + ",event:" + event + "\u672c\u6b21\u4e8b\u4ef6\u662f\u7531\u4e8e\u96c6\u6210\u5e73\u53f0\u6570\u636e\u63a8\u9001\u8fc7\u6765\u5bfc\u81f4\u7684\uff0c\u5ffd\u7565");
            return;
        }
        List pks = this.getPKs(id);
        LogUtil.debugLog("IscBizListener invokeTrigger, pks:" + pks + ",entity:" + entity + ",event:" + event + ",dataCenter:" + dataCenter + ",bostype:" + boType);
        this.saveDataForPushing(entity, event, ctx, boType, (List<EventBindingCache.EventArgs>)triggers, pks);
    }

    private void saveDataForPushing(String entity, String event, Context ctx, BOSObjectType boType, List<EventBindingCache.EventArgs> triggers, List pks) {
        for (EventBindingCache.EventArgs args : triggers) {
            try {
                this.saveDataForPushing(entity, event, ctx, boType, pks, args);
            }
            catch (Throwable e) {
                EasContext.getErrLogger().warn((Object)"PushDataJobHandler failed.", e);
            }
        }
    }

    private void saveDataForPushing(String entity, String event, Context ctx, BOSObjectType boType, List pks, EventBindingCache.EventArgs args) throws BOSException {
        Connection cn = DbConnector.getConnection((Context)ctx);
        try {
            for (Object pk : pks) {
                if (D.s(pk) == null) continue;
                this.saveEachRecord(pk, entity, event, ctx, boType, args, cn);
            }
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
        PushDataJobHandler.dataArrived(ctx.getAIS());
    }

    private List getPKs(Object id) {
        List<Object> pks = id instanceof IObjectValue ? D.asList((Object[])new Object[]{((IObjectValue)id).get("id")}) : (id instanceof IObjectCollection ? this.getIdsFromObjectCollection((IObjectCollection)id) : (id instanceof Collection ? new ArrayList((Collection)id) : (id instanceof Object[] ? Arrays.asList((Object[])id) : D.asList((Object[])new Object[]{id}))));
        return pks;
    }

    private List getIdsFromObjectCollection(IObjectCollection collection) {
        ArrayList<Object> pks = new ArrayList<Object>(collection.size());
        int i = 0;
        while (i < collection.size()) {
            IObjectValue object = collection.getObject(i);
            pks.add(object.get("id"));
            ++i;
        }
        return pks;
    }

    public void saveEachRecord(Object id, String entity, String event, Context ctx, BOSObjectType boType, EventBindingCache.EventArgs args, Connection cn) {
        String data = null;
        String error = null;
        try {
            Map requires = args.getRequiredFields();
            IObjectValue bo = this.load(ctx, boType, id, requires);
            Map<String, Object> item = RetrieveData.formatInfo(requires, ctx, bo);
            item.put("#EVENT", event);
            data = Json.toString(item);
        }
        catch (Throwable e) {
            error = StringUtil.toString((Throwable)e);
            EasContext.getErrLogger().warn((Object)"load data failed.", e);
        }
        EventBindingUtil.saveEventArgs((Connection)cn, (String)entity, (String)event, (String)id.toString(), (String)args.getIscHub(), (String)args.getTriggerType(), (String)args.getTriggerId(), (String)data, (String)error);
    }

    private IObjectValue load(Context ctx, BOSObjectType bosType, Object id, Map<String, Object> requiredFields) {
        try {
            ICoreBase finder = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
            SelectorItemCollection selector = RetrieveData.generateSelector(requiredFields);
            return finder.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)D.s((Object)id))), selector);
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
    }

    private String getEvent(IServiceContext serviceContext, IMetaDataPK operationPK) {
        String event = methods.get(operationPK);
        if (event == null) {
            event = IscBizListener.getMethodName(operationPK, serviceContext);
        }
        return event;
    }

    private String getEntity(IServiceContext serviceContext) {
        String entity = entities.get(serviceContext.getBoType());
        if (entity == null) {
            entity = this.getEntityName(serviceContext);
        }
        return entity;
    }

    private String getEntityName(IServiceContext serviceContext) {
        BOSObjectType boType = serviceContext.getBoType();
        BusinessObjectInfo bo = IscBizListener.getMetaData(serviceContext.getContext(), serviceContext.getMetaType(), boType);
        String name = bo == null ? "" : bo.getRealFullName();
        entities.put(boType, name);
        return name;
    }

    private static BusinessObjectInfo getMetaData(Context ctx, BOSObjectType metaType, BOSObjectType boType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo bo = null;
        if (MetaDataTypeList.ENTITY.equals((Object)metaType)) {
            bo = loader.getEntity(boType);
        } else if (MetaDataTypeList.FACADE.equals((Object)metaType)) {
            bo = loader.getFacade(boType);
        }
        return bo;
    }

    private static String getMethodName(IMetaDataPK operationPK, IServiceContext serviceContext) {
        BusinessObjectInfo bo = IscBizListener.getMetaData(serviceContext.getContext(), serviceContext.getMetaType(), serviceContext.getBoType());
        if (bo == null) {
            methods.put(operationPK, "");
            return "";
        }
        MethodCollection methods = bo.getAllMethodsRuntime();
        HashMap<Object, String> map = new HashMap<Object, String>();
        int i = 0;
        while (i < methods.size()) {
            MethodInfo methodInfo = methods.get(i);
            MetaDataPK pk = MetaDataPK.create((String)methodInfo.getInnerID());
            map.put(pk, methodInfo.getName());
            ++i;
        }
        String name = (String)map.get(operationPK);
        if (name == null) {
            name = "";
            map.put(operationPK, name);
        }
        IscBizListener.methods.putAll(map);
        return name;
    }
}

