/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.server.AbstractSqlCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;

public class ExecuteClassify
extends AbstractSqlCommandExecutor {
    @Override
    public String getCommand() {
        return "execute_classify";
    }

    @Override
    protected ConnectorContext.Operation getOperation() {
        return ConnectorContext.Operation.WRITE;
    }

    @Override
    protected Object exec(ConnectorContext ctx, Connection cn, String sql, Map<String, Object> params) {
        List types = (List)params.get("types");
        List rows = (List)params.get("rows");
        boolean[] exists = new boolean[rows.size()];
        ExecuteClassify.checkExists(cn, sql, types, rows, exists);
        return exists;
    }

    private static void checkExists(Connection cn, String sql, List<Integer> types, List<List<Object>> rows, boolean[] exists) {
        List<DataType> dataTypes = ExecuteClassify.getDataTypes(types);
        int i = 0;
        while (i < rows.size()) {
            List<Object> values = rows.get(i);
            ExecuteClassify.ensureValuesType(values, dataTypes);
            Object value = DbUtil.executeScalar(cn, sql, values, types);
            exists[i] = D.x(value);
            ++i;
        }
    }

    private static List<DataType> getDataTypes(List<Integer> types) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>(types.size());
        for (Integer sqlType : types) {
            dataTypes.add(DataTypeUtil.getDataType(sqlType));
        }
        return dataTypes;
    }

    private static void ensureValuesType(List<Object> values, List<DataType> dataTypes) {
        int j = 0;
        while (j < values.size()) {
            DataType dt = dataTypes.get(j);
            Object value = dt.forSave(dt.narrow(values.get(j)));
            values.set(j, value);
            ++j;
        }
    }
}

