/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.data;

import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import kd.isc.iscb.util.data.LinkedList;
import kd.isc.iscb.util.data.LinkedNode;
import kd.isc.iscb.util.misc.Pair;

public final class LRUMap<K, V> {
    private Type type;
    private HashMap<K, Node<K, V>> map;
    private LinkedList<Node<K, V>> list;
    private int capacity;

    public LRUMap(int capacity) {
        this(capacity, Type.Normal);
    }

    public LRUMap(int capacity, Type type) {
        if (capacity <= 1) {
            throw new IllegalArgumentException("Cache's capacity is less than 1.");
        }
        this.capacity = capacity;
        this.type = type;
        this.map = new HashMap(Math.min(100000, capacity));
        this.list = new LinkedList(new Node());
    }

    public boolean isFull() {
        return this.map.size() >= this.capacity;
    }

    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    public void put(K key, V obj) {
        Node<K, V> node = this.map.get(key);
        if (node != null) {
            this.discard(node);
        } else if (this.isFull()) {
            node = this.list.first();
            this.discard(node);
        } else {
            node = new Node();
        }
        ((Node)node).key = key;
        ((Node)node).ref = this.type.wrap(obj);
        this.list.push(node);
        this.map.put(((Node)node).key, node);
    }

    public Pair<K, V> first() {
        Node<K, V> node = this.list.first();
        if (node == null) {
            return null;
        }
        Object v = this.type.unwrap(((Node)node).ref);
        return new Pair<Object, Object>(((Node)node).key, v);
    }

    public Pair<K, V> last() {
        Node<K, V> node = this.list.last();
        if (node == null) {
            return null;
        }
        Object v = this.type.unwrap(((Node)node).ref);
        return new Pair<Object, Object>(((Node)node).key, v);
    }

    public int size() {
        return this.map.size();
    }

    public V get(K key) {
        Node<K, V> node = this.map.get(key);
        if (node == null) {
            return null;
        }
        Object v = this.type.unwrap(((Node)node).ref);
        if (v != null) {
            this.list.poll(node);
            this.list.push(node);
        } else {
            this.discard(node);
        }
        return (V)v;
    }

    public Collection<V> values() {
        ArrayList<Object> list = new ArrayList<Object>(this.map.size());
        for (Node<K, V> node : this.map.values()) {
            list.add(this.type.unwrap(((Node)node).ref));
        }
        return list;
    }

    public boolean contains(K key) {
        return this.map.containsKey(key);
    }

    public V remove(K key) {
        Node<K, V> node = this.map.get(key);
        if (node == null) {
            return null;
        }
        return this.discard(node);
    }

    private V discard(Node<K, V> node) {
        Object v = this.type.unwrap(((Node)node).ref);
        this.list.poll(node);
        this.map.remove(((Node)node).key);
        return (V)v;
    }

    public boolean extend(int inc) {
        if (this.capacity + inc <= 10) {
            return false;
        }
        this.capacity += inc;
        return true;
    }

    public void clear() {
        this.list.clear();
        this.map.clear();
    }

    private static final class Node<K, V>
    extends LinkedNode<Node<K, V>> {
        private static final long serialVersionUID = -8264155532011907301L;
        private transient K key;
        private transient Object ref;

        private Node() {
        }
    }

    public static enum Type {
        Normal{

            @Override
            Object wrap(Object data) {
                return data;
            }

            @Override
            Object unwrap(Object data) {
                return data;
            }
        }
        ,
        Soft{

            @Override
            Object wrap(Object data) {
                return new SoftReference<Object>(data);
            }

            @Override
            Object unwrap(Object ref) {
                return ((SoftReference)ref).get();
            }
        }
        ,
        Weak{

            @Override
            Object wrap(Object data) {
                return new WeakReference<Object>(data);
            }

            @Override
            Object unwrap(Object ref) {
                return ((WeakReference)ref).get();
            }
        };


        abstract Object wrap(Object var1);

        abstract Object unwrap(Object var1);
    }
}

