/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc.mem.c;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.misc.mem.ClassSizeInfo;
import kd.isc.iscb.util.misc.mem.ObjectSizeCalculator;
import kd.isc.iscb.util.misc.mem.c.DefaultClassSizeInfo;

public class ListClassSizeInfo
implements ClassSizeInfo {
    private final long fixedObjectSize;
    private final long elementExtObjectSize;
    private final Class<?> clazz;

    public ListClassSizeInfo(Class<?> clazz) {
        if (!List.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString("\u7c7b\uff08%s\uff09\u4e0d\u662fCollection\u7c7b\u578b\u3002", "ListClassSizeInfo_2", "isc-iscb-util", new Object[0]), clazz.getName()));
        }
        this.clazz = clazz;
        this.fixedObjectSize = this.getFixedObjectSize(clazz);
        this.elementExtObjectSize = this.getElementExtObjectSize(clazz);
    }

    @Override
    public Class<?> forClass() {
        return this.clazz;
    }

    @Override
    public void visit(Object obj, ObjectSizeCalculator calc, int level) {
        List c = (List)obj;
        long objectSize = (long)c.size() * this.elementExtObjectSize + this.fixedObjectSize;
        calc.increaseSize(objectSize);
        this.visitComponents(c, calc, level + 1);
    }

    private void visitComponents(List<?> c, ObjectSizeCalculator calc, int level) {
        calc.checkLevel(level);
        for (Object e : c) {
            calc.visit(e, level);
        }
    }

    private long getElementExtObjectSize(Class<?> clazz) {
        if (LinkedList.class.isAssignableFrom(clazz)) {
            return ObjectSizeCalculator.OBJECT_HEADER_SIZE + ObjectSizeCalculator.REFERENCE_SIZE * 3;
        }
        return ObjectSizeCalculator.REFERENCE_SIZE;
    }

    private long getFixedObjectSize(Class<?> clazz) {
        long objectSize = new DefaultClassSizeInfo(clazz).getObjectSize();
        if (ArrayList.class.isAssignableFrom(clazz)) {
            objectSize += new DefaultClassSizeInfo(Object[].class).getObjectSize();
        }
        return objectSize;
    }
}

