/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.encoding;

import kd.isc.iscb.util.script.encoding.Crc32;
import kd.isc.iscb.util.script.encoding.Encoding;
import kd.isc.iscb.util.script.encoding.Md5;
import kd.isc.iscb.util.script.encoding.Murmur;
import kd.isc.iscb.util.script.encoding.Sha;
import kd.isc.iscb.util.script.encoding.Sha256;
import kd.isc.iscb.util.script.encoding.Sha384;

public abstract class Hash {
    public static final Hash MD5 = new Md5();
    public static final Hash SHA = new Sha();
    public static final Hash SHA256 = new Sha256();
    public static final Hash SHA384 = new Sha384();
    public static final Hash CRC32 = new Crc32();
    public static final Hash MUR = new Murmur();

    public String hash(String message) {
        byte[] bytes = Encoding.stringToUtf8(message);
        byte[] tmp = this.hash(bytes);
        return Encoding.utf8ToString(Encoding.HEX.encode(tmp));
    }

    public static String md5(String message) {
        return MD5.hash(message);
    }

    public static String crc32(String message) {
        return CRC32.hash(message);
    }

    public static String sha(String message) {
        return SHA.hash(message);
    }

    public static byte[] md5(byte[] message) {
        return MD5.hash(message);
    }

    public static byte[] crc32(byte[] message) {
        return CRC32.hash(message);
    }

    public static byte[] sha(byte[] message) {
        return SHA.hash(message);
    }

    public abstract byte[] hash(byte[] var1);
}

