/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ats.web.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AtsLeaveBillCollection;
import com.kingdee.eas.hr.ats.AtsLeaveBillFactory;
import com.kingdee.eas.hr.ats.AtsLeaveBillInfo;
import com.kingdee.shr.ats.web.handler.AtsLeaveBillListHandler;
import com.kingdee.shr.ats.web.handler.util.AtsLeaveBillOperationUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class AtsLeaveBillListHandlerEx
extends AtsLeaveBillListHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.ats.web.handler.AtsLeaveBillListHandlerEx");

    protected void doBeforeSubmitForWF(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) {
        logger.info((Object)"AtsLeaveBillListHandlerEx.....doBeforeSubmitForWF...start");
        super.doBeforeSubmitForWF(request, response, model);
        try {
            Context ctx = SHRContext.getInstance().getContext();
            AtsLeaveBillInfo info = (AtsLeaveBillInfo)model;
            AtsLeaveBillCollection atsCollection = AtsLeaveBillFactory.getLocalInstance((Context)ctx).getAtsLeaveBillCollection(" where id='" + info.getId().toString() + "'");
            if (atsCollection != null && atsCollection.size() > 0) {
                int i = 0;
                while (i < atsCollection.size()) {
                    AtsLeaveBillInfo atsLeaveBillInfo = atsCollection.get(i);
                    logger.info((Object)("AtsLeaveBillListHandlerEx.....number..." + atsLeaveBillInfo.getNumber()));
                    logger.info((Object)("AtsLeaveBillListHandlerEx.....BillID..." + atsLeaveBillInfo.getId().toString()));
                    String billFormatter = "('" + atsLeaveBillInfo.getId().toString() + "')";
                    AtsLeaveBillOperationUtil.deleteInfo(ctx, billFormatter);
                    AtsLeaveBillOperationUtil.saveInfo(ctx, atsLeaveBillInfo);
                    ++i;
                }
            }
            logger.info((Object)"AtsLeaveBillListHandlerEx.....doBeforeSubmitForWF...end");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void abortBillAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, EASBizException, BOSException {
        logger.info((Object)"AtsLeaveBillListHandlerEx.....abortBillAction...start");
        super.abortBillAction(request, response, modelMap);
        Context ctx = SHRContext.getInstance().getContext();
        String billId = request.getParameter("billId");
        if (StringUtils.isNotBlank((CharSequence)billId)) {
            String billFormatter = "('" + billId.replaceAll(",", "','") + "')";
            AtsLeaveBillOperationUtil.deleteInfo(ctx, billFormatter);
        }
        logger.info((Object)"AtsLeaveBillListHandlerEx.....abortBillAction...start");
    }

    public void againstApproveAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        logger.info((Object)"AtsLeaveBillListHandlerEx.....againstApproveAction...start");
        super.againstApproveAction(request, response, modelMap);
        String billId = request.getParameter("billId");
        Context ctx = SHRContext.getInstance().getContext();
        if (StringUtils.isNotBlank((CharSequence)billId)) {
            String billFormatter = "('" + billId.replaceAll(",", "','") + "')";
            AtsLeaveBillOperationUtil.deleteInfo(ctx, billFormatter);
        }
    }
}

