/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.handler;

import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.compensation.CmpEmpORelationCollection;
import com.kingdee.shr.compensation.CmpEmpORelationFactory;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.ICmpEmpORelation;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitSchemeInfo;
import com.kingdee.shr.compensation.util.columnModel.CmpColumnModels;
import com.kingdee.shr.compensation.web.handler.integrate.BatchSubmitShemeBillMySubmissionEditHandler;
import com.kingdee.shr.customer.gtiit.handler.BaseSubmitBillEntryGenerator;
import com.kingdee.shr.customer.gtiit.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.ui.ModelMap;

public class BatchSubmitShemeBillMySubmissionEditHandlerEx
extends BatchSubmitShemeBillMySubmissionEditHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.customer.gtiit.handler.BatchSubmitShemeBillMySubmissionEditHandlerEx");
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public void getDateTimeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SHRWebException {
        String personId = request.getParameter("personId");
        String type = request.getParameter("type");
        String adminOrgId = request.getParameter("adminOrgId");
        String positionId = request.getParameter("positionId");
        String hourlywage = request.getParameter("hourlywage");
        Context ctx = SHRContext.getInstance().getContext();
        if (StringUtils.isEmpty((CharSequence)personId) || StringUtils.isEmpty((CharSequence)type)) {
            throw new ShrWebBizException("\u5458\u5de5\u7f16\u7801\u6216\u4efb\u804c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        IDynamicObject iDynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
        try {
            PersonInfo personInfo = iPerson.getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            if (type.equals("Full")) {
                DataBaseInfo ftorptInfo = (DataBaseInfo)personInfo.get("ftorpt");
                if (ftorptInfo == null) {
                    throw new ShrWebBizException("\u8bf7\u5728\u5458\u5de5\u4fe1\u606f\u7ef4\u62a4\u5168\u804c\u6216\u517c\u804c\u5b57\u6bb5\uff01\uff01");
                }
                IObjectValue ftorpt = iDynamicObject.getValue(BOSObjectType.create((String)"EE23D375"), (IObjectPK)new ObjectUuidPK(ftorptInfo.getId()));
                java.util.Date hireDate = personInfo.getHireDate();
                map.put("startDate", this.sdf.format(hireDate));
                if (ftorpt.get("number").equals("FULL")) {
                    FilterInfo filterInfo = new FilterInfo();
                    FilterItemCollection filterItems = filterInfo.getFilterItems();
                    filterItems.add(new FilterItemInfo("person", (Object)personId));
                    SorterItemCollection sc = new SorterItemCollection();
                    SorterItemInfo sorterItem = new SorterItemInfo("ExpiredDate");
                    sorterItem.setSortType(SortType.DESCEND);
                    sc.add(sorterItem);
                    EntityViewInfo entityViewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, null, (SorterItemCollection)sc);
                    IObjectCollection collection = iDynamicObject.getCollection(BOSObjectType.create((String)"D8595360"), entityViewInfo);
                    java.util.Date expiredDate = null;
                    if (collection.size() > 0) {
                        IObjectValue pcontractinfo = collection.getObject(0);
                        expiredDate = (java.util.Date)pcontractinfo.get("ExpiredDate");
                    }
                    map.put("endDate", expiredDate == null ? "" : this.sdf.format(expiredDate));
                } else if (ftorpt.get("number").equals("PART")) {
                    java.util.Date jobEndTime = (java.util.Date)personInfo.get("jobEndTime");
                    map.put("endDate", jobEndTime == null ? "" : this.sdf.format(jobEndTime));
                }
            } else if (type.equals("Part")) {
                if (StringUtils.isEmpty((CharSequence)adminOrgId) || StringUtils.isEmpty((CharSequence)positionId)) {
                    throw new ShrWebBizException("\u7ec4\u7ec7ID\u6216\u804c\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01");
                }
                ICmpEmpORelation iCmpEmpORelation = CmpEmpORelationFactory.getLocalInstance((Context)ctx);
                FilterInfo filterInfo = new FilterInfo();
                FilterItemCollection filterItems = filterInfo.getFilterItems();
                filterItems.add(new FilterItemInfo("empOrgRelation.person", (Object)personInfo.getId().toString()));
                filterItems.add(new FilterItemInfo("empOrgRelation.adminOrg", (Object)adminOrgId));
                filterItems.add(new FilterItemInfo("empOrgRelation.position", (Object)positionId));
                filterItems.add(new FilterItemInfo("empOrgRelation.hourlywage", (Object)(StringUtils.isEmpty((CharSequence)hourlywage) ? null : hourlywage)));
                EntityViewInfo entityViewInfo = EntityViewInfo.getInstance((FilterInfo)filterInfo, null, null);
                logger.error((Object)("\u53d1\u85aa\u6863\u6848\u4efb\u804c\u5206\u5f55\u67e5\u8be2person:" + personInfo.getId().toString() + ";adminOrg:" + adminOrgId + "; position:" + positionId + "; hourlywage:" + hourlywage));
                CmpEmpORelationCollection cmpEmpORelationCollection = iCmpEmpORelation.getCmpEmpORelationCollection(entityViewInfo);
                logger.error((Object)("\u67e5\u8be2\u5230CmpEmpORelationCollection\u6570\u91cf:" + cmpEmpORelationCollection.size()));
                if (cmpEmpORelationCollection.size() > 1) {
                    throw new ShrWebBizException("\u5458\u5de5\u4efb\u804c\u4fe1\u606f\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u6392\u67e5\u662f\u5426\u5b58\u5728\u591a\u6761[\u4eba\u5458\u3001\u7ec4\u7ec7\u3001\u804c\u4f4d\u3001\u65f6\u85aa]\u6570\u636e\uff01\uff01");
                }
                if (cmpEmpORelationCollection != null && cmpEmpORelationCollection.size() == 1) {
                    CmpEmpORelationInfo cmpEmpORelationInfo = cmpEmpORelationCollection.get(0);
                    java.util.Date effectDate = cmpEmpORelationInfo.getEffectDate();
                    java.util.Date leffectDate = cmpEmpORelationInfo.getLeffectDate();
                    map.put("startDate", this.sdf.format(effectDate));
                    map.put("endDate", this.sdf.format(leffectDate));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ShrWebBizException((Throwable)e);
        }
        JSONUtils.writeJson((HttpServletResponse)response, map);
    }

    public String getEditGridColModelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        CalSubmitSchemeInfo schemeInfo;
        String submitSchemeId = request.getParameter("submitSchemeId");
        if (StringUtils.isEmpty((CharSequence)submitSchemeId)) {
            JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
            return null;
        }
        boolean dynamicColmunRequired = this.isDynamicColmunRequired(request);
        HashMap params = Maps.newHashMap();
        params.put("datasource", Integer.valueOf(request.getParameter("datasource")));
        params.put("costTypeId", request.getParameter("costTypeId"));
        params.put("dynamicColmunRequired", dynamicColmunRequired);
        params.put("hrOrgUnitId", request.getParameter("hrOrgUnitId"));
        Context ctx = SHRContext.getInstance().getContext();
        CmpColumnModels cmpColumnModels = new BaseSubmitBillEntryGenerator().getEntryColumnModels(ctx, submitSchemeId, params);
        modelMap.put((Object)"colNames", (Object)cmpColumnModels.getColNames());
        modelMap.put((Object)"colModel", (Object)cmpColumnModels.getColModel());
        modelMap.put((Object)"defaultSortname", null);
        try {
            schemeInfo = CalSubmitSchemeFactory.getLocalInstance((Context)ctx).getCalSubmitSchemeInfo((IObjectPK)new ObjectUuidPK(submitSchemeId));
        }
        catch (EASBizException var11) {
            throw new ShrWebBizException(var11.getMessage(), (Throwable)var11);
        }
        catch (BOSException var12) {
            throw new SHRWebException(var12.getMessage(), (Throwable)var12);
        }
        modelMap.put((Object)"description", (Object)schemeInfo.getDescription());
        JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
        return null;
    }

    protected void beforeSubmit(HttpServletRequest request, HttpServletResponse response, CoreBaseInfo model) throws SHRWebException {
        super.beforeSubmit(request, response, model);
        Context ctx = SHRContext.getInstance().getContext();
        BatchSubmitShemeBillInfo info = (BatchSubmitShemeBillInfo)model;
        if (StringUtils.isNotBlank((CharSequence)info.getString("id"))) {
            try {
                info = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillInfo((IObjectPK)new ObjectUuidPK(info.getString("id")));
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        String sql = "select cfistakecheck,CFIsCurrentDepart from T_HR_SCalSubmitScheme where fid = '" + info.getSubmitScheme().getId().toString() + "'";
        boolean isPlanCheck = false;
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)iRowSet.getString("cfistakecheck"))) continue;
                isPlanCheck = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.checkPosition(info);
        this.checkDateOverlap(info);
        if (isPlanCheck) {
            this.checkPositionCount(info);
            this.checkHours(info);
        }
    }

    public void checkPosition(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        String billId = info.getId().toString();
        String sql = "select b.FNAME_L1 from T_HR_SchemeBillEntry a left join T_ORG_Position b on a.FPOSITIONID = b.FID where a.FBILLID = '" + billId + "' " + "and b.FNAME_L1 = (SELECT fname_l2 FROM T_HR_SHRRSVITEM0 where fstate = '1' and FNUMBER = '1007') " + "and EXISTS (SELECT d.CFWORKMULTIPLE FROM T_HR_ATS_LegalHoliday c " + "left join T_HR_ATS_LegalHolidayItem d on c.fid = d.FGROUPID where c.FSTATE = '1' " + "and d.CFWORKMULTIPLE = '3' and d.FSTARTDATE <= a.feffectdate and d.FENDDATE >= a.feffectdate)";
        logger.error((Object)("\u67e5\u8be2\u804c\u4f4d\u5bf9\u5e94\u65e5\u671f\u662f\u5426\u5728\u6cd5\u5b9a\u8282\u5047\u65e5SQL\uff1a" + sql));
        try {
            boolean flag = false;
            String positionName = "";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                flag = true;
                positionName = rowSet.getString("FNAME_L1");
            }
            if (flag) {
                throw new ShrWebBizException("This position (" + positionName + ") does not allow submission of documents that occur on statutory holidays");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void checkDateOverlap(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        BatchSubmitShemeBillEntryCollection entryColl = info.getEntry();
        String billId = info.getId().toString();
        logger.error((Object)("\u5355\u636eID\uff1a" + billId));
        java.util.Date effectDate = entryColl.get(0).getEffectDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(effectDate);
        calendar.set(5, 1);
        java.util.Date startDate = calendar.getTime();
        calendar.add(2, 1);
        java.util.Date endDate = calendar.getTime();
        String startDateStr = DateTimeUtils.dateFormat(startDate, "yyyy-MM-dd");
        String endDateStr = DateTimeUtils.dateFormat(endDate, "yyyy-MM-dd");
        boolean flag = false;
        String sql = "SELECT a.*,b.billNumber FROM T_HR_SchemeBillEntry a , (SELECT a.fnumber billNumber,b.* FROM T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid = b.fbillid where a.FBILLSTATE in ('1','2','3') and b.FPERSONID = '" + personId + "' " + "and b.FEFFECTDATE >= '" + startDateStr + "' and b.FEFFECTDATE < '" + endDateStr + "' and a.FDATASOURCE = '1') b " + "where a.FBILLID = '" + billId + "' and a.cfstarttime < b.CFENDTIME " + "and a.cfendtime > b.CFSTARTTIME";
        logger.error((Object)("\u67e5\u8be2\u662f\u5426\u6709\u65f6\u95f4\u6bb5\u91cd\u53e0\u6570\u636eSQL\uff1a" + sql));
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            String billNumber = "";
            while (rowSet.next()) {
                billNumber = rowSet.getString("billNumber");
                flag = true;
            }
            if (flag) {
                throw new ShrWebBizException("The start and end times overlap with another document (" + billNumber + ")");
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void checkHours(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        BatchSubmitShemeBillEntryCollection entryColl = info.getEntry();
        BigDecimal lastHours = BigDecimal.ZERO;
        BigDecimal currentHour = BigDecimal.ZERO;
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        int currentMonth = calendar.get(2);
        int i = 0;
        while (i < entryColl.size()) {
            BatchSubmitShemeBillEntryInfo entryInfo = entryColl.get(i);
            java.util.Date effectDate = entryInfo.getEffectDate();
            calendar.setTime(effectDate);
            if (currentYear == calendar.get(1) && currentMonth == calendar.get(2)) {
                currentHour = currentHour.add(entryInfo.getBigDecimal("totalWorkHours"));
            } else {
                lastHours = lastHours.add(entryInfo.getBigDecimal("totalWorkHours"));
            }
            ++i;
        }
        try {
            IRowSet adjustRow;
            String adjustSql;
            BigDecimal adjustHour;
            IRowSet iRowSet;
            String hourSql;
            BigDecimal totalHour;
            BigDecimal maxHour = BigDecimal.ZERO;
            String paramSql = "SELECT FNUMBER,fname_l2 name FROM T_HR_SHRRSVITEM0 where fstate = '1' and FNUMBER = '1003'";
            IRowSet paramRow = DbUtil.executeQuery((Context)ctx, (String)paramSql);
            while (paramRow.next()) {
                if (!paramRow.getString("FNUMBER").equals("1003")) continue;
                BigDecimal bigDecimal = maxHour = paramRow.getObject("name") == null ? BigDecimal.ZERO : paramRow.getBigDecimal("name");
            }
            if (lastHours.compareTo(BigDecimal.ZERO) != 0) {
                calendar = Calendar.getInstance();
                calendar.set(5, 1);
                java.util.Date endDate = calendar.getTime();
                calendar.add(2, -1);
                java.util.Date startDate = calendar.getTime();
                totalHour = BigDecimal.ZERO;
                hourSql = "SELECT sum(b.cftotalworkhours) as totalHour FROM T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid=b.fbillid where  b.fpersonid='" + personId + "' and b.feffectdate>='" + sdf.format(startDate) + "' and b.feffectdate<'" + sdf.format(endDate) + "' and a.FBILLSTATE in ('1','2','3')";
                iRowSet = DbUtil.executeQuery((Context)ctx, (String)hourSql);
                while (iRowSet.next()) {
                    BigDecimal bigDecimal = totalHour = iRowSet.getObject("totalHour") == null ? BigDecimal.ZERO : iRowSet.getBigDecimal("totalHour");
                }
                totalHour = totalHour.add(lastHours);
                adjustHour = BigDecimal.ZERO;
                adjustSql = "/*dialect*/SELECT cfadjustinghours FROM CT_MP_Ptworkinghours where fpersonid='" + personId + "' and DATE_TRUNC('month', cfeffectivedate)<='" + sdf.format(startDate) + "' and cfenddate>='" + sdf.format(startDate) + "' order by FLastUpdateTime desc limit 1";
                logger.error((Object)("\u83b7\u53d6\u8c03\u6574\u5de5\u65f6SQL\uff1a" + adjustSql));
                adjustRow = DbUtil.executeQuery((Context)ctx, (String)adjustSql);
                while (adjustRow.next()) {
                    BigDecimal bigDecimal = adjustHour = adjustRow.getObject("cfadjustinghours") == null ? BigDecimal.ZERO : adjustRow.getBigDecimal("cfadjustinghours");
                }
                if (totalHour.compareTo(maxHour.add(adjustHour)) > 0) {
                    throw new ShrWebBizException("The total reported working hours for the previous month cannot exceed the maximum number of working hours");
                }
            }
            if (currentHour.compareTo(BigDecimal.ZERO) != 0) {
                calendar = Calendar.getInstance();
                calendar.set(5, 1);
                java.util.Date startDate = calendar.getTime();
                calendar.add(2, 1);
                java.util.Date endDate = calendar.getTime();
                totalHour = BigDecimal.ZERO;
                hourSql = "SELECT sum(b.cftotalworkhours) as totalHour FROM T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid=b.fbillid where  b.fpersonid='" + personId + "' and b.feffectdate>='" + sdf.format(startDate) + "' and b.feffectdate<'" + sdf.format(endDate) + "' and a.FBILLSTATE in ('1','2','3')";
                iRowSet = DbUtil.executeQuery((Context)ctx, (String)hourSql);
                while (iRowSet.next()) {
                    BigDecimal bigDecimal = totalHour = iRowSet.getObject("totalHour") == null ? BigDecimal.ZERO : iRowSet.getBigDecimal("totalHour");
                }
                totalHour = totalHour.add(lastHours);
                adjustHour = BigDecimal.ZERO;
                adjustSql = "/*dialect*/SELECT cfadjustinghours FROM CT_MP_Ptworkinghours where fpersonid='" + personId + "' and DATE_TRUNC('month', cfeffectivedate)<='" + sdf.format(startDate) + "' and cfenddate>='" + sdf.format(startDate) + "' order by FLastUpdateTime desc limit 1";
                logger.error((Object)("\u83b7\u53d6\u8c03\u6574\u5de5\u65f6SQL\uff1a" + adjustSql));
                adjustRow = DbUtil.executeQuery((Context)ctx, (String)adjustSql);
                while (adjustRow.next()) {
                    BigDecimal bigDecimal = adjustHour = adjustRow.getObject("cfadjustinghours") == null ? BigDecimal.ZERO : adjustRow.getBigDecimal("cfadjustinghours");
                }
                if (totalHour.compareTo(maxHour.add(adjustHour)) > 0) {
                    throw new ShrWebBizException("The total reported working hours for the current month cannot exceed the maximum number of working hours");
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void checkPositionCount(BatchSubmitShemeBillInfo info) throws ShrWebBizException {
        Context ctx = SHRContext.getInstance().getContext();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        BatchSubmitShemeBillEntryCollection entryColl = info.getEntry();
        boolean isLastMonth = false;
        boolean isCurrentMonth = false;
        String positionId = "";
        String superiorId = "";
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        int currentMonth = calendar.get(2);
        int i = 0;
        while (i < entryColl.size()) {
            BatchSubmitShemeBillEntryInfo entryInfo = entryColl.get(i);
            java.util.Date effectDate = entryInfo.getEffectDate();
            calendar.setTime(effectDate);
            if (currentYear == calendar.get(1) && currentMonth == calendar.get(2)) {
                isCurrentMonth = true;
            } else {
                isLastMonth = true;
            }
            positionId = entryInfo.getPosition().getId().toString();
            superiorId = entryInfo.getString("superiorId");
            ++i;
        }
        logger.error((Object)("\u804c\u4f4dID\uff1a" + positionId + ", \u76f4\u63a5\u4e0a\u7ea7ID\uff1a" + superiorId));
        try {
            IRowSet iRowSet;
            String sql;
            if (isLastMonth) {
                calendar = Calendar.getInstance();
                calendar.set(5, 1);
                String endDate = DateTimeUtils.dateFormat(calendar.getTime(), "yyyy-MM-dd");
                calendar.add(2, -1);
                String startDate = DateTimeUtils.dateFormat(calendar.getTime(), "yyyy-MM-dd");
                int count = 0;
                sql = "select count(1) count from T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid=b.fbillid where b.FPERSONID  = '" + personId + "' and b.FPOSITIONID = '" + positionId + "' and b.CFSuperiorID = '" + superiorId + "' and a.fbillstate in ('1','2','3') and a.fdatasource = '1' and b.FEFFECTDATE >= '" + startDate + "' and b.FEFFECTDATE < '" + endDate + "'";
                logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u8be5\u804c\u4f4d\u5f53\u6708\u63d0\u4ea4\u6b21\u6570SQL\uff1a" + sql));
                iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (iRowSet.next()) {
                    count = iRowSet.getInt("count");
                }
                logger.error((Object)("\u5458\u5de5\u8be5\u804c\u4f4d\u5f53\u6708\u63d0\u4ea4\u6b21\u6570\uff1a" + count));
                if (count > 0) {
                    throw new ShrWebBizException("The employee submits the position once within a month");
                }
            }
            if (isCurrentMonth) {
                calendar = Calendar.getInstance();
                calendar.set(5, 1);
                String startDate = DateTimeUtils.dateFormat(calendar.getTime(), "yyyy-MM-dd");
                calendar.add(2, 1);
                String endDate = DateTimeUtils.dateFormat(calendar.getTime(), "yyyy-MM-dd");
                int count = 0;
                sql = "select count(1) count from T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid=b.fbillid where b.FPERSONID  = '" + personId + "' and b.FPOSITIONID = '" + positionId + "' and b.CFSuperiorID = '" + superiorId + "' and a.fbillstate in ('1','2','3') and a.fdatasource = '1' and b.FEFFECTDATE >= '" + startDate + "' and b.FEFFECTDATE < '" + endDate + "'";
                logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u8be5\u804c\u4f4d\u5f53\u6708\u63d0\u4ea4\u6b21\u6570SQL\uff1a" + sql));
                iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (iRowSet.next()) {
                    count = iRowSet.getInt("count");
                }
                logger.error((Object)("\u5458\u5de5\u8be5\u804c\u4f4d\u5f53\u6708\u63d0\u4ea4\u6b21\u6570\uff1a" + count));
                if (count > 0) {
                    throw new ShrWebBizException("The employee submits the position once within a month");
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void checkSumbitDateAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        int day = 0;
        Calendar calendar = Calendar.getInstance();
        int thisDay = calendar.get(5);
        String resultMessage = "";
        try {
            String paramSql = "SELECT FNUMBER,fname_l2 name FROM T_HR_SHRRSVITEM0 where fstate = '1' and FNUMBER = '1004'";
            IRowSet paramRow = DbUtil.executeQuery((Context)ctx, (String)paramSql);
            while (paramRow.next()) {
                if (!paramRow.getString("FNUMBER").equals("1004")) continue;
                int n = day = paramRow.getObject("name") == null ? 0 : paramRow.getInt("name");
            }
            if (day != 0 && thisDay > day) {
                resultMessage = "It is not allowed to submit the previous month's work hours after the " + day + "th of each month";
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        modelMap.put((Object)"resultMessage", (Object)resultMessage);
        JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
    }

    public String getPersonCareerDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String personId = request.getParameter("personId");
        String parentId = "";
        String workHour = "";
        String sql = "select re.FPERSONID,rl.cflinemanagernameI linemanagername,rl.cfhourlywage from (SELECT FPERSONID,max(FEFFDT) as maxDate FROM T_HR_EmpOrgRelation where fassignType = '1' group by  FPERSONID) as re  left join T_HR_EmpOrgRelation rl on re.fpersonid = rl.fpersonid and re.maxDate = rl.feffdt and rl.fassignType = '1' where re.fpersonid='" + personId + "'";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                parentId = iRowSet.getString("linemanagername");
                workHour = iRowSet.getString("cfhourlywage");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        modelMap.put((Object)"parentId", (Object)parentId);
        modelMap.put((Object)"workHour", (Object)workHour);
        JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
        return null;
    }

    public String getInductionDateAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String sql = "select b.fenterdate from (SELECT FPERSONID,max(FEFFDT) as maxDate FROM T_HR_EmpLaborRelationHis group by fpersonid) a left join T_HR_EmpLaborRelationHis b on a.fpersonid=b.fpersonid and a.maxdate=b.FEFFDT where a.fpersonid='" + personId + "'";
        String enterDate = "";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                enterDate = iRowSet.getString("fenterdate");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        modelMap.put((Object)"enterDate", (Object)enterDate);
        JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
        return null;
    }

    public void getContractDateAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String positionId = request.getParameter("positionId");
        Context ctx = SHRContext.getInstance().getContext();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String sql = "SELECT cfcommencingdate,cfexpireddate,cftype FROM CT_MP_Pcontractinfo where fpersonid='" + personId + "' and cfpositionid='" + positionId + "' order by cfcommencingdate asc";
        logger.error((Object)("\u67e5\u8be2\u5408\u540c\u4fe1\u606fSQL\uff1a" + sql));
        java.util.Date beginContractDate = null;
        java.util.Date endContractDate = null;
        String contractType = "";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList list = new ArrayList();
            while (iRowSet.next()) {
                Date beginDate = iRowSet.getDate("cfcommencingdate");
                Date endDate = iRowSet.getDate("cfexpireddate");
                String type = iRowSet.getString("cftype");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("beginDate", beginDate);
                map.put("endDate", endDate);
                map.put("type", type);
                list.add(map);
            }
            int i = 0;
            while (i < list.size()) {
                Map map = (Map)list.get(i);
                java.util.Date beginDate = (java.util.Date)map.get("beginDate");
                java.util.Date endDate = (java.util.Date)map.get("endDate");
                String type = (String)map.get("type");
                if (StringUtils.equals((CharSequence)contractType, (CharSequence)type)) {
                    boolean flag;
                    Calendar beginCalendar = Calendar.getInstance();
                    Calendar endCalendar = Calendar.getInstance();
                    beginCalendar.setTime(beginDate);
                    beginCalendar.add(5, -1);
                    endCalendar.setTime(endContractDate);
                    boolean isYear = beginCalendar.get(1) == endCalendar.get(1);
                    boolean isMonth = beginCalendar.get(2) == endCalendar.get(2);
                    boolean isDay = beginCalendar.get(5) == endCalendar.get(5);
                    boolean bl = flag = isYear && isMonth && isDay;
                    if (flag) {
                        endContractDate = endDate;
                    } else {
                        beginContractDate = beginDate;
                        endContractDate = endDate;
                    }
                } else {
                    beginContractDate = beginDate;
                    endContractDate = endDate;
                    contractType = type;
                }
                ++i;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        modelMap.put((Object)"beginContractDate", beginContractDate);
        modelMap.put((Object)"endContractDate", endContractDate);
        JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
    }

    public String checkEscalationDateAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        BigDecimal maxHour;
        java.util.Date stratDate;
        java.util.Date endDate;
        SimpleDateFormat sdf;
        BigDecimal hours;
        String personId;
        Context ctx;
        block9: {
            ctx = SHRContext.getInstance().getContext();
            personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
            hours = new BigDecimal(request.getParameter("hours"));
            sdf = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            int thisDay = calendar.get(5);
            calendar.set(5, 1);
            endDate = calendar.getTime();
            calendar.add(2, -1);
            stratDate = calendar.getTime();
            maxHour = BigDecimal.ZERO;
            int day = 0;
            String paramSql = "SELECT FNUMBER,fname_l2 name FROM T_HR_SHRRSVITEM0 where fstate = '1' and (FNUMBER = '1003' or FNUMBER = '1004')";
            IRowSet paramRow = DbUtil.executeQuery((Context)ctx, (String)paramSql);
            while (paramRow.next()) {
                if (paramRow.getString("FNUMBER").equals("1003")) {
                    BigDecimal bigDecimal = maxHour = paramRow.getObject("name") == null ? BigDecimal.ZERO : paramRow.getBigDecimal("name");
                }
                if (!paramRow.getString("FNUMBER").equals("1004")) continue;
                int n = day = paramRow.getObject("name") == null ? 0 : paramRow.getInt("name");
            }
            if (thisDay <= day) break block9;
            modelMap.put((Object)"resultMessage", (Object)("It is not allowed to submit the previous month's work hours after the " + day + "th of each month"));
            JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
            return null;
        }
        try {
            BigDecimal totalHour = BigDecimal.ZERO;
            String hourSql = "SELECT sum(b.cftotalworkhours) as totalHour FROM T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid=b.fbillid where  b.fpersonid='" + personId + "' and b.feffectdate>='" + sdf.format(stratDate) + "' and b.feffectdate<'" + sdf.format(endDate) + "' and a.FBILLSTATE in ('1','2','3')";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)hourSql);
            while (iRowSet.next()) {
                BigDecimal bigDecimal = totalHour = iRowSet.getObject("totalHour") == null ? BigDecimal.ZERO : iRowSet.getBigDecimal("totalHour");
            }
            totalHour = totalHour.add(hours);
            BigDecimal adjustHour = BigDecimal.ZERO;
            String adjustSql = "SELECT cfadjustinghours FROM CT_MP_Ptworkinghours where fpersonid='" + personId + "' and cfeffectivedate>='" + sdf.format(stratDate) + "' and cfeffectivedate<'" + sdf.format(endDate) + "'";
            IRowSet adjustRow = DbUtil.executeQuery((Context)ctx, (String)adjustSql);
            while (adjustRow.next()) {
                BigDecimal bigDecimal = adjustHour = adjustRow.getObject("cfadjustinghours") == null ? BigDecimal.ZERO : adjustRow.getBigDecimal("cfadjustinghours");
            }
            if (totalHour.compareTo(maxHour.add(adjustHour)) > 0) {
                modelMap.put((Object)"resultMessage", (Object)"The total working hours in a month cannot exceed the maximum number of hours");
                JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void countHourAmountAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = request.getParameter("billId");
        if (StringUtils.isEmpty((CharSequence)billId)) {
            return;
        }
        Context ctx = SHRContext.getInstance().getContext();
        try {
            BatchSubmitShemeBillInfo batchSubmitShemeBillInfo = BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).getBatchSubmitShemeBillInfo((IObjectPK)new ObjectUuidPK(billId));
            BatchSubmitShemeBillEntryCollection entryColl = batchSubmitShemeBillInfo.getEntry();
            BigDecimal sumHours = BigDecimal.ZERO;
            BigDecimal sumAmount = BigDecimal.ZERO;
            int i = 0;
            while (i < entryColl.size()) {
                BatchSubmitShemeBillEntryInfo entryInfo = entryColl.get(i);
                BigDecimal hour = entryInfo.getBigDecimal("totalWorkHours") == null ? BigDecimal.ZERO : entryInfo.getBigDecimal("totalWorkHours");
                BigDecimal amount = entryInfo.getBigDecimal("totalAmount") == null ? BigDecimal.ZERO : entryInfo.getBigDecimal("totalAmount");
                sumHours = sumHours.add(hour);
                sumAmount = sumAmount.add(amount);
                ++i;
            }
            batchSubmitShemeBillInfo.put("totalWorkHours", (Object)sumHours);
            batchSubmitShemeBillInfo.put("totalAmount", (Object)sumAmount);
            BatchSubmitShemeBillFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)batchSubmitShemeBillInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void workMultipleAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String otDate = request.getParameter("otDate");
        logger.error((Object)("\u63d0\u62a5\u65e5\u671f\uff1a" + otDate));
        java.util.Date parseDate = DateTimeUtils.parseDate(otDate, "yyyy-MM-dd");
        otDate = DateTimeUtils.dateFormat(parseDate, "yyyy-MM-dd");
        String sql = "SELECT b.CFWORKMULTIPLE FROM T_HR_ATS_LegalHoliday a left join T_HR_ATS_LegalHolidayItem b on a.fid = b.FGROUPID where a.FSTATE = '1' and b.FSTARTDATE <= '" + otDate + "' and b.FENDDATE >= '" + otDate + "'";
        logger.error((Object)("\u67e5\u8be2\u52a0\u73ed\u7c7b\u578bSQL\uff1a" + sql));
        HashMap<String, String> returnMap = new HashMap<String, String>();
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean flag = false;
            while (iRowSet.next()) {
                if (!StringUtils.equals((CharSequence)iRowSet.getString("CFWORKMULTIPLE"), (CharSequence)"3")) continue;
                flag = true;
            }
            if (flag) {
                returnMap.put("returnType", "0");
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(parseDate);
                int dayOfWeek = calendar.get(7);
                if (dayOfWeek == 7 || dayOfWeek == 1) {
                    returnMap.put("returnType", "1");
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        JSONUtils.writeJson((HttpServletResponse)response, returnMap);
    }

    public void checkDepartDateAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        String cmpOrgRelationId = request.getParameter("cmpOrgRelationId");
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        int currentMonth = calendar.get(2) + 1;
        boolean flag = false;
        String cmpSql = "select b.fassigntype,b.fpositionid from T_HR_SCmpEmpORelation a left join T_HR_EmpOrgRelation b on a.FEMPORGRELATIONID = b.fid where a.fid ='" + cmpOrgRelationId + "'";
        logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u6863\u6848\u4fe1\u606fSQL\uff1a" + cmpSql));
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)cmpSql);
            String assignType = "";
            String positionId = "";
            while (iRowSet.next()) {
                assignType = iRowSet.getString("fassigntype");
                positionId = iRowSet.getString("fpositionid");
            }
            if (StringUtils.equals((CharSequence)assignType, (CharSequence)"1")) {
                String resignSql = "select year(b.FBIZDATE) year,month(b.FBIZDATE) month from T_HR_ResignBizBill a left join T_HR_ResignBizBillentry b on a.fid=b.fbillid where b.FPERSONID ='" + personId + "' and a.FBILLSTATE = '3' order by b.FBIZDATE desc";
                logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u79bb\u804c\u5355SQL\uff1a" + resignSql));
                IRowSet resignRow = DbUtil.executeQuery((Context)ctx, (String)resignSql);
                int resignYear = 0;
                int resignMonth = 0;
                while (resignRow.next()) {
                    resignYear = resignRow.getInt("year");
                    resignMonth = resignRow.getInt("month");
                }
                if (currentYear == resignYear && currentMonth == resignMonth) {
                    flag = true;
                }
            } else {
                String empSql = "select top 1 year(fleffdt) year,month(fleffdt) month from T_HR_EmpOrgRelation where fpositionid = '" + positionId + "' and fpersonid='" + personId + "' order by feffdt desc";
                logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u517c\u804cSQL\uff1a" + empSql));
                int leffdtYear = 0;
                int leffdtMonth = 0;
                IRowSet empRow = DbUtil.executeQuery((Context)ctx, (String)empSql);
                while (empRow.next()) {
                    leffdtYear = empRow.getInt("year");
                    leffdtMonth = empRow.getInt("month");
                }
                if (currentYear == leffdtYear && currentMonth == leffdtMonth) {
                    flag = true;
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        modelMap.put((Object)"flag", (Object)flag);
        JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
    }

    public void checkSubmitCountAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String positionId = request.getParameter("positionId");
        String personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        String startDate = DateTimeUtils.dateFormat(calendar.getTime(), "yyyy-MM-dd");
        calendar.add(2, 1);
        String endDate = DateTimeUtils.dateFormat(calendar.getTime(), "yyyy-MM-dd");
        int count = 0;
        String sql = "SELECT count(1) count FROM T_HR_SBatchSubmitShemeBill where fid in (select distinct a.fid from T_HR_SBatchSubmitShemeBill a left join T_HR_SchemeBillEntry b on a.fid=b.fbillid where a.FPROPOSERID  = '" + personId + "' and b.FPOSITIONID = '" + positionId + "' and a.fbillstate in ('1','2','3') and a.fdatasource = '1' and a.FSUBMITTIME >= '" + startDate + "' and a.FSUBMITTIME < '" + endDate + "')";
        logger.error((Object)("\u67e5\u8be2\u5458\u5de5\u8be5\u804c\u4f4d\u5f53\u6708\u63d0\u4ea4\u6b21\u6570SQL\uff1a" + sql));
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                count = iRowSet.getInt("count");
            }
            logger.error((Object)("\u5458\u5de5\u8be5\u804c\u4f4d\u5f53\u6708\u63d0\u4ea4\u6b21\u6570\uff1a" + count));
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        modelMap.put((Object)"count", (Object)count);
        JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
    }

    public void isTakeCheckAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Context ctx = SHRContext.getInstance().getContext();
        String calSchemeId = request.getParameter("calSchemeId");
        logger.error((Object)("\u63d0\u62a5\u65b9\u6848ID\uff1a" + calSchemeId));
        boolean isPlanCheck = false;
        boolean isCurrentDepart = false;
        String sql = "select cfistakecheck,CFIsCurrentDepart from T_HR_SCalSubmitScheme where fid = '" + calSchemeId + "'";
        logger.error((Object)("\u67e5\u8be2\u63d0\u62a5\u65b9\u6848SQL\uff1a" + sql));
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                if (StringUtils.equals((CharSequence)"1", (CharSequence)iRowSet.getString("cfistakecheck"))) {
                    isPlanCheck = true;
                }
                if (!StringUtils.equals((CharSequence)"1", (CharSequence)iRowSet.getString("CFIsCurrentDepart"))) continue;
                isCurrentDepart = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        modelMap.put((Object)"isPlanCheck", (Object)isPlanCheck);
        modelMap.put((Object)"isCurrentDepart", (Object)isCurrentDepart);
        JSONUtils.writeJson((HttpServletResponse)response, (Object)modelMap);
    }
}

