/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.util;

import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Date;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.customer.gtiit.util.ExportUtils");

    public static void exportData(HttpServletResponse response, Object resource, String fileName, LinkedHashMap<String, String> selectFieldsTypeMap) throws SQLException {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet("Sheet1");
        XSSFDataFormat format = workBook.createDataFormat();
        if (resource != null && resource instanceof IRowSet) {
            IRowSet rs = (IRowSet)resource;
            int numColumns = selectFieldsTypeMap.entrySet().size();
            int i = 0;
            XSSFRow titleRow = sheet.createRow(i);
            List keyList = selectFieldsTypeMap.keySet().stream().collect(Collectors.toList());
            if (i == 0) {
                int j = 0;
                while (j < numColumns) {
                    XSSFCell cell = titleRow.createCell(j);
                    cell.setCellValue((String)keyList.get(j));
                    ++j;
                }
            }
            ++i;
            while (rs.next()) {
                try {
                    XSSFRow dateRow = sheet.createRow(i);
                    int j = 0;
                    while (j < numColumns) {
                        XSSFCellStyle style = workBook.createCellStyle();
                        XSSFCell cell = dateRow.createCell(j);
                        String column = (String)keyList.get(j);
                        String fieldTypeAndcellStyleType = selectFieldsTypeMap.get(column);
                        int indexOf = fieldTypeAndcellStyleType.indexOf("_");
                        String fieldType = fieldTypeAndcellStyleType.substring(0, indexOf);
                        String cellStyleType = fieldTypeAndcellStyleType.substring(indexOf + 1, fieldTypeAndcellStyleType.length());
                        if ("Date".equals(fieldType)) {
                            Date date = rs.getDate(column);
                            style.setDataFormat(format.getFormat(cellStyleType));
                            cell.setCellStyle((CellStyle)style);
                            cell.setCellValue((java.util.Date)date);
                        } else if ("Number".equals(fieldType)) {
                            style.setDataFormat(format.getFormat(String.format(cellStyleType, " ")));
                            String value = rs.getString(column);
                            cell.setCellStyle((CellStyle)style);
                            if (cellStyleType.contains(".")) {
                                cell.setCellValue(Double.parseDouble(value));
                            } else {
                                cell.setCellValue((double)Integer.parseInt(value));
                            }
                        } else if ("String".equals(fieldType)) {
                            cell.setCellValue(rs.getString(column));
                        }
                        ++j;
                    }
                    ++i;
                }
                catch (Exception e) {
                    System.out.println();
                    logger.info((Object)("Excel file was created Error!" + e.getMessage()));
                }
            }
            try {
                ExportUtils.setResponseHeader(response, fileName);
                ServletOutputStream os = response.getOutputStream();
                workBook.write((OutputStream)os);
                workBook.close();
                os.flush();
                os.close();
                logger.info((Object)"Excel file was created successfully!");
            }
            catch (IOException e) {
                logger.info((Object)("Error while writing to file " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public static void setResponseHeader(HttpServletResponse response, String fileName) {
        try {
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

