/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.facade.employee;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.facade.employee.AbstractEmpPreEntryFacadeControllerBean;
import com.kingdee.eas.custom.utils.SendUtils;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryCollection;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillEntryInfo;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillFactory;
import com.kingdee.eas.hr.affair.EmpEnrollBizBillInfo;
import com.kingdee.eas.hr.affair.SourceBillTypeEnum;
import com.kingdee.eas.hr.base.AffairActionReasonCollection;
import com.kingdee.eas.hr.base.AffairActionReasonFactory;
import com.kingdee.eas.hr.base.ApproveTypeEnum;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.HRBizDefineCollection;
import com.kingdee.eas.hr.base.HRBizDefineFactory;
import com.kingdee.eas.hr.base.VariationReasonCollection;
import com.kingdee.eas.hr.base.VariationReasonFactory;
import com.kingdee.eas.hr.emp.CountryRegionCollection;
import com.kingdee.eas.hr.emp.CountryRegionFactory;
import com.kingdee.eas.hr.emp.CredentialsTypeFactory;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class EmpPreEntryFacadeControllerBean
extends AbstractEmpPreEntryFacadeControllerBean {
    private static final long serialVersionUID = -4572246200432035893L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.custom.facade.employee.EmpPreEntryFacadeControllerBean");

    @Override
    protected void _createEmpEnrollBizBill(Context ctx, String baseDate, String empNumber, String orgNumber) throws BOSException {
        baseDate = this.getYesterday(baseDate);
        logger.error((Object)("\u57fa\u51c6\u65e5\u671f" + baseDate));
        StringBuffer preEntrySql = new StringBuffer();
        preEntrySql.append(" select a.FCreatorID,a.Fid,a.FPositionID,CFLocalName_l2,CFSurname_l2,CFMiddleNames_l2,CFGivenName_l2,CFUserName_l2,a.FName_l2,a.FName_l1,a.FName_l3,CFEmpNumber,");
        preEntrySql.append(" FGender,FBirthday,FGlobalRoaming,FNCell,FEmail,CFWorkemail,FIDCardNO,CFDocumenttypeID,FPassportNO,");
        preEntrySql.append(" FPreEnterDate,CFTryMonth,CFTrialStartDate,CFTransferDate,CFEmpTypeID,CFPersontypeID,CFWcategoryID,");
        preEntrySql.append(" CFFtorptID,CFLmanagerID,CFAdmintitle,CFAcademictitleID,CFJobsID,CFWaitcontract,CFLegalemployer,");
        preEntrySql.append(" CFExpatriate,CFResident,CFPaycurrency,CFHwage,CFFsmentitlement,CFFsentitlement,CFFaentitlement,a.CFJobGradeID,a.CFRmethodID,a.CFCountryRegionID ");
        preEntrySql.append(" from T_HR_PreEntry as a ");
        preEntrySql.append(" left join T_HR_PreEntryPerson as b on a.FTALENTID  = b.fid\t");
        preEntrySql.append(" where fbillState = 3 and CFAutoConversion = 'Yes' and FIsGenerateEntryBill = 0 and FPREENTERDATE <= '" + baseDate + "'");
        if (StringUtils.isNotBlank((CharSequence)empNumber)) {
            preEntrySql.append(" a.CFEmpNumber = '" + empNumber + "' ");
        }
        if (StringUtils.isNotBlank((CharSequence)empNumber)) {
            preEntrySql.append(" a.orgNumber = (select fid from t_org_admin where fnumber = '" + empNumber + "') ");
        }
        logger.error((Object)("\u9884\u5165\u804csql\uff1a" + preEntrySql));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)preEntrySql.toString());
        try {
            if (rs.size() > 0) {
                this.createEmpEnrollBizBillInfo(ctx, rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String getYesterday(String baseDate) {
        if (StringUtils.isEmpty((CharSequence)baseDate)) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            baseDate = simpleDateFormat.format(calendar.getTime());
        }
        return baseDate;
    }

    private void createEmpEnrollBizBillInfo(Context ctx, IRowSet rs) throws SQLException {
        StringBuffer strBuffer = new StringBuffer();
        while (rs.next()) {
            try {
                CountryRegionCollection countryRegionCollection;
                logger.error((Object)("\u751f\u6210\u5165\u804c\u5355\uff1a" + rs.getString("CFEmpNumber")));
                EmpEnrollBizBillInfo empbizInfo = new EmpEnrollBizBillInfo();
                EmpEnrollBizBillEntryInfo empbizEntryInfo = new EmpEnrollBizBillEntryInfo();
                UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(rs.getString("FCreatorID")));
                logger.error((Object)("\u521b\u5efa\u7528\u6237\uff1a" + user.toString()));
                empbizInfo.setApplier(user.getPerson());
                empbizInfo.setApplyDate(new Date());
                PositionInfo positionInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionInfo((IObjectPK)new ObjectUuidPK(rs.getString("FPositionID")));
                AdminOrgUnitInfo adminInfo = positionInfo.getAdminOrgUnit();
                empbizInfo.setAdminOrg(adminInfo);
                empbizInfo.setHrOrgUnit(ContextUtil.getCurrentHRUnit((Context)ctx));
                empbizInfo.setBillState(HRBillStateEnum.AUDITED);
                empbizInfo.setApproveType(ApproveTypeEnum.DIRECT);
                empbizInfo.setBizDate(new Date());
                empbizInfo.setAuditor(user);
                empbizInfo.setIsMultiEntry(false);
                empbizInfo.setInnerState(0);
                empbizInfo.setIsMulti(false);
                empbizInfo.setUseDefault(true);
                empbizEntryInfo.put("localname", (Object)rs.getString("CFLocalName_l2"));
                empbizEntryInfo.put("surname", (Object)rs.getString("CFSurname_l2"));
                empbizEntryInfo.put("middleNames", (Object)rs.getString("CFMiddleNames_l2"));
                empbizEntryInfo.put("givenName", (Object)rs.getString("CFGivenName_l2"));
                empbizEntryInfo.put("userName", (Object)rs.getString("CFUserName_l2"));
                empbizEntryInfo.setEmpName(rs.getString("FName_l2"));
                empbizEntryInfo.setEmpName(rs.getString("FName_l1"), LocaleUtils.locale_l1);
                empbizEntryInfo.setEmpName(rs.getString("FName_l2"), LocaleUtils.locale_l2);
                empbizEntryInfo.setEmpName(rs.getString("FName_l3"), LocaleUtils.locale_l3);
                logger.error((Object)("\u82f1\u6587\u540d\uff1a" + empbizEntryInfo.getEmpName(Locale.ENGLISH) + ",\u4e2d\u6587\u540d\uff1a" + empbizEntryInfo.getEmpName(Locale.SIMPLIFIED_CHINESE) + ",\u540d\u79f0\uff1a" + empbizEntryInfo.getEmpName()));
                empbizEntryInfo.setEmpNumber(rs.getString("CFEmpNumber"));
                empbizEntryInfo.setGender(Genders.getEnum((int)rs.getInt("FGender")));
                empbizEntryInfo.setBirthday((Date)rs.getDate("FBirthday"));
                empbizEntryInfo.setGlobalRoaming(rs.getString("FGlobalRoaming"));
                empbizEntryInfo.setNCell(rs.getString("FNCell"));
                empbizEntryInfo.setEmail(rs.getString("CFWorkemail"));
                empbizEntryInfo.put("pemail", (Object)rs.getString("FEmail"));
                System.out.println("\u5de5\u4f5c\u90ae\u7bb1===" + empbizEntryInfo.getEmail());
                empbizEntryInfo.put("IDCardNo", (Object)rs.getString("FIDCardNO"));
                if (StringUtils.isNotBlank((CharSequence)rs.getString("CFDocumenttypeID"))) {
                    empbizEntryInfo.setCredentialsType(CredentialsTypeFactory.getLocalInstance((Context)ctx).getCredentialsTypeInfo((IObjectPK)new ObjectUuidPK(rs.getString("CFDocumenttypeID"))));
                }
                empbizEntryInfo.put("passPortNo", (Object)rs.getString("FPassportNO"));
                empbizEntryInfo.setPosition(positionInfo);
                if (positionInfo.getJob() != null && positionInfo.getJob().getId() != null) {
                    logger.error((Object)("\u5c97\u4f4d\u804c\u52a1\uff1a" + positionInfo.getJob().getName()));
                    empbizEntryInfo.setJob(positionInfo.getJob());
                }
                empbizEntryInfo.setAdminOrg(positionInfo.getAdminOrgUnit());
                empbizEntryInfo.setBizDate((Date)rs.getDate("FPreEnterDate"));
                empbizEntryInfo.setProbation(rs.getInt("CFTryMonth"));
                empbizEntryInfo.put("trialStartDate", (Object)rs.getDate("CFTrialStartDate"));
                empbizEntryInfo.setPlanFormalDate((Date)rs.getDate("CFTransferDate"));
                if (StringUtils.isNotBlank((CharSequence)rs.getString("CFEmpTypeID"))) {
                    empbizEntryInfo.setEmpType(EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeInfo((IObjectPK)new ObjectUuidPK(rs.getString("CFEmpTypeID"))));
                } else {
                    String paramStr = null;
                    paramStr = empbizEntryInfo.getProbation() > 0 ? "where number = '002'" : "where number = '001'";
                    EmployeeTypeCollection employeeType = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeCollection(paramStr);
                    empbizEntryInfo.setEmpType(employeeType.get(0));
                }
                empbizEntryInfo.put("persontype", (Object)rs.getString("CFPersontypeID"));
                empbizEntryInfo.put("wcategory", (Object)rs.getString("CFWcategoryID"));
                empbizEntryInfo.put("ftorpt", (Object)rs.getString("CFFtorptID"));
                empbizEntryInfo.put("lmanager", (Object)rs.getString("CFLmanagerID"));
                empbizEntryInfo.put("admintitle", (Object)rs.getString("CFAdmintitle"));
                empbizEntryInfo.put("academictitle", (Object)rs.getString("CFAcademictitleID"));
                empbizEntryInfo.put("jobs", (Object)rs.getString("CFJobsID"));
                empbizEntryInfo.put("waitcontract", (Object)rs.getString("CFWaitcontract"));
                empbizEntryInfo.put("legalemployer", (Object)rs.getString("CFLegalemployer"));
                empbizEntryInfo.put("Expatriate", (Object)rs.getString("CFExpatriate"));
                empbizEntryInfo.put("resident", (Object)rs.getString("CFResident"));
                empbizEntryInfo.put("paycurrency", (Object)rs.getString("CFPaycurrency"));
                empbizEntryInfo.put("hwage", (Object)rs.getString("CFHwage"));
                empbizEntryInfo.put("fsmentitlement", (Object)rs.getString("CFFsmentitlement"));
                empbizEntryInfo.put("fsentitlement", (Object)rs.getString("CFFsentitlement"));
                empbizEntryInfo.put("faentitlement", (Object)rs.getString("CFFaentitlement"));
                if (StringUtils.isNotBlank((CharSequence)rs.getString("CFJobGradeID"))) {
                    JobGradeInfo jobGradeInfo = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(rs.getString("CFJobGradeID")));
                    empbizEntryInfo.put("jobGrade", (Object)jobGradeInfo);
                }
                empbizEntryInfo.put("rmethod", (Object)rs.getString("CFRmethodID"));
                empbizEntryInfo.setEnrollAgain(false);
                HRBizDefineCollection hbdc = HRBizDefineFactory.getLocalInstance((Context)ctx).getHRBizDefineCollection(" where number = 'SHR01'");
                empbizEntryInfo.setHrBizDefine(hbdc.get(0));
                AffairActionReasonCollection affairActionReasonCollection = AffairActionReasonFactory.getLocalInstance((Context)ctx).getAffairActionReasonCollection(" where number = '0101'");
                empbizEntryInfo.setAffairActionReason(affairActionReasonCollection.get(0));
                VariationReasonCollection vrcs = VariationReasonFactory.getLocalInstance((Context)ctx).getVariationReasonCollection(" where number = 'RZ05'");
                empbizEntryInfo.setVariationReason(vrcs.get(0));
                empbizEntryInfo.put("PreEntryId", (Object)rs.getString("Fid"));
                empbizEntryInfo.setSourceBillType(SourceBillTypeEnum.PREENTRY);
                if (StringUtils.isNotBlank((CharSequence)rs.getString("CFCountryRegionID")) && (countryRegionCollection = CountryRegionFactory.getLocalInstance((Context)ctx).getCountryRegionCollection("where id = '" + rs.getString("CFCountryRegionID") + "'")) != null && countryRegionCollection.size() > 0) {
                    empbizEntryInfo.setCountryRegion(countryRegionCollection.get(0));
                }
                empbizInfo.getEntrys().add(empbizEntryInfo);
                logger.error((Object)("\u5355\u636e\u4fe1\u606f\uff1a" + empbizInfo.toString()));
                EmpEnrollBizBillInfo model = empbizInfo;
                IObjectPK bosid = EmpEnrollBizBillFactory.getLocalInstance((Context)ctx).submitEffect((CoreBaseInfo)model);
                EmpEnrollBizBillInfo empEnrollBizBillInfo = EmpEnrollBizBillFactory.getLocalInstance((Context)ctx).getEmpEnrollBizBillInfo(bosid);
                EmpEnrollBizBillEntryCollection entrys = empEnrollBizBillInfo.getEntrys();
                String personBillId = "";
                if (entrys.size() > 0) {
                    personBillId = entrys.get(0).getId().toString();
                }
                logger.error((Object)("\u751f\u6210\u5165\u804c\u5355\u6210\u529f\uff1a" + bosid));
                if (StringUtils.isEmpty((CharSequence)("" + bosid))) continue;
                StringBuffer upsql = new StringBuffer();
                upsql.append(" update T_HR_PreEntry set FCheckInState = '3',FIsGenerateEntryBill = '1',FPersonBillId = '" + personBillId + "' where FID = '" + rs.getString("Fid") + "'");
                logger.error((Object)("\u66f4\u65b0\u9884\u5165\u804c\u5355\u72b6\u6001\uff1a" + upsql));
                DbUtil.execute((Context)ctx, (String)upsql.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error((Object)(String.valueOf(rs.getString("CFEmpNumber")) + "\u751f\u6210\u5165\u804c\u5355\u5931\u8d25\uff1a" + e.getMessage()));
                strBuffer.append("Automatic onboarding of employee " + rs.getString("FName_l2") + "(" + rs.getString("CFEmpNumber") + ") failed. " + e.getMessage() + "\r\n");
            }
        }
        if (strBuffer.length() > 0) {
            try {
                strBuffer.append("Please check the data, or contact the system administrator with itsupport@gtiit.edu.cn.");
                HashSet<String> userIdSet = new HashSet<String>();
                String roleSql = "select c.fid from T_WFR_WFROLE a left join T_WFR_PERSONROLE b on a.fid=b.froleid left join T_PM_USER c on b.FPSERSONID = c.FPERSONID where a.FNUMBER in ('105') and c.fid is not null";
                logger.error((Object)("\u83b7\u53d6\u5de5\u4f5c\u6d41\u89d2\u8272\u5bf9\u5e94\u7528\u6237SQL\uff1a" + roleSql));
                IRowSet roleRow = DbUtil.executeQuery((Context)ctx, (String)roleSql);
                try {
                    while (roleRow.next()) {
                        userIdSet.add(roleRow.getString("fid"));
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                logger.error((Object)("\u7528\u6237ID\u96c6\u5408\uff1a" + ((Object)userIdSet).toString()));
                if (userIdSet.size() == 0) {
                    return;
                }
                List list = userIdSet.stream().collect(Collectors.toList());
                SendUtils.msgGroupSend(ctx, "Notification of automatic onboarding failure", 20, false, strBuffer.toString(), list, 2, null);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }
}

