/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.facade.worktime;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.facade.worktime.AbstractDepartStatusFacadeControllerBean;
import com.kingdee.eas.custom.utils.SendUtils;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class DepartStatusFacadeControllerBean
extends AbstractDepartStatusFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.custom.facade.worktime.DepartStatusFacadeControllerBean");

    @Override
    protected void _departStatus(Context ctx) throws BOSException {
        String title = "Notification of Approver Resignation";
        String content = this.getContent(ctx);
        try {
            IRowSet recipientRowSet = this.getRecipient(ctx);
            while (recipientRowSet.next()) {
                SendUtils.msgSend(ctx, title, 20, false, content, recipientRowSet.getString("FPSERSONID"), 2, null, null, MimeTypeEnum.HTML);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public IRowSet getApproved(Context ctx) {
        Date nowDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String strDate = sdf.format(nowDate);
        StringBuffer approvedSql = new StringBuffer();
        approvedSql.append("SELECT c.fid as personid,c.fnumber as personnumber,c.fname_l1 as name FROM T_HR_EmpLaborRelationHis a left join  T_HR_BDEmployeeType b on a.FLaborRelationStateID=b.fid left join t_bd_person c on a.FPersonID=c.fid");
        approvedSql.append(" where b.FinService in('2') and a.FPersonID in (SELECT FPERSONEMPID FROM T_WFR_Assign) and ");
        approvedSql.append("a.FStartDateTime <= '" + strDate + "'");
        approvedSql.append(" and FEndDateTime>='" + strDate + "'");
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)approvedSql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public Map<String, String> getCountBill(Context ctx) {
        HashSet<String> departSet = new HashSet<String>();
        HashMap<String, String> approvedMap = new HashMap<String, String>();
        IRowSet approvedRowSet = this.getApproved(ctx);
        try {
            while (approvedRowSet.next()) {
                departSet.add(approvedRowSet.getString("personid"));
            }
            StringBuffer countBillSql = new StringBuffer();
            countBillSql.append("SELECT count(*) as count, FPERSONEMPID  FROM  T_WFR_Assign  ");
            if (!departSet.isEmpty()) {
                countBillSql.append(" where FPERSONEMPID in (");
                for (String depart : departSet) {
                    countBillSql.append("'");
                    countBillSql.append(depart);
                    countBillSql.append("'");
                    countBillSql.append(",");
                }
                countBillSql.deleteCharAt(countBillSql.length() - 1);
                countBillSql.append(")");
            }
            countBillSql.append(" group by FPERSONEMPID");
            IRowSet countRowSet = DbUtil.executeQuery((Context)ctx, (String)countBillSql.toString());
            while (countRowSet.next()) {
                approvedMap.put(countRowSet.getString("FPERSONEMPID"), countRowSet.getString("count"));
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return approvedMap;
    }

    public IRowSet getRecipient(Context ctx) {
        String sql = "SELECT a.FPSERSONID FROM T_WFR_PERSONROLE a left join T_WFR_WFROLE b on a.FROLEID=b.fid where b.FNUMBER='107'";
        IRowSet reRowSet = null;
        try {
            reRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return reRowSet;
    }

    public String getContent(Context ctx) {
        StringBuffer content = new StringBuffer();
        content.append("<html><head></head><body>");
        content.append("<span>Dear HR and IT:</span><br>");
        content.append("<span></span><br>");
        content.append("<span>The following employees are inactive in HR system but there are still some workflows waiting for their approval.</span><br>");
        content.append("<span></span><br>");
        content.append("<span>If the person will be rehired soon, you can ignore this message.After the rehire is finished, the workflow will be normal.</span><br>");
        content.append("<span></span><br>");
        content.append("<span>If the person will not be rehired soon, you need to identify the new approver and notify the system administrator to manually assign the workflow to the new approver.</span><br>");
        content.append("<span></span><br>");
        content.append("<table border='1' cellspacing='0' style='border:solid 1px #E8F2F9;font-size=8px;;font-size:10px;'>");
        content.append("<tr style='background-color: #428BCA; color:#ffffff'><th>Person Number</th><th>Name</th><th>Document quantity</th></tr>");
        IRowSet approvedRowSet = this.getApproved(ctx);
        Map<String, String> countBillMap = this.getCountBill(ctx);
        try {
            approvedRowSet.beforeFirst();
            while (approvedRowSet.next()) {
                String personId = approvedRowSet.getString("personid");
                if (!countBillMap.containsKey(personId)) continue;
                content.append("<tr>");
                content.append("<td>" + approvedRowSet.getString("personnumber") + "</td>");
                content.append("<td>" + approvedRowSet.getString("name") + "</td>");
                content.append("<td>" + countBillMap.get(personId) + "</td>");
                content.append("</tr>");
                countBillMap.remove(personId);
            }
            content.append("</body></html>");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return content.toString();
    }
}

