/*
 * Decompiled with CFR 0.152.
 */
package com.customer.controller;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.ctrl.swing.StringUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerFactory.getLogger(TokenAuthServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("into.TokenAuthServlet.doGet");
        String token = request.getParameter("token");
        this.logger.info("into.TokenAuthServlet.doGet.token:" + token);
        String appid = request.getParameter("appid");
        this.logger.info("into.TokenAuthServlet.doGet.appid:" + appid);
        String secret = request.getParameter("secret");
        this.logger.info("into.TokenAuthServlet.doGet.secret:" + secret);
        Map<String, String> result = null;
        try {
            result = this.getLoginInfoByToken(token, appid, secret);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("getLoginInfoByToken\u5f02\u5e38\uff1a" + e.getMessage());
            throw new ServletException();
        }
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json; charset=utf-8");
        response.getWriter().write(JSON.toJSONString(result));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public Map<String, String> getLoginInfoByToken(String token, String appid, String secret) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        this.logger.info("getLoginInfoByToken.token=" + token);
        String userNumber = "";
        try {
            userNumber = this.decrypt_Base64(token);
        }
        catch (Exception e) {
            this.logger.error("encryptUserInfo encrypt_Base64 Exception\uff1a" + e.getMessage());
            e.printStackTrace();
            throw new Exception("AD\u57df\u89e3\u5bc6\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.logger.info("getLoginInfoByToken.userNumber=" + userNumber);
        resultMap.put("status", "0");
        resultMap.put("message", userNumber);
        return resultMap;
    }

    private String decrypt_Base64(String str) throws Exception {
        this.logger.info("decrypt_Base64.str=" + str);
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        String sDecode = URLDecoder.decode(str, "UTF-8");
        this.logger.info("decrypt_Base64.sDecode=" + sDecode);
        byte[] asBytes = Base64.getDecoder().decode(sDecode);
        String result = new String(asBytes, "UTF-8");
        return result;
    }

    private int getDeviceType(String requestHeader) {
        if (requestHeader.indexOf("Android") != -1) {
            return 1;
        }
        if (requestHeader.indexOf("iPhone") != -1 || requestHeader.indexOf("iPad") != -1) {
            return 2;
        }
        return 3;
    }

    public final void getKK(String requestHeader) {
        int type = this.getDeviceType(requestHeader);
        if (type == 1 || type == 2) {
            // empty if block
        }
    }
}

