/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemDataType;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.integrate.DateTypeEnum;
import com.kingdee.shr.compensation.app.integrate.SubmitElementCollection;
import com.kingdee.shr.compensation.app.integrate.SubmitElementFactory;
import com.kingdee.shr.compensation.app.integrate.SubmitElementInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalFunctionIntegrateServiceEx
extends SalaryCalFunction {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.service.CalFunctionIntegrateServiceEx");

    public double getTransferSalaryData(Map paramMap, HashMap tempMap, Map<String, BigDecimal> currencyMap, CalSchemeInfo calScheme, String mainTableRowFilter, String calSubmitScheme, String calSubmitItem, String company, double needSubOrg, String beginDate, String endDate, String hrNum) {
        String key = "TransferSalaryEx:" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + calSubmitItem + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate;
        String relyKey = "TransferSalaryEx-" + calScheme.getNumber() + "-" + calSubmitScheme + "-" + calSubmitItem + "-" + company + "-" + needSubOrg + beginDate + "-" + endDate + "-" + "Rely";
        Map salaryMap = new HashMap();
        String calItem = (String)paramMap.get("CALITEM");
        if (tempMap.get(key) == null) {
            String personFilter = this.getPersonFilterSql(calScheme, company, needSubOrg, beginDate, endDate, mainTableRowFilter);
            logger.error((Object)("personFilter=====" + personFilter));
            HashMap<String, Object> methodParamMap = new HashMap<String, Object>();
            methodParamMap.put("calSubmitScheme", calSubmitScheme);
            methodParamMap.put("calSubmitItem", calSubmitItem);
            methodParamMap.put("personFilter", personFilter);
            methodParamMap.put("key", key);
            methodParamMap.put("relyKey", relyKey);
            methodParamMap.put("isNumber", true);
            methodParamMap.put("isCycleScheme", false);
            this.combineTransSalaryData(tempMap, currencyMap, methodParamMap, hrNum);
        }
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        logger.error((Object)("key==" + key));
        logger.error((Object)("personId==" + personId));
        salaryMap = (Map)tempMap.get(key);
        logger.error((Object)("salaryMap==" + salaryMap));
        this.putSubmitDataToParam(paramMap, tempMap, calItem, relyKey);
        logger.error((Object)("salaryMap.containsKey(personId)=" + salaryMap.containsKey(personId)));
        logger.error((Object)("((salaryMap.containsKey(personId)) ? EmptyUtil.isEmpty(salaryMap.get(personId))?0.0D:((BigDecimal)salaryMap.get(personId)).doubleValue() : 0.0D)==" + (salaryMap.containsKey(personId) ? (EmptyUtil.isEmpty(salaryMap.get(personId)) ? 0.0 : ((BigDecimal)salaryMap.get(personId)).doubleValue()) : 0.0)));
        return salaryMap.containsKey(personId) ? (EmptyUtil.isEmpty(salaryMap.get(personId)) ? 0.0 : ((BigDecimal)salaryMap.get(personId)).doubleValue()) : 0.0;
    }

    private String getPersonFilterSql(CalSchemeInfo calScheme, String company, double needSubOrg, String beginDate, String endDate, String mainTableRowFilter) {
        String calschemeid = calScheme.getId().toString();
        int calTime = calScheme.getCalTime();
        int periodYear = calScheme.getPeriodYear();
        int periodMonth = calScheme.getPeriodMonth();
        boolean haveSubOrg = 1.0 == needSubOrg;
        String salaryPeriod = periodYear + "-" + periodMonth + "-" + calTime;
        String beginDateSql = "{ts '" + beginDate + "'}";
        String endDateSql = "{ts '" + endDate + "'}";
        StringBuilder str = new StringBuilder();
        str.append(" select FPersonID from T_HR_SCmpCalTable where FcalSchemeID = '").append(calschemeid).append("' ");
        str.append(" and FperiodYear = ").append(periodYear);
        str.append(" and FperiodMonth = ").append(periodMonth);
        str.append(" and FcalTime = ").append(calTime);
        if (!StringUtils.isEmpty((String)mainTableRowFilter)) {
            str.append(" and ").append(mainTableRowFilter);
        }
        String personSql = str.toString();
        String adminOrgSql = this.getAdminOrgIdFilterSql(company, haveSubOrg);
        str = new StringBuilder();
        str.append(" WHERE ").append(adminOrgSql);
        str.append(" AND FPERSONID  IN ( " + personSql + " )");
        str.append(" AND FEFFECTDATE >= ").append(beginDateSql);
        str.append(" AND FEFFECTDATE <= ").append(endDateSql);
        str.append(" AND FCALSTATE = '03' ");
        str.append(" AND FSALARYPERIOD ='").append(salaryPeriod).append("'");
        return str.toString();
    }

    private void combineTransSalaryData(HashMap tempMap, Map<String, BigDecimal> currencyMap, Map<String, Object> methodParamMap, String hrNum) {
        Set<String> schemeItemSet;
        String calSubmitScheme = (String)methodParamMap.get("calSubmitScheme");
        String calSubmitItem = (String)methodParamMap.get("calSubmitItem");
        String personFilter = (String)methodParamMap.get("personFilter");
        String key = (String)methodParamMap.get("key");
        String relyKey = (String)methodParamMap.get("relyKey");
        Boolean isNumber = (Boolean)methodParamMap.get("isNumber");
        Boolean isCycleScheme = (Boolean)methodParamMap.get("isCycleScheme");
        Boolean isDate = (Boolean)methodParamMap.get("isDate");
        Boolean dateTypeToDay = (Boolean)methodParamMap.get("dateTypeToDay");
        Context ctx = Tools.getInstance().getCtx();
        HashMap<String, Object> salaryMap = new HashMap<String, Object>();
        HashMap relyMap = new HashMap();
        List relyList = new ArrayList();
        String calItem = (String)this.paramMap.get("CALITEM");
        ArrayList schemeTableNameList = this.initSubmitSchemeTable(ctx, tempMap, calSubmitItem);
        if (EmptyUtil.isEmpty((Collection)schemeTableNameList)) {
            tempMap.put(key, salaryMap);
            return;
        }
        CalSubmitItemInfo itemInfo = this.initSubmitItem(ctx, tempMap, calSubmitItem);
        if (itemInfo == null) {
            tempMap.put(key, salaryMap);
            return;
        }
        String itemSn = "S" + itemInfo.getFieldSn();
        String itemDatatTypeValue = itemInfo.getDataType().getValue();
        DecimalFormat df = new DecimalFormat(itemInfo.getDataDot() == null ? "0" : itemInfo.getDataDot().toString());
        DateTypeEnum dateTypeEnum = itemInfo.getDateType();
        if (itemDatatTypeValue != null && "2".equals(itemDatatTypeValue)) {
            isDate = true;
            if (dateTypeEnum != null && 10 == dateTypeEnum.getValue()) {
                dateTypeToDay = true;
            }
        }
        if (!(schemeItemSet = this.initSchemeItem(ctx, tempMap, calSubmitItem)).contains(itemInfo.getFieldSn() + "")) {
            tempMap.put(key, salaryMap);
            return;
        }
        StringBuilder str = new StringBuilder();
        str.append("/*dialect*/ select t.fbillid,t.FPERSONID,t.FSALARYPERIOD,t.FID,t.FCURRENCYID, ").append("t." + itemSn).append("  from (");
        int i = 0;
        while (i < schemeTableNameList.size()) {
            str = str.append(" SELECT fbillid,FPERSONID,FSALARYPERIOD,FID,FCURRENCYID,").append(itemSn);
            str = str.append(" FROM ").append(schemeTableNameList.get(i)).append(" t ");
            str.append(personFilter);
            if (isCycleScheme.booleanValue()) {
                str = str.append(" ORDER BY t.FTransYear desc,t.FTransMonth desc, t.FTransTime desc,t.FPERSONID, t.FEFFECTDATE DESC, t.FCREATETIME DESC ");
            } else if (!isNumber.booleanValue()) {
                str = str.append(" ORDER BY t.FPERSONID, t.FEFFECTDATE DESC, t.sFCREATETIME DESC ");
            }
            if (schemeTableNameList.size() > 1 && i != schemeTableNameList.size() - 1) {
                str = str.append(" union all");
            }
            ++i;
        }
        str.append(") as t ");
        str = str.append(" left join  T_HR_SBatchSubmitShemeBill   t1  on t.fbillid = t1.fid ");
        str = str.append(" left join  T_ORG_BaseUnit   t2  on t1.FHrOrgUnitID = t2.fid ");
        str.append(" where  nvl(t2.fnumber,'##') ='" + hrNum + "' ");
        logger.error((Object)("temp_table_sql ===== " + str.toString()));
        SimpleDateFormat yearMonthFormat = new SimpleDateFormat("yyyy-MM");
        SimpleDateFormat yearMonthDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            logger.error((Object)("sql====" + str.toString()));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
            String moneyStr = "";
            while (rowSet.next()) {
                BigDecimal money;
                java.util.Date utilDate;
                Date date;
                BigDecimal rate;
                BigDecimal money2;
                String currencyId;
                String personId = rowSet.getString("FPersonID");
                logger.error((Object)("isCycleScheme ===== " + isCycleScheme));
                HashMap<String, Object> personRelyMap = new HashMap<String, Object>();
                personRelyMap.put("SUBMITITEMID", null);
                personRelyMap.put("SUBMITITEMTABLE", null);
                if (isCycleScheme.booleanValue()) {
                    if (isNumber.booleanValue()) {
                        currencyId = rowSet.getString("FCURRENCYID");
                        money2 = rowSet.getBigDecimal(itemSn);
                        personRelyMap.put("SUBMITMONEY", df.format(money2.doubleValue()));
                        BigDecimal bigDecimal = rate = currencyMap.get(currencyId) == null ? new BigDecimal(1) : currencyMap.get(currencyId);
                        if (salaryMap.containsKey(personId)) continue;
                        salaryMap.put(personId, money2.multiply(rate));
                    } else {
                        if (isDate != null && isDate.booleanValue()) {
                            date = rowSet.getDate(itemSn);
                            if (date != null) {
                                utilDate = new java.util.Date(date.getTime());
                                moneyStr = dateTypeToDay != null && dateTypeToDay.booleanValue() ? yearMonthDateFormat.format(utilDate) : yearMonthFormat.format(utilDate);
                            } else {
                                moneyStr = "";
                            }
                        } else {
                            String string = moneyStr = rowSet.getString(itemSn) == null ? "" : rowSet.getString(itemSn);
                            if ("0".equals(itemDatatTypeValue)) {
                                boolean isSQLServerDB;
                                money = rowSet.getBigDecimal(itemSn);
                                moneyStr = money == null ? "" : ((isSQLServerDB = "MS SQL Server".equalsIgnoreCase(ContextUtil.getDbType((Context)ctx))) ? df.format(money.doubleValue()) : (rowSet.getString(itemSn) == null ? "" : rowSet.getString(itemSn)));
                            }
                        }
                        personRelyMap.put("SUBMITMONEY", moneyStr);
                        if (salaryMap.containsKey(personId)) continue;
                        salaryMap.put(personId, moneyStr);
                    }
                } else if (isNumber.booleanValue()) {
                    currencyId = rowSet.getString("FCURRENCYID");
                    money2 = EmptyUtil.isEmpty((Object)rowSet.getBigDecimal(itemSn)) ? BigDecimal.ZERO : rowSet.getBigDecimal(itemSn);
                    logger.error((Object)("money====" + money2));
                    personRelyMap.put("SUBMITMONEY", df.format(money2.doubleValue()));
                    rate = currencyMap.get(currencyId) == null ? new BigDecimal(1) : currencyMap.get(currencyId);
                    BigDecimal sum = salaryMap.get(personId) == null ? money2.multiply(rate) : ((BigDecimal)salaryMap.get(personId)).add(money2.multiply(rate));
                    salaryMap.put(personId, sum);
                } else {
                    if (isDate != null && isDate.booleanValue()) {
                        date = rowSet.getDate(itemSn);
                        if (date != null) {
                            utilDate = new java.util.Date(date.getTime());
                            moneyStr = dateTypeToDay != null && dateTypeToDay.booleanValue() ? yearMonthDateFormat.format(utilDate) : yearMonthFormat.format(utilDate);
                        } else {
                            moneyStr = "";
                        }
                    } else {
                        String string = moneyStr = rowSet.getString(itemSn) == null ? "" : rowSet.getString(itemSn);
                        if ("0".equals(itemDatatTypeValue)) {
                            boolean isSQLServerDB;
                            money = rowSet.getBigDecimal(itemSn);
                            moneyStr = money == null ? "" : ((isSQLServerDB = "MS SQL Server".equalsIgnoreCase(ContextUtil.getDbType((Context)ctx))) ? df.format(money.doubleValue()) : (rowSet.getString(itemSn) == null ? "" : rowSet.getString(itemSn)));
                        }
                    }
                    personRelyMap.put("SUBMITMONEY", moneyStr);
                    if (salaryMap.containsKey(personId)) continue;
                    salaryMap.put(personId, moneyStr);
                }
                personRelyMap.put("SUBMITTABLE", schemeTableNameList.get(0));
                personRelyMap.put("SUBMITTABLEID", rowSet.getString("FID"));
                personRelyMap.put("CALITEM", calItem);
                personRelyMap.put("SUBMITNUMBER", calSubmitItem);
                personRelyMap.put("ISBASIC", 0);
                relyList = relyMap.containsKey(personId) ? (List)relyMap.get(personId) : new ArrayList();
                relyList.add(personRelyMap);
                relyMap.put(personId, relyList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tempMap.put(key, salaryMap);
        tempMap.put(relyKey, relyMap);
    }

    private void putSubmitDataToParam(Map paramMap, HashMap tempMap, String calItem, String relyKey) {
        String personId = (String)paramMap.get("T_HR_SCMPCALTABLE_FPERSONID");
        List relyList = new ArrayList();
        Map relyMap = (Map)tempMap.get(relyKey);
        if (relyMap == null || !relyMap.containsKey(personId)) {
            return;
        }
        if (paramMap.containsKey("SUBMITRELY")) {
            Map paramRelayMap = (Map)paramMap.get("SUBMITRELY");
            if (paramRelayMap.containsKey(calItem)) {
                relyList = (List)paramRelayMap.get(calItem);
                relyList.addAll((Collection)relyMap.get(personId));
            } else {
                paramRelayMap.put(calItem, relyMap.get(personId));
            }
        } else {
            HashMap paramRelayMap = new HashMap();
            paramRelayMap.put(calItem, relyMap.get(personId));
            paramMap.put("SUBMITRELY", paramRelayMap);
        }
    }

    public String getAdminOrgIdFilterSql(String companyNum, boolean haveSubOrg) {
        String adminOrgUnitId;
        String companyLongNumber;
        StringBuffer sqlBuffer;
        block7: {
            Context ctx = Tools.getInstance().getCtx();
            sqlBuffer = new StringBuffer();
            String queryOrg = "SELECT FLONGNUMBER,FID FROM T_ORG_ADMIN WHERE FNUMBER = '" + companyNum + "'";
            companyLongNumber = "";
            adminOrgUnitId = "";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)queryOrg);
            while (executeQuery.next()) {
                companyLongNumber = executeQuery.getString("fLongNumber");
                adminOrgUnitId = executeQuery.getString("fid");
            }
            if (!StringUtils.isEmpty((String)companyLongNumber)) break block7;
            return null;
        }
        try {
            if (haveSubOrg) {
                sqlBuffer.append(" FADMINORGUNITID IN (SELECT FID FROM T_ORG_ADMIN WHERE FLONGNUMBER LIKE '" + companyLongNumber + "%')");
            } else {
                sqlBuffer.append(" FADMINORGUNITID IN ('" + adminOrgUnitId + "')");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sqlBuffer.toString();
    }

    public static List<String> getCalShemeTableName(Context ctx, String calSubmitSchemeNum, String calSubmitItemNum) {
        ArrayList<String> list = new ArrayList<String>();
        String sql = "Select n.FCalShemeTableName, m.fieldSn  from  T_HR_SCalSubmitScheme e  inner join T_HR_SCalShemeTableRelation n on n.FSubmitSchemeID = e.fid   inner join T_HR_SCalSubmitSchemeItem sm on sm.FCalSubmitSchemeID = e.fid   inner join T_HR_SCalSubmitItem m on m.fid = sm.FCalSubmitItemID  where e.FNumber = '" + calSubmitSchemeNum + "' and m.FNumber =  '" + calSubmitItemNum + "'  ";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                list.add(rs.getString("FCalShemeTableName"));
                list.add("S" + rs.getString("fieldSn"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public ArrayList initSubmitSchemeTable(Context ctx, HashMap tempMap, String schemeNumber) {
        String key = "CALFUNCTIONINTEGRATESERVICE_SCHEMETABLE_EXT_" + schemeNumber;
        ArrayList<String> list = new ArrayList<String>();
        Map<String, String> schemeMap = new HashMap();
        if (tempMap.get(key) == null) {
            StringBuilder str = new StringBuilder();
            str.append(" SELECT REL.FCALSHEMETABLENAME PROPERTYTABLE, REL.FBILLENTRYTABLENAME DATATABLE, SCHEME.FNUMBER ");
            str.append(" FROM T_HR_SCALSHEMETABLERELATION REL ");
            str.append(" INNER JOIN T_HR_SCALSUBMITSCHEME SCHEME ON REL.FSUBMITSCHEMEID = SCHEME.FID ");
            str.append(" INNER JOIN T_HR_SCALSUBMITSCHEMEITEM SCHEMEITEM ON SCHEME.FID = SCHEMEITEM.FCALSUBMITSCHEMEID ");
            str.append(" INNER JOIN T_HR_SCALSUBMITITEM ITEM ON ITEM.FID = SCHEMEITEM.FCALSUBMITITEMID ");
            str.append(" where ITEM.fnumber ='" + schemeNumber + "' ");
            logger.error((Object)("initSubmitSchemeTable=====" + str.toString()));
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    schemeMap.put(rowSet.getString("FNUMBER"), rowSet.getString("DATATABLE"));
                    list.add(rowSet.getString("DATATABLE"));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(key, schemeMap);
        } else {
            schemeMap = (Map)tempMap.get(key);
        }
        return list;
    }

    public SubmitElementInfo initElementItem(Context ctx, HashMap tempMap, String elementItemNum) {
        String key = "INITELEMENTITEM_SERVICE_SUBMITITEM";
        Map<String, SubmitElementInfo> itemMap = new HashMap();
        if (tempMap.get(key) == null) {
            SubmitElementCollection itemColl = null;
            try {
                itemColl = SubmitElementFactory.getLocalInstance((Context)ctx).getSubmitElementCollection("select id, number, name ");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < itemColl.size()) {
                SubmitElementInfo submitElementInfo = itemColl.get(i);
                itemMap.put(submitElementInfo.getNumber(), submitElementInfo);
                ++i;
            }
            tempMap.put(key, itemMap);
        } else {
            itemMap = (Map)tempMap.get(key);
        }
        SubmitElementInfo submitElementInfo = (SubmitElementInfo)itemMap.get(elementItemNum);
        if (submitElementInfo == null) {
            return null;
        }
        return (SubmitElementInfo)itemMap.get(elementItemNum);
    }

    public CalSubmitItemInfo initSubmitItem(Context ctx, HashMap tempMap, String itemNumber) {
        String key = "CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_EXT_" + itemNumber;
        String basicItemKey = "CALFUNCTIONINTEGRATESERVICE_SUBMITITEM_" + itemNumber;
        Map<String, CalSubmitItemInfo> itemMap = new HashMap();
        if (tempMap.get(key) == null) {
            CalSubmitItemCollection itemColl = null;
            try {
                itemColl = CalSubmitItemFactory.getLocalInstance((Context)ctx).getCalSubmitItemCollection("select id, fieldSn, number, dateType, dataType,dataDot,filterField.entityName ");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            int i = 0;
            while (i < itemColl.size()) {
                CalSubmitItemInfo calSubmitItemInfo = itemColl.get(i);
                itemMap.put(calSubmitItemInfo.getNumber(), calSubmitItemInfo);
                ++i;
            }
            tempMap.put(key, itemMap);
        } else {
            itemMap = (Map)tempMap.get(key);
        }
        CalSubmitItemInfo calSubmitItemInfo = (CalSubmitItemInfo)itemMap.get(itemNumber);
        if (calSubmitItemInfo == null) {
            return null;
        }
        if (calSubmitItemInfo.getDataType().equals((Object)CalSubmitItemDataType.F7) && tempMap.get(basicItemKey) == null) {
            HashMap<String, String> basicItemMap = new HashMap<String, String>();
            String entityName = calSubmitItemInfo.getFilterField().getEntity();
            MetaDataPK meataDataPk = MetaDataPK.create((String)entityName);
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity((IMetaDataPK)meataDataPk);
            String tableName = entityInfo.getTable().getName();
            String sql = "SELECT FID, FNUMBER FROM " + tableName;
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rowSet.next()) {
                    basicItemMap.put(rowSet.getString("FNUMBER"), rowSet.getString("FID") + "###" + rowSet.getString("FNUMBER"));
                }
                basicItemMap.put("TABLENAME", tableName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            tempMap.put(basicItemKey, basicItemMap);
        }
        return (CalSubmitItemInfo)itemMap.get(itemNumber);
    }

    public Set<String> initSchemeItem(Context ctx, HashMap tempMap, String schemeNumber) {
        String key = "CALFUNCTIONINTEGRATESERVICE_SCHEMEITEM";
        HashSet<String> itemSet = new HashSet<String>();
        Map schemeItemMap = new HashMap();
        if (tempMap.get(key) == null) {
            StringBuilder str = new StringBuilder();
            str.append(" SELECT ITEM.FNUMBER, ITEM.FIELDSN ");
            str.append(" FROM T_HR_SCALSUBMITSCHEME SCHEME ");
            str.append(" INNER JOIN T_HR_SCALSUBMITSCHEMEITEM SCHEMEITEM ON SCHEME.FID = SCHEMEITEM.FCALSUBMITSCHEMEID ");
            str.append(" INNER JOIN T_HR_SCALSUBMITITEM ITEM ON ITEM.FID = SCHEMEITEM.FCALSUBMITITEMID ");
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
                while (rowSet.next()) {
                    String number = rowSet.getString("FNUMBER");
                    if (schemeItemMap.containsKey(number)) {
                        ((Set)schemeItemMap.get(number)).add(rowSet.getString("FIELDSN"));
                    }
                    itemSet = new HashSet();
                    itemSet.add(rowSet.getString("FIELDSN"));
                    schemeItemMap.put(number, itemSet);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            schemeItemMap = (Map)tempMap.get(key);
        }
        return schemeItemMap.containsKey(schemeNumber) ? (Set)schemeItemMap.get(schemeNumber) : new HashSet();
    }
}

