/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.facade.leave;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.bd.param.ParamCollection;
import com.kingdee.eas.custom.bd.param.ParamFactory;
import com.kingdee.eas.custom.facade.leave.AbstractLeaveAllowanceFacadeControllerBean;
import com.kingdee.eas.custom.facade.leave.LeaveAllowanceFacadeFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.HolidayLimitFactory;
import com.kingdee.eas.hr.ats.HolidayLimitInfo;
import com.kingdee.eas.hr.ats.HolidayLimitStatus;
import com.kingdee.eas.hr.ats.HolidayPolicyCollection;
import com.kingdee.eas.hr.ats.HolidayPolicyFactory;
import com.kingdee.eas.hr.ats.HolidayPolicyInfo;
import com.kingdee.eas.hr.ats.HolidayTypeCollection;
import com.kingdee.eas.hr.ats.HolidayTypeFactory;
import com.kingdee.eas.hr.ats.HolidayTypeUnitEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class LeaveAllowanceFacadeControllerBean
extends AbstractLeaveAllowanceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.custom.facade.leave.LeaveAllowanceFacadeControllerBean");
    private static final String WC_General_Administrative_Staff = "General Administrative Staff";
    private static final String WC_Professional_Supervisory_Staff = "Professional Supervisory Staff";
    private static final String WC_Senior_Administrative_Staff = "Senior Administrative Staff";
    private static final String WC_Academic_Staff = "Academic Staff";
    private static final String WC_Others = "Others";
    private static final int IV_General_Administrative_Staff = 12;
    private static final int IV_Professional_Supervisory_Staff = 15;
    private static final int IV_Senior_Administrative_Staff = 18;
    private static final int IV_Year = 2;
    private static final int IV_YearAddValue = 1;
    private static final int IV_MAXADD = 8;
    private static final int MONTH_NUM_12 = 12;
    private static final String PARAM_ANNUALLEAVE_CONVERSIONMETHOD = "param_001";
    private static final String PARAM_ANNUALLEAVE_INTEGERMETHOD = "param_002";
    private static final String PARAM_ANNUALLEAVE_INTEGERPERCISION = "param_003";
    private static final String PARAM_ANNUALLEAVE_CONVERTDATE = "param_004";
    private static final String PARAM_ANNUALLEAVE_GENERATEDAY = "param_005";
    private static final String PARAM_NURSINGLEAVE_LIMIT = "param_006";
    private static final String PARAM_PARENTALLEAVE_LIMIT = "param_007";
    private static final String PARAM_NURSINGANDPARENTALLEAVE_CONVERSIONMETHOD = "param_008";
    private static final String PARAM_NURSINGANDPARENTALLEAVE_INTEGERMETHOD = "param_009";
    private static final String PARAM_NURSINGANDPARENTALLEAVE_INTEGERPERCISION = "param_010";
    private static final String PARAM_NURSINGANDPARENTALLEAVE_UPDATESQL = "param_011";
    private static final String CONVERSIONMETHOD_BYDAY = "D";
    private static final String CONVERSIONMETHOD_BYMONTH = "M";
    private static final String INTEGERMETHOD_UP = "U";
    private static final String INTEGERMETHOD_DOWN = "D";
    private static final double INTEGERPERCISION_HALF = 0.5;
    private static final double INTEGERPERCISION_ONE = 1.0;
    private static String annualLeaveConversionMethod;
    private static String annualLeaveIntegerMethod;
    private static double annualLeaveIntegerPrecision;
    private static String annualLeaveConvertDate;
    private static String annualLeaveGenerateDay;
    private static int nursingLeaveLimit;
    private static int parentalLeaveLimit;
    private static String nursingAndParentalLeaveConversionMethod;
    private static String nursingAndParentalLeaveIntegerMethod;
    private static double nursingAndParentalLeaveIntegerPrecision;
    private static String nursingAndParentalLeaveUpdateSql;

    @Override
    protected void _createAnnualLeave(Context ctx, int year, String personNum) throws BOSException {
        try {
            this.initialGlobalParam(ctx);
            Boolean isGenerateNextYearAnnualLeave = false;
            java.util.Date currentDate = new java.util.Date();
            if (year != 0) {
                currentDate = DateTimeUtils.parseDate((String)(year + "-12-31"));
            } else {
                year = DateTimeUtils.getYear((java.util.Date)currentDate);
                java.util.Date annualLeaveGenerateDay = DateTimeUtils.parseDate((String)(year + "-" + LeaveAllowanceFacadeControllerBean.annualLeaveGenerateDay));
                if (currentDate.getTime() >= annualLeaveGenerateDay.getTime()) {
                    isGenerateNextYearAnnualLeave = true;
                }
            }
            this.generateAnnualLeave(ctx, year, personNum, currentDate);
            if (isGenerateNextYearAnnualLeave.booleanValue()) {
                int nextYear = year + 1;
                java.util.Date nextYearCurrentDay = DateTimeUtils.addYear((java.util.Date)currentDate, (int)1);
                this.generateAnnualLeave(ctx, nextYear, personNum, nextYearCurrentDay);
            }
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void generateAnnualLeave(Context ctx, int year, String personNum, java.util.Date currentDate) throws BOSException {
        try {
            String updateHolidaypolicy = "/*dialect*/MERGE INTO T_HR_ATS_HolidayLimit AS hl \n            USING ( \n                    SELECT \n                    af.fproposerid, \n                    hp.fid AS holiday_policy_id \n                    FROM T_HR_ATS_AtsHolidayFile af \n                    LEFT JOIN T_HR_ATS_HolidayPolicy hp ON hp.fholidaypolicysetid = af.fholidaypolicysetid \n                    LEFT JOIN T_HR_ATS_HolidayType ht ON ht.FID = hp.fholidaytypeid \n                    WHERE ht.FNUMBER = 'JQLX000001Y' \n            ) AS src ON hl.fproposerid = src.fproposerid and to_char(hl.fcyclebegindate,'yyyy') ='" + year + "' \n            WHEN MATCHED THEN \n            UPDATE SET hl.fholidaypolicyid = src.holiday_policy_id";
            DbUtil.execute((Context)ctx, (String)updateHolidaypolicy);
            java.util.Date nowDate = new java.util.Date();
            HashMap<String, String> holidayPolicyMap = new HashMap<String, String>();
            String holidayPolicySql = "select hps.FNUMBER, hp.fid  from T_HR_ATS_HolidayPolicy hp left join T_HR_ATS_HolidayPolicySet hps on hp.FHOLIDAYPOLICYSETID = hps.fid where FHOLIDAYTYPEID = (select fid from T_HR_ATS_HolidayType where FNUMBER = 'JQLX000001Y')";
            IRowSet holidayPolicyRowSet = DbUtil.executeQuery((Context)ctx, (String)holidayPolicySql);
            while (holidayPolicyRowSet.next()) {
                holidayPolicyMap.put(holidayPolicyRowSet.getString("FNUMBER"), holidayPolicyRowSet.getString("fid"));
            }
            String currentDateStr = DateTimeUtils.format((java.util.Date)currentDate, (String)"yyyy-MM-dd");
            java.util.Date yearFirstDay = DateTimeUtils.parseDate((String)(DateTimeUtils.getYear((java.util.Date)currentDate) + "-01-01"));
            java.util.Date yearLastDay = DateTimeUtils.parseDate((String)(DateTimeUtils.getYear((java.util.Date)currentDate) + "-12-31"));
            ArrayList<String> personNumberList = new ArrayList<String>();
            CoreBaseCollection addList = new CoreBaseCollection();
            CoreBaseCollection updateList = new CoreBaseCollection();
            ArrayList deleteList = new ArrayList();
            ArrayList reCalList = new ArrayList();
            String personNumStr = "";
            if (StringUtils.isNotEmpty((CharSequence)personNum)) {
                String[] personNumArr = personNum.split(",");
                for (int i = 0; i < personNumArr.length; ++i) {
                    personNumberList.add("'" + personNumArr[i] + "'");
                }
                personNumStr = String.join((CharSequence)",", personNumberList);
            }
            String dbType = ContextUtil.getDbType((Context)ctx);
            String sql = " /*dialect*/select * from (select row_number() over (partition by p.fid order by p.fid,eo.feffdt desc,l.fid) as rn,p.fid,p.fnumber,eo.FADMINORGID,eo.FHRORGUNITID,eo.FPOSITIONID,p.cfftorptid fullOrPartId,fp.fnumber fullOrPartNumber, p.cffae annualleavelimit,case when rbe.fid is null then eo.cfworkercategoryid else rbe.CFWcategoryID end workercategoryid,wc.fname_l2 workercategoryname,p.fhiredate, (to_char(to_date('" + currentDateStr + "','yyyy-MM-dd'),'yyyy') - to_char(p.fhiredate,'yyyy')+1)joinDateYear,case when rbe.fid is null then null else rbe.FBIZDATE end leaveDate,l.fid limitId,coalesce(l.FADDORSUBLIMIT,0) FADDORSUBLIMIT,coalesce(l.FUSEDLIMIT,0) FUSEDLIMIT,coalesce(l.FREEZELIMIT,0) FREEZELIMIT,coalesce(l.cflastcarryforward,0) cflastcarryforward,coalesce(l.cfcarryforward,0) cfcarryforward,coalesce(l.CFEntitlementLimit,0) CFEntitlementLimit,coalesce(l.CFInitializedLimit,0) CFInitializedLimit, ebe.FPROBATION,ebe.FPLANFORMALDATE,hp.fid holidayPolicyId,l.fisleftconvert isleftconvert   from T_HR_ATS_AtsHolidayFile f  left join T_BD_Person p on f.fproposerid = p.fid  left join T_HR_EmpOrgRelation eo on p.fid = eo.fpersonid and eo.fleffdt='2199-12-31 00:00:00'  left join CT_MP_Fullorpart fp on fp.fid = p.cfftorptid  left join T_HR_ATS_HolidayType ht on ht.FNUMBER = 'JQLX000001Y'   left join T_HR_ATS_HolidayPolicy hp on  ht.FID =hp.fholidaytypeid  and f.fholidaypolicysetid = hp.fholidaypolicysetid  left join T_HR_ATS_HolidayLimit l on hp.fid = l.FHOLIDAYPOLICYID and l.FPROPOSERID = p.fid and l.FCYCLEBEGINDATE >= p.fhiredate and l.FCYCLEBEGINDATE <= p.FLEFFDT  and l.fyear =  " + year + " left join (  select rownum rownumber,ebe.FPERSONID,  ebe.FPROBATION,ebe.FPLANFORMALDATE, ebe.FBIZDATE  from T_HR_EmpEnrollBizBillEntry ebe  inner join (select re1.fpersonid,max(re1.fbizdate) fbizdate,count(fid) from T_HR_EmpEnrollBizBillEntry re1  group by re1.fpersonid) re1 on ebe.fpersonid=re1.fpersonid and re1.fbizdate=ebe.fbizdate  left join T_HR_EmpEnrollBizBill eb on ebe.FBILLID = eb.FID  where eb.FBILLSTATE = 3  order by ebe.fbizdate desc) ebe  on ebe.FPERSONID = p.fid  and ebe.FBIZDATE = p.fhiredate  left join(  select rownum rownumber,rbe.fid, rbe.FPERSONID,  rbe.FENTERDATE, rbe.CFWcategoryID, rbe.FBIZDATE  from T_HR_ResignBizBillEntry rbe  inner join (select re1.fpersonid,max(re1.fbizdate) fbizdate,count(fid) from T_HR_ResignBizBillEntry re1  group by re1.fpersonid) re1 on rbe.fpersonid=re1.fpersonid and re1.fbizdate=rbe.fbizdate  left join T_HR_ResignBizBill rb on rb.fid = rbe.FBILLID  where rb.FBILLSTATE = 3 order by rbe.fbizdate desc  ) rbe on  rbe.FPERSONID = p.fid  and p.fhiredate = rbe.FENTERDATE  left join CT_MP_WorkerCategory wc on (wc.fid = eo.cfworkercategoryid or wc.fid = rbe.CFWcategoryID)  where f.fattendfilestate in( 1,2) and ht.FNUMBER = 'JQLX000001Y' and fp.fnumber = 'FULL' and eo.fassigntype = 1 and eo.feffdt <= to_date('" + currentDateStr + "','yyyy-MM-dd') and to_char(p.fhiredate, 'yyyy')<=" + year + " and to_char(p.FLEFFDT,'yyyy')>=" + year + " ";
            if (StringUtils.isNotEmpty((CharSequence)personNumStr)) {
                sql = sql + " and p.fnumber in (" + personNumStr + ")  ";
            }
            sql = sql + " order by l.fid ) temp where temp.rn = 1 ";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                int fprobation;
                HolidayLimitInfo holidayLimitInfo;
                String holidayPolicyId = iRowSet.getString("holidayPolicyId");
                if (StringUtils.isEmpty((CharSequence)holidayPolicyId)) {
                    holidayPolicyId = (String)holidayPolicyMap.values().stream().findFirst().get();
                    continue;
                }
                String limitId = iRowSet.getString("limitId");
                int annualleavelimit = iRowSet.getInt("annualleavelimit");
                String workercategoryname = iRowSet.getString("workercategoryname");
                int joinDateYear = iRowSet.getInt("joinDateYear");
                Date joinDate = iRowSet.getDate("fhiredate");
                Date fplanformaldate = iRowSet.getDate("FPLANFORMALDATE");
                Date leaveDate = iRowSet.getDate("leaveDate");
                BigDecimal standardLimit = BigDecimal.ZERO;
                BigDecimal convertedLimit = BigDecimal.ZERO;
                BigDecimal entitlementLimit = BigDecimal.ZERO;
                boolean isLeave = false;
                BigDecimal realLimit = BigDecimal.ZERO;
                BigDecimal remainLimit = BigDecimal.ZERO;
                BigDecimal entitlementLimitOld = iRowSet.getBigDecimal("CFEntitlementLimit");
                BigDecimal initializedLimit = iRowSet.getBigDecimal("CFInitializedLimit");
                BigDecimal lastCarryforward = iRowSet.getBigDecimal("CFLastCarryforward");
                BigDecimal carryforward = iRowSet.getBigDecimal("CFCarryforward");
                BigDecimal addOrSubLimit = iRowSet.getBigDecimal("FADDORSUBLIMIT");
                BigDecimal usedLimit = iRowSet.getBigDecimal("FUSEDLIMIT");
                BigDecimal freezeLimit = iRowSet.getBigDecimal("FreezeLimit");
                int isleftconvert = iRowSet.getInt("isleftconvert");
                if (StringUtils.equalsIgnoreCase((CharSequence)workercategoryname, (CharSequence)WC_General_Administrative_Staff) || StringUtils.equalsIgnoreCase((CharSequence)workercategoryname, (CharSequence)WC_Professional_Supervisory_Staff) || StringUtils.equalsIgnoreCase((CharSequence)workercategoryname, (CharSequence)WC_Senior_Administrative_Staff)) {
                    if (annualleavelimit > 0) {
                        convertedLimit = BigDecimal.valueOf(annualleavelimit + (joinDateYear - 1) / 2 * 1);
                        if (convertedLimit.compareTo(BigDecimal.valueOf(30L)) > 0) {
                            convertedLimit = BigDecimal.valueOf(30L);
                        }
                    } else {
                        if (StringUtils.equalsIgnoreCase((CharSequence)workercategoryname, (CharSequence)WC_General_Administrative_Staff) && (convertedLimit = BigDecimal.valueOf(12 + (joinDateYear - 1) / 2 * 1)).compareTo(BigDecimal.valueOf(20L)) > 0) {
                            convertedLimit = BigDecimal.valueOf(20L);
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)workercategoryname, (CharSequence)WC_Professional_Supervisory_Staff) && (convertedLimit = BigDecimal.valueOf(15 + (joinDateYear - 1) / 2 * 1)).compareTo(BigDecimal.valueOf(23L)) > 0) {
                            convertedLimit = BigDecimal.valueOf(23L);
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)workercategoryname, (CharSequence)WC_Senior_Administrative_Staff) && (convertedLimit = BigDecimal.valueOf(18 + (joinDateYear - 1) / 2 * 1)).compareTo(BigDecimal.valueOf(26L)) > 0) {
                            convertedLimit = BigDecimal.valueOf(26L);
                        }
                    }
                } else if (StringUtils.equalsIgnoreCase((CharSequence)workercategoryname, (CharSequence)WC_Academic_Staff) || StringUtils.equalsIgnoreCase((CharSequence)workercategoryname, (CharSequence)WC_Others)) {
                    convertedLimit = BigDecimal.valueOf(annualleavelimit);
                }
                entitlementLimit = convertedLimit;
                if (leaveDate != null && DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)leaveDate) && joinDate.compareTo(leaveDate) < 0) {
                    convertedLimit = StringUtils.equals((CharSequence)"D", (CharSequence)annualLeaveConversionMethod) ? (DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)joinDate) ? convertedLimit.multiply(BigDecimal.valueOf(DateTimeUtils.getMonth((java.util.Date)leaveDate) - DateTimeUtils.getMonth((java.util.Date)joinDate) + 1)).divide(BigDecimal.valueOf(12L), 10, 4) : convertedLimit.multiply(BigDecimal.valueOf(DateTimeUtils.getMonth((java.util.Date)leaveDate))).divide(BigDecimal.valueOf(12L), 10, 4)) : (DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)joinDate) ? convertedLimit.multiply(BigDecimal.valueOf(DateTimeUtils.getMonth((java.util.Date)leaveDate) - DateTimeUtils.getMonth((java.util.Date)joinDate) + 1)).divide(BigDecimal.valueOf(12L), 10, 4) : convertedLimit.multiply(BigDecimal.valueOf(DateTimeUtils.getMonth((java.util.Date)leaveDate))).divide(BigDecimal.valueOf(12L), 10, 4));
                } else if (DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)joinDate)) {
                    convertedLimit = StringUtils.equals((CharSequence)"D", (CharSequence)annualLeaveConversionMethod) ? convertedLimit.multiply(BigDecimal.valueOf(12 - DateTimeUtils.getMonth((java.util.Date)joinDate) + 1)).divide(BigDecimal.valueOf(12L), 10, 4) : convertedLimit.multiply(BigDecimal.valueOf(12 - DateTimeUtils.getMonth((java.util.Date)joinDate) + 1)).divide(BigDecimal.valueOf(12L), 10, 4);
                }
                BigDecimal standardLimitInteger = convertedLimit.setScale(0, RoundingMode.FLOOR);
                BigDecimal standardLimitDecimal = convertedLimit.subtract(standardLimitInteger);
                convertedLimit = Double.doubleToLongBits(0.5) == Double.doubleToLongBits(annualLeaveIntegerPrecision) ? (StringUtils.equals((CharSequence)INTEGERMETHOD_UP, (CharSequence)annualLeaveIntegerMethod) ? (standardLimitDecimal.compareTo(BigDecimal.valueOf(0.5)) > 0 ? convertedLimit.setScale(0, RoundingMode.CEILING) : (standardLimitDecimal.compareTo(BigDecimal.ZERO) > 0 ? standardLimitInteger.add(BigDecimal.valueOf(0.5)) : standardLimitInteger)) : (standardLimitDecimal.compareTo(BigDecimal.valueOf(0.5)) > 0 ? standardLimitInteger.add(BigDecimal.valueOf(0.5)) : convertedLimit.setScale(0, RoundingMode.FLOOR))) : (StringUtils.equals((CharSequence)INTEGERMETHOD_UP, (CharSequence)annualLeaveIntegerMethod) ? convertedLimit.setScale(0, RoundingMode.CEILING) : convertedLimit.setScale(0, RoundingMode.FLOOR));
                if (entitlementLimit.compareTo(entitlementLimitOld) != 0 && year <= DateTimeUtils.getYear((java.util.Date)nowDate)) {
                    lastCarryforward = BigDecimal.ZERO;
                    HashMap<String, Object> param = new HashMap<String, Object>();
                    param.put("year", year);
                    param.put("personNum", iRowSet.getString("fnumber"));
                    reCalList.add(param);
                }
                standardLimit = convertedLimit.add(initializedLimit).add(lastCarryforward).subtract(carryforward);
                realLimit = standardLimit.add(addOrSubLimit);
                remainLimit = realLimit.subtract(usedLimit).subtract(freezeLimit);
                if (StringUtils.isNotEmpty((CharSequence)limitId)) {
                    holidayLimitInfo = new HolidayLimitInfo();
                    holidayLimitInfo.setId(BOSUuid.read((String)limitId));
                    holidayLimitInfo.setStandardLimit(standardLimit);
                    holidayLimitInfo.setBigDecimal("convertedLimit", convertedLimit);
                    holidayLimitInfo.setBigDecimal("entitlementLimit", entitlementLimit);
                    holidayLimitInfo.setRealLimit(realLimit);
                    holidayLimitInfo.setRemainLimit(remainLimit);
                    holidayLimitInfo.setBigDecimal("lastCarryforward", lastCarryforward);
                    holidayLimitInfo.setBigDecimal("Carryforward", carryforward);
                    if (leaveDate != null && DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)leaveDate) && joinDate.compareTo(leaveDate) < 0) {
                        holidayLimitInfo.setCycleEndDate((java.util.Date)leaveDate);
                        holidayLimitInfo.setDelayDate((java.util.Date)leaveDate);
                        holidayLimitInfo.setIsLeftConvert(true);
                    } else {
                        if (DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)joinDate)) {
                            holidayLimitInfo.setCycleBeginDate((java.util.Date)joinDate);
                            fprobation = iRowSet.getInt("FPROBATION");
                            if (fprobation > 0) {
                                holidayLimitInfo.setEffectDate((java.util.Date)iRowSet.getDate("FPLANFORMALDATE"));
                            } else {
                                holidayLimitInfo.setEffectDate(holidayLimitInfo.getCycleBeginDate());
                            }
                        }
                        holidayLimitInfo.setIsLeftConvert(false);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FADMINORGID"))) {
                        AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                        adminOrgUnitInfo.setId(BOSUuid.read((String)iRowSet.getString("FADMINORGID")));
                        holidayLimitInfo.setAdminOrgUnit(adminOrgUnitInfo);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FPOSITIONID"))) {
                        PositionInfo positionInfo = new PositionInfo();
                        positionInfo.setId(BOSUuid.read((String)iRowSet.getString("FPOSITIONID")));
                        holidayLimitInfo.setPosition(positionInfo);
                    }
                    holidayLimitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    holidayLimitInfo.setLastUpdateTime(new Timestamp(nowDate.getTime()));
                    if (leaveDate != null && 1 == isleftconvert && leaveDate.getTime() <= holidayLimitInfo.getCycleEndDate().getTime()) continue;
                    updateList.add((CoreBaseInfo)holidayLimitInfo);
                    continue;
                }
                holidayLimitInfo = new HolidayLimitInfo();
                holidayLimitInfo.setStandardLimit(standardLimit);
                holidayLimitInfo.setBigDecimal("convertedLimit", convertedLimit);
                holidayLimitInfo.setBigDecimal("entitlementLimit", entitlementLimit);
                holidayLimitInfo.setRealLimit(realLimit);
                holidayLimitInfo.setRemainLimit(remainLimit);
                holidayLimitInfo.setFreezeLimit(BigDecimal.ZERO);
                holidayLimitInfo.setUsedLimit(BigDecimal.ZERO);
                holidayLimitInfo.setAddOrSubLimit(BigDecimal.ZERO);
                holidayLimitInfo.setPreOverdraftLimit(BigDecimal.ZERO);
                if (DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)joinDate)) {
                    holidayLimitInfo.setCycleBeginDate((java.util.Date)joinDate);
                    fprobation = iRowSet.getInt("FPROBATION");
                    if (fprobation > 0) {
                        holidayLimitInfo.setEffectDate((java.util.Date)iRowSet.getDate("FPLANFORMALDATE"));
                    } else {
                        holidayLimitInfo.setEffectDate(holidayLimitInfo.getCycleBeginDate());
                    }
                } else if (fplanformaldate != null && DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)fplanformaldate)) {
                    holidayLimitInfo.setCycleBeginDate(yearFirstDay);
                    fprobation = iRowSet.getInt("FPROBATION");
                    if (fprobation > 0) {
                        holidayLimitInfo.setEffectDate((java.util.Date)iRowSet.getDate("FPLANFORMALDATE"));
                    } else {
                        holidayLimitInfo.setEffectDate(holidayLimitInfo.getCycleBeginDate());
                    }
                } else {
                    holidayLimitInfo.setCycleBeginDate(yearFirstDay);
                    holidayLimitInfo.setEffectDate(holidayLimitInfo.getCycleBeginDate());
                }
                if (leaveDate != null && DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)leaveDate)) {
                    holidayLimitInfo.setCycleEndDate((java.util.Date)leaveDate);
                    holidayLimitInfo.setDelayDate((java.util.Date)leaveDate);
                    holidayLimitInfo.setIsLeftConvert(true);
                } else {
                    holidayLimitInfo.setCycleEndDate(yearLastDay);
                    holidayLimitInfo.setDelayDate(yearLastDay);
                }
                holidayLimitInfo.setYear(DateTimeUtils.getYear((java.util.Date)yearFirstDay));
                HolidayPolicyInfo holidayPolicyInfo = new HolidayPolicyInfo();
                holidayPolicyInfo.setId(BOSUuid.read((String)holidayPolicyId));
                holidayLimitInfo.setHolidayPolicy(holidayPolicyInfo);
                holidayLimitInfo.setHolidayUnit(HolidayTypeUnitEnum.day);
                holidayLimitInfo.setEnableCycle(true);
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)iRowSet.getString("fid")));
                holidayLimitInfo.setProposer(personInfo);
                holidayLimitInfo.setStatus(HolidayLimitStatus.audited);
                if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FADMINORGID"))) {
                    AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                    adminOrgUnitInfo.setId(BOSUuid.read((String)iRowSet.getString("FADMINORGID")));
                    holidayLimitInfo.setAdminOrgUnit(adminOrgUnitInfo);
                }
                if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FHRORGUNITID"))) {
                    HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
                    hrOrgUnitInfo.setId(BOSUuid.read((String)iRowSet.getString("FHRORGUNITID")));
                    holidayLimitInfo.setHrOrgUnit(hrOrgUnitInfo);
                }
                if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FPOSITIONID"))) {
                    PositionInfo positionInfo = new PositionInfo();
                    positionInfo.setId(BOSUuid.read((String)iRowSet.getString("FPOSITIONID")));
                    holidayLimitInfo.setPosition(positionInfo);
                }
                CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                ctrlUnitInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
                holidayLimitInfo.setCU(ctrlUnitInfo);
                holidayLimitInfo.setCycleDate(yearLastDay);
                holidayLimitInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                holidayLimitInfo.setCreateTime(new Timestamp(nowDate.getTime()));
                holidayLimitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                holidayLimitInfo.setLastUpdateTime(new Timestamp(nowDate.getTime()));
                if (leaveDate != null && 1 == isleftconvert && leaveDate.getTime() <= holidayLimitInfo.getCycleEndDate().getTime()) continue;
                addList.add((CoreBaseInfo)holidayLimitInfo);
            }
            if (addList.size() > 0) {
                HolidayLimitFactory.getLocalInstance((Context)ctx).addnewBatchData(addList);
            }
            if (updateList.size() > 0) {
                HolidayLimitFactory.getLocalInstance((Context)ctx).updateBatchData(updateList);
            }
            if (deleteList.size() > 0) {
                IObjectPK[] iObjectPKS = new IObjectPK[deleteList.size()];
                for (int i = 0; i < deleteList.size(); ++i) {
                    iObjectPKS[i] = new ObjectUuidPK((String)deleteList.get(i));
                }
                HolidayLimitFactory.getLocalInstance((Context)ctx).deleteBatchData(iObjectPKS);
            }
            if (reCalList.size() > 0) {
                for (int i = 0; i < reCalList.size(); ++i) {
                    IRowSet lastYearRowSet;
                    int yearP = (Integer)((Map)reCalList.get(i)).get("year");
                    String personNumP = (String)((Map)reCalList.get(i)).get("personNum");
                    String lastYearSql = "/*dialect*/select p.fid,l.fid limitId,l.FSTANDARDLIMIT,l.FADDORSUBLIMIT,l.FUSEDLIMIT,l.FREEZELIMIT, coalesce(l.CFInitializedLimit, 0) CFInitializedLimit,coalesce(l.CFConvertedLimit, 0) CFConvertedLimit, coalesce(l.cflastcarryforward,0) cflastcarryforward,coalesce(l.cfcarryforward,0) cfcarryforward from t_bd_person p\n left join T_HR_ATS_AtsHolidayFile f on f.fproposerid = p.fid  \n left join T_HR_ATS_HolidayPolicySet hps on f.fholidaypolicysetid = hps.fid  \n left join T_HR_ATS_HolidayPolicy hp on  hps.fid = hp.fholidaypolicysetid \n left join T_HR_ATS_HolidayType ht on ht.FNUMBER = 'JQLX000001Y' and ht.fid = hp.FHOLIDAYTYPEID  \n left join T_HR_ATS_HolidayLimit l on hp.fid = l.FHOLIDAYPOLICYID and l.FPROPOSERID = p.fid and  l.FCYCLEBEGINDATE >= p.fhiredate and l.FCYCLEBEGINDATE <= p.FLEFFDT and l.fyear =  " + (yearP - 1) + "\n where f.fattendfilestate = 1 and p.fnumber = '" + personNumP + "' and l.fid is not null and ht.FNUMBER = 'JQLX000001Y' ";
                    if (StringUtils.equalsIgnoreCase((CharSequence)"MS SQL Server", (CharSequence)dbType)) {
                        lastYearSql = "/*dialect*/select p.fid,l.fid limitId,l.FSTANDARDLIMIT,l.FADDORSUBLIMIT,l.FUSEDLIMIT,l.FREEZELIMIT, isnull(l.CFInitializedLimit, 0) CFInitializedLimit,isnull(l.CFConvertedLimit, 0) CFConvertedLimit, isnull(l.cflastcarryforward,0) cflastcarryforward,isnull(l.cfcarryforward,0) cfcarryforward from t_bd_person p\n left join T_HR_ATS_AtsHolidayFile f on f.fproposerid = p.fid  \n left join T_HR_ATS_HolidayPolicySet hps on f.fholidaypolicysetid = hps.fid  \n left join T_HR_ATS_HolidayPolicy hp on hps.fid = hp.fholidaypolicysetid \n left join T_HR_ATS_HolidayType ht on ht.FNUMBER = 'JQLX000001Y' and ht.fid = hp.FHOLIDAYTYPEID  \n left join T_HR_ATS_HolidayLimit l on hp.fid = l.FHOLIDAYPOLICYID and l.FPROPOSERID = p.fid and  l.FCYCLEBEGINDATE >= p.fhiredate and l.FCYCLEBEGINDATE <= p.FLEFFDT and l.fyear =  " + (yearP - 1) + "\n where f.fattendfilestate = 1 and p.fnumber = '" + personNumP + "' and l.fid is not null and ht.FNUMBER = 'JQLX000001Y'  ";
                    }
                    if (!(lastYearRowSet = DbUtil.executeQuery((Context)ctx, (String)lastYearSql)).next()) continue;
                    HolidayLimitInfo lastYearHolidayLimitInfo = new HolidayLimitInfo();
                    BigDecimal lastYearConvertedLimit = lastYearRowSet.getBigDecimal("CFConvertedLimit");
                    BigDecimal lastYearInitializedLimit = lastYearRowSet.getBigDecimal("CFInitializedLimit");
                    BigDecimal lastYearLastCarryforward = lastYearRowSet.getBigDecimal("CFLastCarryforward");
                    BigDecimal lastYearCarryforward = BigDecimal.ZERO;
                    BigDecimal lastYearStandardLimit = lastYearConvertedLimit.add(lastYearInitializedLimit).add(lastYearLastCarryforward).subtract(lastYearCarryforward);
                    lastYearHolidayLimitInfo.setId(BOSUuid.read((String)lastYearRowSet.getString("limitId")));
                    lastYearHolidayLimitInfo.setBigDecimal("Carryforward", lastYearCarryforward);
                    lastYearHolidayLimitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    lastYearHolidayLimitInfo.setLastUpdateTime(new Timestamp(nowDate.getTime()));
                    LeaveAllowanceFacadeFactory.getLocalInstance(ctx).carryForwardLeave(yearP, true, personNumP);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void initialGlobalParam(Context ctx) throws BOSException {
        HashMap<String, String> param = new HashMap<String, String>();
        ParamCollection paramCollection = ParamFactory.getLocalInstance(ctx).getParamCollection();
        for (int i = 0; i < paramCollection.size(); ++i) {
            param.put(paramCollection.get(i).getNumber(), paramCollection.get(i).getValue());
        }
        annualLeaveConversionMethod = (String)param.get(PARAM_ANNUALLEAVE_CONVERSIONMETHOD);
        annualLeaveIntegerMethod = (String)param.get(PARAM_ANNUALLEAVE_INTEGERMETHOD);
        annualLeaveIntegerPrecision = Double.valueOf((String)param.get(PARAM_ANNUALLEAVE_INTEGERPERCISION));
        annualLeaveConvertDate = (String)param.get(PARAM_ANNUALLEAVE_CONVERTDATE);
        annualLeaveGenerateDay = (String)param.get(PARAM_ANNUALLEAVE_GENERATEDAY);
        nursingLeaveLimit = Integer.parseInt((String)param.get(PARAM_NURSINGLEAVE_LIMIT));
        parentalLeaveLimit = Integer.parseInt((String)param.get(PARAM_PARENTALLEAVE_LIMIT));
        nursingAndParentalLeaveConversionMethod = (String)param.get(PARAM_NURSINGANDPARENTALLEAVE_CONVERSIONMETHOD);
        nursingAndParentalLeaveIntegerMethod = (String)param.get(PARAM_NURSINGANDPARENTALLEAVE_INTEGERMETHOD);
        nursingAndParentalLeaveIntegerPrecision = Double.valueOf((String)param.get(PARAM_NURSINGANDPARENTALLEAVE_INTEGERPERCISION));
        nursingAndParentalLeaveUpdateSql = (String)param.get(PARAM_NURSINGANDPARENTALLEAVE_UPDATESQL);
    }

    @Override
    public void setSeniority(Context ctx) throws BOSException, EASBizException {
        String hisSql = "update T_HR_PersonPositionHis set FJOINCOMPANYYEARS=CEILING(FJOINCOMPANYYEARS) where year(FJOINDATE)<year(now())";
        logger.error((Object)("\u7481\u5267\u7586\u9359\u6401\u7ddeSQL(HIS)\u951b\ufffd" + hisSql));
        DbUtil.execute((Context)ctx, (String)hisSql);
        String sql = "update T_HR_PersonPosition set FJOINCOMPANYYEARS=CEILING(FJOINCOMPANYYEARS) where year(FJOINDATE)<year(now())";
        logger.error((Object)("\u7481\u5267\u7586\u9359\u6401\u7ddeSQL\u951b\ufffd" + sql));
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected void _carryForwardLeave(Context ctx, int year, boolean isExecute, String personNum) throws BOSException, EASBizException {
        try {
            if (!isExecute) {
                return;
            }
            this.initialGlobalParam(ctx);
            java.util.Date nowDate = new java.util.Date();
            java.util.Date currentDate = new java.util.Date();
            if (year != 0) {
                currentDate = DateTimeUtils.parseDate((String)(year + "-12-31"));
            } else {
                year = DateTimeUtils.getYear((java.util.Date)currentDate);
            }
            ArrayList<String> personNumberList = new ArrayList<String>();
            CoreBaseCollection lastYearList = new CoreBaseCollection();
            CoreBaseCollection thisYearList = new CoreBaseCollection();
            String personNumStr = "";
            if (StringUtils.isNotEmpty((CharSequence)personNum)) {
                String[] personNumArr = personNum.split(",");
                for (int i = 0; i < personNumArr.length; ++i) {
                    personNumberList.add("'" + personNumArr[i] + "'");
                }
                personNumStr = String.join((CharSequence)",", personNumberList);
            }
            java.util.Date annualLeaveConvertDate = DateTimeUtils.parseDate((String)(year + "-" + LeaveAllowanceFacadeControllerBean.annualLeaveConvertDate));
            if (currentDate.getTime() >= annualLeaveConvertDate.getTime()) {
                String sql = " /*dialect*/select thisL.fid thisLFid, lastL.fid lastLfID,thisL.FSTANDARDLIMIT, lastL.FREMAINLIMIT,ht.FNUMBER,  case when lastL.FREMAINLIMIT + thisL.CFEntitlementLimit <= 30 then coalesce(lastL.FREMAINLIMIT,0) else coalesce(30 - thisL.CFEntitlementLimit,0) end lastnextForward,   case when lastL.FREMAINLIMIT + thisL.CFEntitlementLimit <= 30 then coalesce(lastL.FREMAINLIMIT,0) else coalesce(30 - thisL.CFEntitlementLimit,0) end thislastforward,   lastL.FStandardLimit lFStandardLimit,coalesce(lastL.cfinitializedlimit,0) lcfinitializedlimit,coalesce(lastL.cfconvertedlimit,0) lcfconvertedlimit,lastL.FADDORSUBLIMIT lFADDORSUBLIMIT,lastL.FUSEDLIMIT lFUSEDLIMIT,lastL.FREEZELIMIT lFREEZELIMIT,coalesce(lastL.cflastcarryforward,0) lcflastcarryforward,coalesce(lastL.cfcarryforward,0) lcfcarryforward,  thisL.FStandardLimit tFStandardLimit,coalesce(thisL.cfinitializedlimit,0) tcfinitializedlimit,coalesce(thisL.cfconvertedlimit,0) tcfconvertedlimit,thisL.FADDORSUBLIMIT tFADDORSUBLIMIT,thisL.FUSEDLIMIT tFUSEDLIMIT,thisL.FREEZELIMIT tFREEZELIMIT,coalesce(thisL.cflastcarryforward,0) tcflastcarryforward,coalesce(thisL.cfcarryforward,0) tcfcarryforward  from t_bd_person p   left join T_HR_ATS_HolidayLimit lastL on p.fid = lastL.FPROPOSERID and lastL.FCYCLEBEGINDATE >= p.fhiredate and lastL.FCYCLEBEGINDATE <= p.FLEFFDT  left join T_HR_ATS_HolidayLimit thisL on thisL.FHOLIDAYPOLICYID = lastL.FHOLIDAYPOLICYID and thisL.FPROPOSERID = lastL.FPROPOSERID  and thisL.FCYCLEBEGINDATE >= p.fhiredate and thisL.FCYCLEBEGINDATE <= p.FLEFFDT  left join T_HR_ATS_AtsHolidayFile hf on hf.fproposerid = p.fid   left join T_HR_ATS_HolidayPolicySet hps on hf.fholidaypolicysetid = hps.fid      left join T_HR_ATS_HolidayPolicy hp on  hps.fid = hp.fholidaypolicysetid and thisL.FHOLIDAYPOLICYID = hp.fid   left join T_HR_ATS_HolidayType ht on ht.fid = hp.FHOLIDAYTYPEID and ht.FNUMBER = 'JQLX000001Y'      where  hf.fattendfilestate = 1 and ht.FNUMBER = 'JQLX000001Y' and (lastL.cfcarryforward is null or lastL.cfcarryforward = 0) and thisL.FYEAR = " + year + " and lastL.fyear = " + (year - 1) + "";
                String dbType = ContextUtil.getDbType((Context)ctx);
                if (StringUtils.equalsIgnoreCase((CharSequence)"MS SQL Server", (CharSequence)dbType)) {
                    sql = " /*dialect*/select thisL.fid thisLFid, lastL.fid lastLfID,thisL.FSTANDARDLIMIT, lastL.FREMAINLIMIT,ht.FNUMBER,  case when lastL.FREMAINLIMIT + thisL.CFEntitlementLimit <= 30 then isnull(lastL.FREMAINLIMIT,0) else isnull(30 - thisL.CFEntitlementLimit,0) end lastnextForward,   case when lastL.FREMAINLIMIT + thisL.CFEntitlementLimit <= 30 then isnull(lastL.FREMAINLIMIT,0) else isnull(30 - thisL.CFEntitlementLimit,0) end thislastforward,   lastL.FStandardLimit lFStandardLimit,isnull(lastL.cfinitializedlimit,0) lcfinitializedlimit,isnull(lastL.cfconvertedlimit,0) lcfconvertedlimit,lastL.FADDORSUBLIMIT lFADDORSUBLIMIT,lastL.FUSEDLIMIT lFUSEDLIMIT,lastL.FREEZELIMIT lFREEZELIMIT,isnull(lastL.cflastcarryforward,0) lcflastcarryforward,isnull(lastL.cfcarryforward,0) lcfcarryforward,  thisL.FStandardLimit tFStandardLimit,isnull(thisL.cfinitializedlimit,0) tcfinitializedlimit,isnull(thisL.cfconvertedlimit,0) tcfconvertedlimit,thisL.FADDORSUBLIMIT tFADDORSUBLIMIT,thisL.FUSEDLIMIT tFUSEDLIMIT,thisL.FREEZELIMIT tFREEZELIMIT,isnull(thisL.cflastcarryforward,0) tcflastcarryforward,isnull(thisL.cfcarryforward,0) tcfcarryforward  from t_bd_person p   left join T_HR_ATS_HolidayLimit lastL on p.fid = lastL.FPROPOSERID  and lastL.FCYCLEBEGINDATE >= p.fhiredate and lastL.FCYCLEBEGINDATE <= p.FLEFFDT  left join T_HR_ATS_HolidayLimit thisL on thisL.FHOLIDAYPOLICYID = lastL.FHOLIDAYPOLICYID and thisL.FPROPOSERID = lastL.FPROPOSERID   and thisL.FCYCLEBEGINDATE >= p.fhiredate and thisL.FCYCLEBEGINDATE <= p.FLEFFDT   left join T_HR_ATS_AtsHolidayFile hf on hf.fproposerid = p.fid   left join T_HR_ATS_HolidayPolicySet hps on hf.fholidaypolicysetid = hps.fid      left join T_HR_ATS_HolidayPolicy hp on  hps.fid = hp.fholidaypolicysetid and thisL.FHOLIDAYPOLICYID = hp.fid   left join T_HR_ATS_HolidayType ht on ht.fid = hp.FHOLIDAYTYPEID and ht.FNUMBER = 'JQLX000001Y'      where hf.fattendfilestate = 1 and ht.FNUMBER = 'JQLX000001Y' and (lastL.cfcarryforward is null or lastL.cfcarryforward = 0) and thisL.FYEAR = " + year + " and lastL.fyear = " + (year - 1) + "";
                }
                if (StringUtils.isNotEmpty((CharSequence)personNumStr)) {
                    sql = sql + " and p.fnumber in (" + personNumStr + ") ";
                }
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                while (rowSet.next()) {
                    HolidayLimitInfo lastYearHolidayLimitInfo = new HolidayLimitInfo();
                    lastYearHolidayLimitInfo.setId(BOSUuid.read((String)rowSet.getString("lastLfID")));
                    lastYearHolidayLimitInfo.setBigDecimal("Carryforward", rowSet.getBigDecimal("lastnextForward"));
                    BigDecimal lastYearConvertedLimit = rowSet.getBigDecimal("lcfconvertedlimit");
                    BigDecimal lastYearInitializedLimit = rowSet.getBigDecimal("lCFInitializedLimit");
                    BigDecimal lastYearLastCarryforward = rowSet.getBigDecimal("lCFLastCarryforward");
                    BigDecimal lastYearStandardLimit = lastYearConvertedLimit.add(lastYearInitializedLimit).add(lastYearLastCarryforward).subtract(lastYearHolidayLimitInfo.getBigDecimal("Carryforward"));
                    lastYearList.add((CoreBaseInfo)lastYearHolidayLimitInfo);
                    HolidayLimitInfo thisYearHolidayLimitInfo = new HolidayLimitInfo();
                    thisYearHolidayLimitInfo.setId(BOSUuid.read((String)rowSet.getString("thisLFid")));
                    thisYearHolidayLimitInfo.setBigDecimal("LastCarryforward", rowSet.getBigDecimal("thislastforward"));
                    BigDecimal thisYearConvertedLimit = rowSet.getBigDecimal("tcfconvertedlimit");
                    BigDecimal thisYearInitializedLimit = rowSet.getBigDecimal("tCFInitializedLimit");
                    BigDecimal thisYearCarryforward = rowSet.getBigDecimal("tCFCarryforward");
                    BigDecimal thisYearStandardLimit = thisYearConvertedLimit.add(thisYearInitializedLimit).add(thisYearHolidayLimitInfo.getBigDecimal("LastCarryforward")).subtract(thisYearCarryforward);
                    thisYearHolidayLimitInfo.setStandardLimit(thisYearStandardLimit);
                    thisYearHolidayLimitInfo.setRealLimit(thisYearHolidayLimitInfo.getStandardLimit().add(rowSet.getBigDecimal("tFADDORSUBLIMIT")));
                    thisYearHolidayLimitInfo.setRemainLimit(thisYearHolidayLimitInfo.getRealLimit().subtract(rowSet.getBigDecimal("tFUSEDLIMIT")).subtract(rowSet.getBigDecimal("tFreezeLimit")));
                    thisYearHolidayLimitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    thisYearHolidayLimitInfo.setLastUpdateTime(new Timestamp(nowDate.getTime()));
                    thisYearList.add((CoreBaseInfo)thisYearHolidayLimitInfo);
                }
            }
            if (lastYearList.size() > 0) {
                SelectorItemCollection sc = new SelectorItemCollection();
                sc.add(new SelectorItemInfo("Carryforward"));
                sc.add(new SelectorItemInfo("LastCarryforward"));
                HolidayLimitFactory.getLocalInstance((Context)ctx).updatePartialBatchData((IObjectCollection)lastYearList, sc);
            }
            if (thisYearList.size() > 0) {
                SelectorItemCollection sc = new SelectorItemCollection();
                sc.add(new SelectorItemInfo("Carryforward"));
                sc.add(new SelectorItemInfo("LastCarryforward"));
                sc.add(new SelectorItemInfo("standardLimit"));
                sc.add(new SelectorItemInfo("realLimit"));
                sc.add(new SelectorItemInfo("remainLimit"));
                sc.add(new SelectorItemInfo("lastUpdateUser"));
                sc.add(new SelectorItemInfo("lastUpdateTime"));
                HolidayLimitFactory.getLocalInstance((Context)ctx).updateBatchData(thisYearList);
            }
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _creareNursingLeave(Context ctx, int year, String personNum) throws BOSException {
        this.createNursingOrParentalLeave(ctx, year, personNum, "JQLX000016Y", nursingLeaveLimit, "P");
    }

    @Override
    protected void _creareParentalLeave(Context ctx, int year, String personNum) throws BOSException {
        this.createNursingOrParentalLeave(ctx, year, personNum, "JQLX000015Y", parentalLeaveLimit, "C");
    }

    private void createNursingOrParentalLeave(Context ctx, int year, String personNum, String policyNumber, int initialLimit, String cnLeave) throws BOSException {
        try {
            this.initialGlobalParam(ctx);
            String personFamilyTempTable = this.createPersonFamilyTempTable(ctx, cnLeave);
            java.util.Date nowDate = new java.util.Date();
            java.util.Date currentDate = new java.util.Date();
            if (year != 0) {
                currentDate = DateTimeUtils.parseDate((String)(year + "-12-31"));
            } else {
                year = DateTimeUtils.getYear((java.util.Date)currentDate);
            }
            String yearFirstDayStr = DateTimeUtils.getYear((java.util.Date)currentDate) + "-01-01";
            java.util.Date yearFirstDay = DateTimeUtils.parseDate((String)yearFirstDayStr);
            String yearLastDayStr = DateTimeUtils.getYear((java.util.Date)currentDate) + "-12-31";
            java.util.Date yearLastDay = DateTimeUtils.parseDate((String)yearLastDayStr);
            ArrayList<String> personNumberList = new ArrayList<String>();
            CoreBaseCollection addList = new CoreBaseCollection();
            CoreBaseCollection updateList = new CoreBaseCollection();
            String personNumStr = "";
            if (StringUtils.isNotEmpty((CharSequence)personNum)) {
                String[] personNumArr = personNum.split(",");
                for (int i = 0; i < personNumArr.length; ++i) {
                    personNumberList.add("'" + personNumArr[i] + "'");
                }
                personNumStr = String.join((CharSequence)",", personNumberList);
            }
            String clearQuotaSql = " update T_HR_ATS_HolidayLimit set FStandardLimit = 0, FRealLimit = FAddOrSubLimit,FRemainLimit = FAddOrSubLimit-FUsedLimit-FreezeLimit where fid in (  select l.fid from T_HR_ATS_HolidayLimit l  left join T_HR_ATS_HolidayPolicy hp on  hp.fid = l.FHOLIDAYPOLICYID  left join T_HR_ATS_HolidayType ht on hp.FHOLIDAYTYPEID = ht.fid  left join t_bd_person p on p.fid = l.FPROPOSERID  where ht.FNUMBER = '" + policyNumber + "' and l.FYEAR = " + year + " and l.FCYCLEBEGINDATE >= p.fhiredate and l.FCYCLEBEGINDATE <= p.FLEFFDT ";
            clearQuotaSql = StringUtils.isNotEmpty((CharSequence)personNumStr) ? clearQuotaSql + " and p.fnumber in (" + personNumStr + ")) " : clearQuotaSql + " ) ";
            DbUtil.execute((Context)ctx, (String)clearQuotaSql);
            String deleteZeroQuotaSql = "delete from T_HR_ATS_HolidayLimit where FHOLIDAYPOLICYID in (select hp.fid from T_HR_ATS_HolidayPolicy hp left join T_HR_ATS_HolidayType ht on hp.FHOLIDAYTYPEID = ht.fid where  ht.FNUMBER = '" + policyNumber + "') and FYEAR = " + year + " and FStandardLimit = 0 and FRealLimit = 0 and FAddOrSubLimit = 0 and FRemainLimit = 0 and FUsedLimit = 0 and FreezeLimit = 0 ";
            if (StringUtils.isNotEmpty((CharSequence)personNumStr)) {
                deleteZeroQuotaSql = deleteZeroQuotaSql + " and FProposerID in (select fid from t_bd_person where fnumber in (" + personNumStr + ") ) ";
            }
            DbUtil.execute((Context)ctx, (String)deleteZeroQuotaSql);
            String sql = "/*dialect*/select f.FPERSONID,p.fnumber, case when to_char(f.CFStartTime,'yyyy') < " + year + " then to_date('" + year + "-01-01','yyyy-MM-dd') else f.CFStartTime end CFStartTime, case when f.CFEndTime is null or to_char(f.CFEndTime,'yyyy') > " + year + " then to_date('" + year + "-12-31','yyyy-MM-dd') else f.CFEndTime end CFEndTime , case when rbe.fid is null then null else rbe.FBIZDATE end leaveDate,p.fhiredate,hf.FADMINORGUNITID, hf.FHRORGUNITID ,hf.FPOSITIONID, l.fid limitId,ebe.FPROBATION, ebe.FPLANFORMALDATE,hp.fid holidayPolicyId,l.FADDORSUBLIMIT,l.FUSEDLIMIT,l.FREEZELIMIT,l.FCYCLEBEGINDATE,l.FCYCLEENDDATE from " + personFamilyTempTable + " f  left join t_bd_person p on p.fid = f.FPERSONID  left join T_HR_ATS_AtsHolidayFile hf on hf.fproposerid = f.FPERSONID  left join T_HR_ATS_HolidayPolicySet hps on hf.fholidaypolicysetid = hps.fid   left join T_HR_ATS_HolidayPolicy hp on hps.fid = hp.fholidaypolicysetid left join T_HR_ATS_HolidayType ht on ht.FNUMBER = '" + policyNumber + "' and ht.fid = hp.FHOLIDAYTYPEID   left join T_HR_ATS_HolidayLimit l on hp.fid = l.FHOLIDAYPOLICYID and l.FPROPOSERID = f.FPERSONID and l.FYEAR = " + year + " and f.CFStartTime<=l.FCYCLEBEGINDATE and f.CFEndTime>=l.FCYCLEBEGINDATE  and l.FCYCLEBEGINDATE >= p.fhiredate and l.FCYCLEENDDATE >= p.fhiredate  left join (  select rownum rownumber,ebe.FPERSONID,  ebe.FPROBATION,ebe.FPLANFORMALDATE, ebe.FBIZDATE  from T_HR_EmpEnrollBizBillEntry ebe  inner join (select re1.fpersonid,max(re1.fbizdate) fbizdate,count(fid) from T_HR_EmpEnrollBizBillEntry re1  group by re1.fpersonid) re1 on ebe.fpersonid=re1.fpersonid and re1.fbizdate=ebe.fbizdate  left join T_HR_EmpEnrollBizBill eb on ebe.FBILLID = eb.FID  and eb.FBILLSTATE = 3  order by ebe.fbizdate desc) ebe  on  ebe.FPERSONID = p.fid  and ebe.FBIZDATE = p.fhiredate  left join(  select rownum rownumber,rbe.fid, rbe.FPERSONID,  rbe.FENTERDATE, rbe.CFWcategoryID, rbe.FBIZDATE  from T_HR_ResignBizBillEntry rbe  inner join (select re1.fpersonid,max(re1.fbizdate) fbizdate,count(fid) from T_HR_ResignBizBillEntry re1  group by re1.fpersonid) re1 on rbe.fpersonid=re1.fpersonid and re1.fbizdate=rbe.fbizdate  left join T_HR_ResignBizBill rb on rb.fid = rbe.FBILLID  and rb.FBILLSTATE = 3 order by rbe.fbizdate desc  ) rbe on  rbe.FPERSONID = p.fid  and p.fhiredate = rbe.FENTERDATE  where ht.FNUMBER = '" + policyNumber + "' and hf.fattendfilestate = 1 and f.CFStartTime <= to_date('" + yearLastDayStr + "','yyyy-MM-dd') and (f.CFEndTime >= to_date('" + yearFirstDayStr + "','yyyy-MM-dd') or f.CFEndTime is null)  and  to_char(p.fhiredate,'yyyy')<=" + year + " and to_char(p.FLEFFDT,'yyyy')>=" + year;
            if (StringUtils.isNotEmpty((CharSequence)personNumStr)) {
                sql = sql + " and p.fnumber in (" + personNumStr + ") ";
            }
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                HolidayLimitInfo holidayLimitInfo;
                String holidayPolicyId = iRowSet.getString("holidayPolicyId");
                if (StringUtils.isEmpty((CharSequence)holidayPolicyId)) continue;
                BigDecimal standardLimit = BigDecimal.valueOf(initialLimit);
                String limitId = iRowSet.getString("limitId");
                Date joinDate = iRowSet.getDate("fhiredate");
                Date fplanformaldate = iRowSet.getDate("FPLANFORMALDATE");
                Date leaveDate = iRowSet.getDate("leaveDate");
                Date cfStartTime = iRowSet.getDate("CFStartTime");
                Date effectDate = iRowSet.getDate("CFStartTime");
                Date cfEndTime = iRowSet.getDate("CFEndTime");
                if (DateTimeUtils.getYear((java.util.Date)joinDate) == DateTimeUtils.getYear((java.util.Date)cfStartTime) && joinDate.getTime() > cfStartTime.getTime()) {
                    cfStartTime = joinDate;
                    effectDate = iRowSet.getDate("FPLANFORMALDATE") != null ? iRowSet.getDate("FPLANFORMALDATE") : joinDate;
                } else if (fplanformaldate != null && DateTimeUtils.getYear((java.util.Date)fplanformaldate) == DateTimeUtils.getYear((java.util.Date)cfStartTime) && fplanformaldate.getTime() > cfStartTime.getTime()) {
                    effectDate = fplanformaldate;
                }
                if (leaveDate != null && DateTimeUtils.getYear((java.util.Date)currentDate) == DateTimeUtils.getYear((java.util.Date)leaveDate) && DateTimeUtils.getYear((java.util.Date)leaveDate) == DateTimeUtils.getYear((java.util.Date)cfEndTime) && cfEndTime.getTime() > leaveDate.getTime()) {
                    cfEndTime = leaveDate;
                }
                if (cfStartTime.getTime() > cfEndTime.getTime()) continue;
                standardLimit = standardLimit.multiply(BigDecimal.valueOf(DateTimeUtils.getMonth((java.util.Date)cfEndTime) - DateTimeUtils.getMonth((java.util.Date)cfStartTime) + 1)).divide(BigDecimal.valueOf(12L), 10, 4);
                BigDecimal standardLimitInteger = standardLimit.setScale(0, RoundingMode.FLOOR);
                BigDecimal standardLimitDecimal = standardLimit.subtract(standardLimitInteger);
                standardLimit = Double.doubleToLongBits(0.5) == Double.doubleToLongBits(nursingAndParentalLeaveIntegerPrecision) ? (StringUtils.equals((CharSequence)INTEGERMETHOD_UP, (CharSequence)nursingAndParentalLeaveIntegerMethod) ? (standardLimitDecimal.compareTo(BigDecimal.valueOf(0.5)) > 0 ? standardLimit.setScale(0, RoundingMode.CEILING) : (standardLimitDecimal.compareTo(BigDecimal.ZERO) > 0 ? standardLimitInteger.add(BigDecimal.valueOf(0.5)) : standardLimitInteger)) : (standardLimitDecimal.compareTo(BigDecimal.valueOf(0.5)) > 0 ? standardLimitInteger.add(BigDecimal.valueOf(0.5)) : standardLimit.setScale(0, RoundingMode.FLOOR))) : (StringUtils.equals((CharSequence)INTEGERMETHOD_UP, (CharSequence)nursingAndParentalLeaveIntegerMethod) ? standardLimit.setScale(0, RoundingMode.CEILING) : standardLimit.setScale(0, RoundingMode.FLOOR));
                if (StringUtils.isNotEmpty((CharSequence)limitId)) {
                    holidayLimitInfo = new HolidayLimitInfo();
                    holidayLimitInfo.setId(BOSUuid.read((String)limitId));
                    holidayLimitInfo.setStandardLimit(standardLimit);
                    holidayLimitInfo.setRealLimit(standardLimit.add(iRowSet.getBigDecimal("FADDORSUBLIMIT")));
                    holidayLimitInfo.setRemainLimit(standardLimit.add(iRowSet.getBigDecimal("FADDORSUBLIMIT")).subtract(iRowSet.getBigDecimal("FUSEDLIMIT")).subtract(iRowSet.getBigDecimal("FreezeLimit")));
                    holidayLimitInfo.setCycleBeginDate((java.util.Date)cfStartTime);
                    holidayLimitInfo.setCycleEndDate((java.util.Date)cfEndTime);
                    holidayLimitInfo.setEffectDate((java.util.Date)effectDate);
                    holidayLimitInfo.setDelayDate(yearLastDay);
                    if (leaveDate != null && leaveDate.getTime() == cfEndTime.getTime()) {
                        holidayLimitInfo.setDelayDate((java.util.Date)cfEndTime);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FADMINORGUNITID"))) {
                        AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                        adminOrgUnitInfo.setId(BOSUuid.read((String)iRowSet.getString("FADMINORGUNITID")));
                        holidayLimitInfo.setAdminOrgUnit(adminOrgUnitInfo);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FHRORGUNITID"))) {
                        HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
                        hrOrgUnitInfo.setId(BOSUuid.read((String)iRowSet.getString("FHRORGUNITID")));
                        holidayLimitInfo.setHrOrgUnit(hrOrgUnitInfo);
                    }
                    if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FPOSITIONID"))) {
                        PositionInfo positionInfo = new PositionInfo();
                        positionInfo.setId(BOSUuid.read((String)iRowSet.getString("FPOSITIONID")));
                        holidayLimitInfo.setPosition(positionInfo);
                    }
                    holidayLimitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                    holidayLimitInfo.setLastUpdateTime(new Timestamp(nowDate.getTime()));
                    updateList.add((CoreBaseInfo)holidayLimitInfo);
                    continue;
                }
                holidayLimitInfo = new HolidayLimitInfo();
                holidayLimitInfo.setStandardLimit(standardLimit);
                holidayLimitInfo.setRealLimit(standardLimit);
                holidayLimitInfo.setRemainLimit(standardLimit);
                holidayLimitInfo.setFreezeLimit(BigDecimal.ZERO);
                holidayLimitInfo.setUsedLimit(BigDecimal.ZERO);
                holidayLimitInfo.setAddOrSubLimit(BigDecimal.ZERO);
                holidayLimitInfo.setPreOverdraftLimit(BigDecimal.ZERO);
                holidayLimitInfo.setCycleBeginDate((java.util.Date)cfStartTime);
                holidayLimitInfo.setCycleEndDate((java.util.Date)cfEndTime);
                holidayLimitInfo.setEffectDate((java.util.Date)effectDate);
                holidayLimitInfo.setDelayDate(yearLastDay);
                if (leaveDate != null && leaveDate.getTime() == cfEndTime.getTime()) {
                    holidayLimitInfo.setDelayDate((java.util.Date)cfEndTime);
                }
                holidayLimitInfo.setYear(DateTimeUtils.getYear((java.util.Date)yearFirstDay));
                HolidayPolicyInfo holidayPolicyInfo = new HolidayPolicyInfo();
                holidayPolicyInfo.setId(BOSUuid.read((String)holidayPolicyId));
                holidayLimitInfo.setHolidayPolicy(holidayPolicyInfo);
                holidayLimitInfo.setHolidayUnit(HolidayTypeUnitEnum.day);
                holidayLimitInfo.setEnableCycle(true);
                PersonInfo personInfo = new PersonInfo();
                personInfo.setId(BOSUuid.read((String)iRowSet.getString("FPERSONID")));
                holidayLimitInfo.setProposer(personInfo);
                holidayLimitInfo.setStatus(HolidayLimitStatus.audited);
                if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FADMINORGUNITID"))) {
                    AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                    adminOrgUnitInfo.setId(BOSUuid.read((String)iRowSet.getString("FADMINORGUNITID")));
                    holidayLimitInfo.setAdminOrgUnit(adminOrgUnitInfo);
                }
                if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FHRORGUNITID"))) {
                    HROrgUnitInfo hrOrgUnitInfo = new HROrgUnitInfo();
                    hrOrgUnitInfo.setId(BOSUuid.read((String)iRowSet.getString("FHRORGUNITID")));
                    holidayLimitInfo.setHrOrgUnit(hrOrgUnitInfo);
                }
                if (StringUtils.isNotEmpty((CharSequence)iRowSet.getString("FPOSITIONID"))) {
                    PositionInfo positionInfo = new PositionInfo();
                    positionInfo.setId(BOSUuid.read((String)iRowSet.getString("FPOSITIONID")));
                    holidayLimitInfo.setPosition(positionInfo);
                }
                CtrlUnitInfo ctrlUnitInfo = new CtrlUnitInfo();
                ctrlUnitInfo.setId(BOSUuid.read((String)"00000000-0000-0000-0000-000000000000CCE7AED4"));
                holidayLimitInfo.setCU(ctrlUnitInfo);
                holidayLimitInfo.setCycleDate(yearLastDay);
                holidayLimitInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
                holidayLimitInfo.setCreateTime(new Timestamp(nowDate.getTime()));
                holidayLimitInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                holidayLimitInfo.setLastUpdateTime(new Timestamp(nowDate.getTime()));
                addList.add((CoreBaseInfo)holidayLimitInfo);
            }
            if (addList.size() > 0) {
                HolidayLimitFactory.getLocalInstance((Context)ctx).addnewBatchData(addList);
            }
            if (updateList.size() > 0) {
                HolidayLimitFactory.getLocalInstance((Context)ctx).updateBatchData(updateList);
            }
        }
        catch (SQLException | ParseException e) {
            throw new BOSException((Throwable)e);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String createPersonFamilyTempTable(Context ctx, String cnLeave) throws BOSException {
        String dbType = ContextUtil.getDbType((Context)ctx);
        String view_pf_PersonFamilyTempTable = "";
        if (StringUtils.equalsIgnoreCase((CharSequence)nursingAndParentalLeaveUpdateSql, (CharSequence)"Y")) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"MS SQL Server", (CharSequence)dbType)) {
                String dropView = " IF EXISTS (SELECT * FROM sys.views WHERE name = 'view_pf_DateRanges_" + cnLeave + "')  DROP VIEW view_pf_DateRanges_" + cnLeave;
                DbUtil.execute((Context)ctx, (String)dropView);
                dropView = " IF EXISTS (SELECT * FROM sys.views WHERE name = 'view_pf_CTE_" + cnLeave + "')  DROP VIEW view_pf_CTE_" + cnLeave;
                DbUtil.execute((Context)ctx, (String)dropView);
                dropView = " IF EXISTS (SELECT * FROM sys.views WHERE name = 'view_pf_MergedRanges_" + cnLeave + "')    DROP VIEW view_pf_MergedRanges_" + cnLeave;
                DbUtil.execute((Context)ctx, (String)dropView);
                dropView = " IF EXISTS (SELECT * FROM sys.views WHERE name = 'view_pf_GroupedRanges_" + cnLeave + "')    DROP VIEW view_pf_GroupedRanges_" + cnLeave;
                DbUtil.execute((Context)ctx, (String)dropView);
            }
            String createView = " /*dialect*/create or replace view view_pf_DateRanges_" + cnLeave + " as (  select CFStartTime StartDate,CFEndTime EndDate,FPERSONID PersonID from t_hr_personfamily where CFCnleave = '" + cnLeave + "'   ) ";
            if (StringUtils.equalsIgnoreCase((CharSequence)"MS SQL Server", (CharSequence)dbType)) {
                createView = " /*dialect*/create view view_pf_DateRanges_" + cnLeave + " as (  select CFStartTime StartDate,CFEndTime EndDate,FPERSONID PersonID from t_hr_personfamily where CFCnleave = '" + cnLeave + "'   ) ";
            }
            DbUtil.execute((Context)ctx, (String)createView);
            createView = " /*dialect*/create or replace view view_pf_CTE_" + cnLeave + " AS (    SELECT PersonID,StartDate, EndDate,LAG(EndDate) OVER (PARTITION BY PersonID ORDER BY StartDate) AS prev_end_date FROM view_pf_DateRanges_" + cnLeave + ") ";
            if (StringUtils.equalsIgnoreCase((CharSequence)"MS SQL Server", (CharSequence)dbType)) {
                createView = " /*dialect*/create view view_pf_CTE_" + cnLeave + " AS (    SELECT PersonID,StartDate, EndDate,LAG(EndDate) OVER (PARTITION BY PersonID ORDER BY StartDate) AS prev_end_date FROM view_pf_DateRanges_" + cnLeave + ") ";
            }
            DbUtil.execute((Context)ctx, (String)createView);
            createView = " /*dialect*/create or replace view view_pf_MergedRanges_" + cnLeave + " AS (     SELECT PersonID,StartDate,EndDate,CASE WHEN StartDate <= prev_end_date + INTERVAL '1 day'  THEN 0 ELSE 1 END AS is_overlap FROM view_pf_CTE_" + cnLeave + ") ";
            if (StringUtils.equalsIgnoreCase((CharSequence)"MS SQL Server", (CharSequence)dbType)) {
                createView = " /*dialect*/create view view_pf_MergedRanges_" + cnLeave + " AS (     SELECT PersonID,StartDate,EndDate,CASE WHEN StartDate <= DATEADD(day, 1, prev_end_date) THEN 0 ELSE 1 END AS is_overlap FROM view_pf_CTE_" + cnLeave + ") ";
            }
            DbUtil.execute((Context)ctx, (String)createView);
            createView = " /*dialect*/create or replace view view_pf_GroupedRanges_" + cnLeave + " AS (     SELECT PersonID,StartDate,EndDate,SUM(is_overlap) OVER (PARTITION BY PersonID ORDER BY StartDate) AS grp FROM view_pf_MergedRanges_" + cnLeave + ") ";
            if (StringUtils.equalsIgnoreCase((CharSequence)"MS SQL Server", (CharSequence)dbType)) {
                createView = " /*dialect*/create view view_pf_GroupedRanges_" + cnLeave + " AS (     SELECT PersonID,StartDate,EndDate,SUM(is_overlap) OVER (PARTITION BY PersonID ORDER BY StartDate) AS grp FROM view_pf_MergedRanges_" + cnLeave + ") ";
            }
            DbUtil.execute((Context)ctx, (String)createView);
        }
        view_pf_PersonFamilyTempTable = " (SELECT PersonID fpersonid,MIN(StartDate) AS CFStartTime,MAX(EndDate) AS CFEndTime FROM view_pf_GroupedRanges_" + cnLeave + " GROUP BY PersonID, grp ORDER BY PersonID, CFStartTime) ";
        if (StringUtils.equalsIgnoreCase((CharSequence)"MS SQL Server", (CharSequence)dbType)) {
            view_pf_PersonFamilyTempTable = " (SELECT top 100 percent PersonID fpersonid,MIN(StartDate) AS CFStartTime,MAX(EndDate) AS CFEndTime FROM view_pf_GroupedRanges_" + cnLeave + " GROUP BY PersonID, grp ORDER BY PersonID, CFStartTime) ";
        }
        return view_pf_PersonFamilyTempTable;
    }

    private List<String> getPersonData(Context ctx, String leaveNumber, int year) throws BOSException, SQLException {
        String nursingSql = " SELECT a.FPROPOSERID FROM T_HR_ATS_HolidayLimit as a ,T_HR_ATS_HolidayPolicy as b , T_HR_ATS_HolidayType c  where a.FHOLIDAYPOLICYID  = b.FID  and b.FHOLIDAYTYPEID = c.FID  and c.FNUMBER  = '" + leaveNumber + "' and FYear =  " + year + " ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)nursingSql);
        ArrayList<String> personList = new ArrayList<String>();
        while (rs.next()) {
            personList.add(rs.getString("FPROPOSERID"));
        }
        return personList;
    }

    private static java.util.Date getStartDate(java.util.Date startDate) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        calendar.clear();
        calendar.set(1, year);
        calendar.add(2, 1);
        calendar.set(5, 0);
        if (startDate.before(calendar.getTime())) {
            startDate = calendar.getTime();
        }
        return startDate;
    }

    private static java.util.Date getEndDate(java.util.Date endDate) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        calendar.set(1, year);
        calendar.roll(6, -1);
        calendar.set(2, 11);
        calendar.set(5, 1);
        if (endDate.after(calendar.getTime())) {
            endDate = calendar.getTime();
        }
        return endDate;
    }

    public double getLeaveDay(double day, int month) {
        double leaveDay = day / 12.0 * (double)month;
        int floorInt = (int)leaveDay;
        double decimals = leaveDay - (double)floorInt;
        if (decimals < 0.5) {
            System.out.print("\u9359\ue219\u7d24\u934b\u56ec\ue582\u6434\ufe3c\u7d30" + floorInt);
            return floorInt;
        }
        System.out.print("\u9359\ue219\u7d24\u934b\u56ec\ue582\u6434\ufe3c\u7d30" + floorInt + 0.5);
        return (double)floorInt + 0.5;
    }

    public String getHolidayPolicyIds(Context ctx, String holidayNumber) {
        StringBuffer holidayPolicyIds = new StringBuffer();
        try {
            HolidayTypeCollection holidayTypeCollection = HolidayTypeFactory.getLocalInstance((Context)ctx).getHolidayTypeCollection("where number = '" + holidayNumber + "'");
            if (holidayTypeCollection != null && holidayTypeCollection.size() > 0) {
                HolidayPolicyCollection holidayPolicyCollection = HolidayPolicyFactory.getLocalInstance((Context)ctx).getHolidayPolicyCollection("where holidayType = '" + holidayTypeCollection.get(0).getId().toString() + "'");
                for (int i = 0; i < holidayPolicyCollection.size(); ++i) {
                    holidayPolicyIds.append("'" + holidayPolicyCollection.get(i).getId().toString() + "',");
                }
                if (holidayPolicyIds.length() > 0) {
                    holidayPolicyIds = holidayPolicyIds.deleteCharAt(holidayPolicyIds.length() - 1);
                }
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return holidayPolicyIds.toString();
    }
}

