/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.util;

import com.cloudera.impala.jdbc4.internal.apache.log4j.Logger;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Date;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportAllUtils {
    private static Logger logger1 = Logger.getLogger((String)"com.kingdee.shr.customer.gtiit.util.ExportAllUtils");

    public static void exportData(HttpServletResponse response, Object resource, String fileName, LinkedHashMap<String, String> selectFieldsTypeMap, List<String> list) throws SQLException {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet("Sheet1");
        XSSFDataFormat format = workBook.createDataFormat();
        if (resource != null && resource instanceof IRowSet) {
            IRowSet rs = (IRowSet)resource;
            int numColumns = selectFieldsTypeMap.entrySet().size();
            int i = 0;
            XSSFRow titleRow = sheet.createRow(i);
            List keyList = selectFieldsTypeMap.keySet().stream().collect(Collectors.toList());
            if (i == 0) {
                int j = 0;
                while (j < numColumns) {
                    XSSFCell cell = titleRow.createCell(j);
                    cell.setCellValue(list.get(j));
                    ++j;
                }
            }
            ++i;
            while (rs.next()) {
                try {
                    XSSFRow dateRow = sheet.createRow(i);
                    int j = 0;
                    while (j < numColumns) {
                        XSSFCell cell = dateRow.createCell(j);
                        String column = (String)keyList.get(j);
                        String fieldTypeAndcellStyleType = selectFieldsTypeMap.get(column);
                        int indexOf = fieldTypeAndcellStyleType.indexOf("_");
                        String fieldType = fieldTypeAndcellStyleType.substring(0, indexOf);
                        String cellStyleType = fieldTypeAndcellStyleType.substring(indexOf + 1, fieldTypeAndcellStyleType.length());
                        String t = rs.getString(column);
                        cell.setCellValue(rs.getString(column));
                        if ("Date".equals(fieldType)) {
                            Date date = rs.getDate(column);
                            cell.setCellValue((java.util.Date)date);
                            XSSFCellStyle stylee = workBook.createCellStyle();
                            stylee.setDataFormat(format.getFormat(cellStyleType));
                            cell.setCellStyle((CellStyle)stylee);
                        } else if ("Number".equals(fieldType)) {
                            String value = rs.getString(column);
                            cell.setCellValue(value);
                            if (value != null && !"".equals(value)) {
                                XSSFCellStyle style = workBook.createCellStyle();
                                style.setDataFormat(format.getFormat(String.format(cellStyleType, " ")));
                                cell.setCellStyle((CellStyle)style);
                                if (cellStyleType.contains(".")) {
                                    cell.setCellValue(Double.parseDouble(value));
                                } else {
                                    cell.setCellValue((double)Integer.parseInt(value));
                                }
                            }
                        } else if ("String".equals(fieldType) && rs.getString(column) != null && !"".equals(rs.getString(column))) {
                            cell.setCellValue(rs.getString(column));
                        }
                        ++j;
                    }
                    ++i;
                }
                catch (Exception e) {
                    logger1.info((Object)("Excel file was created Error!" + e.getMessage()));
                }
            }
            try {
                ExportAllUtils.setResponseHeader(response, fileName);
                ServletOutputStream os = response.getOutputStream();
                workBook.write((OutputStream)os);
                workBook.close();
                os.flush();
                os.close();
                logger1.info((Object)"Excel file was created successfully!");
            }
            catch (IOException e) {
                logger1.info((Object)("Error while writing to file " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public static void setResponseHeader(HttpServletResponse response, String fileName) {
        try {
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void morisExportData(HttpServletResponse response, Object resource, String fileName, LinkedHashMap<String, String> selectFieldsTypeMap, List<String> list, Map<String, Map<String, String>> numberMap, Set<String> numberSet, String formatstartDate, String formatendDate) throws SQLException {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet("Sheet1");
        XSSFDataFormat format = workBook.createDataFormat();
        if (resource != null && resource instanceof IRowSet) {
            IRowSet rs = (IRowSet)resource;
            int numColumns = selectFieldsTypeMap.entrySet().size();
            XSSFRow firstRow = sheet.createRow(0);
            firstRow.createCell(0).setCellValue("Faculty Absence Report ");
            sheet.createRow(1);
            XSSFRow threeRow = sheet.createRow(2);
            XSSFFont font = workBook.createFont();
            font.setFontName("Arial");
            font.setFontHeightInPoints((short)12);
            font.setColor(IndexedColors.BLACK.getIndex());
            XSSFCellStyle cellStyle = workBook.createCellStyle();
            cellStyle.setFont((Font)font);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            firstRow.getCell(0).setCellStyle((CellStyle)cellStyle);
            CellRangeAddress mergedRegion = new CellRangeAddress(0, 1, 0, 6);
            sheet.addMergedRegion(mergedRegion);
            threeRow.createCell(0).setCellValue("A:Annual Leave");
            threeRow.createCell(2).setCellValue("B:Business Travel");
            threeRow.createCell(5).setCellValue("O:Other Leave");
            sheet.createRow(3);
            String allDate = "Duration:" + formatstartDate + "-" + formatendDate;
            XSSFRow fourRow = sheet.createRow(4);
            fourRow.createCell(0).setCellValue(allDate);
            CellRangeAddress megred = new CellRangeAddress(4, 4, 0, 3);
            sheet.addMergedRegion(megred);
            int i = 5;
            XSSFRow titleRow = sheet.createRow(i);
            List keyList = selectFieldsTypeMap.keySet().stream().collect(Collectors.toList());
            if (i == 5) {
                int j = 0;
                while (j < numColumns) {
                    XSSFCell cell = titleRow.createCell(j);
                    cell.setCellValue(list.get(j));
                    ++j;
                }
            }
            ++i;
            rs.beforeFirst();
            while (rs.next()) {
                int tosum = 0;
                String number = null;
                String staffid = rs.getString("StaffID");
                if (!numberSet.contains(staffid)) continue;
                try {
                    XSSFRow dateRow = sheet.createRow(i);
                    int j = 0;
                    while (j < numColumns) {
                        String column = (String)keyList.get(j);
                        ++tosum;
                        if (column.equals("StaffID")) {
                            number = rs.getString(column);
                        }
                        XSSFCell cell = dateRow.createCell(j);
                        if (tosum > 5) {
                            if (numberSet.contains(number)) {
                                Map<String, String> toNumberMap = numberMap.get(number);
                                for (Map.Entry<String, String> entry : toNumberMap.entrySet()) {
                                    String key = entry.getKey();
                                    String subKey = key.substring(0, 5);
                                    String value = entry.getValue();
                                    if (!subKey.equals(column)) continue;
                                    cell.setCellValue(value);
                                }
                            }
                        } else {
                            String tname = rs.getString(column);
                            cell.setCellValue(rs.getString(column));
                        }
                        ++j;
                    }
                    numberSet.remove(number);
                    ++i;
                }
                catch (Exception e) {
                    logger1.info((Object)("Excel file was created Error!" + e.getMessage()));
                }
            }
            try {
                ExportAllUtils.setResponseHeader(response, fileName);
                ServletOutputStream os = response.getOutputStream();
                workBook.write((OutputStream)os);
                workBook.close();
                os.flush();
                os.close();
                logger1.info((Object)"Excel file was created successfully!");
            }
            catch (IOException e) {
                logger1.info((Object)("Error while writing to file " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }
}

