/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.data.fsm;

import java.util.ArrayList;
import kd.isc.iscb.util.script.data.fsm.Reader;
import kd.isc.iscb.util.script.data.fsm.State;
import kd.isc.iscb.util.script.data.fsm.Token;

class Matcher {
    private Reader reader;
    private ArrayList<Token> tokens;
    private String input;

    Matcher(State initial, String input) {
        this.reader = new Reader(input);
        this.input = input;
        this.tokens = new ArrayList();
        this.tokens.add(new Token(initial, -1));
    }

    boolean exec() {
        return this.exec(null);
    }

    boolean exec(Object param) {
        int i = this.tokens.size();
        while (i > 0) {
            char c;
            Token t = this.tokens.remove(i - 1);
            int next = t.getNext();
            State current = t.getCurrent();
            if (this.matched(current, '\u0005', next, param)) {
                return true;
            }
            if ((c = this.reader.read(next++)) != '\u0000') {
                if (this.matched(current, '\u0003', next, param)) {
                    return true;
                }
                if (this.matched(current, c, next, param)) {
                    return true;
                }
            }
            i = this.tokens.size();
        }
        return false;
    }

    private boolean matched(State current, char c, int next, Object param) {
        State to = current.getTargetFor(Character.valueOf(c));
        if (to == null) {
            return false;
        }
        if (to.isTerminal()) {
            to.exec(this.input, param);
            return true;
        }
        this.tokens.add(new Token(to, next));
        return false;
    }
}

