/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.op.arith;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.feature.op.arith.CalcBase;
import kd.isc.iscb.util.script.feature.op.arith.Util;
import kd.isc.iscb.util.script.feature.tool.collection.Sum;
import kd.isc.iscb.util.script.feature.tool.date.DateAdd;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;
import kd.isc.iscb.util.script.feature.tool.string.ToString;
import kd.isc.iscb.util.script.util.Numeric;

public final class Add
extends CalcBase {
    private static final String _name = "+";
    public static final Add INS = new Add();

    private Add() {
    }

    @Override
    public String name() {
        return _name;
    }

    @Override
    protected Object calc(int a, int b) {
        return a + b;
    }

    @Override
    protected Object calc(long a, long b) {
        return a + b;
    }

    @Override
    protected Object calc(double a, double b) {
        return a + b;
    }

    @Override
    protected BigInteger calc(BigInteger a, BigInteger b) {
        return a.add(b);
    }

    @Override
    protected BigDecimal calc(BigDecimal a, BigDecimal b) {
        return a.add(b);
    }

    @Override
    protected Object calc(Object[] args) {
        Object a = args[0];
        Object b = args[1];
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof CharSequence && !(b instanceof List)) {
            return a + ToString.toString(b);
        }
        if (a instanceof TimeSpan) {
            if (b instanceof TimeSpan) {
                return TimeSpan.add((TimeSpan)a, (TimeSpan)b);
            }
            if (b instanceof Date) {
                return DateAdd.calc((Date)b, (TimeSpan)a);
            }
        } else if (a instanceof Date) {
            if (b instanceof TimeSpan) {
                return DateAdd.calc((Date)a, (TimeSpan)b);
            }
            if (b instanceof Time) {
                return DateAdd.calc((Date)a, (Time)b);
            }
        } else {
            if (a instanceof Set && b instanceof Set) {
                return this.addSet((Set)a, (Set)b);
            }
            if (a instanceof Map && b instanceof Map) {
                return this.addMap((Map)a, (Map)b);
            }
            if (b instanceof CharSequence && !(a instanceof List)) {
                return String.valueOf(ToString.toString(a)) + b;
            }
        }
        return Util.calc(a, b, (NativeFunction)this);
    }

    private Object addMap(Map<?, ?> a, Map<?, ?> b) {
        LinkedHashMap result = new LinkedHashMap(a.size() + b.size());
        result.putAll(a);
        result.putAll(b);
        return result;
    }

    private Object addSet(Set<?> ca, Set<?> cb) {
        int size = ca.size() + cb.size();
        HashSet set = new HashSet(size);
        set.addAll(ca);
        set.addAll(cb);
        return set;
    }

    @Override
    protected Object calcSingleValue(Object value) {
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            return Sum.calc(c.toArray(new Object[c.size()]));
        }
        return value;
    }

    public static Object calc(Object a, Object b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (b.getClass() == a.getClass()) {
            int type = Numeric.getType(a);
            return INS.calc(a, b, type);
        }
        Object[] args = new Object[]{a, b};
        int type = Numeric.normalize(args);
        return INS.calc(args[0], args[1], type);
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public int priority() {
        return 4;
    }
}

