/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.dt.i;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.AbstractSimpleDataType;

public final class DecimalType
extends AbstractSimpleDataType {
    private int precision;
    private int scale;

    public static DecimalType getType(int precision, int scale) {
        return new DecimalType(precision, scale);
    }

    public DecimalType(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    @Override
    public Object narrow(Object value) {
        if (value == null) {
            return null;
        }
        BigDecimal d = D.n(value);
        d = this.adjustScale(value, d);
        return d;
    }

    public String toString() {
        if (this.precision > 0) {
            return "decimal(" + this.precision + "," + this.scale + ")";
        }
        return "decimal";
    }

    private BigDecimal adjustScale(Object value, BigDecimal d) {
        if (this.scale >= 0 && d.scale() != this.scale) {
            return d.setScale(this.scale, RoundingMode.HALF_UP);
        }
        return d;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }
}

