/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc;

import java.security.MessageDigest;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.misc.Base64;
import kd.isc.iscb.util.misc.MurmurHash;

public class Hash {
    private static final String DEFAULT_HASH;

    static {
        StringBuilder s = new StringBuilder();
        s.append('M');
        s.append('D');
        s.append('5');
        DEFAULT_HASH = s.toString();
    }

    private Hash() {
    }

    public static String md5(String s) {
        try {
            MessageDigest md5 = MessageDigest.getInstance(DEFAULT_HASH);
            md5.update(s == null ? new byte[]{} : s.getBytes(D.UTF_8));
            return Hex.encode(md5.digest());
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    public static byte[] md5(byte[] bytes) {
        try {
            MessageDigest md5 = MessageDigest.getInstance(DEFAULT_HASH);
            md5.update(bytes);
            return md5.digest();
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    public static byte[] sha256(byte[] bytes) {
        try {
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            sha.update(bytes);
            return sha.digest();
        }
        catch (Exception e) {
            throw D.e(e);
        }
    }

    public static String mur16(Object ... values) {
        String s = Hash.toString(values);
        int h = MurmurHash.hash(s.getBytes(D.UTF_8), 1937006962);
        return Integer.toHexString(h & 0xFFFF).toUpperCase();
    }

    public static String mur2base64(Object ... values) {
        String s = Hash.toString(values);
        long h = MurmurHash.hash(s.getBytes(D.UTF_8));
        byte[] bytes = Hex.decode(Long.toHexString(h));
        return new String(Base64.encode(bytes), 0, 11);
    }

    public static String mur2digital32(Object ... values) {
        String s = Hash.toString(values);
        long h = Math.abs(MurmurHash.hash(s.getBytes(D.UTF_8)));
        return Hash.longToDigital32(h);
    }

    public static String longToDigital32(long h) {
        String digitals = "ABCDEFGHIJKLMN123456789OPQRSTUVWXYZ";
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 13) {
            int d = (int)h & 0x1F;
            sb.append("ABCDEFGHIJKLMN123456789OPQRSTUVWXYZ".charAt(d));
            h >>= 5;
            ++i;
        }
        return sb.toString();
    }

    public static String mur24(Object ... values) {
        String s = Hash.toString(values);
        int h = MurmurHash.hash(s.getBytes(D.UTF_8), 1937006962);
        return Integer.toHexString(h & 0xFFFFFF).toUpperCase();
    }

    public static String mur32(Object ... values) {
        String s = Hash.toString(values);
        int h = MurmurHash.hash(s.getBytes(D.UTF_8), 1937006962);
        return Integer.toHexString(h).toUpperCase();
    }

    public static long mur(Object ... values) {
        String s = Hash.toString(values);
        byte[] bytes = s.getBytes(D.UTF_8);
        return MurmurHash.hash64A(bytes, 1937006962);
    }

    public static long mur64(byte[] bytes) {
        return MurmurHash.hash64A(bytes, 1937006962);
    }

    public static long md5i64(byte[] bytes) {
        byte[] hash = Hash.md5(bytes);
        return Math.abs(Hash.toLong(hash, 4, 12));
    }

    public static long toLong(byte[] bytes, int start, int end) {
        long value = 0L;
        int i = start;
        while (i < end) {
            value = value << 8 | (long)(bytes[i] & 0xFF);
            ++i;
        }
        return value;
    }

    public static int mur32(byte[] bytes) {
        return MurmurHash.hash(bytes, 1937006962);
    }

    public static String toString(Object ... values) {
        if (values.length == 0) {
            return "";
        }
        if (values.length == 1) {
            Object v = values[0];
            return v == null ? "" : v.toString();
        }
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object v = objectArray[n2];
            sb.append(v).append('\n');
            ++n2;
        }
        return sb.toString();
    }
}

