/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.number;

import javax.script.ScriptContext;
import kd.isc.iscb.util.script.LifeScriptEngine;
import kd.isc.iscb.util.script.core.AbstractToolKit;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.feature.tool.number.Abs;
import kd.isc.iscb.util.script.feature.tool.number.Ceil;
import kd.isc.iscb.util.script.feature.tool.number.Floor;
import kd.isc.iscb.util.script.feature.tool.number.FormatMoney;
import kd.isc.iscb.util.script.feature.tool.number.FormatNumber;
import kd.isc.iscb.util.script.feature.tool.number.FormatPercent;
import kd.isc.iscb.util.script.feature.tool.number.IsNumber;
import kd.isc.iscb.util.script.feature.tool.number.ParseDecimal;
import kd.isc.iscb.util.script.feature.tool.number.ParseDouble;
import kd.isc.iscb.util.script.feature.tool.number.ParseHex;
import kd.isc.iscb.util.script.feature.tool.number.ParseInt;
import kd.isc.iscb.util.script.feature.tool.number.ParseLong;
import kd.isc.iscb.util.script.feature.tool.number.Rand;
import kd.isc.iscb.util.script.feature.tool.number.Round;
import kd.isc.iscb.util.script.feature.tool.number.Split;
import kd.isc.iscb.util.script.feature.tool.number.ToCapital;
import kd.isc.iscb.util.script.util.Numeric;

public class NumberToolKit
extends AbstractToolKit
implements NativeFunction {
    public NumberToolKit() {
        this.register(new FormatNumber());
        this.register(new ParseHex());
        NativeFunction fn = new ParseInt();
        this.register(fn);
        this.register("int", fn);
        fn = new ParseLong();
        this.register(fn);
        this.register("long", fn);
        fn = new ParseDouble();
        this.register(fn);
        this.register("double", fn);
        fn = new ParseDecimal();
        this.register(fn);
        this.register("decimal", fn);
        this.register(new Split());
        this.register(new IsNumber());
        this.register(new ToCapital());
        this.register(new Round());
        this.register(new Ceil());
        this.register(new Floor());
        this.register(new Abs());
        this.register(new FormatPercent());
        this.register(new FormatMoney());
        this.register(new Rand());
    }

    @Override
    public void registerOtherElements(LifeScriptEngine engine) {
        engine.register("I", (Object)this.get("int"));
        engine.register("L", (Object)this.get("long"));
        engine.register("N", (Object)this.get("decimal"));
        engine.register("D", (Object)this.get("double"));
        engine.register("H", (Object)this.get("parseHex"));
    }

    @Override
    public boolean isFor(Object object) {
        return object instanceof Number;
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Object a = args[0];
        if (a == null || a instanceof Number) {
            return a;
        }
        String s = a.toString().trim();
        if (s.length() == 0) {
            return null;
        }
        if (s.indexOf(44) >= 0) {
            s = s.replaceAll(",", "");
        }
        return Numeric.parse(s);
    }
}

